/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;

public class KafkaPartitionInfoProvider {
    private final AdminClient adminClient;

    public KafkaPartitionInfoProvider(AdminClient adminClient) {
        this.adminClient = adminClient;
    }

    public Collection<Integer> getPartitions(String topicName) throws ExecutionException, InterruptedException {
        DescribeTopicsResult result = this.adminClient.describeTopics(Collections.singletonList(topicName));
        KafkaFuture topicDescription = (KafkaFuture)result.topicNameValues().get(topicName);
        try {
            return ((TopicDescription)topicDescription.get()).partitions().stream().map(TopicPartitionInfo::partition).collect(Collectors.toSet());
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof UnknownTopicOrPartitionException) {
                return Set.of();
            }
            throw ex;
        }
    }
}

