/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.SynchronizationContext;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.shaded.com.github.xds.data.orca.v3.OrcaLoadReport;
import io.grpc.xds.shaded.com.github.xds.service.orca.v3.OpenRcaServiceGrpc;
import io.grpc.xds.shaded.com.github.xds.service.orca.v3.OrcaLoadReportRequest;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

final class OrcaServiceImpl
extends OpenRcaServiceGrpc.OpenRcaServiceImplBase {
    private static final Logger logger = Logger.getLogger(OrcaServiceImpl.class.getName());
    private final long minReportIntervalNanos;
    private final ScheduledExecutorService timeService;
    private volatile ConcurrentHashMap<String, Double> metricsData = new ConcurrentHashMap();
    private volatile double cpuUtilization;
    private volatile double memoryUtilization;
    @VisibleForTesting
    final AtomicInteger clientCount = new AtomicInteger(0);

    public OrcaServiceImpl(long minReportIntervalNanos, ScheduledExecutorService timeService) {
        this.minReportIntervalNanos = minReportIntervalNanos;
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timeService);
    }

    @Override
    public void streamCoreMetrics(OrcaLoadReportRequest request, StreamObserver<OrcaLoadReport> responseObserver) {
        OrcaClient client = new OrcaClient(request, responseObserver);
        client.run();
        this.clientCount.getAndIncrement();
    }

    private OrcaLoadReport generateMetricsReport() {
        return OrcaLoadReport.newBuilder().setCpuUtilization(this.cpuUtilization).setMemUtilization(this.memoryUtilization).putAllUtilization(this.metricsData).build();
    }

    void setUtilizationMetric(String key, double value) {
        this.metricsData.put(key, value);
    }

    void setAllUtilizationMetrics(Map<String, Double> metrics) {
        this.metricsData = new ConcurrentHashMap<String, Double>(metrics);
    }

    void deleteUtilizationMetric(String key) {
        this.metricsData.remove(key);
    }

    void setCpuUtilizationMetric(double value) {
        this.cpuUtilization = value;
    }

    void deleteCpuUtilizationMetric() {
        this.cpuUtilization = 0.0;
    }

    void setMemoryUtilizationMetric(double value) {
        this.memoryUtilization = value;
    }

    void deleteMemoryUtilizationMetric() {
        this.memoryUtilization = 0.0;
    }

    private final class OrcaClient
    implements Runnable {
        final ServerCallStreamObserver<OrcaLoadReport> responseObserver;
        SynchronizationContext.ScheduledHandle periodicReportTimer;
        final long reportIntervalNanos;
        final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.log(Level.SEVERE, "Exception!" + e);
            }
        });

        OrcaClient(OrcaLoadReportRequest request, StreamObserver<OrcaLoadReport> responseObserver) {
            this.reportIntervalNanos = Math.max(Durations.toNanos((Duration)((OrcaLoadReportRequest)Preconditions.checkNotNull((Object)request)).getReportInterval()), OrcaServiceImpl.this.minReportIntervalNanos);
            this.responseObserver = (ServerCallStreamObserver)responseObserver;
            this.responseObserver.setOnCancelHandler(new Runnable(){

                @Override
                public void run() {
                    OrcaClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (OrcaClient.this.periodicReportTimer != null) {
                                OrcaClient.this.periodicReportTimer.cancel();
                            }
                            OrcaServiceImpl.this.clientCount.getAndDecrement();
                        }
                    });
                }
            });
        }

        @Override
        public void run() {
            if (this.periodicReportTimer != null && this.periodicReportTimer.isPending()) {
                return;
            }
            OrcaLoadReport report = OrcaServiceImpl.this.generateMetricsReport();
            this.responseObserver.onNext((Object)report);
            this.periodicReportTimer = this.syncContext.schedule((Runnable)this, this.reportIntervalNanos, TimeUnit.NANOSECONDS, OrcaServiceImpl.this.timeService);
        }
    }
}

