/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.connector.oracle.OracleTableIdParser;
import io.debezium.doc.FixFor;
import io.debezium.relational.TableId;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class OracleTableIdParserTest {
    @Test
    @FixFor(value={"DBZ-4744"})
    public void shouldParseFullyQualifiedTableNameWithDomainNameAsCatalog() throws Exception {
        TableId tableId = OracleTableIdParser.parse((String)"RB02.DOMAIN.COM.TBSLV.DEBEZIUM_SIGNAL");
        Assertions.assertThat((String)tableId.table()).isEqualTo((Object)"DEBEZIUM_SIGNAL");
        Assertions.assertThat((String)tableId.schema()).isEqualTo((Object)"TBSLV");
        Assertions.assertThat((String)tableId.catalog()).isEqualTo((Object)"RB02.DOMAIN.COM");
    }

    @Test
    @FixFor(value={"DBZ-4744"})
    public void shouldParseFullyQualifiedTableWithoutDomainNameAsCatalogName() throws Exception {
        TableId tableId = OracleTableIdParser.parse((String)"SERVER1.TBSLV.DEBEZIUM_SIGNAL");
        Assertions.assertThat((String)tableId.table()).isEqualTo((Object)"DEBEZIUM_SIGNAL");
        Assertions.assertThat((String)tableId.schema()).isEqualTo((Object)"TBSLV");
        Assertions.assertThat((String)tableId.catalog()).isEqualTo((Object)"SERVER1");
    }

    @Test
    @FixFor(value={"DBZ-7942"})
    public void shouldQuoteTableNameThatStartsWithUnderscoreWithDatabaseAndSchemaNames() throws Exception {
        List<String> keywords = Collections.singletonList("FROM");
        TableId tableId = OracleTableIdParser.parse((String)"DB.SCHEMA.__DEBEZIUM_SIGNAL");
        String quotedValue = OracleTableIdParser.quoteIfNeeded((TableId)tableId, (boolean)false, (boolean)true, keywords);
        Assertions.assertThat((String)quotedValue).isEqualTo((Object)"SCHEMA.\"__DEBEZIUM_SIGNAL\"");
    }

    @Test
    @FixFor(value={"DBZ-7942"})
    public void shouldQuoteTableNameThatStartsWithUnderscoreWithSchemaName() throws Exception {
        List<String> keywords = Collections.singletonList("FROM");
        TableId tableId = OracleTableIdParser.parse((String)"SCHEMA.__DEBEZIUM_SIGNAL");
        String quotedValue = OracleTableIdParser.quoteIfNeeded((TableId)tableId, (boolean)false, (boolean)true, keywords);
        Assertions.assertThat((String)quotedValue).isEqualTo((Object)"SCHEMA.\"__DEBEZIUM_SIGNAL\"");
    }

    @Test
    @FixFor(value={"DBZ-7942"})
    public void shouldQuoteTableNameThatContainsDatabaseKeyword() throws Exception {
        List<String> keywords = Collections.singletonList("FROM");
        TableId tableId = OracleTableIdParser.parse((String)"SCHEMA.FROM");
        String quotedValue = OracleTableIdParser.quoteIfNeeded((TableId)tableId, (boolean)false, (boolean)true, keywords);
        Assertions.assertThat((String)quotedValue).isEqualTo((Object)"SCHEMA.\"FROM\"");
    }
}

