/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.oracle.CommitScn;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.relational.TableId;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

@NotThreadSafe
public class SourceInfo
extends BaseSourceInfo {
    public static final String TXID_KEY = "txId";
    public static final String SCN_KEY = "scn";
    public static final String EVENT_SCN_KEY = "scn";
    public static final String COMMIT_SCN_KEY = "commit_scn";
    public static final String LCR_POSITION_KEY = "lcr_position";
    public static final String SNAPSHOT_KEY = "snapshot";
    public static final String USERNAME_KEY = "user_name";
    public static final String SCN_INDEX_KEY = "scn_idx";
    public static final String REDO_SQL = "redo_sql";
    public static final String ROW_ID = "row_id";
    private final ThreadLocal<String> rowId = new ThreadLocal();
    private Scn scn;
    private CommitScn commitScn;
    private Scn eventScn;
    private String lcrPosition;
    private String transactionId;
    private String userName;
    private Instant sourceTime;
    private Set<TableId> tableIds;
    private Integer redoThread;
    private String rsId;
    private long ssn;
    private Long scnIndex;
    private String redoSql;

    protected SourceInfo(OracleConnectorConfig connectorConfig) {
        super((CommonConnectorConfig)connectorConfig);
    }

    public Scn getScn() {
        return this.scn;
    }

    public CommitScn getCommitScn() {
        return this.commitScn;
    }

    public Scn getEventScn() {
        return this.eventScn;
    }

    public void setScn(Scn scn) {
        this.scn = scn;
    }

    public void setCommitScn(CommitScn commitScn) {
        this.commitScn = commitScn;
    }

    public void setEventScn(Scn eventScn) {
        this.eventScn = eventScn;
    }

    public String getLcrPosition() {
        return this.lcrPosition;
    }

    public void setLcrPosition(String lcrPosition) {
        this.lcrPosition = lcrPosition;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getRsId() {
        return this.rsId;
    }

    public void setRsId(String rsId) {
        this.rsId = rsId;
    }

    public long getSsn() {
        return this.ssn;
    }

    public void setSsn(long ssn) {
        this.ssn = ssn;
    }

    public Instant getSourceTime() {
        return this.sourceTime;
    }

    public void setSourceTime(Instant sourceTime) {
        this.sourceTime = sourceTime;
    }

    public String getRedoSql() {
        return this.redoSql;
    }

    public void setRedoSql(String redoSql) {
        this.redoSql = redoSql;
    }

    public String getRowId() {
        return this.rowId.get();
    }

    public void setRowId(String rowId) {
        this.rowId.set(rowId);
    }

    public String tableSchema() {
        return this.tableIds == null || this.tableIds.isEmpty() ? null : this.tableIds.stream().filter(x -> x != null).map(TableId::schema).distinct().collect(Collectors.joining(","));
    }

    public String table() {
        return this.tableIds == null || this.tableIds.isEmpty() ? null : this.tableIds.stream().filter(x -> x != null).map(TableId::table).collect(Collectors.joining(","));
    }

    public void tableEvent(Set<TableId> tableIds) {
        this.tableIds = new LinkedHashSet<TableId>(tableIds);
    }

    public void tableEvent(TableId tableId) {
        this.tableIds = Collections.singleton(tableId);
    }

    public Integer getRedoThread() {
        return this.redoThread;
    }

    public void setRedoThread(Integer redoThread) {
        this.redoThread = redoThread;
    }

    public Long getScnIndex() {
        return this.scnIndex;
    }

    public void setScnIndex(Long scnIndex) {
        this.scnIndex = scnIndex;
    }

    protected Instant timestamp() {
        return this.sourceTime;
    }

    protected String database() {
        return this.tableIds != null ? this.tableIds.iterator().next().catalog() : null;
    }
}

