/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.util;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.embedded.async.AsyncEmbeddedEngine;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.storage.file.history.FileSchemaHistory;
import io.debezium.storage.kafka.history.KafkaSchemaHistory;
import io.debezium.testing.testcontainers.ConnectorConfiguration;
import io.debezium.testing.testcontainers.OracleContainer;
import io.debezium.testing.testcontainers.testhelper.RestExtensionTestInfrastructure;
import io.debezium.util.Strings;
import io.debezium.util.Testing;
import java.math.BigInteger;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.persistence.sifs.configuration.SoftIndexFileStoreConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class TestHelper {
    private static final String PDB_NAME = "pdb.name";
    private static final String DATABASE_PREFIX = "database.";
    private static final String DATABASE_ADMIN_PREFIX = "database.admin.";
    public static final Path SCHEMA_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-schema-history-connect.txt").toAbsolutePath();
    public static final String CONNECTOR_USER = "c##dbzuser";
    public static final String CONNECTOR_NAME = "oracle";
    public static final String SERVER_NAME = "server1";
    public static final String CONNECTOR_USER_PASS = "dbz";
    public static final String HOST = "localhost";
    public static final String SCHEMA_USER = "debezium";
    public static final String SCHEMA_PASS = "dbz";
    public static final String DATABASE = "ORCLPDB1";
    public static final String DATABASE_CDB = "ORCLCDB";
    public static final int PORT = 1521;
    public static final int INFINISPAN_HOTROD_PORT = 11222;
    public static final String INFINISPAN_USER = "admin";
    public static final String INFINISPAN_PASS = "admin";
    public static final String INFINISPAN_HOST = "0.0.0.0";
    public static final String INFINISPAN_SERVER_LIST = "0.0.0.0:11222";
    public static final String OPENLOGREPLICATOR_SOURCE = System.getProperty("openlogreplicator.source", "ORACLE");
    public static final String OPENLOGREPLICATOR_HOST = System.getProperty("openlogreplicator.host", "localhost");
    public static final String OPENLOGREPLICATOR_PORT = System.getProperty("openlogreplicator.port", "9000");
    public static final String TYPE_NAME_PARAMETER_KEY = "__debezium.source.column.type";
    public static final String TYPE_LENGTH_PARAMETER_KEY = "__debezium.source.column.length";
    public static final String TYPE_SCALE_PARAMETER_KEY = "__debezium.source.column.scale";
    private static final Logger LOGGER = LoggerFactory.getLogger(TestHelper.class);
    private static final Map<String, Field> cacheMappings = new HashMap<String, Field>();

    public static String getConnectorUserName() {
        String userName = TestHelper.getDatabaseConfig(DATABASE_PREFIX).getString(JdbcConfiguration.USER.name());
        return Strings.isNullOrEmpty((String)userName) ? CONNECTOR_USER : userName;
    }

    private static String getConnectorUserPassword() {
        String password = TestHelper.getDatabaseConfig(DATABASE_PREFIX).getString(JdbcConfiguration.PASSWORD.name());
        return Strings.isNullOrEmpty((String)password) ? "dbz" : password;
    }

    public static String getDatabaseName() {
        String databaseName = TestHelper.getDatabaseConfig(DATABASE_PREFIX).getString(JdbcConfiguration.DATABASE);
        return Strings.isNullOrEmpty((String)databaseName) ? DATABASE : databaseName;
    }

    private static JdbcConfiguration defaultJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)TestHelper.getDatabaseConfig(DATABASE_PREFIX)).withDefault(JdbcConfiguration.HOSTNAME, HOST)).withDefault(JdbcConfiguration.PORT, 1521)).withDefault(JdbcConfiguration.USER, TestHelper.getConnectorUserName())).withDefault(JdbcConfiguration.PASSWORD, TestHelper.getConnectorUserPassword())).withDefault(JdbcConfiguration.DATABASE, DATABASE_CDB)).build();
    }

    public static Configuration.Builder defaultConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.defaultJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with(DATABASE_PREFIX + field, value));
        if (TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.XSTREAM)) {
            builder.withDefault(OracleConnectorConfig.XSTREAM_SERVER_NAME, "dbzxout");
        } else if (TestHelper.adapter().equals((Object)OracleConnectorConfig.ConnectorAdapter.OLR)) {
            builder.withDefault(OracleConnectorConfig.OLR_SOURCE, OPENLOGREPLICATOR_SOURCE);
            builder.withDefault(OracleConnectorConfig.OLR_HOST, OPENLOGREPLICATOR_HOST);
            builder.withDefault(OracleConnectorConfig.OLR_PORT, OPENLOGREPLICATOR_PORT);
        } else {
            String bufferTypeName;
            OracleConnectorConfig.LogMiningBufferType bufferType;
            builder.withDefault(OracleConnectorConfig.LOG_MINING_STRATEGY, "online_catalog");
            Boolean readOnly = Boolean.parseBoolean(System.getProperty(OracleConnectorConfig.LOG_MINING_READ_ONLY.name()));
            if (readOnly.booleanValue()) {
                builder.with(OracleConnectorConfig.LOG_MINING_READ_ONLY, (Object)readOnly);
            }
            if ((bufferType = OracleConnectorConfig.LogMiningBufferType.parse((String)(bufferTypeName = System.getProperty(OracleConnectorConfig.LOG_MINING_BUFFER_TYPE.name())))).isInfinispan()) {
                builder.with(OracleConnectorConfig.LOG_MINING_BUFFER_TYPE, (EnumeratedValue)bufferType);
                TestHelper.withDefaultInfinispanCacheConfigurations(bufferType, builder);
                if (!bufferType.isInfinispanEmbedded()) {
                    builder.with("log.mining.buffer.infinispan.client.hotrod.server_list", INFINISPAN_SERVER_LIST);
                    builder.with("log.mining.buffer.infinispan.client.hotrod.auth_username", "admin");
                    builder.with("log.mining.buffer.infinispan.client.hotrod.auth_password", "admin");
                }
            }
            builder.withDefault(OracleConnectorConfig.LOG_MINING_BUFFER_DROP_ON_STOP, true);
        }
        if (TestHelper.isUsingPdb()) {
            builder.withDefault(OracleConnectorConfig.PDB_NAME, DATABASE);
        }
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)builder.with(CommonConnectorConfig.TOPIC_PREFIX, SERVER_NAME)).with(OracleConnectorConfig.SCHEMA_HISTORY, FileSchemaHistory.class)).with(FileSchemaHistory.FILE_PATH, (Object)SCHEMA_HISTORY_PATH)).with(OracleConnectorConfig.INCLUDE_SCHEMA_CHANGES, false)).with(AsyncEmbeddedEngine.TASK_MANAGEMENT_TIMEOUT_MS, 90000);
    }

    public static OracleConnection defaultConnection() {
        Configuration config = TestHelper.defaultConfig().build();
        Configuration jdbcConfig = config.subset(DATABASE_PREFIX, true);
        return TestHelper.createConnection(config, JdbcConfiguration.adapt((Configuration)jdbcConfig), true);
    }

    public static OracleConnection defaultConnection(boolean switchToRoot) {
        Configuration config = TestHelper.defaultConfig().build();
        Configuration jdbcConfig = config.subset(DATABASE_PREFIX, true);
        OracleConnection connection = TestHelper.createConnection(config, JdbcConfiguration.adapt((Configuration)jdbcConfig), true);
        if (switchToRoot && TestHelper.isUsingPdb()) {
            connection.resetSessionToCdb();
        }
        return connection;
    }

    private static JdbcConfiguration testJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)TestHelper.getDatabaseConfig(DATABASE_PREFIX)).withDefault(JdbcConfiguration.HOSTNAME, HOST)).withDefault(JdbcConfiguration.PORT, 1521)).with(JdbcConfiguration.USER, SCHEMA_USER)).with(JdbcConfiguration.PASSWORD, "dbz")).withDefault(JdbcConfiguration.DATABASE, DATABASE)).build();
    }

    private static JdbcConfiguration adminJdbcConfig() {
        return (JdbcConfiguration)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)((JdbcConfiguration.Builder)JdbcConfiguration.copy((Configuration)TestHelper.getDatabaseConfig(DATABASE_ADMIN_PREFIX)).withDefault(JdbcConfiguration.HOSTNAME, HOST)).withDefault(JdbcConfiguration.PORT, 1521)).withDefault(JdbcConfiguration.USER, "sys as sysdba")).withDefault(JdbcConfiguration.PASSWORD, "top_secret")).withDefault(JdbcConfiguration.DATABASE, TestHelper.getDatabaseName())).build();
    }

    public static Configuration.Builder testConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.testJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with(DATABASE_PREFIX + field, value));
        builder.with(CommonConnectorConfig.TOPIC_PREFIX, SERVER_NAME);
        return builder;
    }

    private static Configuration.Builder adminConfig() {
        JdbcConfiguration jdbcConfiguration = TestHelper.adminJdbcConfig();
        Configuration.Builder builder = Configuration.create();
        jdbcConfiguration.forEach((field, value) -> builder.with(DATABASE_PREFIX + field, value));
        builder.with(CommonConnectorConfig.TOPIC_PREFIX, SERVER_NAME);
        return builder;
    }

    private static Configuration getDatabaseConfig(String prefix) {
        String pdbName;
        Configuration config = Configuration.fromSystemProperties((String)prefix);
        if (config.hasKey(PDB_NAME) && Strings.isNullOrEmpty((String)(pdbName = config.getString(PDB_NAME)))) {
            Map map = config.asMap();
            map.remove(PDB_NAME);
            config = Configuration.from((Map)map);
        }
        return config;
    }

    public static OracleConnection testConnection() {
        Configuration config = TestHelper.testConfig().build();
        Configuration jdbcConfig = config.subset(DATABASE_PREFIX, true);
        return TestHelper.createConnection(config, JdbcConfiguration.adapt((Configuration)jdbcConfig), false);
    }

    public static OracleConnection testConnection(Configuration config) {
        Configuration jdbcConfig = config.subset(DATABASE_PREFIX, true);
        return TestHelper.createConnection(config, JdbcConfiguration.adapt((Configuration)jdbcConfig), false);
    }

    public static OracleConnection adminConnection() {
        Configuration config = TestHelper.adminConfig().build();
        Configuration jdbcConfig = config.subset(DATABASE_PREFIX, true);
        return TestHelper.createConnection(config, JdbcConfiguration.adapt((Configuration)jdbcConfig), false);
    }

    public static OracleConnection adminConnection(boolean switchToRoot) {
        Configuration config = TestHelper.adminConfig().build();
        Configuration jdbcConfig = config.subset(DATABASE_PREFIX, true);
        OracleConnection connection = TestHelper.createConnection(config, JdbcConfiguration.adapt((Configuration)jdbcConfig), false);
        if (switchToRoot && TestHelper.isUsingPdb()) {
            connection.resetSessionToCdb();
        }
        return connection;
    }

    private static OracleConnection createConnection(Configuration config, JdbcConfiguration jdbcConfig, boolean autoCommit) {
        OracleConnection connection = new OracleConnection(jdbcConfig);
        try {
            connection.setAutoCommit(autoCommit);
            String pdbName = new OracleConnectorConfig(config).getPdbName();
            if (!Strings.isNullOrEmpty((String)pdbName)) {
                connection.setSessionToPdb(pdbName);
            }
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create connection", e);
        }
    }

    public static void forceLogfileSwitch() {
        Configuration config = TestHelper.adminConfig().build();
        Configuration jdbcConfig = config.subset(DATABASE_PREFIX, true);
        try (OracleConnection jdbcConnection = new OracleConnection(JdbcConfiguration.adapt((Configuration)jdbcConfig));){
            if (new OracleConnectorConfig(TestHelper.defaultConfig().build()).getPdbName() != null) {
                jdbcConnection.resetSessionToCdb();
            }
            jdbcConnection.execute(new String[]{"ALTER SYSTEM SWITCH LOGFILE"});
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to switch logfile", e);
        }
    }

    public static int getNumberOfOnlineLogGroups() {
        int n;
        Configuration config = TestHelper.adminConfig().build();
        Configuration jdbcConfig = config.subset(DATABASE_PREFIX, true);
        OracleConnection jdbcConnection = new OracleConnection(JdbcConfiguration.adapt((Configuration)jdbcConfig));
        try {
            if (new OracleConnectorConfig(TestHelper.defaultConfig().build()).getPdbName() != null) {
                jdbcConnection.resetSessionToCdb();
            }
            n = (Integer)jdbcConnection.queryAndMap("SELECT COUNT(GROUP#) FROM V$LOG", rs -> {
                rs.next();
                return rs.getInt(1);
            });
        }
        catch (Throwable throwable) {
            try {
                try {
                    jdbcConnection.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to get redo log groups", e);
            }
        }
        jdbcConnection.close();
        return n;
    }

    public static void forceFlushOfRedoLogsToArchiveLogs() {
        int groups = TestHelper.getNumberOfOnlineLogGroups();
        for (int i = 0; i < groups; ++i) {
            TestHelper.forceLogfileSwitch();
        }
    }

    public static void dropTable(OracleConnection connection, String table) {
        block2: {
            try {
                connection.execute(new String[]{"DROP TABLE " + table});
            }
            catch (SQLException e) {
                if (e.getMessage().contains("ORA-00942") && 942 == e.getErrorCode()) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    public static void dropTables(OracleConnection connection, String ... tables) {
        for (String table : tables) {
            TestHelper.dropTable(connection, table);
        }
    }

    public static void dropSequence(OracleConnection connection, String sequence) {
        block2: {
            try {
                connection.execute(new String[]{"DROP SEQUENCE " + sequence});
            }
            catch (SQLException e) {
                if (e.getMessage().contains("ORA-02289") && 2289 == e.getErrorCode()) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    public static void streamTable(OracleConnection connection, String table) throws SQLException {
        connection.execute(new String[]{String.format("GRANT SELECT ON %s TO %s", table, TestHelper.getConnectorUserName())});
        connection.execute(new String[]{String.format("ALTER TABLE %s ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS", table)});
    }

    public static void purgeRecycleBin(OracleConnection connection) {
        try {
            connection.execute(new String[]{"PURGE RECYCLEBIN"});
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to clear user recyclebin", e);
        }
    }

    public static void grantRole(String roleName) {
        TestHelper.grantRole(roleName, null, TestHelper.testJdbcConfig().getString(JdbcConfiguration.USER));
    }

    public static void grantRole(String roleName, String objectName, String userName) {
        String pdbName = TestHelper.defaultConfig().build().getString(OracleConnectorConfig.PDB_NAME);
        try (OracleConnection connection = TestHelper.adminConnection();){
            if (pdbName != null) {
                connection.setSessionToPdb(pdbName);
            }
            StringBuilder sql = new StringBuilder("GRANT ").append(roleName);
            if (!Strings.isNullOrEmpty((String)objectName)) {
                sql.append(" ON ").append(objectName);
            }
            sql.append(" TO ").append(userName);
            System.out.println(sql.toString());
            connection.execute(new String[]{sql.toString()});
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to grant role '" + roleName + "' for user " + userName, e);
        }
    }

    public static void revokeRole(String roleName) {
        String pdbName = TestHelper.defaultConfig().build().getString(OracleConnectorConfig.PDB_NAME);
        String userName = TestHelper.testJdbcConfig().getString(JdbcConfiguration.USER);
        try (OracleConnection connection = TestHelper.adminConnection();){
            if (pdbName != null) {
                connection.setSessionToPdb(pdbName);
            }
            connection.execute(new String[]{"REVOKE " + roleName + " FROM " + userName});
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to revoke role '" + roleName + "' for user " + userName, e);
        }
    }

    public static int defaultMessageConsumerPollTimeout() {
        return 120;
    }

    public static OracleConnectorConfig.ConnectorAdapter adapter() {
        String s = System.getProperty(OracleConnectorConfig.CONNECTOR_ADAPTER.name());
        return s == null || s.length() == 0 ? OracleConnectorConfig.ConnectorAdapter.LOG_MINER : OracleConnectorConfig.ConnectorAdapter.parse((String)s);
    }

    public static OracleConnectorConfig.LogMiningStrategy logMiningStrategy() {
        if (OracleConnectorConfig.ConnectorAdapter.LOG_MINER.equals((Object)TestHelper.adapter())) {
            Configuration configuration = TestHelper.defaultConfig().build();
            return OracleConnectorConfig.LogMiningStrategy.parse((String)configuration.getString(OracleConnectorConfig.LOG_MINING_STRATEGY));
        }
        return null;
    }

    public static void dropAllTables() {
        try (OracleConnection connection = TestHelper.testConnection();){
            connection.query("SELECT TABLE_NAME FROM USER_TABLES", rs -> {
                while (rs.next()) {
                    Object tableName = rs.getString(1);
                    if (TestHelper.isQuoteRequired((String)tableName)) {
                        tableName = "\"" + (String)tableName + "\"";
                    }
                    TestHelper.dropTable(connection, String.format("%s.%s", SCHEMA_USER, tableName));
                }
            });
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to clean database", e);
        }
    }

    public static boolean isQuoteRequired(String tableName) {
        if (!(Strings.isNullOrBlank((String)tableName) || tableName.startsWith("\"") || tableName.endsWith("\""))) {
            for (int i = 0; i < tableName.length(); ++i) {
                char c = tableName.charAt(i);
                if (!Character.isLowerCase(c) && Character.isLetterOrDigit(c)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<BigInteger> getCurrentRedoLogSequences() throws SQLException {
        try (OracleConnection connection = TestHelper.adminConnection();){
            List list = (List)connection.queryAndMap("SELECT SEQUENCE# FROM V$LOG WHERE STATUS = 'CURRENT'", rs -> {
                ArrayList<BigInteger> sequences = new ArrayList<BigInteger>();
                while (rs.next()) {
                    sequences.add(new BigInteger(rs.getString(1)));
                }
                return sequences;
            });
            return list;
        }
    }

    public static String getDefaultInfinispanEmbeddedCacheConfig(String cacheName) {
        String result = ((SoftIndexFileStoreConfigurationBuilder)((SoftIndexFileStoreConfigurationBuilder)((SoftIndexFileStoreConfigurationBuilder)((SoftIndexFileStoreConfigurationBuilder)((SoftIndexFileStoreConfigurationBuilder)new ConfigurationBuilder().persistence().passivation(false).addSoftIndexFileStore().segmented(true)).preload(true)).shared(false)).fetchPersistentState(true)).ignoreModifications(false)).dataLocation("./target/data").indexLocation("./target/data").build().toXMLString(cacheName);
        return result;
    }

    public static String getDefaultInfinispanRemoteCacheConfig(String cacheName) {
        return "<distributed-cache name=\"" + cacheName + "\" statistics=\"true\">\n\t<encoding media-type=\"application/x-protostream\"/>\n\t<persistence passivation=\"false\">\n\t\t<file-store read-only=\"false\" preload=\"true\" shared=\"false\" segmented=\"true\"/>\n\t</persistence>\n</distributed-cache>";
    }

    public static Configuration.Builder withDefaultInfinispanCacheConfigurations(OracleConnectorConfig.LogMiningBufferType bufferType, Configuration.Builder builder) {
        for (Map.Entry<String, Field> cacheMapping : cacheMappings.entrySet()) {
            Field field = cacheMapping.getValue();
            String cacheName = cacheMapping.getKey();
            String config = bufferType.isInfinispanEmbedded() ? TestHelper.getDefaultInfinispanEmbeddedCacheConfig(cacheName) : TestHelper.getDefaultInfinispanRemoteCacheConfig(cacheName);
            builder.with(field, config);
        }
        if (bufferType.isInfinispanEmbedded()) {
            builder.with(OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_GLOBAL, TestHelper.getDefaultInfinispanEmbeddedCacheConfig("global"));
        }
        return builder;
    }

    public static void sleep(long duration, TimeUnit units) throws Exception {
        Awaitility.await().atMost(duration + 1L, units).pollDelay(duration, units).until(() -> true);
    }

    public static String getOracleConnectionUrlDescriptor() {
        StringBuilder url = new StringBuilder();
        url.append("jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=");
        url.append(HOST);
        url.append(")(PORT=").append(1521).append("))");
        url.append("(CONNECT_DATA=(SERVER=DEDICATED)(SERVICE_NAME=").append(TestHelper.getDatabaseName()).append(")))");
        return url.toString();
    }

    public static boolean isUsingPdb() {
        Map properties = Configuration.fromSystemProperties((String)DATABASE_PREFIX).asMap();
        if (properties.containsKey(PDB_NAME)) {
            return !Strings.isNullOrEmpty((String)((String)properties.get(PDB_NAME)));
        }
        return Strings.isNullOrEmpty((String)((String)properties.get(PDB_NAME)));
    }

    public static OracleConnectorConfig.ConnectorAdapter getAdapter(Configuration config) {
        return OracleConnectorConfig.ConnectorAdapter.parse((String)config.getString(OracleConnectorConfig.CONNECTOR_ADAPTER));
    }

    public static Scn getCurrentScn() throws SQLException {
        try (OracleConnection admin = new OracleConnection(TestHelper.adminJdbcConfig(), false);){
            if (TestHelper.isUsingPdb()) {
                admin.resetSessionToCdb();
            }
            Scn scn = admin.getCurrentScn();
            return scn;
        }
    }

    private static Configuration getTestConnectionConfiguration(ConnectorConfiguration config) {
        Configuration connectionConfiguration = Configuration.from((Properties)config.asProperties()).subset(DATABASE_PREFIX, true);
        String dbName = Strings.isNullOrEmpty((String)connectionConfiguration.getString(PDB_NAME)) ? connectionConfiguration.getString(JdbcConfiguration.DATABASE) : connectionConfiguration.getString(PDB_NAME);
        return ((Configuration.Builder)((Configuration.Builder)connectionConfiguration.edit().with(JdbcConfiguration.HOSTNAME.name(), HOST).with(JdbcConfiguration.PORT, (Object)RestExtensionTestInfrastructure.getOracleContainer().getMappedPort(1521))).with(JdbcConfiguration.DATABASE, dbName)).build();
    }

    private static OracleConnection createConnection(ConnectorConfiguration config, boolean autoCommit) {
        Configuration connectionConfiguration = TestHelper.getTestConnectionConfiguration(config);
        OracleConnection connection = new OracleConnection(JdbcConfiguration.adapt((Configuration)connectionConfiguration));
        try {
            connection.setAutoCommit(autoCommit);
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create connection", e);
        }
    }

    /*
     * Exception decompiling
     */
    private static String[] getResourceSqlFileContent(String file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void loadTestData(ConnectorConfiguration config, String sqlFile) {
        try (OracleConnection conn = TestHelper.createConnection(config, false);){
            conn.execute(TestHelper.getResourceSqlFileContent(sqlFile));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void patchConnectorConfigurationForContainer(ConnectorConfiguration connectorConfiguration, OracleContainer oracleContainer) {
        String oracleImageName = oracleContainer.getDockerImageName();
        if (!oracleImageName.startsWith(OracleContainer.DEFAULT_IMAGE_NAME.getUnversionedPart())) {
            return;
        }
        String imageTag = "latest";
        String imageTagSuffix = "";
        if (oracleImageName.contains(":")) {
            imageTag = oracleImageName.split(":")[1];
        }
        if (imageTag.contains("-")) {
            imageTagSuffix = imageTag.substring(imageTag.lastIndexOf("-") + 1);
        }
        String pdbName = connectorConfiguration.asProperties().getProperty(OracleConnectorConfig.PDB_NAME.name());
        if (!imageTag.contains("-") || "xs".equals(imageTagSuffix)) {
            if (!Strings.isNullOrEmpty((String)pdbName)) {
                connectorConfiguration.with(OracleConnectorConfig.DATABASE_NAME.name(), pdbName);
            }
        } else if ("noncdb".equals(imageTagSuffix)) {
            if (!Strings.isNullOrEmpty((String)pdbName)) {
                connectorConfiguration.remove(OracleConnectorConfig.PDB_NAME.name());
            }
        } else {
            throw new RuntimeException("Invalid or unknown image tag '" + imageTagSuffix + "' for Oracle container image: " + oracleImageName);
        }
    }

    public static ConnectorConfiguration getOracleConnectorConfiguration(int id, String ... options) {
        OracleContainer oracleContainer = RestExtensionTestInfrastructure.getOracleContainer();
        ConnectorConfiguration config = ConnectorConfiguration.forJdbcContainer((JdbcDatabaseContainer)oracleContainer).with(OracleConnectorConfig.PDB_NAME.name(), oracleContainer.ORACLE_PDB_NAME).with(OracleConnectorConfig.DATABASE_NAME.name(), oracleContainer.ORACLE_DBNAME).with(OracleConnectorConfig.TOPIC_PREFIX.name(), "dbserver" + id).with(KafkaSchemaHistory.BOOTSTRAP_SERVERS.name(), "kafka-dbz-ui:9092").with(KafkaSchemaHistory.TOPIC.name(), "dbhistory.oracle");
        if (options != null && options.length > 0) {
            for (int i = 0; i < options.length; i += 2) {
                config.with(options[i], options[i + 1]);
            }
        }
        TestHelper.patchConnectorConfigurationForContainer(config, oracleContainer);
        return config;
    }

    static {
        cacheMappings.put("transactions", OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_TRANSACTIONS);
        cacheMappings.put("processed-transactions", OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_PROCESSED_TRANSACTIONS);
        cacheMappings.put("schema-changes", OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_SCHEMA_CHANGES);
        cacheMappings.put("events", OracleConnectorConfig.LOG_MINING_BUFFER_INFINISPAN_CACHE_EVENTS);
    }
}

