/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.config.Configuration;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleStreamingMetricsTest;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.LogMinerStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import java.math.BigInteger;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.Test;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class LogMinerStreamMetricsTest
extends OracleStreamingMetricsTest<LogMinerStreamingChangeEventSourceMetrics> {
    @Override
    protected LogMinerStreamingChangeEventSourceMetrics createMetrics(OracleTaskContext taskContext, ChangeEventQueue<DataChangeEvent> queue, EventMetadataProvider metadataProvider, OracleConnectorConfig connectorConfig, Clock clock) {
        return new LogMinerStreamingChangeEventSourceMetrics((CdcSourceTaskContext)taskContext, queue, metadataProvider, connectorConfig, clock);
    }

    @Test
    public void testMetrics() {
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setLastCapturedDmlCount(1);
        Assertions.assertThat((((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getTotalCapturedDmlCount() == 1L ? 1 : 0) != 0).isTrue();
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setCurrentScn(Scn.valueOf((long)1000L));
        Assertions.assertThat((BigInteger)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getCurrentScn()).isEqualTo("1000");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setLastDurationOfFetchQuery(Duration.ofMillis(100L));
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLastDurationOfFetchQueryInMilliseconds()).isEqualTo(100L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setLastDurationOfFetchQuery(Duration.ofMillis(200L));
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLastDurationOfFetchQueryInMilliseconds()).isEqualTo(200L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxDurationOfFetchQueryInMilliseconds()).isEqualTo(200L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getFetchingQueryCount()).isEqualTo(2L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setCurrentLogFileNames(new HashSet<String>(Arrays.asList("name", "name1")));
        Assertions.assertThat((boolean)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getCurrentRedoLogFileName()[0].equals("name")).isTrue();
        Assertions.assertThat((boolean)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getCurrentRedoLogFileName()[1].equals("name1")).isTrue();
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setSwitchCount(5);
        Assertions.assertThat((((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getSwitchCounter() == 5 ? 1 : 0) != 0).isTrue();
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).reset();
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setLastDurationOfFetchQuery(Duration.ofMillis(1000L));
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLastDurationOfFetchQueryInMilliseconds()).isEqualTo(1000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getFetchingQueryCount()).isEqualTo(1L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).reset();
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setLastCapturedDmlCount(300);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setLastBatchProcessingDuration(Duration.ofMillis(1000L));
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLastCapturedDmlCount()).isEqualTo(300L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLastBatchProcessingTimeInMilliseconds()).isEqualTo(1000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getAverageBatchProcessingThroughput()).isGreaterThanOrEqualTo(300L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxCapturedDmlInBatch()).isEqualTo(300L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxBatchProcessingThroughput()).isEqualTo(300L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setLastCapturedDmlCount(500);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setLastBatchProcessingDuration(Duration.ofMillis(1000L));
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getAverageBatchProcessingThroughput()).isEqualTo(400L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxCapturedDmlInBatch()).isEqualTo(500L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxBatchProcessingThroughput()).isEqualTo(500L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLastBatchProcessingThroughput()).isEqualTo(500L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setLastBatchProcessingDuration(Duration.ofMillis(5000L));
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLastBatchProcessingThroughput()).isEqualTo(100L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setLastBatchProcessingDuration(Duration.ZERO);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLastBatchProcessingThroughput()).isEqualTo(0L);
        Assertions.assertThat((int)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getHoursToKeepTransactionInBuffer()).isEqualTo(0);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMillisecondsToKeepTransactionsInBuffer()).isEqualTo(0L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setRedoLogStatuses(Collections.singletonMap("name", "current"));
        Assertions.assertThat((boolean)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getRedoLogStatus()[0].equals("name | current")).isTrue();
        Assertions.assertThat((boolean)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).toString().contains("logMinerQueryCount"));
    }

    @Test
    public void testLagMetrics() {
        long lag = ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(0L);
        Instant dbEventTime = this.fixedClock.instant().minusMillis(2000L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).calculateLagFromSource(dbEventTime);
        lag = ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(2000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxLagFromSourceInMilliseconds()).isEqualTo(2000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMinLagFromSourceInMilliseconds()).isEqualTo(2000L);
        dbEventTime = this.fixedClock.instant().plusMillis(3000L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).calculateLagFromSource(dbEventTime);
        lag = ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(3000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxLagFromSourceInMilliseconds()).isEqualTo(3000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMinLagFromSourceInMilliseconds()).isEqualTo(2000L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).reset();
        OffsetDateTime dbTime = OffsetDateTime.parse("2021-05-16T00:30:01.00+12:00");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setDatabaseTimeDifference(dbTime);
        dbEventTime = Instant.parse("2021-05-16T00:29:58.00Z");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).calculateLagFromSource(dbEventTime);
        lag = ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(3000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxLagFromSourceInMilliseconds()).isEqualTo(3000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMinLagFromSourceInMilliseconds()).isEqualTo(3000L);
        dbEventTime = Instant.parse("2021-05-16T00:29:57.00Z");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).calculateLagFromSource(dbEventTime);
        lag = ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(4000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxLagFromSourceInMilliseconds()).isEqualTo(4000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMinLagFromSourceInMilliseconds()).isEqualTo(3000L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).reset();
        dbTime = OffsetDateTime.parse("2021-05-15T12:30:01.00Z");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setDatabaseTimeDifference(dbTime);
        dbEventTime = Instant.parse("2021-05-15T12:29:58.00Z");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).calculateLagFromSource(dbEventTime);
        lag = ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(3000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxLagFromSourceInMilliseconds()).isEqualTo(3000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMinLagFromSourceInMilliseconds()).isEqualTo(3000L);
        dbEventTime = Instant.parse("2021-05-15T12:29:57.00Z");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).calculateLagFromSource(dbEventTime);
        lag = ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(4000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxLagFromSourceInMilliseconds()).isEqualTo(4000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMinLagFromSourceInMilliseconds()).isEqualTo(3000L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).reset();
        dbTime = OffsetDateTime.parse("2021-05-15T00:30:01.00-12:00");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setDatabaseTimeDifference(dbTime);
        dbEventTime = Instant.parse("2021-05-15T00:29:58.00Z");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).calculateLagFromSource(dbEventTime);
        lag = ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(3000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxLagFromSourceInMilliseconds()).isEqualTo(3000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMinLagFromSourceInMilliseconds()).isEqualTo(3000L);
        dbEventTime = Instant.parse("2021-05-15T00:29:57.00Z");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).calculateLagFromSource(dbEventTime);
        lag = ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(4000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxLagFromSourceInMilliseconds()).isEqualTo(4000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMinLagFromSourceInMilliseconds()).isEqualTo(3000L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).reset();
        dbTime = OffsetDateTime.parse("2021-05-16T00:29:59.00+12:00");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setDatabaseTimeDifference(dbTime);
        dbEventTime = Instant.parse("2021-05-16T00:29:58.00Z");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).calculateLagFromSource(dbEventTime);
        lag = ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(1000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxLagFromSourceInMilliseconds()).isEqualTo(1000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMinLagFromSourceInMilliseconds()).isEqualTo(1000L);
        dbTime = OffsetDateTime.parse("2021-05-15T12:29:59.00Z");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setDatabaseTimeDifference(dbTime);
        dbEventTime = Instant.parse("2021-05-15T12:29:58.00Z");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).calculateLagFromSource(dbEventTime);
        lag = ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(1000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxLagFromSourceInMilliseconds()).isEqualTo(1000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMinLagFromSourceInMilliseconds()).isEqualTo(1000L);
        dbTime = OffsetDateTime.parse("2021-05-15T00:29:59.00-12:00");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setDatabaseTimeDifference(dbTime);
        dbEventTime = Instant.parse("2021-05-15T00:29:58.00Z");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).calculateLagFromSource(dbEventTime);
        lag = ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLagFromSourceInMilliseconds();
        Assertions.assertThat((long)lag).isEqualTo(1000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxLagFromSourceInMilliseconds()).isEqualTo(1000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMinLagFromSourceInMilliseconds()).isEqualTo(1000L);
    }

    @Test
    public void testOtherMetrics() {
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).incrementScnFreezeCount();
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getScnFreezeCount()).isEqualTo(1L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).incrementErrorCount();
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getErrorCount()).isEqualTo(1L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).incrementWarningCount();
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getWarningCount()).isEqualTo(1L);
        for (int i = 0; i < 1000; ++i) {
            ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).incrementTotalChangesCount();
            ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).incrementCommittedTransactionCount();
        }
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getRegisteredDmlCount()).isEqualTo(1000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getNumberOfCommittedTransactions()).isEqualTo(1000L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getCommitThroughput()).isGreaterThanOrEqualTo(1000L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).incrementOversizedTransactionCount();
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getNumberOfOversizedTransactions()).isEqualTo(1L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).incrementRolledBackTransactionCount();
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getNumberOfRolledBackTransactions()).isEqualTo(1L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setActiveTransactionCount(5L);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getNumberOfActiveTransactions()).isEqualTo(5L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).addRolledBackTransactionId("rolledback id");
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getNumberOfRolledBackTransactions()).isEqualTo(1L);
        Assertions.assertThat((boolean)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getRolledBackTransactionIds().contains("rolledback id")).isTrue();
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).addAbandonedTransactionId("abandoned id");
        Assertions.assertThat((int)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getAbandonedTransactionIds().size()).isEqualTo(1);
        Assertions.assertThat((boolean)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getAbandonedTransactionIds().contains("abandoned id")).isTrue();
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setOldestScnDetails(Scn.valueOf((long)10L), null);
        Assertions.assertThat((BigInteger)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getOldestScn()).isEqualTo("10");
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setCommitScn(Scn.valueOf((long)10L));
        Assertions.assertThat((BigInteger)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getCommittedScn()).isEqualTo("10");
        Assertions.assertThat((boolean)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).toString().contains("changesCount=1000")).isTrue();
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setLastCommitDuration(Duration.ofMillis(100L));
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getLastCommitDurationInMilliseconds()).isEqualTo(100L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setLastCommitDuration(Duration.ofMillis(50L));
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMaxCommitDurationInMilliseconds()).isEqualTo(100L);
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).setOffsetScn(Scn.valueOf((long)10L));
        Assertions.assertThat((BigInteger)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getOldestScn()).isEqualTo("10");
    }

    @Test
    @FixFor(value={"DBZ-2754"})
    public void testCustomTransactionRetention() throws Exception {
        this.init((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.LOG_MINING_TRANSACTION_RETENTION, 3));
        Assertions.assertThat((int)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getHoursToKeepTransactionInBuffer()).isEqualTo(3);
        Assertions.assertThat((long)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getMillisecondsToKeepTransactionsInBuffer()).isEqualTo(10800000L);
    }

    @Test
    @FixFor(value={"DBZ-5179"})
    public void testRollbackTransactionIdSetSizeLimit() throws Exception {
        this.init((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.LOG_MINING_TRANSACTION_RETENTION, 3));
        for (int i = 1; i <= 10; ++i) {
            ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).addRolledBackTransactionId(String.valueOf(i));
        }
        Assertions.assertThat((Iterable)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getRolledBackTransactionIds()).containsOnly((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).addRolledBackTransactionId("11");
        Assertions.assertThat((Iterable)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getRolledBackTransactionIds()).containsOnly((Object[])new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11"});
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).addRolledBackTransactionId("11");
        Assertions.assertThat((Iterable)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getRolledBackTransactionIds()).containsOnly((Object[])new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11"});
    }

    @Test
    @FixFor(value={"DBZ-5179"})
    public void testAbandonedTransactionIdSetSizeLimit() throws Exception {
        this.init((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.LOG_MINING_TRANSACTION_RETENTION, 3));
        for (int i = 1; i <= 10; ++i) {
            ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).addAbandonedTransactionId(String.valueOf(i));
        }
        Assertions.assertThat((Iterable)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getAbandonedTransactionIds()).containsOnly((Object[])new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).addAbandonedTransactionId("11");
        Assertions.assertThat((Iterable)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getAbandonedTransactionIds()).containsOnly((Object[])new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11"});
        ((LogMinerStreamingChangeEventSourceMetrics)this.metrics).addAbandonedTransactionId("11");
        Assertions.assertThat((Iterable)((LogMinerStreamingChangeEventSourceMetrics)this.metrics).getAbandonedTransactionIds()).containsOnly((Object[])new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "11"});
    }
}

