/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.oracle.AbstractOracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleEventMetadataProvider;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.mockito.Mockito;

public abstract class OracleStreamingMetricsTest<T extends AbstractOracleStreamingChangeEventSourceMetrics> {
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();
    protected OracleConnectorConfig connectorConfig;
    protected T metrics;
    protected Clock fixedClock;

    @Before
    public void before() {
        this.init(TestHelper.defaultConfig());
    }

    protected void init(Configuration.Builder builder) {
        this.connectorConfig = new OracleConnectorConfig(builder.build());
        ChangeEventQueue queue = new ChangeEventQueue.Builder().pollInterval(Duration.of(8192L, ChronoUnit.MILLIS)).maxBatchSize(2048).maxQueueSize(8192).build();
        OracleTaskContext taskContext = (OracleTaskContext)Mockito.mock(OracleTaskContext.class);
        Mockito.when((Object)taskContext.getConnectorName()).thenReturn((Object)"connector name");
        Mockito.when((Object)taskContext.getConnectorType()).thenReturn((Object)"connector type");
        OracleEventMetadataProvider metadataProvider = new OracleEventMetadataProvider();
        this.fixedClock = Clock.fixed(Instant.parse("2021-05-15T12:30:00.00Z"), ZoneOffset.UTC);
        this.metrics = this.createMetrics(taskContext, (ChangeEventQueue<DataChangeEvent>)queue, (EventMetadataProvider)metadataProvider, this.connectorConfig, this.fixedClock);
    }

    protected abstract T createMetrics(OracleTaskContext var1, ChangeEventQueue<DataChangeEvent> var2, EventMetadataProvider var3, OracleConnectorConfig var4, Clock var5);
}

