/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.converters.RawToStringConverter;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OracleRawToStringIT
extends AbstractConnectorTest {
    private OracleConnection connection;

    @Before
    public void before() throws Exception {
        this.connection = TestHelper.testConnection();
        TestHelper.dropTable(this.connection, "debezium.raw_to_string_test");
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        this.connection.execute(new String[]{"CREATE TABLE raw_to_string_test (id numeric primary key, data raw(128))"});
        TestHelper.streamTable(this.connection, "debezium.raw_to_string_test");
    }

    @After
    public void after() throws Exception {
        this.stopConnector();
        if (this.connection != null && this.connection.isConnected()) {
            TestHelper.dropTable(this.connection, "debezium.raw_to_string_test");
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-7753"})
    public void shouldHandleRawConvertedToString() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.RAW_TO_STRING_TEST")).with(OracleConnectorConfig.CUSTOM_CONVERTERS, "raw")).with("raw.type", RawToStringConverter.class.getName()).with("raw.selector", ".*RAW_TO_STRING_TEST\\.DATA.*").build();
        this.insertDataBatchStartingAtKey(1);
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleRawToStringIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(2);
        List testRecords = records.recordsForTopic("server1.DEBEZIUM.RAW_TO_STRING_TEST");
        Assertions.assertThat((List)testRecords).hasSize(2);
        this.assertRecordNumberValue(testRecords, 0, BigDecimal.valueOf(1L), null);
        this.assertRecordNumberValue(testRecords, 1, BigDecimal.valueOf(2L), "2b09ccae-06aa-45aa-a2f1-dd0e4c047249");
        OracleRawToStringIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        this.insertDataBatchStartingAtKey(5);
        records = this.consumeRecordsByTopic(2);
        testRecords = records.recordsForTopic("server1.DEBEZIUM.RAW_TO_STRING_TEST");
        Assertions.assertThat((List)testRecords).hasSize(2);
        this.assertRecordNumberValue(testRecords, 0, BigDecimal.valueOf(5L), null);
        this.assertRecordNumberValue(testRecords, 1, BigDecimal.valueOf(6L), "2b09ccae-06aa-45aa-a2f1-dd0e4c047249");
    }

    private void assertRecordNumberValue(List<SourceRecord> records, int index, Object key, Object data) {
        Struct after = (Struct)((Struct)records.get(index).value()).get("after");
        Assertions.assertThat((Object)after.get("ID")).isEqualTo(key);
        Assertions.assertThat((Object)after.get("DATA")).isEqualTo(data);
    }

    private void insertDataBatchStartingAtKey(int initialKey) throws SQLException {
        this.connection.executeWithoutCommitting(new String[]{"INSERT INTO debezium.raw_to_string_test values (" + initialKey + ", null)"});
        this.connection.prepareQuery("INSERT INTO debezium.raw_to_string_test values (?, utl_raw.cast_to_raw(?))", ps -> {
            ps.setInt(1, initialKey + 1);
            ps.setString(2, "2b09ccae-06aa-45aa-a2f1-dd0e4c047249");
        }, null);
        this.connection.commit();
    }
}

