/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIs;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.Clob;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class OraclePrimaryKeyLobReselectIT
extends AbstractConnectorTest {
    @Rule
    public TestRule skipAdapterRule = new SkipTestDependingOnAdapterNameRule();
    private OracleConnection connection;

    @Before
    public void beforeEach() {
        this.connection = TestHelper.testConnection();
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void afterEach() throws Exception {
        super.stopConnector();
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-7458"})
    public void testCharColumn() throws Exception {
        this.testPrimaryKeyChangeReselect("char(5)", "'no'");
    }

    @Test
    @FixFor(value={"DBZ-7458"})
    public void testNationalizedCharColumn() throws Exception {
        this.testPrimaryKeyChangeReselect("nchar(5)", "'no'");
    }

    @Test
    @FixFor(value={"DBZ-7458"})
    public void testVarchar2Column() throws Exception {
        this.testPrimaryKeyChangeReselect("varchar2(50)", "'insert'");
    }

    @Test
    @FixFor(value={"DBZ-7458"})
    public void testNationalizedVarchar2Column() throws Exception {
        this.testPrimaryKeyChangeReselect("nvarchar2(50)", "'insert'");
    }

    @Test
    @FixFor(value={"DBZ-7458"})
    public void testNumericColumnNotVariableScaleDecimal() throws Exception {
        this.testPrimaryKeyChangeReselect("numeric(18,0)", "25");
    }

    @Test
    @FixFor(value={"DBZ-7458"})
    public void testNumeric38Column() throws Exception {
        this.testPrimaryKeyChangeReselect("numeric(38,0)", "25");
    }

    @Test
    @FixFor(value={"DBZ-7458"})
    public void testFloatColumn() throws Exception {
        this.testPrimaryKeyChangeReselect("float(38)", "25");
    }

    @Test
    @SkipWhenAdapterNameIs(value=SkipWhenAdapterNameIs.AdapterName.OLR, reason="BINARY_FLOAT not supported")
    @FixFor(value={"DBZ-7458"})
    public void testBinaryFloatColumn() throws Exception {
        this.testPrimaryKeyChangeReselect("binary_float", "25");
    }

    @Test
    @SkipWhenAdapterNameIs(value=SkipWhenAdapterNameIs.AdapterName.OLR, reason="BINARY_DOUBLE not supported")
    @FixFor(value={"DBZ-7458"})
    public void testBinaryDoubleColumn() throws Exception {
        this.testPrimaryKeyChangeReselect("binary_double", "25");
    }

    @Test
    @FixFor(value={"DBZ-7458"})
    public void testDateColumn() throws Exception {
        this.testPrimaryKeyChangeReselect("date", "sysdate");
    }

    @Test
    @FixFor(value={"DBZ-7458"})
    public void testTimestampColumn() throws Exception {
        this.testPrimaryKeyChangeReselect("timestamp", "current_timestamp");
    }

    @Test
    @FixFor(value={"DBZ-7458"})
    public void testIntervalYearToMonthColumn() throws Exception {
        this.testPrimaryKeyChangeReselect("interval year to month", "INTERVAL '-3-6' YEAR TO MONTH");
    }

    @Test
    @FixFor(value={"DBZ-7458"})
    public void testIntervalDayToSecondColumn() throws Exception {
        this.testPrimaryKeyChangeReselect("interval day(3) to second(2)", "INTERVAL '-1 2:3:4.56' DAY TO SECOND");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPrimaryKeyChangeReselect(String keyType, String keyValue) throws Exception {
        TestHelper.dropTable(this.connection, "dbz7458");
        try {
            this.connection.execute(new String[]{String.format("CREATE TABLE dbz7458 (id numeric(9,0), other_id %s, data clob, primary key(id, other_id))", keyType)});
            TestHelper.streamTable(this.connection, "dbz7458");
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.LOB_ENABLED, "true")).with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM.DBZ7458")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OraclePrimaryKeyLobReselectIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            String data = RandomStringUtils.randomAlphanumeric((int)16384);
            Clob clob = this.connection.connection().createClob();
            clob.setString(1L, data);
            this.connection.prepareQuery(String.format("INSERT INTO dbz7458 (id,other_id,data) values (1,%s,?)", keyValue), ps -> ps.setClob(1, clob), null);
            this.connection.commit();
            this.connection.execute(new String[]{"UPDATE dbz7458 SET id = 2 WHERE id = 1"});
            AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(4);
            List tableRecords = sourceRecords.recordsForTopic("server1.DEBEZIUM.DBZ7458");
            Assertions.assertThat((List)tableRecords).hasSize(4);
            SourceRecord insert = (SourceRecord)tableRecords.get(3);
            VerifyRecord.isValidInsert((SourceRecord)insert, (String)"ID", (int)2);
            Struct after = ((Struct)insert.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)data);
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz7458");
        }
    }
}

