/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor;

import io.debezium.connector.oracle.logminer.processor.TransactionCommitConsumer;
import java.sql.SQLException;
import java.util.List;
import java.util.Random;
import oracle.sql.RAW;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class LobUnderConstructionTest {
    @Test
    public void shouldBuildCorrectLobFromInitialValue() {
        TransactionCommitConsumer.LobUnderConstruction lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue(null);
        Assertions.assertThat((boolean)lob.isNull).isTrue();
        Assertions.assertThat((List)lob.fragments).isEmpty();
        Assertions.assertThat((int)lob.start).isEqualTo(0);
        Assertions.assertThat((int)lob.end).isEqualTo(0);
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)"EMPTY_BLOB()");
        Assertions.assertThat((boolean)lob.isNull).isFalse();
        Assertions.assertThat((boolean)lob.binary).isTrue();
        Assertions.assertThat((List)lob.fragments).isEmpty();
        Assertions.assertThat((int)lob.start).isEqualTo(0);
        Assertions.assertThat((int)lob.end).isEqualTo(0);
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)"EMPTY_CLOB()");
        Assertions.assertThat((boolean)lob.isNull).isFalse();
        Assertions.assertThat((boolean)lob.binary).isFalse();
        Assertions.assertThat((List)lob.fragments).isEmpty();
        Assertions.assertThat((int)lob.start).isEqualTo(0);
        Assertions.assertThat((int)lob.end).isEqualTo(0);
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)"0123456789");
        Assertions.assertThat((boolean)lob.isNull).isFalse();
        Assertions.assertThat((boolean)lob.binary).isFalse();
        Assertions.assertThat((int)lob.start).isEqualTo(0);
        Assertions.assertThat((int)lob.end).isEqualTo(10);
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)"HEXTORAW('0123456789')");
        Assertions.assertThat((boolean)lob.isNull).isFalse();
        Assertions.assertThat((boolean)lob.binary).isTrue();
        Assertions.assertThat((int)lob.start).isEqualTo(0);
        Assertions.assertThat((int)lob.end).isEqualTo(5);
        TransactionCommitConsumer.LobUnderConstruction lob2 = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)lob);
        Assertions.assertThat((lob2 == lob ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void shouldMergeCorrectly() throws SQLException {
        TransactionCommitConsumer.LobUnderConstruction lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue(null);
        Assertions.assertThat((Object)lob.merge()).isEqualTo(null);
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)"EMPTY_BLOB()");
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)"EMPTY_BLOB()");
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)"EMPTY_CLOB()");
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)"EMPTY_CLOB()");
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)"0123456789");
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)"0123456789");
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)"EMPTY_CLOB()");
        lob.add((TransactionCommitConsumer.Fragment)new TransactionCommitConsumer.LobFragment("0123456789"));
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)"0123456789");
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)"HEXTORAW('0123456789')");
        Assertions.assertThat((Object)lob.merge()).isInstanceOf(byte[].class);
        Assertions.assertThat((byte[])((byte[])lob.merge())).isEqualTo((Object)RAW.hexString2Bytes((String)"0123456789"));
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)"EMPTY_BLOB()");
        lob.add((TransactionCommitConsumer.Fragment)new TransactionCommitConsumer.LobFragment("HEXTORAW('0123456789')"));
        Assertions.assertThat((Object)lob.merge()).isInstanceOf(byte[].class);
        Assertions.assertThat((byte[])((byte[])lob.merge())).isEqualTo((Object)RAW.hexString2Bytes((String)"0123456789"));
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)"0123456789");
        TransactionCommitConsumer.LobFragment frag = new TransactionCommitConsumer.LobFragment("9876543210");
        frag.offset = 11;
        lob.add((TransactionCommitConsumer.Fragment)frag);
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)"0123456789 9876543210");
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)"HEXTORAW('0123456789')");
        frag = new TransactionCommitConsumer.LobFragment("HEXTORAW('9876543210')");
        frag.offset = 6;
        lob.add((TransactionCommitConsumer.Fragment)frag);
        Assertions.assertThat((byte[])((byte[])lob.merge())).isEqualTo((Object)RAW.hexString2Bytes((String)"0123456789009876543210"));
    }

    private String randomString(int length) {
        int lower = 97;
        int upper = 122;
        return new Random().ints(lower, upper + 1).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    private String encodeBytes(byte[] bytes, int offset, int length) {
        StringBuilder builder = new StringBuilder("HEXTORAW('");
        for (int i = offset; i < offset + length; ++i) {
            builder.append(String.format("%02x", bytes[i]));
        }
        builder.append("')");
        return builder.toString();
    }

    @Test
    public void shouldHandleNonLinearInsertionOrderWithOverwritesForBlob() {
        TransactionCommitConsumer.LobFragment frag;
        int offset;
        int i;
        byte[] contents = new byte[1024];
        new Random().nextBytes(contents);
        TransactionCommitConsumer.LobUnderConstruction lob = new TransactionCommitConsumer.LobUnderConstruction();
        for (i = 0; i < 64; ++i) {
            offset = 1024 - 16 * i - 16;
            frag = new TransactionCommitConsumer.LobFragment(this.encodeBytes(contents, offset, 16));
            frag.offset = offset;
            lob.add((TransactionCommitConsumer.Fragment)frag);
        }
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)contents);
        lob = new TransactionCommitConsumer.LobUnderConstruction();
        for (i = 0; i < 32; ++i) {
            int frontOffset = 16 * i;
            TransactionCommitConsumer.LobFragment frontFrag = new TransactionCommitConsumer.LobFragment(this.encodeBytes(contents, frontOffset, 16));
            frontFrag.offset = frontOffset;
            int backOffset = 1024 - 16 * i - 16;
            TransactionCommitConsumer.LobFragment backFrag = new TransactionCommitConsumer.LobFragment(this.encodeBytes(contents, backOffset, 16));
            backFrag.offset = backOffset;
            lob.add((TransactionCommitConsumer.Fragment)frontFrag);
            lob.add((TransactionCommitConsumer.Fragment)backFrag);
        }
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)contents);
        lob = new TransactionCommitConsumer.LobUnderConstruction();
        for (i = 0; i < 32; ++i) {
            offset = 32 * i;
            frag = new TransactionCommitConsumer.LobFragment(this.encodeBytes(contents, offset, 16));
            frag.offset = offset;
            lob.add((TransactionCommitConsumer.Fragment)frag);
        }
        for (i = 0; i < 32; ++i) {
            offset = 32 * i + 16;
            frag = new TransactionCommitConsumer.LobFragment(this.encodeBytes(contents, offset, 16));
            frag.offset = offset;
            lob.add((TransactionCommitConsumer.Fragment)frag);
        }
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)contents);
        lob = new TransactionCommitConsumer.LobUnderConstruction();
        for (i = 0; i < 63; ++i) {
            offset = 16 * i;
            frag = new TransactionCommitConsumer.LobFragment(this.encodeBytes(contents, offset, 32));
            frag.offset = offset;
            lob.add((TransactionCommitConsumer.Fragment)frag);
        }
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)contents);
        byte[] otherContents = new byte[1024];
        new Random().nextBytes(otherContents);
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)this.encodeBytes(otherContents, 0, otherContents.length));
        for (int i2 = 0; i2 < 64; ++i2) {
            int offset2 = 1024 - 16 * i2 - 16;
            TransactionCommitConsumer.LobFragment frag2 = new TransactionCommitConsumer.LobFragment(this.encodeBytes(contents, offset2, 16));
            frag2.offset = offset2;
            lob.add((TransactionCommitConsumer.Fragment)frag2);
            Assertions.assertThat((int)lob.fragments.size()).isLessThan(11);
        }
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)contents);
    }

    @Test
    public void shouldHandleNonLinearInsertionOrderWithOverwritesForClob() {
        TransactionCommitConsumer.LobFragment frag;
        int offset;
        int i;
        String contents = this.randomString(1024);
        TransactionCommitConsumer.LobUnderConstruction lob = new TransactionCommitConsumer.LobUnderConstruction();
        for (i = 0; i < 64; ++i) {
            offset = 1024 - 16 * i - 16;
            frag = new TransactionCommitConsumer.LobFragment(contents.substring(offset, offset + 16));
            frag.offset = offset;
            lob.add((TransactionCommitConsumer.Fragment)frag);
        }
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)contents);
        lob = new TransactionCommitConsumer.LobUnderConstruction();
        for (i = 0; i < 32; ++i) {
            int frontOffset = 16 * i;
            TransactionCommitConsumer.LobFragment frontFrag = new TransactionCommitConsumer.LobFragment(contents.substring(frontOffset, frontOffset + 16));
            frontFrag.offset = frontOffset;
            int backOffset = 1024 - 16 * i - 16;
            TransactionCommitConsumer.LobFragment backFrag = new TransactionCommitConsumer.LobFragment(contents.substring(backOffset, backOffset + 16));
            backFrag.offset = backOffset;
            lob.add((TransactionCommitConsumer.Fragment)frontFrag);
            lob.add((TransactionCommitConsumer.Fragment)backFrag);
        }
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)contents);
        lob = new TransactionCommitConsumer.LobUnderConstruction();
        for (i = 0; i < 32; ++i) {
            offset = 32 * i;
            frag = new TransactionCommitConsumer.LobFragment(contents.substring(offset, offset + 16));
            frag.offset = offset;
            lob.add((TransactionCommitConsumer.Fragment)frag);
        }
        for (i = 0; i < 32; ++i) {
            offset = 32 * i + 16;
            frag = new TransactionCommitConsumer.LobFragment(contents.substring(offset, offset + 16));
            frag.offset = offset;
            lob.add((TransactionCommitConsumer.Fragment)frag);
        }
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)contents);
        lob = new TransactionCommitConsumer.LobUnderConstruction();
        for (i = 0; i < 63; ++i) {
            offset = 16 * i;
            frag = new TransactionCommitConsumer.LobFragment(contents.substring(offset, offset + 32));
            frag.offset = offset;
            lob.add((TransactionCommitConsumer.Fragment)frag);
        }
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)contents);
        lob = TransactionCommitConsumer.LobUnderConstruction.fromInitialValue((Object)this.randomString(1024));
        for (i = 0; i < 64; ++i) {
            offset = 1024 - 16 * i - 16;
            frag = new TransactionCommitConsumer.LobFragment(contents.substring(offset, offset + 16));
            frag.offset = offset;
            lob.add((TransactionCommitConsumer.Fragment)frag);
            Assertions.assertThat((int)lob.fragments.size()).isLessThan(11);
        }
        Assertions.assertThat((Object)lob.merge()).isEqualTo((Object)contents);
    }
}

