/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.logminer.UnistrHelper;
import io.debezium.doc.FixFor;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class UnistrHelperTest {
    @Test
    @FixFor(value={"DBZ-3892"})
    public void shouldCorrectlyDetectIfUnistrValue() throws Exception {
        Assertions.assertThat((boolean)UnistrHelper.isUnistrFunction((String)"UNISTR('\\0412\\044B')")).isTrue();
        Assertions.assertThat((boolean)UnistrHelper.isUnistrFunction((String)"OTHER_FUNCTION('\\0412\\044B')")).isFalse();
    }

    @Test
    @FixFor(value={"DBZ-3892"})
    public void shouldConvertUnistrValues() throws Exception {
        Assertions.assertThat((String)UnistrHelper.convert((String)"UNISTR('\\0412\\044B')")).isEqualTo((Object)"\u0412\u044b");
        Assertions.assertThat((String)UnistrHelper.convert((String)"UNISTR('\\0412\\044B') || UNISTR('\\0431\\0443')")).isEqualTo((Object)"\u0412\u044b\u0431\u0443");
        Assertions.assertThat((String)UnistrHelper.convert((String)"UNISTR('\\0412\\044B')||UNISTR('\\0431\\0443')")).isEqualTo((Object)"\u0412\u044b\u0431\u0443");
        Assertions.assertThat((String)UnistrHelper.convert((String)"UNISTR('\\0412\\044B') ||UNISTR('\\0431\\0443')")).isEqualTo((Object)"\u0412\u044b\u0431\u0443");
        Assertions.assertThat((String)UnistrHelper.convert((String)"UNISTR('\\0412\\044B')|| UNISTR('\\0431\\0443')")).isEqualTo((Object)"\u0412\u044b\u0431\u0443");
        Assertions.assertThat((String)UnistrHelper.convert((String)"UNISTR('\\0412\\044B')||  UNISTR('\\0431\\0443')")).isEqualTo((Object)"\u0412\u044b\u0431\u0443");
        Assertions.assertThat((String)UnistrHelper.convert((String)"UNISTR('\\0412\\044B')  ||  UNISTR('\\0431\\0443')")).isEqualTo((Object)"\u0412\u044b\u0431\u0443");
    }
}

