/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.antlr.OracleDdlParser;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipTestWhenRunWithApicurioRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.junit.SkipWhenRunWithApicurio;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VariableScaleDecimal;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.embedded.EmbeddedEngineConfig;
import io.debezium.embedded.KafkaConnectUtil;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.junit.SkipLongRunning;
import io.debezium.junit.SkipTestRule;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Table;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlChanges;
import io.debezium.relational.ddl.DdlParserListener;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.relational.history.SchemaHistoryMetrics;
import io.debezium.relational.history.TableChanges;
import io.debezium.storage.file.history.FileSchemaHistory;
import io.debezium.util.Collect;
import io.debezium.util.Strings;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.apache.kafka.connect.storage.OffsetBackingStore;
import org.apache.kafka.connect.storage.OffsetStorageWriter;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER, reason="Only applies to LogMiner")
public class HybridMiningStrategyIT
extends AbstractConnectorTest {
    @Rule
    public final TestRule skipApicurioRule = new SkipTestWhenRunWithApicurioRule();
    @Rule
    public final TestRule skipAdapterRule = new SkipTestDependingOnAdapterNameRule();
    @Rule
    public final TestRule skipLongRunning = new SkipTestRule();
    private OracleConnection connection;
    private RelationalDatabaseConnectorConfig.DecimalHandlingMode decimalHandlingMode;
    private TemporalPrecisionMode temporalPrecisionMode;

    @Before
    public void beforeEach() throws Exception {
        this.connection = TestHelper.testConnection();
        this.decimalHandlingMode = RelationalDatabaseConnectorConfig.DecimalHandlingMode.PRECISE;
        this.temporalPrecisionMode = TemporalPrecisionMode.ADAPTIVE;
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        TestHelper.dropAllTables();
    }

    @After
    public void afterEach() throws Exception {
        if (this.connection != null) {
            TestHelper.dropAllTables();
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamOfflineSchemaChangesCharacterDataTypes() throws Exception {
        this.streamOfflineSchemaChanges("varchar(50)", QueryValue.ofBind("ABC"), QueryValue.ofBind("XYZ"), "ABC", "XYZ");
        this.streamOfflineSchemaChanges("varchar2(50)", QueryValue.ofBind("ABC"), QueryValue.ofBind("XYZ"), "ABC", "XYZ");
        this.streamOfflineSchemaChanges("nvarchar2(50)", QueryValue.ofBind("A\u00ea\u00f1\u00fcC"), QueryValue.ofBind("XYZ"), "A\u00ea\u00f1\u00fcC", "XYZ");
        this.streamOfflineSchemaChanges("char(3)", QueryValue.ofBind("NO"), QueryValue.ofBind("YES"), "NO ", "YES");
        this.streamOfflineSchemaChanges("nchar(3)", QueryValue.ofBind("NO"), QueryValue.ofBind("YES"), "NO ", "YES");
    }

    @Test
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamSchemaChangeWithDataChangeCharacterDataTypes() throws Exception {
        this.streamSchemaChangeMixedWithDataChange("varchar(50)", QueryValue.ofBind("ABC"), QueryValue.ofBind("XYZ"), "ABC", "XYZ");
        this.streamSchemaChangeMixedWithDataChange("varchar2(50)", QueryValue.ofBind("ABC"), QueryValue.ofBind("XYZ"), "ABC", "XYZ");
        this.streamSchemaChangeMixedWithDataChange("nvarchar2(50)", QueryValue.ofBind("A\u00ea\u00f1\u00fcC"), QueryValue.ofBind("XYZ"), "A\u00ea\u00f1\u00fcC", "XYZ");
        this.streamSchemaChangeMixedWithDataChange("char(3)", QueryValue.ofBind("NO"), QueryValue.ofBind("YES"), "NO ", "YES");
        this.streamSchemaChangeMixedWithDataChange("nchar(3)", QueryValue.ofBind("NO"), QueryValue.ofBind("YES"), "NO ", "YES");
    }

    @Test
    @SkipLongRunning
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamOfflineSchemaChangesFloatingPointDataTypes() throws Exception {
        this.streamOfflineSchemaChanges("binary_float", QueryValue.ofBind(Float.valueOf(3.14f)), QueryValue.ofBind(Float.valueOf(4.14f)), Float.valueOf(3.14f), Float.valueOf(4.14f));
        this.streamOfflineSchemaChanges("binary_double", QueryValue.ofBind(3.14), QueryValue.ofBind(4.14), 3.14, 4.14);
        this.streamOfflineSchemaChanges("float", QueryValue.ofBind(3.33), QueryValue.ofBind(4.33), this.varScaleDecimal("3.33"), this.varScaleDecimal("4.33"));
        this.streamOfflineSchemaChanges("float(10)", QueryValue.ofBind(8.888), QueryValue.ofBind(9.999), this.varScaleDecimal("8.888"), this.varScaleDecimal("9.999"));
        this.streamOfflineSchemaChanges("number(10,6)", QueryValue.ofBind(4.4444), QueryValue.ofBind(5.5555), new BigDecimal("4.444400"), new BigDecimal("5.555500"));
        this.streamOfflineSchemaChanges("double precision", QueryValue.ofBind(5.555), QueryValue.ofBind(6.666), this.varScaleDecimal("5.555"), this.varScaleDecimal("6.666"));
        this.streamOfflineSchemaChanges("real", QueryValue.ofBind(6.66), QueryValue.ofBind(7.77), this.varScaleDecimal("6.66"), this.varScaleDecimal("7.77"));
        this.streamOfflineSchemaChanges("decimal(10,6)", QueryValue.ofBind(1234.567891), QueryValue.ofBind(2345.678912), new BigDecimal("1234.567891"), new BigDecimal("2345.678912"));
        this.streamOfflineSchemaChanges("numeric(10,6)", QueryValue.ofBind(1234.567891), QueryValue.ofBind(2345.678912), new BigDecimal("1234.567891"), new BigDecimal("2345.678912"));
        this.streamOfflineSchemaChanges("number", QueryValue.ofBind(77.323), QueryValue.ofBind(88.434), this.varScaleDecimal("77.323"), this.varScaleDecimal("88.434"));
    }

    @Test
    @SkipLongRunning
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamOfflineSchemaChangesFloatingPointDataTypesAsString() throws Exception {
        this.decimalHandlingMode = RelationalDatabaseConnectorConfig.DecimalHandlingMode.STRING;
        this.streamOfflineSchemaChanges("binary_float", QueryValue.ofBind(Float.valueOf(3.14f)), QueryValue.ofBind(Float.valueOf(4.14f)), Float.valueOf(3.14f), Float.valueOf(4.14f));
        this.streamOfflineSchemaChanges("binary_double", QueryValue.ofBind(3.14), QueryValue.ofBind(4.14), 3.14, 4.14);
        this.streamOfflineSchemaChanges("float", QueryValue.ofBind(3.33), QueryValue.ofBind(4.33), "3.33", "4.33");
        this.streamOfflineSchemaChanges("float(10)", QueryValue.ofBind(8.888), QueryValue.ofBind(9.999), "8.888", "9.999");
        this.streamOfflineSchemaChanges("number(10,6)", QueryValue.ofBind(4.4444), QueryValue.ofBind(5.5555), "4.444400", "5.555500");
        this.streamOfflineSchemaChanges("double precision", QueryValue.ofBind(5.555), QueryValue.ofBind(6.666), "5.555", "6.666");
        this.streamOfflineSchemaChanges("real", QueryValue.ofBind(6.66), QueryValue.ofBind(7.77), "6.66", "7.77");
        this.streamOfflineSchemaChanges("decimal(10,6)", QueryValue.ofBind(1234.567891), QueryValue.ofBind(2345.678912), "1234.567891", "2345.678912");
        this.streamOfflineSchemaChanges("numeric(10,6)", QueryValue.ofBind(1234.567891), QueryValue.ofBind(2345.678912), "1234.567891", "2345.678912");
        this.streamOfflineSchemaChanges("number", QueryValue.ofBind(77.323), QueryValue.ofBind(88.434), "77.323", "88.434");
    }

    @Test
    @SkipLongRunning
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamOfflineSchemaChangesFloatingPointDataTypesAsDouble() throws Exception {
        this.decimalHandlingMode = RelationalDatabaseConnectorConfig.DecimalHandlingMode.DOUBLE;
        this.streamOfflineSchemaChanges("binary_float", QueryValue.ofBind(Float.valueOf(3.14f)), QueryValue.ofBind(Float.valueOf(4.14f)), Float.valueOf(3.14f), Float.valueOf(4.14f));
        this.streamOfflineSchemaChanges("binary_double", QueryValue.ofBind(3.14), QueryValue.ofBind(4.14), 3.14, 4.14);
        this.streamOfflineSchemaChanges("float", QueryValue.ofBind(3.33), QueryValue.ofBind(4.33), 3.33, 4.33);
        this.streamOfflineSchemaChanges("float(10)", QueryValue.ofBind(8.888), QueryValue.ofBind(9.999), 8.888, 9.999);
        this.streamOfflineSchemaChanges("number(10,6)", QueryValue.ofBind(4.4444), QueryValue.ofBind(5.5555), 4.4444, 5.5555);
        this.streamOfflineSchemaChanges("double precision", QueryValue.ofBind(5.555), QueryValue.ofBind(6.666), 5.555, 6.666);
        this.streamOfflineSchemaChanges("real", QueryValue.ofBind(6.66), QueryValue.ofBind(7.77), 6.66, 7.77);
        this.streamOfflineSchemaChanges("decimal(10,6)", QueryValue.ofBind(1234.567891), QueryValue.ofBind(2345.678912), 1234.567891, 2345.678912);
        this.streamOfflineSchemaChanges("numeric(10,6)", QueryValue.ofBind(1234.567891), QueryValue.ofBind(2345.678912), 1234.567891, 2345.678912);
        this.streamOfflineSchemaChanges("number", QueryValue.ofBind(77.323), QueryValue.ofBind(88.434), 77.323, 88.434);
    }

    @Test
    @SkipLongRunning
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamSchemaChangeWithDataChangeFloatingPointDataTypes() throws Exception {
        this.streamSchemaChangeMixedWithDataChange("binary_float", QueryValue.ofBind(Float.valueOf(3.14f)), QueryValue.ofBind(Float.valueOf(4.14f)), Float.valueOf(3.14f), Float.valueOf(4.14f));
        this.streamSchemaChangeMixedWithDataChange("binary_double", QueryValue.ofBind(3.14), QueryValue.ofBind(4.14), 3.14, 4.14);
        this.streamSchemaChangeMixedWithDataChange("float", QueryValue.ofBind(3.33), QueryValue.ofBind(4.33), this.varScaleDecimal("3.33"), this.varScaleDecimal("4.33"));
        this.streamSchemaChangeMixedWithDataChange("float(10)", QueryValue.ofBind(8.888), QueryValue.ofBind(9.999), this.varScaleDecimal("8.888"), this.varScaleDecimal("9.999"));
        this.streamSchemaChangeMixedWithDataChange("number(10,6)", QueryValue.ofBind(4.4444), QueryValue.ofBind(5.5555), new BigDecimal("4.444400"), new BigDecimal("5.555500"));
        this.streamSchemaChangeMixedWithDataChange("double precision", QueryValue.ofBind(5.555), QueryValue.ofBind(6.666), this.varScaleDecimal("5.555"), this.varScaleDecimal("6.666"));
        this.streamSchemaChangeMixedWithDataChange("real", QueryValue.ofBind(6.66), QueryValue.ofBind(7.77), this.varScaleDecimal("6.66"), this.varScaleDecimal("7.77"));
        this.streamSchemaChangeMixedWithDataChange("decimal(10,6)", QueryValue.ofBind(1234.567891), QueryValue.ofBind(2345.678912), new BigDecimal("1234.567891"), new BigDecimal("2345.678912"));
        this.streamSchemaChangeMixedWithDataChange("numeric(10,6)", QueryValue.ofBind(1234.567891), QueryValue.ofBind(2345.678912), new BigDecimal("1234.567891"), new BigDecimal("2345.678912"));
        this.streamSchemaChangeMixedWithDataChange("number", QueryValue.ofBind(77.323), QueryValue.ofBind(88.434), this.varScaleDecimal("77.323"), this.varScaleDecimal("88.434"));
    }

    @Test
    @SkipLongRunning
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamSchemaChangeWithDataChangeFloatingPointDataTypesAsString() throws Exception {
        this.decimalHandlingMode = RelationalDatabaseConnectorConfig.DecimalHandlingMode.STRING;
        this.streamSchemaChangeMixedWithDataChange("binary_float", QueryValue.ofBind(Float.valueOf(3.14f)), QueryValue.ofBind(Float.valueOf(4.14f)), Float.valueOf(3.14f), Float.valueOf(4.14f));
        this.streamSchemaChangeMixedWithDataChange("binary_double", QueryValue.ofBind(3.14), QueryValue.ofBind(4.14), 3.14, 4.14);
        this.streamSchemaChangeMixedWithDataChange("float", QueryValue.ofBind(3.33), QueryValue.ofBind(4.33), "3.33", "4.33");
        this.streamSchemaChangeMixedWithDataChange("float(10)", QueryValue.ofBind(8.888), QueryValue.ofBind(9.999), "8.888", "9.999");
        this.streamSchemaChangeMixedWithDataChange("number(10,6)", QueryValue.ofBind(4.4444), QueryValue.ofBind(5.5555), "4.444400", "5.555500");
        this.streamSchemaChangeMixedWithDataChange("double precision", QueryValue.ofBind(5.555), QueryValue.ofBind(6.666), "5.555", "6.666");
        this.streamSchemaChangeMixedWithDataChange("real", QueryValue.ofBind(6.66), QueryValue.ofBind(7.77), "6.66", "7.77");
        this.streamSchemaChangeMixedWithDataChange("decimal(10,6)", QueryValue.ofBind(1234.567891), QueryValue.ofBind(2345.678912), "1234.567891", "2345.678912");
        this.streamSchemaChangeMixedWithDataChange("numeric(10,6)", QueryValue.ofBind(1234.567891), QueryValue.ofBind(2345.678912), "1234.567891", "2345.678912");
        this.streamSchemaChangeMixedWithDataChange("number", QueryValue.ofBind(77.323), QueryValue.ofBind(88.434), "77.323", "88.434");
    }

    @Test
    @SkipLongRunning
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamSchemaChangeWithDataChangeFloatingPointDataTypesAsDouble() throws Exception {
        this.decimalHandlingMode = RelationalDatabaseConnectorConfig.DecimalHandlingMode.DOUBLE;
        this.streamSchemaChangeMixedWithDataChange("binary_float", QueryValue.ofBind(Float.valueOf(3.14f)), QueryValue.ofBind(Float.valueOf(4.14f)), Float.valueOf(3.14f), Float.valueOf(4.14f));
        this.streamSchemaChangeMixedWithDataChange("binary_double", QueryValue.ofBind(3.14), QueryValue.ofBind(4.14), 3.14, 4.14);
        this.streamSchemaChangeMixedWithDataChange("float", QueryValue.ofBind(3.33), QueryValue.ofBind(4.33), 3.33, 4.33);
        this.streamSchemaChangeMixedWithDataChange("float(10)", QueryValue.ofBind(8.888), QueryValue.ofBind(9.999), 8.888, 9.999);
        this.streamSchemaChangeMixedWithDataChange("number(10,6)", QueryValue.ofBind(4.4444), QueryValue.ofBind(5.5555), 4.4444, 5.5555);
        this.streamSchemaChangeMixedWithDataChange("double precision", QueryValue.ofBind(5.555), QueryValue.ofBind(6.666), 5.555, 6.666);
        this.streamSchemaChangeMixedWithDataChange("real", QueryValue.ofBind(6.66), QueryValue.ofBind(7.77), 6.66, 7.77);
        this.streamSchemaChangeMixedWithDataChange("decimal(10,6)", QueryValue.ofBind(1234.567891), QueryValue.ofBind(2345.678912), 1234.567891, 2345.678912);
        this.streamSchemaChangeMixedWithDataChange("numeric(10,6)", QueryValue.ofBind(1234.567891), QueryValue.ofBind(2345.678912), 1234.567891, 2345.678912);
        this.streamSchemaChangeMixedWithDataChange("number", QueryValue.ofBind(77.323), QueryValue.ofBind(88.434), 77.323, 88.434);
    }

    @Test
    @SkipWhenRunWithApicurio
    @SkipLongRunning
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamOfflineSchemaChangesIntegerDataTypes() throws Exception {
        this.streamOfflineSchemaChanges("int", QueryValue.ofBind(1), QueryValue.ofBind(2), new BigDecimal("1"), new BigDecimal("2"));
        this.streamOfflineSchemaChanges("integer", QueryValue.ofBind(1), QueryValue.ofBind(2), new BigDecimal("1"), new BigDecimal("2"));
        this.streamOfflineSchemaChanges("smallint", QueryValue.ofBind(33), QueryValue.ofBind(44), new BigDecimal("33"), new BigDecimal("44"));
        this.streamOfflineSchemaChanges("number(38)", QueryValue.ofBind(4444), QueryValue.ofBind(5555), new BigDecimal("4444"), new BigDecimal("5555"));
        this.streamOfflineSchemaChanges("number(38,0)", QueryValue.ofBind(4444), QueryValue.ofBind(5555), new BigDecimal("4444"), new BigDecimal("5555"));
        this.streamOfflineSchemaChanges("number(2)", QueryValue.ofBind(88), QueryValue.ofBind(99), (byte)88, (byte)99);
        this.streamOfflineSchemaChanges("number(4)", QueryValue.ofBind(8888), QueryValue.ofBind(9999), (short)8888, (short)9999);
        this.streamOfflineSchemaChanges("number(9)", QueryValue.ofBind(888888888), QueryValue.ofBind(999999999), 888888888, 999999999);
        this.streamOfflineSchemaChanges("number(18)", QueryValue.ofBind(888888888888888888L), QueryValue.ofBind(999999999999999999L), 888888888888888888L, 999999999999999999L);
        this.streamOfflineSchemaChanges("number(1,-1)", QueryValue.ofBind(93), QueryValue.ofBind(94), (byte)90, (byte)90);
        this.streamOfflineSchemaChanges("number(2,-2)", QueryValue.ofBind(9349), QueryValue.ofBind(9449), (short)9300, (short)9400);
        this.streamOfflineSchemaChanges("number(8,-1)", QueryValue.ofBind(989999994), QueryValue.ofBind(999999994), 989999990, 999999990);
        this.streamOfflineSchemaChanges("number(16,-2)", QueryValue.ofBind(989999999999999949L), QueryValue.ofBind(999999999999999949L), 989999999999999900L, 999999999999999900L);
        this.streamOfflineSchemaChanges("number(36,-2)", QueryValue.ofBind(new BigDecimal(new BigInteger("999999999999999999999999999999999999"), -2)), QueryValue.ofBind(new BigDecimal(new BigInteger("999999999999999999999999999999999949"), -2)), new BigDecimal(new BigInteger("999999999999999999999999999999999999"), -2), new BigDecimal(new BigInteger("999999999999999999999999999999999949"), -2));
        this.streamOfflineSchemaChanges("decimal(10)", QueryValue.ofBind(9899999999L), QueryValue.ofBind(9999999999L), 9899999999L, 9999999999L);
        this.streamOfflineSchemaChanges("numeric(10)", QueryValue.ofBind(9899999999L), QueryValue.ofBind(9999999999L), 9899999999L, 9999999999L);
        this.streamOfflineSchemaChanges("number(1)", QueryValue.ofBind(1), QueryValue.ofBind(2), (byte)1, (byte)2);
    }

    @Test
    @SkipWhenRunWithApicurio
    @SkipLongRunning
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamSchemaChangeWithDataChangeIntegerDataTypes() throws Exception {
        this.streamSchemaChangeMixedWithDataChange("int", QueryValue.ofBind(1), QueryValue.ofBind(2), new BigDecimal("1"), new BigDecimal("2"));
        this.streamSchemaChangeMixedWithDataChange("integer", QueryValue.ofBind(1), QueryValue.ofBind(2), new BigDecimal("1"), new BigDecimal("2"));
        this.streamSchemaChangeMixedWithDataChange("smallint", QueryValue.ofBind(33), QueryValue.ofBind(44), new BigDecimal("33"), new BigDecimal("44"));
        this.streamSchemaChangeMixedWithDataChange("number(38)", QueryValue.ofBind(4444), QueryValue.ofBind(5555), new BigDecimal("4444"), new BigDecimal("5555"));
        this.streamSchemaChangeMixedWithDataChange("number(38,0)", QueryValue.ofBind(4444), QueryValue.ofBind(5555), new BigDecimal("4444"), new BigDecimal("5555"));
        this.streamSchemaChangeMixedWithDataChange("number(2)", QueryValue.ofBind(88), QueryValue.ofBind(99), (byte)88, (byte)99);
        this.streamSchemaChangeMixedWithDataChange("number(4)", QueryValue.ofBind(8888), QueryValue.ofBind(9999), (short)8888, (short)9999);
        this.streamSchemaChangeMixedWithDataChange("number(9)", QueryValue.ofBind(888888888), QueryValue.ofBind(999999999), 888888888, 999999999);
        this.streamSchemaChangeMixedWithDataChange("number(18)", QueryValue.ofBind(888888888888888888L), QueryValue.ofBind(999999999999999999L), 888888888888888888L, 999999999999999999L);
        this.streamSchemaChangeMixedWithDataChange("number(1,-1)", QueryValue.ofBind(93), QueryValue.ofBind(94), (byte)90, (byte)90);
        this.streamSchemaChangeMixedWithDataChange("number(2,-2)", QueryValue.ofBind(9349), QueryValue.ofBind(9449), (short)9300, (short)9400);
        this.streamSchemaChangeMixedWithDataChange("number(8,-1)", QueryValue.ofBind(989999994), QueryValue.ofBind(999999994), 989999990, 999999990);
        this.streamSchemaChangeMixedWithDataChange("number(16,-2)", QueryValue.ofBind(989999999999999949L), QueryValue.ofBind(999999999999999949L), 989999999999999900L, 999999999999999900L);
        this.streamSchemaChangeMixedWithDataChange("number(36,-2)", QueryValue.ofBind(new BigDecimal(new BigInteger("999999999999999999999999999999999999"), -2)), QueryValue.ofBind(new BigDecimal(new BigInteger("999999999999999999999999999999999949"), -2)), new BigDecimal(new BigInteger("999999999999999999999999999999999999"), -2), new BigDecimal(new BigInteger("999999999999999999999999999999999949"), -2));
        this.streamSchemaChangeMixedWithDataChange("decimal(10)", QueryValue.ofBind(9899999999L), QueryValue.ofBind(9999999999L), 9899999999L, 9999999999L);
        this.streamSchemaChangeMixedWithDataChange("numeric(10)", QueryValue.ofBind(9899999999L), QueryValue.ofBind(9999999999L), 9899999999L, 9999999999L);
        this.streamSchemaChangeMixedWithDataChange("number(1)", QueryValue.ofBind(1), QueryValue.ofBind(2), (byte)1, (byte)2);
    }

    @Test
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamOfflineSchemaChangesTemporalDataTypes() throws Exception {
        this.streamOfflineSchemaChanges("date", QueryValue.ofSql("TO_DATE('2018-03-27','yyyy-mm-dd')"), QueryValue.ofSql("TO_DATE('2018-10-15','yyyy-mm-dd')"), 1522108800000L, 1539561600000L);
        this.streamOfflineSchemaChanges("timestamp", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 789, 5)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 789, 5)), LocalDateTime.of(2018, 3, 27, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000L + 7890L, LocalDateTime.of(2018, 10, 15, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000L + 7890L);
        this.streamOfflineSchemaChanges("timestamp(2)", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 12545, 5)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 12545, 5)), LocalDateTime.of(2018, 3, 27, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000L + 130L, LocalDateTime.of(2018, 10, 15, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000L + 130L);
        this.streamOfflineSchemaChanges("timestamp(4)", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 12545, 5)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 12545, 5)), LocalDateTime.of(2018, 3, 27, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000L + 125500L, LocalDateTime.of(2018, 10, 15, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000L + 125500L);
        this.streamOfflineSchemaChanges("timestamp(9)", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 123456789, 9)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 123456789, 9)), LocalDateTime.of(2018, 3, 27, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000000L + 123456789L, LocalDateTime.of(2018, 10, 15, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000000L + 123456789L);
        this.streamOfflineSchemaChanges("timestamp with time zone", QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 3, 27, 1, 34, 56, 7890, 6, "-11:00")), QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 10, 15, 1, 34, 56, 7890, 6, "-11:00")), "2018-03-27T01:34:56.007890-11:00", "2018-10-15T01:34:56.007890-11:00");
        this.streamOfflineSchemaChanges("timestamp with local time zone", QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 3, 27, 1, 34, 56, 7890, 6, "-06:00")), QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 10, 15, 1, 34, 56, 7890, 6, "-06:00")), "2018-03-27T07:34:56.007890Z", "2018-10-15T07:34:56.007890Z");
        this.streamOfflineSchemaChanges("interval year to month", QueryValue.ofSql("INTERVAL '-3-6' YEAR TO MONTH"), QueryValue.ofSql("INTERVAL '-2-5' YEAR TO MONTH"), -110451600000000L, -76264200000000L);
        this.streamOfflineSchemaChanges("interval day(3) to second(2)", QueryValue.ofSql("INTERVAL '-1 2:3:4.56' DAY TO SECOND"), QueryValue.ofSql("INTERVAL '-2 4:5:6.21' DAY TO SECOND"), -93784560000L, -187506210000L);
    }

    @Test
    @SkipLongRunning
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamOfflineSchemaChangesTemporalDataTypesAsConnect() throws Exception {
        this.temporalPrecisionMode = TemporalPrecisionMode.CONNECT;
        this.streamOfflineSchemaChanges("date", QueryValue.ofSql("TO_DATE('2018-03-27','yyyy-mm-dd')"), QueryValue.ofSql("TO_DATE('2018-10-15','yyyy-mm-dd')"), Date.from(LocalDate.of(2018, 3, 27).atStartOfDay().atOffset(ZoneOffset.UTC).toInstant()), Date.from(LocalDate.of(2018, 10, 15).atStartOfDay().atOffset(ZoneOffset.UTC).toInstant()));
        this.streamOfflineSchemaChanges("timestamp", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 789, 5)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 789, 5)), Date.from(LocalDateTime.of(2018, 3, 27, 12, 34, 56, 7890000).atOffset(ZoneOffset.UTC).toInstant()), Date.from(LocalDateTime.of(2018, 10, 15, 12, 34, 56, 7890000).atOffset(ZoneOffset.UTC).toInstant()));
        this.streamOfflineSchemaChanges("timestamp(2)", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 12545, 5)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 12545, 5)), Date.from(LocalDateTime.of(2018, 3, 27, 12, 34, 56, 130000000).atOffset(ZoneOffset.UTC).toInstant()), Date.from(LocalDateTime.of(2018, 10, 15, 12, 34, 56, 130000000).atOffset(ZoneOffset.UTC).toInstant()));
        this.streamOfflineSchemaChanges("timestamp(4)", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 12545, 5)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 12545, 5)), Date.from(LocalDateTime.of(2018, 3, 27, 12, 34, 56, 125500000).atOffset(ZoneOffset.UTC).toInstant()), Date.from(LocalDateTime.of(2018, 10, 15, 12, 34, 56, 125500000).atOffset(ZoneOffset.UTC).toInstant()));
        this.streamOfflineSchemaChanges("timestamp(9)", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 123456789, 9)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 123456789, 9)), Date.from(LocalDateTime.of(2018, 3, 27, 12, 34, 56, 123456789).atOffset(ZoneOffset.UTC).toInstant()), Date.from(LocalDateTime.of(2018, 10, 15, 12, 34, 56, 123456789).atOffset(ZoneOffset.UTC).toInstant()));
        this.streamOfflineSchemaChanges("timestamp with time zone", QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 3, 27, 1, 34, 56, 7890, 6, "-11:00")), QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 10, 15, 1, 34, 56, 7890, 6, "-11:00")), "2018-03-27T01:34:56.007890-11:00", "2018-10-15T01:34:56.007890-11:00");
        this.streamOfflineSchemaChanges("timestamp with local time zone", QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 3, 27, 1, 34, 56, 7890, 6, "-06:00")), QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 10, 15, 1, 34, 56, 7890, 6, "-06:00")), "2018-03-27T07:34:56.007890Z", "2018-10-15T07:34:56.007890Z");
        this.streamOfflineSchemaChanges("interval year to month", QueryValue.ofSql("INTERVAL '-3-6' YEAR TO MONTH"), QueryValue.ofSql("INTERVAL '-2-5' YEAR TO MONTH"), -110451600000000L, -76264200000000L);
        this.streamOfflineSchemaChanges("interval day(3) to second(2)", QueryValue.ofSql("INTERVAL '-1 2:3:4.56' DAY TO SECOND"), QueryValue.ofSql("INTERVAL '-2 4:5:6.21' DAY TO SECOND"), -93784560000L, -187506210000L);
    }

    @Test
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamSchemaChangeWithDataChangeTemporalDataTypes() throws Exception {
        this.streamSchemaChangeMixedWithDataChange("date", QueryValue.ofSql("TO_DATE('2018-03-27','yyyy-mm-dd')"), QueryValue.ofSql("TO_DATE('2018-10-15','yyyy-mm-dd')"), 1522108800000L, 1539561600000L);
        this.streamSchemaChangeMixedWithDataChange("timestamp", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 789, 5)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 789, 5)), LocalDateTime.of(2018, 3, 27, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000L + 7890L, LocalDateTime.of(2018, 10, 15, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000L + 7890L);
        this.streamSchemaChangeMixedWithDataChange("timestamp(2)", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 12545, 5)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 12545, 5)), LocalDateTime.of(2018, 3, 27, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000L + 130L, LocalDateTime.of(2018, 10, 15, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000L + 130L);
        this.streamSchemaChangeMixedWithDataChange("timestamp(4)", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 12545, 5)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 12545, 5)), LocalDateTime.of(2018, 3, 27, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000L + 125500L, LocalDateTime.of(2018, 10, 15, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000L + 125500L);
        this.streamSchemaChangeMixedWithDataChange("timestamp(9)", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 123456789, 9)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 123456789, 9)), LocalDateTime.of(2018, 3, 27, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000000L + 123456789L, LocalDateTime.of(2018, 10, 15, 12, 34, 56).toEpochSecond(ZoneOffset.UTC) * 1000000000L + 123456789L);
        this.streamSchemaChangeMixedWithDataChange("timestamp with time zone", QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 3, 27, 1, 34, 56, 7890, 6, "-11:00")), QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 10, 15, 1, 34, 56, 7890, 6, "-11:00")), "2018-03-27T01:34:56.007890-11:00", "2018-10-15T01:34:56.007890-11:00");
        this.streamSchemaChangeMixedWithDataChange("timestamp with local time zone", QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 3, 27, 1, 34, 56, 7890, 6, "-06:00")), QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 10, 15, 1, 34, 56, 7890, 6, "-06:00")), "2018-03-27T07:34:56.007890Z", "2018-10-15T07:34:56.007890Z");
        this.streamSchemaChangeMixedWithDataChange("interval year to month", QueryValue.ofSql("INTERVAL '-3-6' YEAR TO MONTH"), QueryValue.ofSql("INTERVAL '-2-5' YEAR TO MONTH"), -110451600000000L, -76264200000000L);
        this.streamSchemaChangeMixedWithDataChange("interval day(3) to second(2)", QueryValue.ofSql("INTERVAL '-1 2:3:4.56' DAY TO SECOND"), QueryValue.ofSql("INTERVAL '-2 4:5:6.21' DAY TO SECOND"), -93784560000L, -187506210000L);
    }

    @Test
    @SkipLongRunning
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamSchemaChangeWithDataChangeTemporalDataTypesAsConnect() throws Exception {
        this.temporalPrecisionMode = TemporalPrecisionMode.CONNECT;
        this.streamSchemaChangeMixedWithDataChange("date", QueryValue.ofSql("TO_DATE('2018-03-27','yyyy-mm-dd')"), QueryValue.ofSql("TO_DATE('2018-10-15','yyyy-mm-dd')"), Date.from(LocalDate.of(2018, 3, 27).atStartOfDay().atOffset(ZoneOffset.UTC).toInstant()), Date.from(LocalDate.of(2018, 10, 15).atStartOfDay().atOffset(ZoneOffset.UTC).toInstant()));
        this.streamSchemaChangeMixedWithDataChange("timestamp", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 789, 5)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 789, 5)), Date.from(LocalDateTime.of(2018, 3, 27, 12, 34, 56, 7890000).atOffset(ZoneOffset.UTC).toInstant()), Date.from(LocalDateTime.of(2018, 10, 15, 12, 34, 56, 7890000).atOffset(ZoneOffset.UTC).toInstant()));
        this.streamSchemaChangeMixedWithDataChange("timestamp(2)", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 12545, 5)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 12545, 5)), Date.from(LocalDateTime.of(2018, 3, 27, 12, 34, 56, 130000000).atOffset(ZoneOffset.UTC).toInstant()), Date.from(LocalDateTime.of(2018, 10, 15, 12, 34, 56, 130000000).atOffset(ZoneOffset.UTC).toInstant()));
        this.streamSchemaChangeMixedWithDataChange("timestamp(4)", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 12545, 5)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 12545, 5)), Date.from(LocalDateTime.of(2018, 3, 27, 12, 34, 56, 125500000).atOffset(ZoneOffset.UTC).toInstant()), Date.from(LocalDateTime.of(2018, 10, 15, 12, 34, 56, 125500000).atOffset(ZoneOffset.UTC).toInstant()));
        this.streamSchemaChangeMixedWithDataChange("timestamp(9)", QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 3, 27, 12, 34, 56, 123456789, 9)), QueryValue.ofSql(HybridMiningStrategyIT.toTimestamp(2018, 10, 15, 12, 34, 56, 123456789, 9)), Date.from(LocalDateTime.of(2018, 3, 27, 12, 34, 56, 123456789).atOffset(ZoneOffset.UTC).toInstant()), Date.from(LocalDateTime.of(2018, 10, 15, 12, 34, 56, 123456789).atOffset(ZoneOffset.UTC).toInstant()));
        this.streamSchemaChangeMixedWithDataChange("timestamp with time zone", QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 3, 27, 1, 34, 56, 7890, 6, "-11:00")), QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 10, 15, 1, 34, 56, 7890, 6, "-11:00")), "2018-03-27T01:34:56.007890-11:00", "2018-10-15T01:34:56.007890-11:00");
        this.streamSchemaChangeMixedWithDataChange("timestamp with local time zone", QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 3, 27, 1, 34, 56, 7890, 6, "-06:00")), QueryValue.ofSql(HybridMiningStrategyIT.toTimestampTz(2018, 10, 15, 1, 34, 56, 7890, 6, "-06:00")), "2018-03-27T07:34:56.007890Z", "2018-10-15T07:34:56.007890Z");
        this.streamSchemaChangeMixedWithDataChange("interval year to month", QueryValue.ofSql("INTERVAL '-3-6' YEAR TO MONTH"), QueryValue.ofSql("INTERVAL '-2-5' YEAR TO MONTH"), -110451600000000L, -76264200000000L);
        this.streamSchemaChangeMixedWithDataChange("interval day(3) to second(2)", QueryValue.ofSql("INTERVAL '-1 2:3:4.56' DAY TO SECOND"), QueryValue.ofSql("INTERVAL '-2 4:5:6.21' DAY TO SECOND"), -93784560000L, -187506210000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamOfflineSchemaChangeWithExistingLegacySchemaHistory() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3401");
        try {
            LogInterceptor logInterceptor = new LogInterceptor(BaseSourceTask.class);
            String columnName = "C1";
            String columnType = "varchar2(50)";
            QueryValue insertValue = QueryValue.ofBind("test");
            QueryValue updateValue = QueryValue.ofBind("updated");
            String expectedInsert = "test";
            String expectedUpdate = "updated";
            this.createAndStreamTable("C1", "varchar2(50)");
            this.createSchemaHistoryForDdl(String.format("CREATE TABLE dbz3401 (id numeric(9,0) primary key, %s %s)", "C1", "varchar2(50)"));
            this.createOffsetBasedOnCurrentScn();
            Configuration config = this.configureAndStartConnector(false);
            HybridMiningStrategyIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)logInterceptor.containsMessage("No previous offsets found")).as("Existing offsets were not found but expected", new Object[0])).isFalse();
            this.assertNoRecordsToConsume();
            this.stopConnector();
            this.insertRowWithoutCommit("C1", insertValue, 1);
            this.connection.commit();
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 ADD C12 varchar2(50)"});
            this.insertRowOffline("C1", insertValue, 2);
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 DROP COLUMN C12"});
            this.updateRowOffline("C1", updateValue, 2);
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 ADD C12 varchar2(50)"});
            this.connection.execute(new String[]{"DELETE FROM dbz3401 WHERE ID = 2"});
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 DROP COLUMN C12"});
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            HybridMiningStrategyIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            int expected = 4;
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(4);
            List tableRecords = records.recordsForTopic(HybridMiningStrategyIT.topicName("DEBEZIUM", "DBZ3401"));
            Struct after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("C1")).isEqualTo((Object)"test");
            after = ((Struct)((SourceRecord)tableRecords.get(1)).value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("C1")).isEqualTo((Object)"test");
            Assertions.assertThat((Object)after.get("C12")).isEqualTo((Object)"test");
            after = ((Struct)((SourceRecord)tableRecords.get(2)).value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("C1")).isEqualTo((Object)"updated");
            Assertions.assertThat((Object)after.schema().field("C12")).isNull();
            Struct before = ((Struct)((SourceRecord)tableRecords.get(3)).value()).getStruct("before");
            after = ((Struct)((SourceRecord)tableRecords.get(3)).value()).getStruct("after");
            Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)before.get("C1")).isEqualTo((Object)"updated");
            Assertions.assertThat((Object)before.get("C12")).isNull();
            Assertions.assertThat((Object)after).isNull();
        }
        finally {
            this.stopConnector();
            TestHelper.dropTable(this.connection, "dbz3401");
            Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
            Testing.Files.delete((Path)OFFSET_STORE_PATH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3401"})
    public void shouldStreamSchemaChangeWithExistingLegacySchemaHistory() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3401");
        try {
            LogInterceptor logInterceptor = new LogInterceptor(BaseSourceTask.class);
            String columnName = "C1";
            String columnType = "varchar2(50)";
            QueryValue insertValue = QueryValue.ofBind("test");
            QueryValue updateValue = QueryValue.ofBind("updated");
            String expectedInsert = "test";
            String expectedUpdate = "updated";
            this.createAndStreamTable("C1", "varchar2(50)");
            this.createSchemaHistoryForDdl(String.format("CREATE TABLE dbz3401 (id numeric(9,0) primary key, %s %s)", "C1", "varchar2(50)"));
            this.createOffsetBasedOnCurrentScn();
            this.configureAndStartConnector(false);
            HybridMiningStrategyIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)logInterceptor.containsMessage("No previous offsets found")).as("Existing offsets were not found but expected", new Object[0])).isFalse();
            this.insertRowWithoutCommit("C1", insertValue, 1);
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 add C2 varchar2(50)"});
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List tableRecords = records.recordsForTopic(HybridMiningStrategyIT.topicName("DEBEZIUM", "DBZ3401"));
            Assertions.assertThat((List)tableRecords).hasSize(1);
            Struct after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("C1".toUpperCase())).isEqualTo((Object)"test");
            Assertions.assertThat((Object)after.schema().field("C2")).isNull();
            this.updateRowWithoutCommit("C1", updateValue, 1);
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 add C3 varchar2(50)"});
            records = this.consumeRecordsByTopic(1);
            tableRecords = records.recordsForTopic(HybridMiningStrategyIT.topicName("DEBEZIUM", "DBZ3401"));
            Assertions.assertThat((List)tableRecords).hasSize(1);
            after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("C1".toUpperCase())).isEqualTo((Object)"updated");
            Assertions.assertThat((Object)after.get("C2")).isNull();
            Assertions.assertThat((Object)after.schema().field("C3")).isNull();
            this.connection.executeWithoutCommitting(new String[]{"DELETE FROM dbz3401 where id = 1"});
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 add C4 varchar2(50)"});
            records = this.consumeRecordsByTopic(1);
            tableRecords = records.recordsForTopic(HybridMiningStrategyIT.topicName("DEBEZIUM", "DBZ3401"));
            Assertions.assertThat((List)tableRecords).hasSize(1);
            Struct before = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("before");
            Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)before.get("C1".toUpperCase())).isEqualTo((Object)"updated");
            Assertions.assertThat((Object)before.get("C2")).isNull();
            Assertions.assertThat((Object)before.get("C3")).isNull();
            after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after).isNull();
            this.insertRowWithoutCommit("C1", insertValue, 2);
            this.connection.execute(new String[]{"DROP TABLE dbz3401"});
            records = this.consumeRecordsByTopic(1);
            tableRecords = records.recordsForTopic(HybridMiningStrategyIT.topicName("DEBEZIUM", "DBZ3401"));
            Assertions.assertThat((List)tableRecords).hasSize(1);
            after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after).isNotNull();
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("C1".toUpperCase())).isEqualTo((Object)"test");
            this.createAndStreamTable("C1", "varchar2(50)");
            this.insertRowWithoutCommit("C1", insertValue, 3);
            this.connection.execute(new String[]{"DROP TABLE dbz3401 PURGE"});
            records = this.consumeRecordsByTopic(1);
            tableRecords = records.recordsForTopic(HybridMiningStrategyIT.topicName("DEBEZIUM", "DBZ3401"));
            Assertions.assertThat((List)tableRecords).hasSize(1);
            after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after).isNotNull();
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
            Assertions.assertThat((Object)after.get("C1".toUpperCase())).isEqualTo((Object)"test");
            this.stopConnector();
        }
        finally {
            this.stopConnector();
            TestHelper.dropTable(this.connection, "dbz3401");
            Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
            Testing.Files.delete((Path)OFFSET_STORE_PATH);
        }
    }

    private static String toTimestamp(int year, int month, int day, int hour, int min, int sec, int nanos, int precision) {
        String nanoSeconds = Strings.justify((Strings.Justify)Strings.Justify.RIGHT, (String)String.valueOf(nanos), (int)precision, (char)'0');
        String format = "'%04d-%02d-%02d %02d:%02d:%02d.%s', 'yyyy-mm-dd HH24:MI:SS.FF" + precision + "'";
        return String.format("TO_TIMESTAMP(" + format + ")", year, month, day, hour, min, sec, nanoSeconds);
    }

    private static String toTimestampTz(int year, int month, int day, int hour, int min, int sec, int nanos, int precision, String tz) {
        String nanoSeconds = Strings.justify((Strings.Justify)Strings.Justify.RIGHT, (String)String.valueOf(nanos), (int)precision, (char)'0');
        String format = "'%04d-%02d-%02d %02d:%02d:%02d.%s %s', 'yyyy-mm-dd HH24:MI:SS.FF" + precision + " TZH:TZM'";
        return String.format("TO_TIMESTAMP_TZ(" + format + ")", year, month, day, hour, min, sec, nanoSeconds, tz);
    }

    private void streamOfflineSchemaChanges(String columnType, QueryValue insertValue, QueryValue updateValue, Object expectedInsert, Object expectedUpdate) throws Exception {
        this.streamOfflineSchemaChanges(columnType, insertValue, updateValue, expectedInsert, expectedUpdate, false, false);
        this.streamOfflineSchemaChanges(columnType, insertValue, updateValue, expectedInsert, expectedUpdate, true, false);
        this.streamOfflineSchemaChanges(columnType, insertValue, updateValue, expectedInsert, expectedUpdate, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamSchemaChangeMixedWithDataChange(String columnType, QueryValue insertValue, QueryValue updateValue, Object expectedInsert, Object expectedUpdate) throws Exception {
        String columnName = "C1";
        TestHelper.dropTable(this.connection, "dbz3401");
        try {
            this.createAndStreamTable("C1", columnType);
            this.configureAndStartConnector(false);
            HybridMiningStrategyIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            this.insertRowWithoutCommit("C1", insertValue, 1);
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 add C2 varchar2(50)"});
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List tableRecords = records.recordsForTopic(HybridMiningStrategyIT.topicName("DEBEZIUM", "DBZ3401"));
            Assertions.assertThat((List)tableRecords).hasSize(1);
            Struct after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("C1".toUpperCase())).isEqualTo(expectedInsert);
            Assertions.assertThat((Object)after.schema().field("C2")).isNull();
            this.updateRowWithoutCommit("C1", updateValue, 1);
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 add C3 varchar2(50)"});
            records = this.consumeRecordsByTopic(1);
            tableRecords = records.recordsForTopic(HybridMiningStrategyIT.topicName("DEBEZIUM", "DBZ3401"));
            Assertions.assertThat((List)tableRecords).hasSize(1);
            after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("C1".toUpperCase())).isEqualTo(expectedUpdate);
            Assertions.assertThat((Object)after.get("C2")).isNull();
            Assertions.assertThat((Object)after.schema().field("C3")).isNull();
            this.connection.executeWithoutCommitting(new String[]{"DELETE FROM dbz3401 where id = 1"});
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 add C4 varchar2(50)"});
            records = this.consumeRecordsByTopic(1);
            tableRecords = records.recordsForTopic(HybridMiningStrategyIT.topicName("DEBEZIUM", "DBZ3401"));
            Assertions.assertThat((List)tableRecords).hasSize(1);
            Struct before = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("before");
            Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)before.get("C1".toUpperCase())).isEqualTo(expectedUpdate);
            Assertions.assertThat((Object)before.get("C2")).isNull();
            Assertions.assertThat((Object)before.get("C3")).isNull();
            after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after).isNull();
            this.insertRowWithoutCommit("C1", insertValue, 2);
            this.connection.execute(new String[]{"DROP TABLE dbz3401"});
            records = this.consumeRecordsByTopic(1);
            tableRecords = records.recordsForTopic(HybridMiningStrategyIT.topicName("DEBEZIUM", "DBZ3401"));
            Assertions.assertThat((List)tableRecords).hasSize(1);
            after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after).isNotNull();
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("C1".toUpperCase())).isEqualTo(expectedInsert);
            this.createAndStreamTable("C1", columnType);
            this.insertRowWithoutCommit("C1", insertValue, 3);
            this.connection.execute(new String[]{"DROP TABLE dbz3401 PURGE"});
            records = this.consumeRecordsByTopic(1);
            tableRecords = records.recordsForTopic(HybridMiningStrategyIT.topicName("DEBEZIUM", "DBZ3401"));
            Assertions.assertThat((List)tableRecords).hasSize(1);
            after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after).isNotNull();
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)3);
            Assertions.assertThat((Object)after.get("C1".toUpperCase())).isEqualTo(expectedInsert);
            this.stopConnector();
        }
        finally {
            this.stopConnector();
            TestHelper.dropTable(this.connection, "dbz3401");
            Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
            Testing.Files.delete((Path)OFFSET_STORE_PATH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamOfflineSchemaChanges(String columnType, QueryValue insertValue, QueryValue updateValue, Object expectedInsert, Object expectedUpdate, boolean dropTable, boolean dropTableWithPurge) throws Exception {
        String columnName = "C1";
        TestHelper.dropTable(this.connection, "dbz3401");
        try {
            this.createAndStreamTable("C1", columnType);
            this.insertRowWithoutCommit("C1", insertValue, 1);
            this.connection.commit();
            Configuration config = this.configureAndStartConnector(false);
            HybridMiningStrategyIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List tableRecords = records.recordsForTopic(HybridMiningStrategyIT.topicName("DEBEZIUM", "DBZ3401"));
            Assertions.assertThat((List)tableRecords).hasSize(1);
            this.stopConnector();
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 ADD C12 " + columnType});
            this.insertRowOffline("C1", insertValue, 2);
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 DROP COLUMN C12"});
            this.updateRowOffline("C1", updateValue, 2);
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 ADD C12 " + columnType});
            this.connection.execute(new String[]{"DELETE FROM dbz3401 WHERE ID = 2"});
            this.connection.execute(new String[]{"ALTER TABLE dbz3401 DROP COLUMN C12"});
            if (dropTable) {
                if (dropTableWithPurge) {
                    this.connection.execute(new String[]{"DROP TABLE dbz3401 PURGE"});
                } else {
                    TestHelper.dropTable(this.connection, "dbz3401");
                }
            }
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            HybridMiningStrategyIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            int expected = 3;
            records = this.consumeRecordsByTopic(3);
            tableRecords = records.recordsForTopic(HybridMiningStrategyIT.topicName("DEBEZIUM", "DBZ3401"));
            Struct after = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("C1")).isEqualTo(expectedInsert);
            Assertions.assertThat((Object)after.get("C12")).isEqualTo(expectedInsert);
            after = ((Struct)((SourceRecord)tableRecords.get(1)).value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("C1")).isEqualTo(expectedUpdate);
            Assertions.assertThat((Object)after.schema().field("C12")).isNull();
            Struct before = ((Struct)((SourceRecord)tableRecords.get(2)).value()).getStruct("before");
            after = ((Struct)((SourceRecord)tableRecords.get(2)).value()).getStruct("after");
            Assertions.assertThat((Object)before.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)before.get("C1")).isEqualTo(expectedUpdate);
            Assertions.assertThat((Object)before.get("C12")).isNull();
            Assertions.assertThat((Object)after).isNull();
        }
        finally {
            this.stopConnector();
            TestHelper.dropTable(this.connection, "dbz3401");
            Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
            Testing.Files.delete((Path)OFFSET_STORE_PATH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOffsetBasedOnCurrentScn() throws Exception {
        Scn currentScn;
        try (OracleConnection admin = TestHelper.adminConnection();){
            currentScn = admin.getCurrentScn();
        }
        Converter keyConverter = KafkaConnectUtil.converterForOffsetStore();
        Converter valueConverter = KafkaConnectUtil.converterForOffsetStore();
        Map embeddedConfig = TestHelper.defaultConfig().build().asMap(EmbeddedEngineConfig.ALL_FIELDS);
        embeddedConfig.put("offset.storage.file.filename", OFFSET_STORE_PATH.toAbsolutePath().toString());
        embeddedConfig.put("key.converter", keyConverter.getClass().getName());
        embeddedConfig.put("value.converter", valueConverter.getClass().getName());
        System.out.println(embeddedConfig);
        FileOffsetBackingStore store = KafkaConnectUtil.fileOffsetBackingStore();
        store.configure((WorkerConfig)new TestWorkerConfig(embeddedConfig));
        store.start();
        try {
            Map<String, String> partition = Map.of("server", "server1");
            Map<String, Boolean> offsets = Map.of("snapshot", true, "scn", currentScn.toString(), "snapshot_completed", true);
            OffsetStorageWriter writer = new OffsetStorageWriter((OffsetBackingStore)store, "testing-connector", keyConverter, valueConverter);
            writer.offset(partition, offsets);
            writer.beginFlush();
            Future flush = writer.doFlush((error, result) -> {});
            Assertions.assertThat((Future)flush).isNotNull();
            flush.get();
        }
        finally {
            store.stop();
        }
    }

    private void createSchemaHistoryForDdl(String ddlText) {
        FileSchemaHistory schemaHistory = new FileSchemaHistory();
        schemaHistory.configure(((Configuration.Builder)Configuration.create().with(FileSchemaHistory.FILE_PATH, TestHelper.SCHEMA_HISTORY_PATH.toString())).build(), null, SchemaHistoryMetrics.NOOP, true);
        schemaHistory.start();
        String databaseName = TestHelper.getDatabaseName().toUpperCase();
        String schemaName = "debezium".toUpperCase();
        Map source = Collect.linkMapOf((Object)"server", (Object)"server1");
        Map position = Collect.linkMapOf((Object)"commit_scn", (Object)"1001:1:", (Object)"snapshot_scn", (Object)"1001", (Object)"scn", (Object)"1001", (Object)"snapshot_completed", (Object)true);
        OracleDdlParser parser = new OracleDdlParser();
        DdlChanges ddlChanges = parser.getDdlChanges();
        Tables tables = new Tables();
        ddlChanges.reset();
        parser.setCurrentDatabase(databaseName);
        parser.setCurrentSchema(schemaName);
        parser.parse(ddlText, tables);
        ddlChanges.getEventsByDatabase((arg_0, arg_1) -> HybridMiningStrategyIT.lambda$createSchemaHistoryForDdl$2(tables, (SchemaHistory)schemaHistory, source, position, databaseName, schemaName, ddlText, arg_0, arg_1));
    }

    private Struct varScaleDecimal(String value) {
        return VariableScaleDecimal.fromLogical((Schema)VariableScaleDecimal.builder().optional().build(), (BigDecimal)new BigDecimal(value));
    }

    private static String topicName(String schema, String table) {
        return "server1." + schema + "." + table;
    }

    private void createAndStreamTable(String columnName, String columnType) throws SQLException {
        this.connection.execute(new String[]{String.format("CREATE TABLE dbz3401 (id numeric(9,0) not null primary key, %s %s)", columnName, columnType)});
        TestHelper.streamTable(this.connection, "dbz3401");
    }

    private Configuration configureAndStartConnector(boolean lobEnabled) {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3401")).with(OracleConnectorConfig.LOB_ENABLED, Boolean.toString(lobEnabled))).with(OracleConnectorConfig.LOG_MINING_STRATEGY, "hybrid")).with(OracleConnectorConfig.TOMBSTONES_ON_DELETE, false)).with(OracleConnectorConfig.DECIMAL_HANDLING_MODE, this.decimalHandlingMode.getValue())).with(OracleConnectorConfig.TIME_PRECISION_MODE, this.temporalPrecisionMode.getValue())).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        return config;
    }

    private void insertRowWithoutCommit(String columnName, QueryValue insertValue, Integer id) throws SQLException {
        if (insertValue.isSqlFragment()) {
            this.connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO dbz3401 (id,%s) values (%d,%s)", columnName, id, insertValue.getValue())});
        } else {
            this.connection.prepareUpdate(String.format("INSERT INTO dbz3401 (id,%s) values (%d,?)", columnName, id), p -> p.setObject(1, insertValue.getValue()));
        }
    }

    private void updateRowWithoutCommit(String columnName, QueryValue updateValue, Integer id) throws SQLException {
        if (updateValue.isSqlFragment()) {
            this.connection.execute(new String[]{String.format("UPDATE dbz3401 set %s=%s WHERE id=%d", columnName, updateValue.getValue(), id)});
        } else {
            this.connection.prepareUpdate(String.format("UPDATE dbz3401 set %s=? where id=%d", columnName, id), p -> p.setObject(1, updateValue.getValue()));
        }
    }

    private void insertRowOffline(String columnName, QueryValue insertValue, Integer id) throws SQLException {
        if (insertValue.isSqlFragment()) {
            this.connection.execute(new String[]{String.format("INSERT INTO dbz3401 (id,%s,%s2) values (%d,%s,%s)", columnName, columnName, id, insertValue.getValue(), insertValue.getValue())});
        } else {
            this.connection.prepareUpdate(String.format("INSERT INTO dbz3401 (id,%s,%s2) values (%d,?,?)", columnName, columnName, id), p -> {
                p.setObject(1, insertValue.getValue());
                p.setObject(2, insertValue.getValue());
            });
            this.connection.commit();
        }
    }

    private void updateRowOffline(String columnName, QueryValue updateValue, Integer id) throws SQLException {
        if (updateValue.isSqlFragment()) {
            this.connection.execute(new String[]{String.format("UPDATE dbz3401 SET %s=%s WHERE id=%d", columnName, updateValue.getValue(), id)});
        } else {
            this.connection.prepareUpdate(String.format("UPDATE dbz3401 SET %s=? where id=%d", columnName, id), p -> p.setObject(1, updateValue.getValue()));
            this.connection.commit();
        }
    }

    private static /* synthetic */ void lambda$createSchemaHistoryForDdl$2(Tables tables, SchemaHistory schemaHistory, Map source, Map position, String databaseName, String schemaName, String ddlText, String dbName, List events) {
        events.forEach(event -> {
            if (event instanceof DdlParserListener.TableCreatedEvent) {
                DdlParserListener.TableCreatedEvent createEvent = (DdlParserListener.TableCreatedEvent)event;
                Table table = tables.forTable(createEvent.tableId());
                TableChanges changes = new TableChanges().create(table);
                schemaHistory.record(source, position, databaseName, schemaName, ddlText, changes, Instant.now());
            }
        });
    }

    private static interface QueryValue {
        public boolean isSqlFragment();

        public Object getValue();

        public static QueryValue ofSql(String value) {
            return new SqlFragmentQueryValue(value);
        }

        public static QueryValue ofBind(Object value) {
            return new BindQueryValue(value);
        }
    }

    protected static class TestWorkerConfig
    extends WorkerConfig {
        private static final ConfigDef CONFIG;

        protected TestWorkerConfig(Map<String, String> props) {
            super(CONFIG, props);
        }

        static {
            ConfigDef config = TestWorkerConfig.baseConfigDef();
            Field.group((ConfigDef)config, (String)"file", (Field[])new Field[]{EmbeddedEngineConfig.OFFSET_STORAGE_FILE_FILENAME});
            Field.group((ConfigDef)config, (String)"kafka", (Field[])new Field[]{EmbeddedEngineConfig.OFFSET_STORAGE_KAFKA_TOPIC});
            Field.group((ConfigDef)config, (String)"kafka", (Field[])new Field[]{EmbeddedEngineConfig.OFFSET_STORAGE_KAFKA_PARTITIONS});
            Field.group((ConfigDef)config, (String)"kafka", (Field[])new Field[]{EmbeddedEngineConfig.OFFSET_STORAGE_KAFKA_REPLICATION_FACTOR});
            CONFIG = config;
        }
    }

    private static class BindQueryValue
    implements QueryValue {
        private final Object value;

        BindQueryValue(Object value) {
            this.value = value;
        }

        @Override
        public boolean isSqlFragment() {
            return false;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static class SqlFragmentQueryValue
    implements QueryValue {
        private final String value;

        SqlFragmentQueryValue(String value) {
            this.value = value;
        }

        @Override
        public boolean isSqlFragment() {
            return true;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

