/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.junit;

import io.debezium.connector.oracle.OracleConnectorConfig;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
public @interface SkipWhenLogMiningStrategyIs {
    public Strategy value();

    public String reason() default "";

    public static enum Strategy {
        CATALOG_IN_REDO{

            @Override
            boolean isEqualTo(String miningStrategy) {
                return OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO.getValue().equalsIgnoreCase(miningStrategy);
            }
        }
        ,
        ONLINE_CATALOG{

            @Override
            boolean isEqualTo(String miningStrategy) {
                return OracleConnectorConfig.LogMiningStrategy.ONLINE_CATALOG.getValue().equalsIgnoreCase(miningStrategy);
            }
        }
        ,
        HYBRID{

            @Override
            boolean isEqualTo(String miningStrategy) {
                return OracleConnectorConfig.LogMiningStrategy.HYBRID.getValue().equalsIgnoreCase(miningStrategy);
            }
        };


        abstract boolean isEqualTo(String var1);
    }
}

