/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.junit;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipOnReadOnly;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.junit.AnnotationBasedTestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipTestDependingOnReadOnly
extends AnnotationBasedTestRule {
    private static final Configuration config = TestHelper.defaultConfig().build();

    public Statement apply(Statement base, Description description) {
        SkipOnReadOnly skipOnReadOnly = (SkipOnReadOnly)this.hasAnnotation(description, SkipOnReadOnly.class);
        if (skipOnReadOnly != null && config.getBoolean(OracleConnectorConfig.LOG_MINING_READ_ONLY)) {
            String reasonForSkipping = "Read Only: " + skipOnReadOnly.reason();
            return SkipTestDependingOnReadOnly.emptyStatement((String)reasonForSkipping, (Description)description);
        }
        return base;
    }
}

