/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnStrategyRule;
import io.debezium.connector.oracle.junit.SkipWhenLogMiningStrategyIs;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenLogMiningStrategyIs(value=SkipWhenLogMiningStrategyIs.Strategy.HYBRID, reason="Hybrid does not support BLOB")
public class OracleBinaryModeIT
extends AbstractConnectorTest {
    @Rule
    public final TestRule skipStrategyRule = new SkipTestDependingOnStrategyRule();
    private OracleConnection connection;

    @Before
    public void before() throws SQLException {
        this.connection = TestHelper.testConnection();
        TestHelper.dropTable(this.connection, "binary_mode_test");
        this.connection.execute(new String[]{"CREATE TABLE binary_mode_test (id numeric(9,0), blob_col blob not null, primary key(id))"});
        this.connection.execute(new String[]{"INSERT INTO binary_mode_test (id, blob_col) values (1, HEXTORAW('010203'))"});
        TestHelper.streamTable(this.connection, "binary_mode_test");
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws SQLException {
        this.stopConnector();
        if (this.connection != null && this.connection.isConnected()) {
            TestHelper.dropTable(this.connection, "binary_mode_test");
            this.connection.close();
        }
    }

    @Test
    public void shouldReceiveRawBinary() throws InterruptedException {
        Struct data = this.consume(CommonConnectorConfig.BinaryHandlingMode.BYTES);
        ByteBuffer expectedValue = ByteBuffer.wrap(new byte[]{1, 2, 3});
        Assert.assertEquals((Object)expectedValue, (Object)data.get("BLOB_COL"));
    }

    @Test
    public void shouldReceiveHexBinary() throws InterruptedException {
        Struct data = this.consume(CommonConnectorConfig.BinaryHandlingMode.HEX);
        String expectedValue = "010203";
        Assert.assertEquals((Object)expectedValue, (Object)data.get("BLOB_COL"));
    }

    @Test
    public void shouldReceiveBase64Binary() throws InterruptedException {
        Struct data = this.consume(CommonConnectorConfig.BinaryHandlingMode.BASE64);
        String expectedValue = "AQID";
        Assert.assertEquals((Object)expectedValue, (Object)data.get("BLOB_COL"));
    }

    @Test
    public void shouldReceiveBase64UrlSafeBinary() throws InterruptedException {
        Struct data = this.consume(CommonConnectorConfig.BinaryHandlingMode.BASE64_URL_SAFE);
        String expectedValue = "AQID";
        Assert.assertEquals((Object)expectedValue, (Object)data.get("BLOB_COL"));
    }

    private Struct consume(CommonConnectorConfig.BinaryHandlingMode binaryMode) throws InterruptedException {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL)).with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.BINARY_MODE_TEST")).with(OracleConnectorConfig.BINARY_HANDLING_MODE, (EnumeratedValue)binaryMode)).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        OracleBinaryModeIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List results = records.recordsForTopic("server1.DEBEZIUM.BINARY_MODE_TEST");
        Assertions.assertThat((List)results).hasSize(1);
        return (Struct)((Struct)((SourceRecord)results.get(0)).value()).get("after");
    }
}

