/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.junit;

import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipWhenLogMiningStrategyIs;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.junit.AnnotationBasedTestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipTestDependingOnStrategyRule
extends AnnotationBasedTestRule {
    private static final String strategyName = SkipTestDependingOnStrategyRule.determineStrategyName();

    public Statement apply(Statement base, Description description) {
        SkipWhenLogMiningStrategyIs strategyIs = (SkipWhenLogMiningStrategyIs)this.hasAnnotation(description, SkipWhenLogMiningStrategyIs.class);
        if (strategyIs != null && strategyIs.value().isEqualTo(strategyName)) {
            String reason = "Strategy is " + strategyIs.value() + System.lineSeparator() + strategyIs.reason();
            return SkipTestDependingOnStrategyRule.emptyStatement((String)reason, (Description)description);
        }
        return base;
    }

    public static String determineStrategyName() {
        OracleConnectorConfig.LogMiningStrategy strategy = TestHelper.logMiningStrategy();
        return strategy != null ? strategy.getValue() : null;
    }
}

