/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.util.Testing;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ConnectionIT
implements Testing {
    @Test
    public void shouldDoStuffWithDatabase() throws SQLException {
        Configuration config = TestHelper.testConfig().with("database.query.timeout.ms", "1000").build();
        try (OracleConnection conn = TestHelper.testConnection(config);){
            conn.connect();
            TestHelper.dropTable(conn, "debezium.customer");
            conn.execute(new String[]{"create table debezium.customer (  id numeric(9,0) not null,   name varchar2(1000),   score decimal(6, 2),   registered timestamp,   primary key (id))"});
            conn.execute(new String[]{"SELECT * FROM debezium.customer"});
        }
    }

    @Test
    public void whenQueryTakesMoreThenConfiguredQueryTimeoutAnExceptionMustBeThrown() throws SQLException {
        Configuration config = TestHelper.defaultConfig().with("database.query.timeout.ms", "1000").build();
        try (OracleConnection conn = TestHelper.testConnection(config);){
            conn.connect();
            Assertions.assertThatThrownBy(() -> conn.execute(new String[]{"begin\n   dbms_lock.sleep(10);\nend;"})).isInstanceOf(SQLTimeoutException.class);
        }
    }
}

