/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER, reason="Requires LogMiner")
public class LogMinerSourceInfoRedoSqlIT
extends AbstractConnectorTest {
    @Rule
    public final TestRule skipAdapterRule = new SkipTestDependingOnAdapterNameRule();
    private static OracleConnection connection;

    @BeforeClass
    public static void beforeClass() throws SQLException {
        connection = TestHelper.testConnection();
    }

    @AfterClass
    public static void closeConnection() throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    @Before
    public void before() throws SQLException {
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @Test
    @FixFor(value={"DBZ-6960"})
    public void shouldStreamRedoSqlInSourceInfoBlockWhenEnabled() throws Exception {
        this.testRedoSqlInSourceInfoBlock(true);
    }

    @Test
    @FixFor(value={"DBZ-6960"})
    public void shouldNotIncludeRedoSqlInSourceInfoBlockWhenNotEnabled() throws Exception {
        this.testRedoSqlInSourceInfoBlock(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRedoSqlInSourceInfoBlock(boolean includeRedoSql) throws Exception {
        TestHelper.dropTable(connection, "dbz6960");
        try {
            connection.execute(new String[]{"CREATE TABLE dbz6960 (id number(9,0) primary key, data varchar2(50))"});
            TestHelper.streamTable(connection, "dbz6960");
            Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.LOG_MINING_INCLUDE_REDO_SQL, Boolean.toString(includeRedoSql))).with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ6960")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            LogMinerSourceInfoRedoSqlIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            connection.execute(new String[]{"INSERT INTO dbz6960 (id,data) values (1, 'test')"});
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List tableRecords = records.recordsForTopic("server1.DEBEZIUM.DBZ6960");
            Assertions.assertThat((List)tableRecords).hasSize(1);
            VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)tableRecords.get(0)), (String)"ID", (int)1);
            Struct source = ((Struct)((SourceRecord)tableRecords.get(0)).value()).getStruct("source");
            Assertions.assertThat((Object)source.schema().field("redo_sql")).isNotNull();
            String redoSql = source.getString("redo_sql");
            if (includeRedoSql) {
                Assertions.assertThat((String)redoSql).isEqualTo((Object)"insert into \"DEBEZIUM\".\"DBZ6960\"(\"ID\",\"DATA\") values ('1','test');");
            } else {
                Assertions.assertThat((String)redoSql).isNull();
            }
        }
        finally {
            TestHelper.dropTable(connection, "dbz6960");
        }
    }
}

