/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipTestDependingOnStrategyRule;
import io.debezium.connector.oracle.junit.SkipWhenLogMiningStrategyIs;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.sql.Clob;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class OracleRawDataTypeIT
extends AbstractConnectorTest {
    private static final int RAW_LENGTH = 2000;
    private static final String RAW_DATA = Testing.Files.readResourceAsString((String)"data/test_lob_data.json");
    @Rule
    public final TestRule skipAdapterRule = new SkipTestDependingOnAdapterNameRule();
    @Rule
    public final TestRule skipStrategyRule = new SkipTestDependingOnStrategyRule();
    private OracleConnection connection;

    @Before
    public void before() {
        this.connection = TestHelper.testConnection();
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldSnapshotTableWithRawColumnType() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA raw(2000), primary key(ID))"});
            TestHelper.streamTable(this.connection, "dbz3605");
            String data = OracleRawDataTypeIT.part(RAW_DATA, 0, 2000);
            this.connection.prepareQuery("insert into dbz3605 values (1,utl_raw.cast_to_raw(?))", ps -> ps.setString(1, data), null);
            this.connection.commit();
            Configuration config = ((Configuration.Builder)this.getDefaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleRawDataTypeIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
            Struct after = OracleRawDataTypeIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(data.getBytes()));
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldStreamTableWithRawColumnType() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA raw(2000), primary key(ID))"});
            TestHelper.streamTable(this.connection, "dbz3605");
            Configuration config = ((Configuration.Builder)this.getDefaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleRawDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            String data = OracleRawDataTypeIT.part(RAW_DATA, 0, 2000);
            this.connection.prepareQuery("insert into dbz3605 values (1,utl_raw.cast_to_raw(?))", ps -> ps.setString(1, data), null);
            this.connection.commit();
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidInsert((SourceRecord)record, (String)"ID", (int)1);
            Struct after = OracleRawDataTypeIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(data.getBytes()));
            String updateData = OracleRawDataTypeIT.part(RAW_DATA, 500, 2000);
            this.connection.prepareQuery("UPDATE dbz3605 SET data = utl_raw.cast_to_raw(?) WHERE id = 1", ps -> ps.setString(1, updateData), null);
            this.connection.commit();
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (String)"ID", (int)1);
            after = OracleRawDataTypeIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(updateData.getBytes()));
            this.connection.execute(new String[]{"DELETE FROM dbz3605 WHERE id = 1"});
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidDelete((SourceRecord)record, (String)"ID", (int)1);
            after = OracleRawDataTypeIT.before(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(updateData.getBytes()));
            Assertions.assertThat((Object)OracleRawDataTypeIT.after(record)).isNull();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldStreamTableWithRawTypeColumnAndOtherNonLobColumns() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA raw(2000), DATA2 varchar2(50))"});
            TestHelper.streamTable(this.connection, "dbz3605");
            Configuration config = ((Configuration.Builder)this.getDefaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleRawDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            String data = OracleRawDataTypeIT.part(RAW_DATA, 0, 2000);
            this.connection.prepareQuery("insert into dbz3605 values (1,utl_raw.cast_to_raw(?),'Acme')", ps -> ps.setString(1, data), null);
            this.connection.commit();
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidInsert((SourceRecord)record, (boolean)false);
            Struct after = OracleRawDataTypeIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(data.getBytes()));
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"Acme");
            String updateData = OracleRawDataTypeIT.part(RAW_DATA, 500, 2000);
            this.connection.prepareQuery("UPDATE dbz3605 SET data = utl_raw.cast_to_raw(?) WHERE id=1", ps -> ps.setString(1, updateData), null);
            this.connection.commit();
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (boolean)false);
            after = OracleRawDataTypeIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(updateData.getBytes()));
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"Acme");
            this.connection.prepareQuery("UPDATE dbz3605 SET data = utl_raw.cast_to_raw(?), DATA2 = 'Data' WHERE id=1", ps -> ps.setString(1, data), null);
            this.connection.commit();
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (boolean)false);
            after = OracleRawDataTypeIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(data.getBytes()));
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"Data");
            this.connection.execute(new String[]{"UPDATE dbz3605 SET DATA2 = 'Acme' WHERE id=1"});
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (boolean)false);
            after = OracleRawDataTypeIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(data.getBytes()));
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"Acme");
            this.connection.execute(new String[]{"DELETE FROM dbz3605 WHERE id = 1"});
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidDelete((SourceRecord)record, (boolean)false);
            after = OracleRawDataTypeIT.before(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(data.getBytes()));
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)"Acme");
            Assertions.assertThat((Object)OracleRawDataTypeIT.after(record)).isNull();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-3605"})
    public void shouldStreamTableWithNoPrimaryKeyWithRawTypeColumn() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA raw(2000))"});
            TestHelper.streamTable(this.connection, "dbz3605");
            Configuration config = ((Configuration.Builder)this.getDefaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleRawDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            String data = OracleRawDataTypeIT.part(RAW_DATA, 0, 2000);
            this.connection.prepareQuery("insert into dbz3605 values (1,utl_raw.cast_to_raw(?))", ps -> ps.setString(1, data), null);
            this.connection.commit();
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidInsert((SourceRecord)record, (boolean)false);
            Struct after = OracleRawDataTypeIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(data.getBytes()));
            String updateData = OracleRawDataTypeIT.part(RAW_DATA, 500, 2000);
            this.connection.prepareQuery("UPDATE dbz3605 SET data = utl_raw.cast_to_raw(?) WHERE id=1", ps -> ps.setObject(1, updateData), null);
            this.connection.commit();
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (boolean)false);
            after = OracleRawDataTypeIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(updateData.getBytes()));
            this.connection.execute(new String[]{"DELETE FROM dbz3605 WHERE id = 1"});
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidDelete((SourceRecord)record, (boolean)false);
            after = OracleRawDataTypeIT.before(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(updateData.getBytes()));
            Assertions.assertThat((Object)OracleRawDataTypeIT.after(record)).isNull();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SkipWhenLogMiningStrategyIs(value=SkipWhenLogMiningStrategyIs.Strategy.HYBRID, reason="Cannot use lob.enabled with Hybrid")
    @FixFor(value={"DBZ-3605"})
    public void shouldStreamTableWithRawTypeColumnAndAnotherLobColumn() throws Exception {
        TestHelper.dropTable(this.connection, "dbz3605");
        try {
            this.connection.execute(new String[]{"CREATE TABLE DBZ3605 (ID numeric(9,0), DATA raw(2000), DATA2 clob)"});
            TestHelper.streamTable(this.connection, "dbz3605");
            Configuration config = ((Configuration.Builder)((Configuration.Builder)this.getDefaultConfig().with(OracleConnectorConfig.LOB_ENABLED, true)).with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ3605")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleRawDataTypeIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            String data = OracleRawDataTypeIT.part(RAW_DATA, 0, 2000);
            Clob clob = this.connection.connection().createClob();
            clob.setString(1L, data);
            this.connection.prepareQuery("insert into dbz3605 values (1,utl_raw.cast_to_raw(?),?)", ps -> {
                ps.setString(1, data);
                ps.setClob(2, clob);
            }, null);
            this.connection.commit();
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            SourceRecord record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidInsert((SourceRecord)record, (boolean)false);
            Struct after = OracleRawDataTypeIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(data.getBytes()));
            Assertions.assertThat((Object)after.get("DATA2")).isEqualTo((Object)clob.getSubString(1L, (int)clob.length()));
            String updateData = OracleRawDataTypeIT.part(RAW_DATA, 500, 2000);
            this.connection.prepareQuery("UPDATE dbz3605 SET data = utl_raw.cast_to_raw(?) WHERE id=1", ps -> ps.setObject(1, updateData), null);
            this.connection.commit();
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidUpdate((SourceRecord)record, (boolean)false);
            after = OracleRawDataTypeIT.after(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(updateData.getBytes()));
            OracleRawDataTypeIT.assertFieldIsUnavailablePlaceholder(after, "DATA2", config);
            this.connection.execute(new String[]{"DELETE FROM dbz3605 WHERE id = 1"});
            records = this.consumeRecordsByTopic(1);
            topicRecords = records.recordsForTopic(OracleRawDataTypeIT.topicName("DBZ3605"));
            Assertions.assertThat((List)topicRecords).hasSize(1);
            record = (SourceRecord)topicRecords.get(0);
            VerifyRecord.isValidDelete((SourceRecord)record, (boolean)false);
            after = OracleRawDataTypeIT.before(record);
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("DATA")).isEqualTo((Object)ByteBuffer.wrap(updateData.getBytes()));
            OracleRawDataTypeIT.assertFieldIsUnavailablePlaceholder(after, "DATA2", config);
            Assertions.assertThat((Object)OracleRawDataTypeIT.after(record)).isNull();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz3605");
        }
    }

    private Configuration.Builder getDefaultConfig() {
        return TestHelper.defaultConfig();
    }

    private static void assertFieldIsUnavailablePlaceholder(Struct after, String fieldName, Configuration config) {
        Assertions.assertThat((String)after.getString(fieldName)).isEqualTo((Object)config.getString(OracleConnectorConfig.UNAVAILABLE_VALUE_PLACEHOLDER));
    }

    private static String topicName(String tableName) {
        return "server1.DEBEZIUM." + tableName;
    }

    private static Struct before(SourceRecord record) {
        return ((Struct)record.value()).getStruct("before");
    }

    private static Struct after(SourceRecord record) {
        return ((Struct)record.value()).getStruct("after");
    }

    private static String part(String text, int start, int length) {
        return text == null ? "" : text.substring(start, Math.min(length, text.length()));
    }
}

