/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.CustomTestSnapshot;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CustomSnapshotterIT
extends AbstractConnectorTest {
    private static OracleConnection connection;
    private static final String PK_FIELD = "PK";

    @BeforeClass
    public static void beforeClass() throws SQLException {
        connection = TestHelper.testConnection();
        TestHelper.dropAllTables();
        connection.execute(new String[]{"CREATE TABLE debezium.a (pk numeric(9,0), aa integer, primary key(pk))"});
        connection.execute(new String[]{"GRANT SELECT ON debezium.a to  " + TestHelper.getConnectorUserName()});
        connection.execute(new String[]{"ALTER TABLE debezium.a ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
        connection.execute(new String[]{"CREATE TABLE debezium.b (pk numeric(9,0), aa integer, PRIMARY KEY(pk))"});
        connection.execute(new String[]{"GRANT SELECT ON debezium.b to  " + TestHelper.getConnectorUserName()});
        connection.execute(new String[]{"ALTER TABLE debezium.b ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS"});
    }

    @AfterClass
    public static void closeConnection() throws SQLException {
        if (connection != null) {
            TestHelper.dropTable(connection, "debezium.a");
            TestHelper.dropTable(connection, "debezium.b");
            connection.close();
        }
    }

    @Before
    public void before() throws SQLException {
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @Test
    public void shouldAllowForCustomSnapshot() throws InterruptedException, SQLException {
        connection.execute(new String[]{"INSERT INTO debezium.a (pk, aa) VALUES (1, 1)"});
        connection.execute(new String[]{"INSERT INTO debezium.b (pk, aa) VALUES (1, 1)"});
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.A, DEBEZIUM\\.B")).with(OracleConnectorConfig.SNAPSHOT_MODE, OracleConnectorConfig.SnapshotMode.CUSTOM.getValue())).with(OracleConnectorConfig.SNAPSHOT_MODE_CUSTOM_NAME, CustomTestSnapshot.class.getName())).with(OracleConnectorConfig.SNAPSHOT_QUERY_MODE, (EnumeratedValue)CommonConnectorConfig.SnapshotQueryMode.CUSTOM)).with(OracleConnectorConfig.SNAPSHOT_QUERY_MODE_CUSTOM_NAME, CustomTestSnapshot.class.getName())).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords actualRecords = this.consumeRecordsByTopic(1);
        List s1recs = actualRecords.recordsForTopic(this.topicName("DEBEZIUM", "A"));
        List s2recs = actualRecords.recordsForTopic(this.topicName("DEBEZIUM", "B"));
        Assertions.assertThat((int)s1recs.size()).isEqualTo(1);
        Assertions.assertThat((List)s2recs).isNull();
        SourceRecord record = (SourceRecord)s1recs.get(0);
        VerifyRecord.isValidRead((SourceRecord)record, (String)PK_FIELD, (int)1);
        connection.execute(new String[]{"INSERT INTO debezium.a (pk, aa) VALUES (2, 1)"});
        connection.execute(new String[]{"INSERT INTO debezium.b (pk, aa) VALUES (2, 1)"});
        actualRecords = this.consumeRecordsByTopic(2);
        s1recs = actualRecords.recordsForTopic(this.topicName("DEBEZIUM", "A"));
        s2recs = actualRecords.recordsForTopic(this.topicName("DEBEZIUM", "B"));
        Assertions.assertThat((int)s1recs.size()).isEqualTo(1);
        Assertions.assertThat((int)s2recs.size()).isEqualTo(1);
        record = (SourceRecord)s1recs.get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)PK_FIELD, (int)2);
        record = (SourceRecord)s2recs.get(0);
        VerifyRecord.isValidInsert((SourceRecord)record, (String)PK_FIELD, (int)2);
        this.stopConnector();
        config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.A, DEBEZIUM\\.B")).with(OracleConnectorConfig.SNAPSHOT_MODE, OracleConnectorConfig.SnapshotMode.CUSTOM.getValue())).with(OracleConnectorConfig.SNAPSHOT_MODE_CUSTOM_NAME, CustomTestSnapshot.class.getName())).with(OracleConnectorConfig.SNAPSHOT_QUERY_MODE, (EnumeratedValue)CommonConnectorConfig.SnapshotQueryMode.CUSTOM)).with(OracleConnectorConfig.SNAPSHOT_QUERY_MODE_CUSTOM_NAME, CustomTestSnapshot.class.getName())).build();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        actualRecords = this.consumeRecordsByTopic(4);
        s1recs = actualRecords.recordsForTopic(this.topicName("DEBEZIUM", "A"));
        s2recs = actualRecords.recordsForTopic(this.topicName("DEBEZIUM", "B"));
        Assertions.assertThat((int)s1recs.size()).isEqualTo(2);
        Assertions.assertThat((int)s2recs.size()).isEqualTo(2);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)s1recs.get(0)), (String)PK_FIELD, (int)1);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)s1recs.get(1)), (String)PK_FIELD, (int)2);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)s2recs.get(0)), (String)PK_FIELD, (int)1);
        VerifyRecord.isValidRead((SourceRecord)((SourceRecord)s2recs.get(1)), (String)PK_FIELD, (int)2);
    }

    private String topicName(String schema, String table) {
        return "server1." + schema + "." + table;
    }
}

