/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.olr;

import io.debezium.config.Configuration;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.oracle.AbstractStreamingAdapter;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.olr.OpenLogReplicatorOracleOffsetContextLoader;
import io.debezium.connector.oracle.olr.OpenLogReplicatorStreamingChangeEventSource;
import io.debezium.connector.oracle.olr.OpenLogReplicatorStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.olr.OpenLogReplicatorValueConverter;
import io.debezium.document.Document;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLogReplicatorAdapter
extends AbstractStreamingAdapter<OpenLogReplicatorStreamingChangeEventSourceMetrics> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenLogReplicatorAdapter.class);
    private static final String TYPE = "olr";

    public OpenLogReplicatorAdapter(OracleConnectorConfig connectorConfig) {
        super(connectorConfig);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            protected boolean isPositionAtOrBefore(Document recorded, Document desired) {
                return OpenLogReplicatorAdapter.this.resolveScn(recorded).compareTo(OpenLogReplicatorAdapter.this.resolveScn(desired)) < 1;
            }
        };
    }

    @Override
    public OffsetContext.Loader<OracleOffsetContext> getOffsetContextLoader() {
        return new OpenLogReplicatorOracleOffsetContextLoader(this.connectorConfig);
    }

    @Override
    public StreamingChangeEventSource<OraclePartition, OracleOffsetContext> getSource(OracleConnection connection, EventDispatcher<OraclePartition, TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, OracleTaskContext taskContext, Configuration jdbcConfig, OpenLogReplicatorStreamingChangeEventSourceMetrics streamingMetrics, SnapshotterService snapshotterService) {
        return new OpenLogReplicatorStreamingChangeEventSource(this.connectorConfig, connection, dispatcher, errorHandler, clock, schema, streamingMetrics, snapshotterService);
    }

    @Override
    public OpenLogReplicatorStreamingChangeEventSourceMetrics getStreamingMetrics(OracleTaskContext taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider, OracleConnectorConfig connectorConfig) {
        return new OpenLogReplicatorStreamingChangeEventSourceMetrics(taskContext, changeEventQueueMetrics, metadataProvider);
    }

    @Override
    public OracleOffsetContext determineSnapshotOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> ctx, OracleConnectorConfig connectorConfig, OracleConnection connection) throws SQLException {
        Optional<Scn> latestTableDdlScn = this.getLatestTableDdlScn(ctx, connection);
        Scn currentScn = null;
        do {
            currentScn = connection.getCurrentScn();
        } while (this.areSameTimestamp(latestTableDdlScn.orElse(null), currentScn, connection));
        LOGGER.info("\tCurrent SCN resolved as {}", (Object)currentScn);
        return OracleOffsetContext.create().logicalName(connectorConfig).scn(currentScn).snapshotScn(currentScn).snapshotPendingTransactions(Collections.emptyMap()).transactionContext(new TransactionContext()).incrementalSnapshotContext((IncrementalSnapshotContext<TableId>)new SignalBasedIncrementalSnapshotContext()).build();
    }

    @Override
    public OracleValueConverters getValueConverter(OracleConnectorConfig connectorConfig, OracleConnection connection) {
        return new OpenLogReplicatorValueConverter(connectorConfig, connection);
    }

    @Override
    public Scn getOffsetScn(OracleOffsetContext offsetContext) {
        return offsetContext.getScn();
    }

    @Override
    public OracleOffsetContext copyOffset(OracleConnectorConfig connectorConfig, OracleOffsetContext offsetContext) {
        return new OpenLogReplicatorOracleOffsetContextLoader(connectorConfig).load(offsetContext.getOffset());
    }
}

