/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.ForwardOnlyResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class OracleReturnResultSet
extends ForwardOnlyResultSet {
    OracleReturnResultSet(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        super(physicalConnection, oracleStatement);
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.statement.connection.acquireCloseableLock();){
            super.close();
            this.statement.currentResultSet = null;
            this.statement.returnParamsFetched = false;
            this.statement.rowsDmlReturned = 0;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.statement.connection.acquireCloseableLock();){
            if (!this.statement.isAutoGeneratedKey) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
            }
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 10).fillInStackTrace();
            }
            if (this.statement.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            AutoKeyInfo autoKeyInfo = this.statement.autoKeyInfo;
            autoKeyInfo.statement = this.statement;
            autoKeyInfo.connection = this.connection;
            autoKeyInfo.initMetaData(this);
            AutoKeyInfo autoKeyInfo2 = autoKeyInfo;
            return autoKeyInfo2;
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        Monitor.CloseableLock closeableLock = this.statement.connection.acquireCloseableLock();
        Throwable throwable = null;
        try {
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (closeableLock != null) {
                if (throwable != null) {
                    try {
                        closeableLock.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    closeableLock.close();
                }
            }
            throw throwable3;
        }
    }
}

