/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDefaultValueConverter;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.time.Interval;
import io.debezium.time.MicroDuration;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OracleDefaultValueIT
extends AbstractConnectorTest {
    private OracleConnection connection;
    private Consumer<Configuration.Builder> configUpdater;
    private Configuration config;

    @Before
    public void before() throws Exception {
        this.configUpdater = builder -> {};
        this.connection = TestHelper.testConnection();
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        TestHelper.dropTable(this.connection, "default_value_test");
        TestHelper.dropSequence(this.connection, "debezium_seq");
        this.connection.execute(new String[]{"CREATE SEQUENCE debezium_seq MINVALUE 1 MAXVALUE 999999999 INCREMENT BY 1 START WITH 1"});
    }

    @After
    public void after() throws Exception {
        if (this.connection != null && this.connection.isConnected()) {
            TestHelper.dropTable(this.connection, "default_value_test");
            TestHelper.dropSequence(this.connection, "debezium_seq");
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-3710"})
    public void shouldHandleNumericDefaultTypes() throws Exception {
        if (VerifyRecord.isApucurioAvailable()) {
            this.skipAvroValidation();
        }
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_int", "int", "1", "2", BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_integer", "integer", "1", "2", BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_smallint", "smallint", "1", "2", BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_num", "number", "1", "2", BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), AssertionType.FIELD_NO_DEFAULT), new ColumnDefinition("val_number_38_no_scale", "number(38)", "1", "2", BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_number_38_scale_0", "number(38,0)", "1", "2", BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_number_2", "number(2)", "1", "2", (byte)1, (byte)2, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_number_4", "number(4)", "1", "2", (short)1, (short)2, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_number_9", "number(9)", "1", "2", 1, 2, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_number_18", "number(18)", "1", "2", 1L, 2L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_number_2_neg_scale", "number(1,-1)", "10", "20", (byte)10, (byte)20, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_number_4_neg_scale", "number(2,-2)", "100", "200", (short)100, (short)200, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_number_9_neg_scale", "number(8,-1)", "10", "20", 10, 20, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_number_918_neg_scale", "number(16,-2)", "100", "200", 100L, 200L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_decimal", "decimal(10)", "125", "250", 125L, 250L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_numeric", "numeric(10)", "125", "250", 125L, 250L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_number_1", "number(1)", "1", "2", (byte)1, (byte)2, AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @FixFor(value={"DBZ-3710"})
    public void shouldHandleFloatPointDefaultTypes() throws Exception {
        if (VerifyRecord.isApucurioAvailable()) {
            this.skipAvroValidation();
        }
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_bf", "binary_float", "3.14", "6.28", Float.valueOf(3.14f), Float.valueOf(6.28f), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_bd", "binary_double", "3.14", "6.28", 3.14, 6.28, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_float", "float", "3.14", "6.28", Float.valueOf(3.14f), Float.valueOf(6.28f), AssertionType.FIELD_NO_DEFAULT), new ColumnDefinition("val_float_10", "float(10)", "3.14", "6.28", Float.valueOf(3.14f), Float.valueOf(6.28f), AssertionType.FIELD_NO_DEFAULT), new ColumnDefinition("val_double_precision", "double precision", "3.14", "6.28", Float.valueOf(3.14f), Float.valueOf(6.28f), AssertionType.FIELD_NO_DEFAULT), new ColumnDefinition("val_real", "real", "3.14", "6.28", Float.valueOf(3.14f), Float.valueOf(6.28f), AssertionType.FIELD_NO_DEFAULT), new ColumnDefinition("val_number_10_6", "number(10,6)", "123.45", "234.57", BigDecimal.valueOf(123450000L, 6), BigDecimal.valueOf(234570000L, 6), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_decimal_10_6", "decimal(10,6)", "3.14", "6.28", BigDecimal.valueOf(3140000L, 6), BigDecimal.valueOf(6280000L, 6), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_numeric_10_6", "numeric(10,6)", "3.14", "6.28", BigDecimal.valueOf(3140000L, 6), BigDecimal.valueOf(6280000L, 6), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_number_vs", "number", "3.14", "6.28", Float.valueOf(3.14f), Float.valueOf(6.28f), AssertionType.FIELD_NO_DEFAULT));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @FixFor(value={"DBZ-3710"})
    public void shouldHandleCharacterDefaultTypes() throws Exception {
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_varchar", "varchar(100)", "'hello'", "'world'", "hello", "world", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_varchar_paren", "varchar(100)", "('hello')", "('world')", "hello", "world", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_varchar2", "varchar2(100)", "'red'", "'green'", "red", "green", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_varchar2_paren", "varchar2(100)", "('red')", "('green')", "red", "green", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_nvarchar2", "nvarchar2(100)", "'cedric'", "'entertainer'", "cedric", "entertainer", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_nvarchar2_paren", "nvarchar2(100)", "('cedric')", "('entertainer')", "cedric", "entertainer", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_char", "char(5)", "'YES'", "'NO'", "YES  ", "NO   ", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_char_paren", "char(5)", "('YES')", "('NO')", "YES  ", "NO   ", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_nchar", "nchar(5)", "'ON'", "'OFF'", "ON   ", "OFF  ", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_nchar_paren", "nchar(5)", "('ON')", "('OFF')", "ON   ", "OFF  ", AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @FixFor(value={"DBZ-3710"})
    public void shouldHandleDateTimeDefaultTypes() throws Exception {
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_date", "date", "TO_DATE('2001-02-03 00:00:00', 'YYYY-MM-DD HH24:MI:SS')", "TO_DATE('2005-01-31 00:00:00', 'YYYY-MM-DD HH24:MI:SS')", 981158400000L, 1107129600000L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_ts", "timestamp", "TO_DATE('2001-02-03 01:02:03', 'YYYY-MM-DD HH24:MI:SS')", "TO_DATE('2005-01-31 02:03:04', 'YYYY-MM-DD HH24:MI:SS')", 981162123000000L, 1107136984000000L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_ts_prec2", "timestamp(2)", "TO_DATE('2001-02-03 01:02:03', 'YYYY-MM-DD HH24:MI:SS')", "TO_DATE('2005-01-31 02:03:04', 'YYYY-MM-DD HH24:MI:SS')", 981162123000L, 1107136984000L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_ts_prec4", "timestamp(4)", "TO_DATE('2001-02-03 01:02:03', 'YYYY-MM-DD HH24:MI:SS')", "TO_DATE('2005-01-31 02:03:04', 'YYYY-MM-DD HH24:MI:SS')", 981162123000000L, 1107136984000000L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_ts_prec9", "timestamp(9)", "TO_DATE('2001-02-03 01:02:03', 'YYYY-MM-DD HH24:MI:SS')", "TO_DATE('2005-01-31 02:03:04', 'YYYY-MM-DD HH24:MI:SS')", 981162123000000000L, 1107136984000000000L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_tstz", "timestamp with time zone", "TO_TIMESTAMP_TZ('2018-03-27 01:34:56.00789 -11:00', 'yyyy-mm-dd HH24:MI:SS.FF5 TZH:TZM')", "TO_TIMESTAMP_TZ('2019-04-28 02:35:57.00891 -10:00', 'yyyy-mm-dd HH24:MI:SS.FF5 TZH:TZM')", "2018-03-27T01:34:56.007890-11:00", "2019-04-28T02:35:57.008910-10:00", AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_tsltz", "timestamp with local time zone", "TO_TIMESTAMP_TZ('2018-03-27 01:34:56.00789 -11:00', 'yyyy-mm-dd HH24:MI:SS.FF5 TZH:TZM')", "TO_TIMESTAMP_TZ('2019-04-28 02:35:57.00891 -10:00', 'yyyy-mm-dd HH24:MI:SS.FF5 TZH:TZM')", "2018-03-27T12:34:56.007890Z", "2019-04-28T12:35:57.008910Z", AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @FixFor(value={"DBZ-3710"})
    public void shouldHandleIntervalDefaultTypes() throws Exception {
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_int_ytm", "interval year to month", "'5-3'", "'7-4'", this.getOracleIntervalYearMonth(5, 3), this.getOracleIntervalYearMonth(7, 4), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_int_dts", "interval day(3) to second(3)", "'5 1:2:3.456'", "'3 2:1:4.567'", this.getOracleIntervalDaySecond(5, 1, 2, 3, 456000), this.getOracleIntervalDaySecond(3, 2, 1, 4, 567000), AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @FixFor(value={"DBZ-1539"})
    public void shouldHandleIntervalDefaultTypesAsString() throws Exception {
        this.configUpdater = builder -> builder.with(OracleConnectorConfig.INTERVAL_HANDLING_MODE, OracleConnectorConfig.IntervalHandlingMode.STRING.getValue());
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_int_ytm", "interval year to month", "'5-3'", "'7-4'", this.getOracleIntervalYearMonthString(5, 3), this.getOracleIntervalYearMonthString(7, 4), AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_int_dts", "interval day(3) to second(3)", "'5 1:2:3.456'", "'3 2:1:4.567'", this.getOracleIntervalDaySecondString(5, 1, 2, 3, 456000), this.getOracleIntervalDaySecondString(3, 2, 1, 4, 567000), AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
    }

    @Test
    @FixFor(value={"DBZ-4208"})
    public void shouldHandleDefaultValueFromSequencesAsNoDefault() throws Exception {
        LogInterceptor logInterceptor = new LogInterceptor(OracleDefaultValueConverter.class);
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_id", "number(18,0)", "debezium_seq.nextval", "debezium_seq.nextval", BigDecimal.valueOf(1L), BigDecimal.valueOf(2L), AssertionType.FIELD_NO_DEFAULT));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
        Assertions.assertThat((long)logInterceptor.countOccurrences("Cannot parse column default value")).isEqualTo(6L);
    }

    @Test
    @FixFor(value={"DBZ-4360"})
    public void shouldHandleDefaultValuesWhereSqlMayContainsTrailingSpaces() throws Exception {
        LogInterceptor logInterceptor = new LogInterceptor(OracleDefaultValueConverter.class);
        List<ColumnDefinition> columnDefinitions = Arrays.asList(new ColumnDefinition("val_num", "number(15)", "null ", "null ", null, null, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_num2", "number(15)", "2 ", "3 ", 2L, 3L, AssertionType.FIELD_DEFAULT_EQUAL), new ColumnDefinition("val_char", "char(3)", "'No' ", "'NO' ", "No ", "NO ", AssertionType.FIELD_DEFAULT_EQUAL));
        this.shouldHandleDefaultValuesCommon(columnDefinitions);
        Assertions.assertThat((long)logInterceptor.countOccurrences("Cannot parse column default value")).isEqualTo(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-4388"})
    public void shouldHandleDefaultValueForNonOptionalColumnUsingUnparseableValues() throws Exception {
        TestHelper.dropTable(this.connection, "dbz4388");
        try {
            this.connection.execute(new String[]{"CREATE TABLE dbz4388 (  id NUMBER(9) GENERATED BY DEFAULT ON NULL AS IDENTITY NOT NULL PRIMARY KEY,  first_name VARCHAR2(255) NOT NULL,  last_name VARCHAR2(255) NOT NULL,  email VARCHAR2(255) NOT NULL UNIQUE)"});
            TestHelper.streamTable(this.connection, "dbz4388");
            this.connection.execute(new String[]{"INSERT INTO debezium.dbz4388 (first_name,last_name,email) values ('John','Doe','john@noanswer.org')"});
            Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DBZ4388")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            OracleDefaultValueIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            Assertions.assertThat((List)records.allRecordsInOrder()).hasSize(1);
            Assertions.assertThat((List)records.recordsForTopic("server1.DEBEZIUM.DBZ4388")).hasSize(1);
            SourceRecord record = (SourceRecord)records.recordsForTopic("server1.DEBEZIUM.DBZ4388").get(0);
            Struct after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)1);
            Assertions.assertThat((Object)after.get("FIRST_NAME")).isEqualTo((Object)"John");
            Assertions.assertThat((Object)after.schema().field("ID").schema().defaultValue()).isNull();
            OracleDefaultValueIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            this.connection.execute(new String[]{"INSERT INTO debezium.dbz4388 (first_name,last_name,email) values ('Jane','Doe','jane@noanswer.org')"});
            records = this.consumeRecordsByTopic(1);
            Assertions.assertThat((List)records.allRecordsInOrder()).hasSize(1);
            Assertions.assertThat((List)records.recordsForTopic("server1.DEBEZIUM.DBZ4388")).hasSize(1);
            record = (SourceRecord)records.recordsForTopic("server1.DEBEZIUM.DBZ4388").get(0);
            after = ((Struct)record.value()).getStruct("after");
            Assertions.assertThat((Object)after.get("ID")).isEqualTo((Object)2);
            Assertions.assertThat((Object)after.get("FIRST_NAME")).isEqualTo((Object)"Jane");
            Assertions.assertThat((Object)after.schema().field("ID").schema().defaultValue()).isNull();
        }
        finally {
            TestHelper.dropTable(this.connection, "dbz4388");
        }
    }

    private long getOracleIntervalYearMonth(int years, int month) {
        return MicroDuration.durationMicros((int)years, (int)month, (int)0, (int)0, (int)0, (double)0.0, (Double)30.4375);
    }

    private String getOracleIntervalYearMonthString(int years, int month) {
        return Interval.toIsoString((int)years, (int)month, (int)0, (int)0, (int)0, (BigDecimal)BigDecimal.ZERO);
    }

    private long getOracleIntervalDaySecond(int days, int hours, int minutes, int seconds, int micros) {
        return MicroDuration.durationMicros((int)0, (int)0, (int)days, (int)hours, (int)minutes, (double)seconds, (int)micros, (Double)30.4375);
    }

    private String getOracleIntervalDaySecondString(int days, int hours, int minutes, int seconds, int micros) {
        double secondsDouble = (double)seconds + (double)micros / 1000000.0;
        return Interval.toIsoString((int)0, (int)0, (int)days, (int)hours, (int)minutes, (BigDecimal)BigDecimal.valueOf(secondsDouble));
    }

    private void shouldHandleDefaultValuesCommon(List<ColumnDefinition> columnDefinitions) throws Exception {
        this.testDefaultValuesCreateTableAndSnapshot(columnDefinitions);
        this.testDefaultValuesAlterTableModifyExisting(columnDefinitions);
        this.testDefaultValuesAlterTableAdd(columnDefinitions);
        this.TestDefaultValuesByRestartAndLoadingHistoryTopic();
    }

    private void TestDefaultValuesByRestartAndLoadingHistoryTopic() throws Exception {
        this.stopConnector();
        this.start(OracleConnector.class, this.config);
        this.assertConnectorIsRunning();
        OracleDefaultValueIT.waitForStreamingRunning((String)"oracle", (String)"server1");
    }

    private void testDefaultValuesCreateTableAndSnapshot(List<ColumnDefinition> columnDefinitions) throws Exception {
        StringBuilder createSql = new StringBuilder();
        createSql.append("CREATE TABLE default_value_test (id numeric(9,0) not null");
        for (ColumnDefinition column : columnDefinitions) {
            createSql.append(", ").append(column.name).append(" ").append(column.definition).append(" ").append("default ").append(column.addDefaultValue);
            createSql.append(", ").append(column.name).append("_null").append(" ").append(column.definition).append(" ").append("default null");
            if (!column.temporalType) continue;
            createSql.append(", ").append(column.name).append("_sysdate").append(" ").append(column.definition).append(" ").append("default sysdate");
            createSql.append(", ").append(column.name).append("_sysdate_nonnull").append(" ").append(column.definition).append(" ").append("default sysdate not null");
        }
        createSql.append(", primary key(id))");
        this.connection.execute(new String[]{createSql.toString()});
        TestHelper.streamTable(this.connection, "default_value_test");
        this.connection.execute(new String[]{"INSERT INTO default_value_test (id) values (1)"});
        this.config = ((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.DEFAULT_VALUE_TEST")).apply(this.configUpdater).build();
        this.start(OracleConnector.class, this.config);
        this.assertConnectorIsRunning();
        OracleDefaultValueIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List tableRecords = records.recordsForTopic("server1.DEBEZIUM.DEFAULT_VALUE_TEST");
        Assertions.assertThat((List)tableRecords).hasSize(1);
        SourceRecord record = (SourceRecord)tableRecords.get(0);
        for (ColumnDefinition column : columnDefinitions) {
            switch (column.assertionType) {
                case FIELD_DEFAULT_EQUAL: {
                    OracleDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toUpperCase(), column.expectedAddDefaultValue);
                    OracleDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toUpperCase() + "_NULL", null);
                    break;
                }
                case FIELD_NO_DEFAULT: {
                    OracleDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toUpperCase(), column.expectedAddDefaultValue);
                    OracleDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toUpperCase() + "_NULL", null);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected assertion type: " + column.assertionType);
                }
            }
            if (!column.temporalType) continue;
            OracleDefaultValueIT.assertSchemaFieldWithDefaultSysdate(record, column.name.toUpperCase() + "_SYSDATE", null);
            if (column.expectedAddDefaultValue instanceof String) {
                String assertionValue = column.isZonedTimestamp() ? "1970-01-01T00:00:00Z" : "0";
                OracleDefaultValueIT.assertSchemaFieldDefaultAndNonNullValue(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", assertionValue);
                continue;
            }
            OracleDefaultValueIT.assertSchemaFieldWithDefaultSysdate(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", 0L);
        }
    }

    private void testDefaultValuesAlterTableModifyExisting(List<ColumnDefinition> columnDefinitions) throws Exception {
        StringBuilder alterSql = new StringBuilder();
        alterSql.append("ALTER TABLE default_value_test modify (");
        Iterator<ColumnDefinition> iterator = columnDefinitions.iterator();
        while (iterator.hasNext()) {
            ColumnDefinition column = iterator.next();
            alterSql.append(column.name).append(" ").append(column.definition).append(" ").append("default ").append(column.modifyDefaultValue);
            alterSql.append(", ").append(column.name).append("_null").append(" ").append(column.definition).append(" ").append("default null");
            if (column.temporalType) {
                alterSql.append(", ").append(column.name).append("_sysdate").append(" ").append(column.definition).append(" ").append("default sysdate");
            }
            if (!iterator.hasNext()) continue;
            alterSql.append(", ");
        }
        alterSql.append(")");
        OracleDefaultValueIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        this.connection.execute(new String[]{alterSql.toString()});
        this.connection.execute(new String[]{"INSERT INTO default_value_test (id) values (2)"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List tableRecords = records.recordsForTopic("server1.DEBEZIUM.DEFAULT_VALUE_TEST");
        Assertions.assertThat((List)tableRecords).hasSize(1);
        SourceRecord record = (SourceRecord)tableRecords.get(0);
        for (ColumnDefinition column : columnDefinitions) {
            switch (column.assertionType) {
                case FIELD_DEFAULT_EQUAL: {
                    OracleDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toUpperCase(), column.expectedModifyDefaultValue);
                    OracleDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toUpperCase() + "_NULL", null);
                    break;
                }
                case FIELD_NO_DEFAULT: {
                    OracleDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toUpperCase(), column.expectedModifyDefaultValue);
                    OracleDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toUpperCase() + "_NULL", null);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected assertion type: " + column.assertionType);
                }
            }
            if (!column.temporalType) continue;
            OracleDefaultValueIT.assertSchemaFieldWithDefaultSysdate(record, column.name.toUpperCase() + "_SYSDATE", null);
            if (column.expectedAddDefaultValue instanceof String) {
                String assertionValue = column.isZonedTimestamp() ? "1970-01-01T00:00:00Z" : "0";
                OracleDefaultValueIT.assertSchemaFieldDefaultAndNonNullValue(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", assertionValue);
                continue;
            }
            OracleDefaultValueIT.assertSchemaFieldWithDefaultSysdate(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", 0L);
        }
    }

    private void testDefaultValuesAlterTableAdd(List<ColumnDefinition> columnDefinitions) throws Exception {
        StringBuilder alterSql = new StringBuilder();
        alterSql.append("ALTER TABLE default_value_test add (");
        Iterator<ColumnDefinition> iterator = columnDefinitions.iterator();
        while (iterator.hasNext()) {
            ColumnDefinition column = iterator.next();
            alterSql.append("a").append(column.name).append(" ").append(column.definition).append(" ").append("default ").append(column.addDefaultValue);
            alterSql.append(", ").append("a").append(column.name).append("_null").append(" ").append(column.definition).append(" ").append("default null");
            if (column.temporalType) {
                alterSql.append(", ").append("a").append(column.name).append("_sysdate").append(" ").append(column.definition).append(" ").append("default sysdate");
                alterSql.append(", ").append("a").append(column.name).append("_sysdate_nonnull").append(" ").append(column.definition).append(" ").append("default sysdate not null");
            }
            if (!iterator.hasNext()) continue;
            alterSql.append(", ");
        }
        alterSql.append(")");
        OracleDefaultValueIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        this.connection.execute(new String[]{alterSql.toString()});
        this.connection.execute(new String[]{"INSERT INTO default_value_test (id) values (3)"});
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List tableRecords = records.recordsForTopic("server1.DEBEZIUM.DEFAULT_VALUE_TEST");
        Assertions.assertThat((List)tableRecords).hasSize(1);
        SourceRecord record = (SourceRecord)tableRecords.get(0);
        for (ColumnDefinition column : columnDefinitions) {
            switch (column.assertionType) {
                case FIELD_DEFAULT_EQUAL: {
                    OracleDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toUpperCase(), column.expectedModifyDefaultValue);
                    OracleDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, column.name.toUpperCase() + "_NULL", null);
                    OracleDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, "A" + column.name.toUpperCase(), column.expectedAddDefaultValue);
                    OracleDefaultValueIT.assertSchemaFieldWithSameDefaultAndValue(record, "A" + column.name.toUpperCase() + "_NULL", null);
                    break;
                }
                case FIELD_NO_DEFAULT: {
                    OracleDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toUpperCase(), column.expectedModifyDefaultValue);
                    OracleDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, column.name.toUpperCase() + "_NULL", null);
                    OracleDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, "A" + column.name.toUpperCase(), column.expectedAddDefaultValue);
                    OracleDefaultValueIT.assertSchemaFieldNoDefaultWithValue(record, "A" + column.name.toUpperCase() + "_NULL", null);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected assertion type: " + column.assertionType);
                }
            }
            if (!column.temporalType) continue;
            OracleDefaultValueIT.assertSchemaFieldWithDefaultSysdate(record, column.name.toUpperCase() + "_SYSDATE", null);
            OracleDefaultValueIT.assertSchemaFieldWithDefaultSysdate(record, "A" + column.name.toUpperCase() + "_SYSDATE", null);
            if (column.expectedAddDefaultValue instanceof String) {
                String assertionValue = column.isZonedTimestamp() ? "1970-01-01T00:00:00Z" : "0";
                OracleDefaultValueIT.assertSchemaFieldDefaultAndNonNullValue(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", assertionValue);
                OracleDefaultValueIT.assertSchemaFieldDefaultAndNonNullValue(record, "A" + column.name.toUpperCase() + "_SYSDATE_NONNULL", assertionValue);
                continue;
            }
            OracleDefaultValueIT.assertSchemaFieldWithDefaultSysdate(record, column.name.toUpperCase() + "_SYSDATE_NONNULL", 0L);
            OracleDefaultValueIT.assertSchemaFieldWithDefaultSysdate(record, "A" + column.name.toUpperCase() + "_SYSDATE_NONNULL", 0L);
        }
    }

    private static void assertSchemaFieldWithSameDefaultAndValue(SourceRecord record, String fieldName, Object expectedValue) {
        OracleDefaultValueIT.assertSchemaFieldValueWithDefault(record, fieldName, expectedValue, r -> ((ObjectAssert)Assertions.assertThat((Object)r).as("Unexpected field value: " + fieldName, new Object[0])).isEqualTo(expectedValue));
    }

    private static void assertSchemaFieldNoDefaultWithValue(SourceRecord record, String fieldName, Object fieldValue) {
        OracleDefaultValueIT.assertSchemaFieldValueWithDefault(record, fieldName, null, r -> ((ObjectAssert)Assertions.assertThat((Object)r).as("Unexpected field value: " + fieldName, new Object[0])).isEqualTo(fieldValue));
    }

    private static void assertSchemaFieldDefaultAndNonNullValue(SourceRecord record, String fieldName, Object defaultValue) {
        OracleDefaultValueIT.assertSchemaFieldValueWithDefault(record, fieldName, defaultValue, r -> ((ObjectAssert)Assertions.assertThat((Object)r).as("Unexpected field value: " + fieldName, new Object[0])).isNotNull());
    }

    private static void assertSchemaFieldWithDefaultSysdate(SourceRecord record, String fieldName, Object expectedValue) {
        OracleDefaultValueIT.assertSchemaFieldValueWithDefault(record, fieldName, expectedValue, r -> {
            if (expectedValue == null) {
                Assertions.assertThat((Object)r).isNull();
            } else {
                ((AbstractLongAssert)Assertions.assertThat((long)((Long)r)).as("Unexpected field value: " + fieldName, new Object[0])).isGreaterThanOrEqualTo(1L);
            }
        });
    }

    private static void assertSchemaFieldValueWithDefault(SourceRecord record, String fieldName, Object expectedDefault, Consumer<Object> valueCheck) {
        Struct after = ((Struct)record.value()).getStruct("after");
        Field field = after.schema().field(fieldName);
        ((ObjectAssert)Assertions.assertThat((Object)field).as("Expected non-null field for " + fieldName, new Object[0])).isNotNull();
        Object defaultValue = field.schema().defaultValue();
        if (expectedDefault == null) {
            Assertions.assertThat((Object)defaultValue).isNull();
            return;
        }
        ((ObjectAssert)Assertions.assertThat((Object)defaultValue).as("Expected non-null default value for field " + fieldName, new Object[0])).isNotNull();
        Assertions.assertThat(defaultValue.getClass()).isEqualTo(expectedDefault.getClass());
        ((ObjectAssert)Assertions.assertThat((Object)defaultValue).as("Unexpected default value: " + fieldName + " with field value: " + after.get(fieldName), new Object[0])).isEqualTo(expectedDefault);
        valueCheck.accept(after.get(fieldName));
    }

    private static class ColumnDefinition {
        public final String name;
        public final String definition;
        public final String addDefaultValue;
        public final String modifyDefaultValue;
        public final Object expectedAddDefaultValue;
        public final Object expectedModifyDefaultValue;
        public final AssertionType assertionType;
        public final boolean temporalType;

        ColumnDefinition(String name, String definition, String addDefaultValue, String modifyDefaultValue, Object expectedAddDefaultValue, Object expectedModifyDefaultValue, AssertionType assertionType) {
            this.name = name;
            this.definition = definition;
            this.addDefaultValue = addDefaultValue;
            this.modifyDefaultValue = modifyDefaultValue;
            this.expectedAddDefaultValue = expectedAddDefaultValue;
            this.expectedModifyDefaultValue = expectedModifyDefaultValue;
            this.assertionType = assertionType;
            this.temporalType = definition.equalsIgnoreCase("date") || definition.toUpperCase().startsWith("TIMESTAMP");
        }

        public boolean isZonedTimestamp() {
            return this.definition.equalsIgnoreCase("timestamp with time zone") || this.definition.equalsIgnoreCase("timestamp with local time zone");
        }
    }

    static enum AssertionType {
        FIELD_DEFAULT_EQUAL,
        FIELD_NO_DEFAULT;

    }
}

