/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.olr;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleSchemaChangeEventEmitter;
import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.olr.OpenLogReplicatorChangeRecordEmitter;
import io.debezium.connector.oracle.olr.OpenLogReplicatorStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.olr.client.OlrNetworkClient;
import io.debezium.connector.oracle.olr.client.PayloadEvent;
import io.debezium.connector.oracle.olr.client.StreamingEvent;
import io.debezium.connector.oracle.olr.client.payloads.AbstractMutationEvent;
import io.debezium.connector.oracle.olr.client.payloads.PayloadSchema;
import io.debezium.connector.oracle.olr.client.payloads.SchemaChangeEvent;
import io.debezium.connector.oracle.olr.client.payloads.Values;
import io.debezium.data.Envelope;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Clock;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenLogReplicatorStreamingChangeEventSource
implements StreamingChangeEventSource<OraclePartition, OracleOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenLogReplicatorStreamingChangeEventSource.class);
    private final OracleConnectorConfig connectorConfig;
    private final OracleConnection jdbcConnection;
    private final EventDispatcher<OraclePartition, TableId> dispatcher;
    private final ErrorHandler errorHandler;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final OpenLogReplicatorStreamingChangeEventSourceMetrics streamingMetrics;
    private final SnapshotterService snapshotterService;
    private OlrNetworkClient client;
    private OraclePartition partition;
    private OracleOffsetContext offsetContext;
    private boolean transactionEvents = false;
    private Scn lastCheckpointScn = Scn.NULL;
    private long lastCheckpointIndex;

    public OpenLogReplicatorStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleConnection connection, EventDispatcher<OraclePartition, TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, OpenLogReplicatorStreamingChangeEventSourceMetrics streamingMetrics, SnapshotterService snapshotterService) {
        this.connectorConfig = connectorConfig;
        this.dispatcher = dispatcher;
        this.jdbcConnection = connection;
        this.errorHandler = errorHandler;
        this.clock = clock;
        this.schema = schema;
        this.streamingMetrics = streamingMetrics;
        this.snapshotterService = snapshotterService;
    }

    public void init(OracleOffsetContext offsetContext) throws InterruptedException {
        this.offsetContext = offsetContext == null ? this.emptyContext() : offsetContext;
    }

    public OracleOffsetContext getOffsetContext() {
        return this.offsetContext;
    }

    private OracleOffsetContext emptyContext() {
        return OracleOffsetContext.create().logicalName(this.connectorConfig).snapshotPendingTransactions(Collections.emptyMap()).transactionContext(new TransactionContext()).incrementalSnapshotContext((IncrementalSnapshotContext<TableId>)new SignalBasedIncrementalSnapshotContext()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context, OraclePartition partition, OracleOffsetContext offsetContext) throws InterruptedException {
        if (!this.snapshotterService.getSnapshotter().shouldStream()) {
            LOGGER.info("Streaming is not enabled in current configuration");
            return;
        }
        try {
            this.partition = partition;
            this.offsetContext = offsetContext;
            this.jdbcConnection.setAutoCommit(false);
            Scn startScn = this.connectorConfig.getAdapter().getOffsetScn(offsetContext);
            Long startScnIndex = offsetContext.getScnIndex();
            this.client = new OlrNetworkClient(this.connectorConfig);
            if (this.client.connect(startScn, startScnIndex)) {
                while (this.client.isConnected() && context.isRunning()) {
                    StreamingEvent event = this.client.readEvent();
                    if (event != null) {
                        this.onEvent(event);
                    }
                    if (!context.isPaused()) continue;
                    LOGGER.info("Streaming will now pause");
                    context.streamingPaused();
                    context.waitSnapshotCompletion();
                    LOGGER.info("Streaming resumed");
                }
                this.client.disconnect();
                LOGGER.info("Client disconnected.");
            } else {
                LOGGER.warn("Failed to connect to OpenLogReplicator server.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed: {}", (Object)e.getMessage(), (Object)e);
            this.errorHandler.setProducerThrowable((Throwable)e);
        }
        finally {
            LOGGER.info("Streaming metrics dump: {}", (Object)this.streamingMetrics.toString());
            LOGGER.info("Offsets: {}", (Object)offsetContext);
        }
    }

    public void commitOffset(Map<String, ?> partition, Map<String, ?> offset) {
        this.confirmLastCheckpointScn();
    }

    private void confirmLastCheckpointScn() {
        if (!this.lastCheckpointScn.isNull() && this.lastCheckpointIndex > 0L && this.client != null && this.client.isConnected()) {
            this.client.confirm(this.lastCheckpointScn, (Long)this.lastCheckpointIndex);
        } else if (this.lastCheckpointScn.isNull()) {
            LOGGER.warn("Cannot flush latest offset SCN as no checkpoint event was received.");
        }
    }

    private void onEvent(StreamingEvent event) throws Exception {
        block7: for (PayloadEvent payloadEvent : event.getPayload()) {
            switch (payloadEvent.getType()) {
                case BEGIN: {
                    this.onBeginEvent(event);
                    continue block7;
                }
                case COMMIT: {
                    this.onCommitEvent(event);
                    continue block7;
                }
                case CHECKPOINT: {
                    this.onCheckpointEvent(event);
                    continue block7;
                }
                case DDL: {
                    this.onSchemaChangeEvent(event, (SchemaChangeEvent)payloadEvent);
                    continue block7;
                }
                case INSERT: 
                case UPDATE: 
                case DELETE: {
                    this.onMutationEvent(event, (AbstractMutationEvent)payloadEvent);
                    continue block7;
                }
            }
            throw new DebeziumException("Unexpected event type detected: " + payloadEvent.getType());
        }
        this.streamingMetrics.incrementProcessedEventsCount();
        this.streamingMetrics.setCheckpointDetails(event.getCheckpointScn(), event.getCheckpointIndex());
    }

    private void onBeginEvent(StreamingEvent event) {
        this.offsetContext.setScn(event.getCheckpointScn());
        this.offsetContext.setScnIndex(event.getCheckpointIndex());
        this.offsetContext.setEventScn(event.getCheckpointScn());
        this.offsetContext.setTransactionId(event.getXid());
        this.offsetContext.setSourceTime(event.getTimestamp());
        this.transactionEvents = false;
    }

    private void onCommitEvent(StreamingEvent event) throws InterruptedException {
        this.offsetContext.setScn(event.getCheckpointScn());
        this.offsetContext.setScnIndex(event.getCheckpointIndex());
        this.offsetContext.setEventScn(event.getCheckpointScn());
        this.offsetContext.setTransactionId(event.getXid());
        this.offsetContext.setSourceTime(event.getTimestamp());
        this.streamingMetrics.incrementCommittedTransactionCount();
        if (this.transactionEvents) {
            this.dispatcher.dispatchTransactionCommittedEvent((Partition)this.partition, (OffsetContext)this.offsetContext, event.getTimestamp());
        }
        this.updateCheckpoint(event);
        this.dispatcher.alwaysDispatchHeartbeatEvent((Partition)this.partition, (OffsetContext)this.offsetContext);
    }

    private void onCheckpointEvent(StreamingEvent event) throws InterruptedException {
        this.offsetContext.setScn(event.getCheckpointScn());
        this.offsetContext.setScnIndex(event.getCheckpointIndex());
        this.offsetContext.setEventScn(event.getCheckpointScn());
        this.offsetContext.setTransactionId(event.getXid());
        this.offsetContext.setSourceTime(event.getTimestamp());
        this.updateCheckpoint(event);
        this.dispatcher.alwaysDispatchHeartbeatEvent((Partition)this.partition, (OffsetContext)this.offsetContext);
    }

    private void onMutationEvent(StreamingEvent event, AbstractMutationEvent mutationEvent) throws Exception {
        Envelope.Operation operation;
        PayloadEvent.Type eventType = mutationEvent.getType();
        TableId tableId = mutationEvent.getSchema().getTableId(event.getDatabaseName());
        if (!this.connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
            return;
        }
        Table table = this.schema.tableFor(tableId);
        if (table == null) {
            Optional<Table> result = this.potentiallyEmitSchemaChangeForUnknownTable(eventType, tableId);
            if (result.isEmpty()) {
                return;
            }
            table = result.get();
        }
        switch (eventType) {
            case INSERT: {
                operation = Envelope.Operation.CREATE;
                break;
            }
            case UPDATE: {
                operation = Envelope.Operation.UPDATE;
                break;
            }
            case DELETE: {
                operation = Envelope.Operation.DELETE;
                break;
            }
            default: {
                throw new DebeziumException("Unexpected DML event type: " + eventType);
            }
        }
        this.offsetContext.setScn(event.getCheckpointScn());
        this.offsetContext.setScnIndex(event.getCheckpointIndex());
        this.offsetContext.setEventScn(event.getCheckpointScn());
        this.offsetContext.setTransactionId(event.getXid());
        this.offsetContext.tableEvent(tableId, event.getTimestamp());
        this.streamingMetrics.setLastCapturedDmlCount(1);
        this.updateCheckpoint(event);
        if (!this.transactionEvents) {
            this.dispatcher.dispatchTransactionStartedEvent((Partition)this.partition, event.getXid(), (OffsetContext)this.offsetContext, event.getTimestamp());
            this.transactionEvents = true;
        }
        Object[] oldValues = this.toColumnValuesArray(table, mutationEvent.getBefore());
        Object[] newValues = this.toColumnValuesArray(table, mutationEvent.getAfter());
        LOGGER.trace("Dispatching {} (SCN {}) for table {}", new Object[]{eventType, event.getScn(), tableId});
        this.dispatcher.dispatchDataChangeEvent((Partition)this.partition, (DataCollectionId)tableId, (ChangeRecordEmitter)new OpenLogReplicatorChangeRecordEmitter(this.connectorConfig, this.partition, this.offsetContext, operation, oldValues, newValues, table, this.schema, this.clock));
    }

    private void onSchemaChangeEvent(StreamingEvent event, SchemaChangeEvent schemaEvent) throws Exception {
        PayloadSchema payloadSchema = schemaEvent.getSchema();
        TableId tableId = payloadSchema.getTableId(event.getDatabaseName());
        if (tableId.schema() == null || tableId.table().startsWith("OBJ_")) {
            LOGGER.trace("Cannot process DDL due to missing schema: {}", (Object)schemaEvent.getSql());
            return;
        }
        if (tableId.table().startsWith("BIN$") && tableId.table().endsWith("==$0")) {
            LOGGER.trace("Skipping DDL for recycling bin table: {}", (Object)schemaEvent.getSql());
            return;
        }
        this.offsetContext.setScn(event.getCheckpointScn());
        this.offsetContext.setScnIndex(event.getCheckpointIndex());
        this.offsetContext.setEventScn(event.getCheckpointScn());
        this.offsetContext.setTransactionId(event.getXid());
        this.offsetContext.tableEvent(tableId, event.getTimestamp());
        String sqlStatement = schemaEvent.getSql().toLowerCase().trim();
        if (!this.isTableSqlStatement(sqlStatement)) {
            LOGGER.trace("Skipping internal DDL: {}", (Object)schemaEvent.getSql());
            return;
        }
        if (sqlStatement.contains("rename constraint ")) {
            LOGGER.trace("Ignoring constraint rename: {}", (Object)schemaEvent.getSql());
            return;
        }
        if (sqlStatement.contains("rename to \"bin$")) {
            LOGGER.trace("Ignoring table rename to recycling object: {}", (Object)schemaEvent.getSql());
            return;
        }
        this.updateCheckpoint(event);
        LOGGER.trace("Dispatching DDL (SCN {}): [{}]", (Object)event.getScn(), (Object)schemaEvent.getSql());
        this.dispatcher.dispatchSchemaChangeEvent((Partition)this.partition, (OffsetContext)this.offsetContext, (DataCollectionId)tableId, (SchemaChangeEventEmitter)new OracleSchemaChangeEventEmitter(this.connectorConfig, this.partition, this.offsetContext, tableId, tableId.catalog(), tableId.schema(), schemaEvent.getSql(), this.schema, event.getTimestamp(), this.streamingMetrics, () -> this.processTruncateEvent(event, schemaEvent)));
    }

    private boolean isTableSqlStatement(String sqlStatement) {
        return sqlStatement.startsWith("create table ") || sqlStatement.startsWith("alter table ") || sqlStatement.startsWith("drop table ") || sqlStatement.startsWith("truncate table ");
    }

    private Object[] toColumnValuesArray(Table table, Values values) {
        Object[] results = new Object[table.columns().size()];
        if (values != null) {
            try {
                TableId tableId = table.id();
                for (Column column : table.columns()) {
                    int index = column.position() - 1;
                    Object value = this.resolveColumnValue(tableId, column, values);
                    LOGGER.trace("Processing column at {} with name {} [jdbcType={}, type={},length={},scale={}] and value {} ({}).", new Object[]{index, column.name(), column.jdbcType(), column.typeName(), column.length(), column.scale().orElse(0), value, value != null ? value.getClass() : "<null>"});
                    results[index] = value;
                }
            }
            catch (Exception e) {
                throw new DebeziumException("Failed to create column array values", (Throwable)e);
            }
        }
        return results;
    }

    private Optional<Table> potentiallyEmitSchemaChangeForUnknownTable(PayloadEvent.Type eventType, TableId tableId) throws Exception {
        String tableDdl;
        if (!this.connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
            LOGGER.trace("{} for non-captured table {} detected.", (Object)eventType, (Object)tableId);
            return Optional.empty();
        }
        LOGGER.warn("Fetching schema for table {}, which should already be loaded. This may indicate a potential error in your configuration.", (Object)tableId);
        try {
            tableDdl = this.jdbcConnection.getTableMetadataDdl(tableId);
        }
        catch (OracleConnection.NonRelationalTableException e) {
            LOGGER.warn("Table {} is not a relational table, the {} will be skipped.", (Object)tableId, (Object)eventType);
            this.streamingMetrics.incrementWarningCount();
            return Optional.empty();
        }
        this.dispatcher.dispatchSchemaChangeEvent((Partition)this.partition, (OffsetContext)this.offsetContext, (DataCollectionId)tableId, (SchemaChangeEventEmitter)new OracleSchemaChangeEventEmitter(this.connectorConfig, this.partition, this.offsetContext, tableId, tableId.catalog(), tableId.schema(), tableDdl, this.schema, Instant.now(), this.streamingMetrics, null));
        return Optional.ofNullable(this.schema.tableFor(tableId));
    }

    private void processTruncateEvent(StreamingEvent event, SchemaChangeEvent ddlEvent) throws InterruptedException {
        if (ddlEvent.getSchema() == null) {
            LOGGER.warn("Truncate event ignored, no schema found.");
            return;
        }
        TableId tableId = ddlEvent.getSchema().getTableId(event.getDatabaseName());
        if (!this.connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
            LOGGER.warn("Truncate event ignored, table is no included.");
            return;
        }
        Table table = this.schema.tableFor(tableId);
        if (table == null) {
            try {
                Optional<Table> result = this.potentiallyEmitSchemaChangeForUnknownTable(ddlEvent.getType(), tableId);
                if (result.isEmpty()) {
                    LOGGER.warn("Truncate ignored, cannot find table relational model");
                    return;
                }
                table = result.get();
            }
            catch (Exception e) {
                LOGGER.warn("Truncate ignored, failed to emit schema change", (Throwable)e);
                return;
            }
        }
        this.offsetContext.setScn(event.getScn());
        this.offsetContext.setEventScn(event.getScn());
        this.offsetContext.setTransactionId(event.getXid());
        this.offsetContext.tableEvent(tableId, event.getTimestamp());
        this.updateCheckpoint(event);
        LOGGER.trace("Dispatching {} (SCN {}) for table {}", new Object[]{Envelope.Operation.TRUNCATE, event.getScn(), tableId});
        this.dispatcher.dispatchDataChangeEvent((Partition)this.partition, (DataCollectionId)tableId, (ChangeRecordEmitter)new OpenLogReplicatorChangeRecordEmitter(this.connectorConfig, this.partition, this.offsetContext, Envelope.Operation.TRUNCATE, new Object[table.columns().size()], new Object[table.columns().size()], table, this.schema, this.clock));
    }

    private Object resolveColumnValue(TableId tableId, Column column, Values values) {
        Object value = values.getValues().getOrDefault(column.name(), OracleValueConverters.UNAVAILABLE_VALUE);
        if (value == OracleValueConverters.UNAVAILABLE_VALUE) {
            List<Column> lobColumns = this.schema.getLobColumnsForTable(tableId);
            for (Column lobColumn : lobColumns) {
                if (!lobColumn.equals(column)) continue;
                return value;
            }
            value = null;
        }
        return value;
    }

    private void updateCheckpoint(StreamingEvent event) {
        this.lastCheckpointScn = event.getCheckpointScn();
        this.lastCheckpointIndex = event.getCheckpointIndex();
    }
}

