/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.AssociativeArrayEntry;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.SQLName;
import oracle.sql.StructDescriptor;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public class OracleTypeCOLLECTION
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -7279638692691669378L;
    int userCode = 0;
    long maxSize = 0L;
    OracleType elementType = null;
    private int collectionFlag = 0;
    static final int CURRENT_USER_OBJECT = 0;
    static final int CURRENT_USER_SYNONYM = 1;
    static final int CURRENT_USER_SYNONYM_10g = 2;
    static final int CURRENT_USER_PUBLIC_SYNONYM = 3;
    static final int CURRENT_USER_PUBLIC_SYNONYM_10g = 4;
    static final int POSSIBLY_OTHER_USER_OBJECT = 5;
    static final int POSSIBLY_OTHER_USER_OBJECT_10g = 6;
    static final int OTHER_USER_OBJECT = 7;
    static final int OTHER_USER_SYNONYM = 8;
    static final int PUBLIC_SYNONYM = 9;
    static final int PUBLIC_SYNONYM_10g = 10;
    static final int BREAK = 11;
    static final String[] sqlString = new String[]{"SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME = :1", "DECLARE CURSOR usyn_cur IS SELECT table_name from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; BEGIN SELECT TABLE_NAME BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name; END IF; OPEN ? FOR SELECT  ELEM_TYPE_NAME, ELEM_TYPE_OWNER   FROM USER_COLL_TYPES   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?); END;", "DECLARE CURSOR usyn_cur IS SELECT table_name from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; BEGIN SELECT TABLE_NAME BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name; END IF; OPEN ? FOR SELECT  ELEM_TYPE_NAME, ELEM_TYPE_OWNER   FROM USER_COLL_TYPES   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?); END;", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM USER_COLL_TYPES WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ", "DECLARE CURSOR usyn_cur IS SELECT table_name from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; BEGIN SELECT TABLE_NAME BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name; END IF; OPEN ? FOR SELECT  ELEM_TYPE_NAME, ELEM_TYPE_OWNER   FROM ALL_COLL_TYPES   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?); END;", "DECLARE CURSOR usyn_cur IS SELECT table_name from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; BEGIN SELECT TABLE_NAME BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name; END IF; OPEN ? FOR SELECT  ELEM_TYPE_NAME, ELEM_TYPE_OWNER   FROM ALL_COLL_TYPES   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?); END;", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE OWNER = :1 AND TYPE_NAME = :2", "SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES WHERE OWNER = (SELECT DISTINCT TABLE_OWNER FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:1) AND TYPE_NAME = (SELECT DISTINCT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:2) ", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); BEGIN  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); BEGIN  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ELEM_TYPE_NAME, ELEM_TYPE_OWNER FROM ALL_COLL_TYPES  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;"};

    public OracleTypeCOLLECTION(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, (Connection)oracleConnection);
    }

    public OracleTypeCOLLECTION(OracleTypeADT oracleTypeADT, int n2, OracleConnection oracleConnection) throws SQLException {
        super(oracleTypeADT, n2, (Connection)oracleConnection);
    }

    public OracleTypeCOLLECTION(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, OracleConnection oracleConnection) throws SQLException {
        super(sQLName, byArray, n2, byArray2, oracleConnection);
    }

    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            if (object instanceof ARRAY) {
                return (Datum)object;
            }
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            return new ARRAY(arrayDescriptor, this.connection, object);
        }
        return null;
    }

    @Override
    public int getTypeCode() {
        return 2003;
    }

    @Override
    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        if (oracleType == null) {
            return false;
        }
        if (oracleType == this) {
            return true;
        }
        if (oracleType.getClass() != this.getClass()) {
            return false;
        }
        return oracleType.getTypeDescriptor().getName().equals(this.descriptor.getName());
    }

    @Override
    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    @Override
    public boolean isObjectType() {
        return false;
    }

    @Override
    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        long l2 = tDSReader.readLong();
        this.maxSize = tDSReader.readLong();
        this.userCode = tDSReader.readByte();
        tDSReader.addSimplePatch(l2, this);
    }

    @Override
    public Datum unlinearize(byte[] byArray, long l2, Datum datum, int n2, Map map) throws SQLException {
        return this.unlinearize(byArray, l2, datum, 1L, -1, n2, map);
    }

    @Override
    public Datum unlinearize(byte[] byArray, long l2, Datum datum, long l3, int n2, int n3, Map map) throws SQLException {
        OracleConnection oracleConnection = this.getConnection();
        Datum datum2 = null;
        if (oracleConnection == null) {
            datum2 = this.unlinearizeInternal(byArray, l2, datum, l3, n2, n3, map);
        } else {
            try (Monitor.CloseableLock closeableLock = oracleConnection.acquireCloseableLock();){
                datum2 = this.unlinearizeInternal(byArray, l2, datum, l3, n2, n3, map);
            }
        }
        return datum2;
    }

    public Datum unlinearizeInternal(byte[] byArray, long l2, Datum datum, long l3, int n2, int n3, Map map) throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            if (byArray == null) {
                Datum datum2 = null;
                return datum2;
            }
            PickleContext pickleContext = new PickleContext(byArray, l2);
            Datum datum3 = (Datum)((Object)this.unpickle81(pickleContext, (OracleArray)((Object)datum), l3, n2, 1, n3, map));
            return datum3;
        }
    }

    public boolean isInlineImage(byte[] byArray, int n2) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock closeableLock = this.acquireCloseableLock();){
            if (byArray == null) {
                boolean bl = false;
                return bl;
            }
            if (PickleContext.isCollectionImage_pctx(byArray[n2])) {
                boolean bl = true;
                return bl;
            }
            if (PickleContext.isDegenerateImage_pctx(byArray[n2])) {
                boolean bl = false;
                return bl;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not a collection image").fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        OracleArray oracleArray = (OracleArray)((Object)datum);
        boolean bl = oracleArray.hasDataSeg();
        int n2 = 0;
        int n3 = pickleContext.offset() + 2;
        if (bl) {
            if (!this.metaDataInitialized) {
                this.copy_properties((OracleTypeCOLLECTION)oracleArray.getDescriptor().getPickler());
            }
            Datum[] datumArray = oracleArray.getOracleArray();
            if (this.userCode == 3 && (long)datumArray.length > this.maxSize) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 71, null).fillInStackTrace();
            }
            pickleContext.setCollectionUserCode(this.userCode);
            n2 += pickleContext.writeCollImageHeader(datumArray.length, this.typeVersion);
            for (int i2 = 0; i2 < datumArray.length; ++i2) {
                if (this.userCode == 1) {
                    AssociativeArrayEntry associativeArrayEntry = (AssociativeArrayEntry)datumArray[i2];
                    Integer n4 = (Integer)associativeArrayEntry.getKey();
                    n2 += pickleContext.writeUB4(n4);
                    Datum datum2 = (Datum)((AssociativeArrayEntry)datumArray[i2]).getValue();
                    if (datum2 == null) {
                        n2 += pickleContext.writeElementNull();
                        continue;
                    }
                    n2 += this.elementType.pickle81(pickleContext, datum2);
                    continue;
                }
                if (datumArray[i2] == null) {
                    n2 += pickleContext.writeElementNull();
                    continue;
                }
                n2 += this.elementType.pickle81(pickleContext, datumArray[i2]);
            }
        } else {
            n2 += pickleContext.writeCollImageHeader(oracleArray.getLocator());
        }
        pickleContext.patchImageLen(n3, n2);
        return n2;
    }

    OracleArray unpickle81(PickleContext pickleContext, OracleArray oracleArray, int n2, int n3, Map map) throws SQLException {
        return this.unpickle81(pickleContext, oracleArray, 1L, -1, n2, n3, map);
    }

    OracleArray unpickle81(PickleContext pickleContext, OracleArray oracleArray, long l2, int n2, int n3, int n4, Map map) throws SQLException {
        OracleArray oracleArray2 = oracleArray;
        if (oracleArray2 == null) {
            ArrayDescriptor arrayDescriptor = this.createArrayDescriptor();
            oracleArray2 = new ARRAY(arrayDescriptor, (byte[])null, this.connection);
        }
        if (this.unpickle81ImgHeader(pickleContext, oracleArray2, n3, n4)) {
            this.collectionFlag = pickleContext.readByte();
            pickleContext.setCollectionUserCode(this.collectionFlag);
            if (l2 == 1L && n2 == -1) {
                this.unpickle81ImgBody(pickleContext, oracleArray2, n4, map);
            } else {
                this.unpickle81ImgBody(pickleContext, oracleArray2, l2, n2, n4, map);
            }
        }
        return oracleArray2;
    }

    boolean unpickle81ImgHeader(PickleContext pickleContext, OracleArray oracleArray, int n2, int n3) throws SQLException {
        boolean bl = true;
        if (n2 == 3) {
            oracleArray.setImage(pickleContext.image(), pickleContext.absoluteOffset(), 0L);
        }
        byte by = pickleContext.readByte();
        if (!PickleContext.is81format(by)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not in 8.1 format").fillInStackTrace();
        }
        if (!PickleContext.hasPrefix(by)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image has no prefix segment").fillInStackTrace();
        }
        if (PickleContext.isCollectionImage_pctx(by)) {
            bl = true;
        } else if (PickleContext.isDegenerateImage_pctx(by)) {
            bl = false;
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not a collection image").fillInStackTrace();
        }
        pickleContext.readByte();
        if (n2 == 9) {
            pickleContext.skipBytes(pickleContext.readLength(true) - 2);
            return false;
        }
        if (n2 == 3) {
            long l2 = pickleContext.readLength();
            oracleArray.setImageLength(l2);
            pickleContext.skipTo(oracleArray.getImageOffset() + l2);
            return false;
        }
        pickleContext.skipLength();
        int n4 = pickleContext.readLength();
        oracleArray.setPrefixFlag(pickleContext.readByte());
        if (oracleArray.isInline()) {
            pickleContext.readDataValue(n4 - 1);
        } else {
            oracleArray.setLocator(pickleContext.readDataValue(n4 - 1));
        }
        return oracleArray.isInline();
    }

    void unpickle81ImgBody(PickleContext pickleContext, OracleArray oracleArray, long l2, int n2, int n3, Map map) throws SQLException {
        boolean bl;
        int n4 = pickleContext.readLength();
        oracleArray.setLength(n4);
        if (n3 == 0) {
            return;
        }
        int n5 = (int)this.getAccessLength(n4, l2, n2);
        boolean bl2 = bl = ArrayDescriptor.getCacheStyle(oracleArray) == 1;
        if (l2 > 1L && n5 > 0) {
            long l3 = oracleArray.getLastIndex();
            if (l3 < l2) {
                if (l3 > 0L) {
                    pickleContext.skipTo(oracleArray.getLastOffset());
                } else {
                    l3 = 1L;
                }
                if (bl) {
                    for (long i2 = l3; i2 < l2; ++i2) {
                        oracleArray.setIndexOffset(i2, pickleContext.offset());
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                    }
                } else {
                    for (long i3 = l3; i3 < l2; ++i3) {
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                    }
                }
            } else if (l3 > l2) {
                long l4 = oracleArray.getOffset(l2);
                if (l4 != -1L) {
                    pickleContext.skipTo(l4);
                } else if (bl) {
                    int n6 = 1;
                    while ((long)n6 < l2) {
                        oracleArray.setIndexOffset(n6, pickleContext.offset());
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                        ++n6;
                    }
                } else {
                    int n7 = 1;
                    while ((long)n7 < l2) {
                        this.elementType.unpickle81rec(pickleContext, 9, null);
                        ++n7;
                    }
                }
            } else {
                pickleContext.skipTo(oracleArray.getLastOffset());
            }
            oracleArray.setLastIndexOffset(l2, pickleContext.offset());
        }
        this.unpickle81ImgBodyElements(pickleContext, oracleArray, (int)l2, n5, n3, map);
    }

    void unpickle81ImgBody(PickleContext pickleContext, OracleArray oracleArray, int n2, Map map) throws SQLException {
        int n3 = pickleContext.readLength();
        oracleArray.setLength(n3);
        if (n2 == 0) {
            return;
        }
        this.unpickle81ImgBodyElements(pickleContext, oracleArray, 1, n3, n2, map);
    }

    private void unpickle81ImgBodyElements(PickleContext pickleContext, OracleArray oracleArray, int n2, int n3, int n4, Map map) throws SQLException {
        boolean bl = ArrayDescriptor.getCacheStyle(oracleArray) == 1;
        switch (n4) {
            case 1: {
                Datum[] datumArray = new Datum[n3];
                if (bl) {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        oracleArray.setIndexOffset(n2 + i2, pickleContext.offset());
                        datumArray[i2] = (Datum)this.elementType.unpickle81rec(pickleContext, n4, map);
                    }
                } else {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        datumArray[i3] = (Datum)this.elementType.unpickle81rec(pickleContext, n4, map);
                    }
                }
                oracleArray.setDatumArray(datumArray);
                break;
            }
            case 2: {
                Object[] objectArray = ArrayDescriptor.makeJavaArray(n3, this.elementType.getTypeCode());
                HashMap<Integer, Object> hashMap = null;
                if (this.userCode == 1) {
                    hashMap = new HashMap<Integer, Object>();
                }
                if (bl) {
                    for (int i4 = 0; i4 < n3; ++i4) {
                        if (this.collectionFlag == PickleContext.KOPI20_CF_INDX) {
                            Integer n5 = new Integer((int)pickleContext.readUB4());
                            oracleArray.setIndexOffset(n2 + i4, pickleContext.offset());
                            objectArray[i4] = this.elementType.unpickle81rec(pickleContext, n4, map);
                            if (hashMap == null) continue;
                            hashMap.put(n5, objectArray[i4]);
                            continue;
                        }
                        oracleArray.setIndexOffset(n2 + i4, pickleContext.offset());
                        objectArray[i4] = this.elementType.unpickle81rec(pickleContext, n4, map);
                    }
                } else {
                    for (int i5 = 0; i5 < n3; ++i5) {
                        if (this.collectionFlag == PickleContext.KOPI20_CF_INDX) {
                            Integer n6 = new Integer((int)pickleContext.readUB4());
                            objectArray[i5] = this.elementType.unpickle81rec(pickleContext, n4, map);
                            if (hashMap == null) continue;
                            hashMap.put(n6, objectArray[i5]);
                            continue;
                        }
                        objectArray[i5] = this.elementType.unpickle81rec(pickleContext, n4, map);
                    }
                }
                oracleArray.setObjArray(objectArray);
                oracleArray.setJavaMap(hashMap);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.elementType instanceof OracleTypeNUMBER || this.elementType instanceof OracleTypeFLOAT) {
                    oracleArray.setObjArray(OracleTypeNUMBER.unpickle81NativeArray(pickleContext, 1L, n3, n4));
                    break;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "This feature is limited to numeric collection").fillInStackTrace();
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid conversion type " + this.elementType).fillInStackTrace();
            }
        }
        oracleArray.setLastIndexOffset(n2 + n3, pickleContext.offset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCollElemTypeName() throws SQLException {
        if (this.connection == null) {
            return;
        }
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            if (this.sqlName == null) {
                this.getFullName();
            }
            Statement statement = null;
            Statement statement2 = null;
            ResultSet resultSet = null;
            this.connection.beginNonRequestCalls();
            try {
                int n2;
                int n3 = n2 = this.sqlName.getSchema().equalsIgnoreCase(this.connection.getDefaultSchemaNameForNamedTypes()) ? 0 : 7;
                while (n2 != 11) {
                    switch (n2) {
                        case 0: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 5;
                            break;
                        }
                        case 1: {
                            if (this.connection.getVersionNumber() >= 10000) {
                                n2 = 2;
                            }
                        }
                        case 2: {
                            statement = (OracleCallableStatement)this.connection.prepareCall(this.getSqlHint() + sqlString[n2]);
                            statement.setString(1, this.sqlName.getSimpleName());
                            statement.setString(3, this.sqlName.getSimpleName());
                            statement.registerOutParameter(2, -10);
                            statement.execute();
                            resultSet = ((OracleCallableStatement)statement).getCursor(2);
                            resultSet.setFetchSize(1);
                            n2 = 3;
                            break;
                        }
                        case 3: {
                            if (this.connection.getVersionNumber() >= 10000) {
                                n2 = 4;
                            }
                        }
                        case 4: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSimpleName());
                            statement2.setString(2, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 8;
                            break;
                        }
                        case 5: {
                            if (this.connection.getVersionNumber() >= 10000) {
                                n2 = 6;
                            }
                        }
                        case 6: {
                            statement = (OracleCallableStatement)this.connection.prepareCall(this.getSqlHint() + sqlString[n2]);
                            statement.setString(1, this.sqlName.getSimpleName());
                            statement.setString(3, this.sqlName.getSimpleName());
                            statement.registerOutParameter(2, -10);
                            statement.execute();
                            resultSet = ((OracleCallableStatement)statement).getCursor(2);
                            resultSet.setFetchSize(1);
                            n2 = 1;
                            break;
                        }
                        case 7: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSchema());
                            statement2.setString(2, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 8;
                            break;
                        }
                        case 8: {
                            statement2 = this.connection.prepareStatement(this.getSqlHint() + sqlString[n2]);
                            statement2.setString(1, this.sqlName.getSimpleName());
                            statement2.setString(2, this.sqlName.getSimpleName());
                            statement2.setFetchSize(1);
                            resultSet = statement2.executeQuery();
                            n2 = 9;
                            break;
                        }
                        case 9: {
                            if (this.connection.getVersionNumber() >= 10000) {
                                n2 = 10;
                            }
                        }
                        case 10: {
                            statement = this.connection.prepareCall(this.getSqlHint() + sqlString[n2]);
                            statement.setString(1, this.sqlName.getSimpleName());
                            statement.registerOutParameter(2, -10);
                            statement.execute();
                            resultSet = ((OracleCallableStatement)statement).getCursor(2);
                            n2 = 11;
                        }
                    }
                    if (resultSet != null && resultSet.next()) {
                        if (this.attrTypeNames == null) {
                            this.attrTypeNames = new String[1];
                        }
                        this.attrTypeNames[0] = resultSet.getString(2) + "." + resultSet.getString(1);
                        n2 = 11;
                    } else if (n2 == 11) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
                    }
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement2 != null) {
                        statement2.close();
                    }
                    if (statement == null) continue;
                    statement.close();
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement2 != null) {
                    statement2.close();
                }
                if (statement != null) {
                    statement.close();
                }
                this.connection.endNonRequestCalls();
            }
        }
    }

    @Override
    public String getAttributeName(int n2) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
    }

    @Override
    public String getAttributeName(int n2, boolean bl) throws SQLException {
        return this.getAttributeName(n2);
    }

    @Override
    public String getAttributeType(int n2) throws SQLException {
        if (n2 != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        if (this.sqlName == null) {
            this.getFullName();
        }
        if (this.attrTypeNames == null) {
            this.initCollElemTypeName();
        }
        return this.attrTypeNames[0];
    }

    @Override
    public String getAttributeType(int n2, boolean bl) throws SQLException {
        if (bl) {
            return this.getAttributeType(n2);
        }
        if (n2 != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        if (this.sqlName != null && this.attrTypeNames != null) {
            return this.attrTypeNames[0];
        }
        return null;
    }

    @Override
    public int getNumAttrs() throws SQLException {
        return 0;
    }

    @Override
    public OracleType getAttrTypeAt(int n2) throws SQLException {
        return null;
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        return new ArrayDescriptor(this, (Connection)this.connection);
    }

    ArrayDescriptor createArrayDescriptorWithItsOwnTree() throws SQLException {
        if (this.descriptor == null) {
            this.descriptor = this.sqlName == null && this.getFullName(false) == null ? new ArrayDescriptor(this, (Connection)this.connection) : ArrayDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        }
        return (ArrayDescriptor)this.descriptor;
    }

    public OracleType getElementType() throws SQLException {
        return this.elementType;
    }

    public int getUserCode() throws SQLException {
        return this.userCode;
    }

    public long getMaxLength() throws SQLException {
        return this.maxSize;
    }

    private long getAccessLength(long l2, long l3, int n2) throws SQLException {
        if (l3 > l2) {
            return 0L;
        }
        if (n2 < 0) {
            return l2 - l3 + 1L;
        }
        return Math.min(l2 - l3 + 1L, (long)n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.userCode);
        objectOutputStream.writeLong(this.maxSize);
        objectOutputStream.writeObject(this.elementType);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.userCode = objectInputStream.readInt();
        this.maxSize = objectInputStream.readLong();
        this.elementType = (OracleType)objectInputStream.readObject();
    }

    @Override
    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
        this.elementType.setConnection(oracleConnection);
    }

    @Override
    public void initMetadataRecursively() throws SQLException {
        this.initMetadata(this.connection);
        if (this.elementType != null) {
            this.elementType.initMetadataRecursively();
        }
    }

    @Override
    public void initChildNamesRecursively(Map map) throws SQLException {
        TypeTreeElement typeTreeElement = (TypeTreeElement)map.get(this.sqlName);
        if (this.elementType != null) {
            this.elementType.setNames(typeTreeElement.getChildSchemaName(0), typeTreeElement.getChildTypeName(0));
            this.elementType.initChildNamesRecursively(map);
            this.elementType.cacheDescriptor();
        }
    }

    @Override
    public void cacheDescriptor() throws SQLException {
        this.descriptor = ArrayDescriptor.createDescriptor(this);
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        this.printXML(printWriter, n2, false);
    }

    @Override
    public void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println("<OracleTypeCOLLECTION sqlName=\"" + this.sqlName + "\" >");
        if (this.elementType != null) {
            this.elementType.printXML(printWriter, n2 + 1, bl);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println("</OracleTypeCOLLECTION>");
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

