/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.LogMinerQueryBuilder;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class LogMinerQueryBuilderTest {
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();
    private static final String LOG_MINER_QUERY_BASE = "SELECT SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, USERNAME, ROW_ID, ROLLBACK, RS_ID, STATUS, INFO, SSN, THREAD# FROM V$LOGMNR_CONTENTS WHERE SCN > ? AND SCN <= ?";
    private static final String PDB_PREDICATE = "SRC_CON_NAME = '${pdbName}'";
    private static final String OPERATION_CODES_LOB_ENABLED = "1,2,3,6,7,9,10,11,29,34,36,68,70,71,255";
    private static final String OPERATION_CODES_LOB_DISABLED = "1,2,3,6,7,34,36,255";
    private static final String OPERATION_CODES_PREDICATE = "(OPERATION_CODE IN (${operationCodes})${operationDdl})";

    @Test
    public void testLogMinerQueryFilterNone() {
        this.testLogMinerQueryFilterMode(OracleConnectorConfig.LogMiningQueryFilterMode.NONE);
    }

    @Test
    public void testLogMinerQueryFilterIn() {
        this.testLogMinerQueryFilterMode(OracleConnectorConfig.LogMiningQueryFilterMode.IN);
    }

    @Test
    public void testLogMinerQueryFilterRegEx() {
        this.testLogMinerQueryFilterMode(OracleConnectorConfig.LogMiningQueryFilterMode.REGEX);
    }

    @Test
    @FixFor(value={"DBZ-5648"})
    public void testLogMinerQueryWithLobDisabled() {
        Configuration config = TestHelper.defaultConfig().build();
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(config);
        String result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig);
        Assertions.assertThat((String)result).isEqualTo((Object)this.getQueryFromTemplate(connectorConfig));
        config = ((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.PDB_NAME, "")).build();
        connectorConfig = new OracleConnectorConfig(config);
        result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig);
        Assertions.assertThat((String)result).isEqualTo((Object)this.getQueryFromTemplate(connectorConfig));
    }

    @Test
    @FixFor(value={"DBZ-5648"})
    public void testLogMinerQueryWithLobEnabled() {
        Configuration config = ((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        OracleConnectorConfig connectorConfig = new OracleConnectorConfig(config);
        String result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig);
        Assertions.assertThat((String)result).isEqualTo((Object)this.getQueryFromTemplate(connectorConfig));
        config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.PDB_NAME, "")).with(OracleConnectorConfig.LOB_ENABLED, true)).build();
        connectorConfig = new OracleConnectorConfig(config);
        result = LogMinerQueryBuilder.build((OracleConnectorConfig)connectorConfig);
        Assertions.assertThat((String)result).isEqualTo((Object)this.getQueryFromTemplate(connectorConfig));
    }

    private void testLogMinerQueryFilterMode(OracleConnectorConfig.LogMiningQueryFilterMode mode) {
        this.assertQuery(this.getBuilderForMode(mode));
        String schemas = "DEBEZIUM1,DEBEZIUM2, DEBEZIUM3, DEBEZIUM4";
        this.assertQuery(this.getBuilderForMode(mode).with(RelationalDatabaseConnectorConfig.SCHEMA_INCLUDE_LIST, "DEBEZIUM1,DEBEZIUM2, DEBEZIUM3, DEBEZIUM4"));
        this.assertQuery(this.getBuilderForMode(mode).with(RelationalDatabaseConnectorConfig.SCHEMA_EXCLUDE_LIST, "DEBEZIUM1,DEBEZIUM2, DEBEZIUM3, DEBEZIUM4"));
        String tables = "DEBEZIUM\\.T1,DEBEZIUM\\.T2, DEBEZIUM\\.T3, DEBEZIUM\\.T4";
        this.assertQuery(this.getBuilderForMode(mode).with(RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.T1,DEBEZIUM\\.T2, DEBEZIUM\\.T3, DEBEZIUM\\.T4"));
        this.assertQuery(this.getBuilderForMode(mode).with(RelationalDatabaseConnectorConfig.SCHEMA_EXCLUDE_LIST, "DEBEZIUM\\.T1,DEBEZIUM\\.T2, DEBEZIUM\\.T3, DEBEZIUM\\.T4"));
        String users = "U1,U2, U3, U4";
        this.assertQuery(this.getBuilderForMode(mode).with(OracleConnectorConfig.LOG_MINING_USERNAME_INCLUDE_LIST, "U1,U2, U3, U4"));
        this.assertQuery(this.getBuilderForMode(mode).with(OracleConnectorConfig.LOG_MINING_USERNAME_EXCLUDE_LIST, "U1,U2, U3, U4"));
        String signalTable = TestHelper.getDatabaseName() + ".DEBEZIUM1.SIGNAL_TABLE";
        this.assertQuery(this.getBuilderForMode(mode).with(RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.T1,DEBEZIUM\\.T2, DEBEZIUM\\.T3, DEBEZIUM\\.T4").with(CommonConnectorConfig.SIGNAL_DATA_COLLECTION, signalTable));
        this.assertQuery(this.getBuilderForMode(mode).with(RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST, "DEBEZIUM\\.T1,DEBEZIUM\\.T2, DEBEZIUM\\.T3, DEBEZIUM\\.T4").with(CommonConnectorConfig.SIGNAL_DATA_COLLECTION, signalTable));
        String tables2 = "DEBEZIUM\\.T1,DEBEZIUM\\.T2, DEBEZIUM\\.T3, DEBEZIUM\\.T4,DEBEZIUM1\\.SIGNAL_TABLE";
        this.assertQuery(this.getBuilderForMode(mode).with(RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.T1,DEBEZIUM\\.T2, DEBEZIUM\\.T3, DEBEZIUM\\.T4,DEBEZIUM1\\.SIGNAL_TABLE").with(CommonConnectorConfig.SIGNAL_DATA_COLLECTION, signalTable));
        this.assertQuery(this.getBuilderForMode(mode).with(RelationalDatabaseConnectorConfig.SCHEMA_INCLUDE_LIST, "DEBEZIUM1,DEBEZIUM2, DEBEZIUM3, DEBEZIUM4").with(RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.T1,DEBEZIUM\\.T2, DEBEZIUM\\.T3, DEBEZIUM\\.T4").with(OracleConnectorConfig.LOG_MINING_USERNAME_INCLUDE_LIST, "U1,U2, U3, U4"));
        this.assertQuery(this.getBuilderForMode(mode).with(RelationalDatabaseConnectorConfig.SCHEMA_EXCLUDE_LIST, "DEBEZIUM1,DEBEZIUM2, DEBEZIUM3, DEBEZIUM4").with(RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST, "DEBEZIUM\\.T1,DEBEZIUM\\.T2, DEBEZIUM\\.T3, DEBEZIUM\\.T4").with(OracleConnectorConfig.LOG_MINING_USERNAME_EXCLUDE_LIST, "U1,U2, U3, U4"));
        this.assertQuery(this.getBuilderForMode(mode).with(RelationalDatabaseConnectorConfig.SCHEMA_INCLUDE_LIST, "DEBEZIUM1,DEBEZIUM2, DEBEZIUM3, DEBEZIUM4").with(RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST, "DEBEZIUM\\.T1,DEBEZIUM\\.T2, DEBEZIUM\\.T3, DEBEZIUM\\.T4").with(OracleConnectorConfig.LOG_MINING_USERNAME_INCLUDE_LIST, "U1,U2, U3, U4"));
    }

    private ConfigBuilder getBuilderForMode(OracleConnectorConfig.LogMiningQueryFilterMode mode) {
        return new ConfigBuilder().with(OracleConnectorConfig.LOG_MINING_QUERY_FILTER_MODE, mode.getValue());
    }

    private void assertQuery(ConfigBuilder builder) {
        OracleConnectorConfig config = builder.with(HistorizedRelationalDatabaseConnectorConfig.STORE_ONLY_CAPTURED_TABLES_DDL, "false").build();
        Assertions.assertThat((String)LogMinerQueryBuilder.build((OracleConnectorConfig)config)).isEqualTo((Object)this.getQueryFromTemplate(config));
        config = builder.with(HistorizedRelationalDatabaseConnectorConfig.STORE_ONLY_CAPTURED_TABLES_DDL, "true").build();
        Assertions.assertThat((String)LogMinerQueryBuilder.build((OracleConnectorConfig)config)).isEqualTo((Object)this.getQueryFromTemplate(config));
    }

    private String getQueryFromTemplate(OracleConnectorConfig config) {
        Object query = LOG_MINER_QUERY_BASE;
        query = (String)query + this.getPdbPredicate(config);
        query = (String)query + " AND ";
        if (!config.storeOnlyCapturedTables()) {
            query = (String)query + "((";
        }
        query = (String)query + this.getOperationCodePredicate(config);
        query = (String)query + this.getUserNamePredicate(config);
        query = (String)query + this.getSchemaNamesPredicate(config);
        query = (String)query + this.getTableNamesPredicate(config);
        if (!config.storeOnlyCapturedTables()) {
            query = (String)query + ")" + this.getOperationDdlPredicate() + ")";
        }
        return query;
    }

    private String getPdbPredicate(OracleConnectorConfig config) {
        if (!Strings.isNullOrEmpty((String)config.getPdbName())) {
            return " AND " + PDB_PREDICATE.replace("${pdbName}", config.getPdbName());
        }
        return "";
    }

    private String getOperationCodePredicate(OracleConnectorConfig config) {
        String codes = config.isLobEnabled() ? OPERATION_CODES_LOB_ENABLED : OPERATION_CODES_LOB_DISABLED;
        String predicate = OPERATION_CODES_PREDICATE.replace("${operationCodes}", codes);
        return predicate.replace("${operationDdl}", config.storeOnlyCapturedTables() ? this.getOperationDdlPredicate() : "");
    }

    private String getOperationDdlPredicate() {
        return " OR (OPERATION_CODE = 5 AND INFO NOT LIKE 'INTERNAL DDL%')";
    }

    private String getUserNamePredicate(OracleConnectorConfig config) {
        OracleConnectorConfig.LogMiningQueryFilterMode queryFilterMode = config.getLogMiningQueryFilterMode();
        Set includes = config.getLogMiningUsernameIncludes();
        Set excludes = config.getLogMiningUsernameExcludes();
        if (!includes.isEmpty() && !queryFilterMode.equals((Object)OracleConnectorConfig.LogMiningQueryFilterMode.NONE)) {
            return " AND UPPER(USERNAME) IN ('UNKNOWN'," + includes.stream().map(this::quote).collect(Collectors.joining(",")) + ")";
        }
        if (!excludes.isEmpty() && !queryFilterMode.equals((Object)OracleConnectorConfig.LogMiningQueryFilterMode.NONE)) {
            return " AND UPPER(USERNAME) NOT IN (" + excludes.stream().map(this::quote).collect(Collectors.joining(",")) + ")";
        }
        return "";
    }

    private Set<String> getExcludedSchemas() {
        return OracleConnectorConfig.EXCLUDED_SCHEMAS.stream().map(String::toUpperCase).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private String getSchemaNamesPredicate(OracleConnectorConfig config) {
        Object otherClause;
        String regExpLikeClause;
        String fieldName = "SEG_OWNER";
        String includeList = config.schemaIncludeList();
        String excludeList = config.schemaExcludeList();
        if (OracleConnectorConfig.LogMiningQueryFilterMode.NONE.equals((Object)config.getLogMiningQueryFilterMode()) || Strings.isNullOrEmpty((String)includeList) && Strings.isNullOrEmpty((String)excludeList)) {
            return " AND (SEG_OWNER IS NULL OR " + this.getIn("SEG_OWNER", this.getExcludedSchemas(), true, false) + ")";
        }
        if (config.getLogMiningQueryFilterMode().equals((Object)OracleConnectorConfig.LogMiningQueryFilterMode.IN)) {
            String inClause = !Strings.isNullOrEmpty((String)includeList) ? this.getIn("SEG_OWNER", this.getSchemaIncludes(includeList, false), false, true) : this.getIn("SEG_OWNER", this.getSchemaExcludes(excludeList, false), true, true);
            return " AND (SEG_OWNER IS NULL OR " + inClause + ")";
        }
        if (!Strings.isNullOrEmpty((String)includeList)) {
            regExpLikeClause = this.getRegexpLike("SEG_OWNER", this.getSchemaIncludes(includeList, true), false);
            otherClause = "SEG_OWNER = 'UNKNOWN'";
        } else {
            regExpLikeClause = this.getRegexpLike("SEG_OWNER", this.getSchemaExcludes(excludeList, true), true);
            otherClause = "SEG_OWNER NOT IN (" + this.getExcludedSchemas().stream().map(v -> "'" + v + "'").collect(Collectors.joining(",")) + ")";
        }
        return " AND (SEG_OWNER IS NULL OR " + (String)otherClause + " OR " + regExpLikeClause + ")";
    }

    private String getTableNamesPredicate(OracleConnectorConfig config) {
        String fieldName = "SEG_OWNER || '.' || TABLE_NAME";
        String includeList = config.tableIncludeList();
        String excludeList = config.tableExcludeList();
        if (config.getLogMiningQueryFilterMode().equals((Object)OracleConnectorConfig.LogMiningQueryFilterMode.NONE) || Strings.isNullOrEmpty((String)includeList) && Strings.isNullOrEmpty((String)excludeList)) {
            return "";
        }
        if (config.getLogMiningQueryFilterMode().equals((Object)OracleConnectorConfig.LogMiningQueryFilterMode.IN)) {
            String inClause = !Strings.isNullOrEmpty((String)includeList) ? this.getIn("SEG_OWNER || '.' || TABLE_NAME", this.getTableIncludeOrExclude(includeList, false), false, true) : this.getIn("SEG_OWNER || '.' || TABLE_NAME", this.getTableIncludeOrExclude(excludeList, false), true, true);
            String signalDataClause = this.getSignalDataCollectionTableClause(config);
            return " AND (TABLE_NAME IS NULL OR TABLE_NAME LIKE 'OBJ#%' OR " + signalDataClause + inClause + ")";
        }
        String regExpLikeClause = !Strings.isNullOrEmpty((String)includeList) ? this.getRegexpLike("SEG_OWNER || '.' || TABLE_NAME", this.getTableIncludeOrExclude(includeList, true), false) : this.getRegexpLike("SEG_OWNER || '.' || TABLE_NAME", this.getTableIncludeOrExclude(excludeList, true), true);
        String signalDataClause = this.getSignalDataCollectionTableClause(config);
        return " AND (TABLE_NAME IS NULL OR TABLE_NAME LIKE 'OBJ#%' OR " + signalDataClause + regExpLikeClause + ")";
    }

    private String getSignalDataCollectionTableClause(OracleConnectorConfig config) {
        if (!Strings.isNullOrEmpty((String)config.getSignalingDataCollectionId())) {
            TableId tableId = TableId.parse((String)config.getSignalingDataCollectionId());
            boolean foundMatch = false;
            List includeList = Strings.listOfRegex((String)config.tableIncludeList(), (int)2);
            for (Pattern pattern : includeList) {
                if (config.getLogMiningQueryFilterMode().equals((Object)OracleConnectorConfig.LogMiningQueryFilterMode.REGEX)) {
                    if (!pattern.matcher(tableId.identifier()).matches()) continue;
                    foundMatch = true;
                    break;
                }
                if (!pattern.matcher(tableId.schema() + "." + tableId.table()).matches()) continue;
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                return "UPPER(SEG_OWNER || '.' || TABLE_NAME) = '" + tableId.schema().toUpperCase() + '.' + tableId.table().toUpperCase() + "' OR ";
            }
        }
        return "";
    }

    private String getIn(String columnName, Collection<String> values, boolean negated, boolean caseInsensitive) {
        StringBuilder predicate = new StringBuilder();
        if (caseInsensitive) {
            predicate.append("UPPER(").append(columnName).append(")");
        } else {
            predicate.append(columnName);
        }
        if (negated) {
            predicate.append(" NOT");
        }
        predicate.append(" IN (");
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            String value = iterator.next();
            predicate.append("'").append(value).append("'");
            if (!iterator.hasNext()) continue;
            predicate.append(",");
        }
        predicate.append(")");
        return predicate.toString();
    }

    private String getRegexpLike(String columnName, Collection<Pattern> values, boolean negated) {
        StringBuilder predicate = new StringBuilder();
        predicate.append("(");
        Iterator<Pattern> iterator = values.iterator();
        while (iterator.hasNext()) {
            if (negated) {
                predicate.append("NOT ");
            }
            Pattern pattern = iterator.next();
            predicate.append("REGEXP_LIKE(");
            predicate.append(columnName).append(",");
            predicate.append("'^").append(pattern.pattern()).append("$','i')");
            if (!iterator.hasNext()) continue;
            predicate.append(negated ? " AND " : " OR ");
        }
        predicate.append(")");
        return predicate.toString();
    }

    private <T> List<T> getSchemaIncludes(String schemaIncludeList, boolean regex) {
        ArrayList<String> inclusions = new ArrayList<String>();
        if (!regex) {
            inclusions.add("UNKNOWN");
            inclusions.addAll(Strings.setOfTrimmed((String)schemaIncludeList, String::trim));
        } else {
            inclusions.addAll(Strings.listOfRegex((String)schemaIncludeList, (int)2));
        }
        return inclusions;
    }

    private <T> List<T> getSchemaExcludes(String schemaExcludeList, boolean regex) {
        ArrayList<String> exclusions = new ArrayList<String>();
        if (!regex) {
            exclusions.addAll(this.getExcludedSchemas());
            if (!Strings.isNullOrEmpty((String)schemaExcludeList)) {
                exclusions.addAll(Strings.setOfTrimmed((String)schemaExcludeList, String::new));
            }
        } else if (!Strings.isNullOrEmpty((String)schemaExcludeList)) {
            exclusions.addAll(Strings.listOfRegex((String)schemaExcludeList, (int)2));
        }
        return exclusions;
    }

    private <T> List<T> getTableIncludeOrExclude(String list, boolean regex) {
        ArrayList values = new ArrayList();
        if (!regex) {
            values.addAll(Strings.setOfTrimmed((String)list, s -> s.split("[,]"), v -> v.replaceAll("\\\\", "")));
        } else {
            values.addAll(Strings.listOfRegex((String)list, (int)2));
        }
        return values;
    }

    private String quote(String value) {
        return "'" + value + "'";
    }

    private class ConfigBuilder {
        private final Configuration.Builder builder = TestHelper.defaultConfig();

        private ConfigBuilder() {
        }

        public ConfigBuilder with(Field field, String value) {
            this.builder.with(field, value);
            return this;
        }

        public OracleConnectorConfig build() {
            return new OracleConnectorConfig(this.builder.build());
        }
    }
}

