/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.converters.NumberOneToBooleanConverter;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.transforms.outbox.AbstractEventRouterTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Schema;
import org.junit.After;
import org.junit.Before;

public class OutboxEventRouterIT
extends AbstractEventRouterTest<OracleConnector> {
    private static final String SETUP_OUTBOX_TABLE = "CREATE TABLE debezium.outbox (id varchar2(64) not null primary key, aggregatetype varchar2(255) not null, aggregateid varchar2(255) not null, type varchar2(255) not null, payload varchar2(4000))";
    private OracleConnection connection;

    @Before
    public void beforeEach() throws Exception {
        this.connection = TestHelper.testConnection();
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        super.beforeEach();
    }

    @After
    public void afterEach() throws Exception {
        super.afterEach();
        if (this.connection != null && this.connection.isConnected()) {
            TestHelper.dropTable(this.connection, this.tableName());
            this.connection.close();
        }
    }

    protected Class<OracleConnector> getConnectorClass() {
        return OracleConnector.class;
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected Configuration.Builder getConfigurationBuilder(boolean initialSnapshot) {
        OracleConnectorConfig.SnapshotMode snapshotMode = initialSnapshot ? OracleConnectorConfig.SnapshotMode.INITIAL : OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY;
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SNAPSHOT_MODE, snapshotMode.getValue())).with(OracleConnectorConfig.CUSTOM_CONVERTERS, "boolean")).with("boolean.type", NumberOneToBooleanConverter.class.getName()).with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.OUTBOX");
    }

    protected String getSchemaNamePrefix() {
        return "server1.DEBEZIUM.OUTBOX.";
    }

    protected Schema getPayloadSchema() {
        return Schema.OPTIONAL_STRING_SCHEMA;
    }

    protected String tableName() {
        return "debezium.outbox";
    }

    protected String topicName() {
        return "server1.DEBEZIUM.OUTBOX";
    }

    protected void createTable() throws Exception {
        TestHelper.dropTable(this.connection, this.tableName());
        this.connection.execute(new String[]{SETUP_OUTBOX_TABLE});
        TestHelper.streamTable(this.connection, this.tableName());
    }

    protected String createInsert(String eventId, String eventType, String aggregateType, String aggregateId, String payloadJson, String additional) {
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO debezium.outbox VALUES (");
        insert.append("'").append(eventId).append("', ");
        insert.append("'").append(aggregateType).append("', ");
        insert.append("'").append(aggregateId).append("', ");
        insert.append("'").append(eventType).append("', ");
        if (payloadJson != null) {
            insert.append("'").append(payloadJson).append("'");
        } else {
            insert.append("NULL");
        }
        if (additional != null) {
            insert.append(additional);
        }
        insert.append(")");
        return insert.toString();
    }

    protected void waitForSnapshotCompleted() throws InterruptedException {
        OutboxEventRouterIT.waitForSnapshotToBeCompleted((String)"oracle", (String)"server1");
    }

    protected void waitForStreamingStarted() throws InterruptedException {
        OutboxEventRouterIT.waitForStreamingRunning((String)"oracle", (String)"server1");
    }

    protected void alterTableWithExtra4Fields() throws Exception {
        this.connection.execute(new String[]{"ALTER TABLE debezium.outbox add version numeric(9,0) not null"});
        this.connection.execute(new String[]{"ALTER TABLE debezium.outbox add somebooltype numeric(1,0) not null"});
        this.connection.execute(new String[]{"ALTER TABLE debezium.outbox add createdat timestamp not null"});
        this.connection.execute(new String[]{"ALTER TABLE debezium.outbox add is_deleted numeric(1,0) default 0"});
    }

    protected void alterTableWithTimestampField() throws Exception {
        this.connection.execute(new String[]{"ALTER TABLE debezium.outbox add createdat timestamp not null"});
    }

    protected void alterTableModifyPayload() throws Exception {
        this.connection.execute(new String[]{"ALTER TABLE debezium.outbox modify (payload varchar2(1000))"});
    }

    protected String getAdditionalFieldValues(boolean deleted) {
        return ", 1, 1, TO_TIMESTAMP('2019-03-24 20:52:59', 'YYYY-MM-DD HH24:MI:SS'), " + (deleted ? "1" : "0");
    }

    protected String getAdditionalFieldValuesTimestampOnly() {
        return ", TO_TIMESTAMP('2019-03-24 20:52:59', 'YYYY-MM-DD HH24:MI:SS')";
    }

    protected String getFieldEventType() {
        return super.getFieldEventType().toUpperCase();
    }

    protected String getFieldSchemaVersion() {
        return super.getFieldSchemaVersion().toUpperCase();
    }

    protected String getFieldEventTimestamp() {
        return super.getFieldEventTimestamp().toUpperCase();
    }

    protected String getFieldAggregateType() {
        return super.getFieldAggregateType().toUpperCase();
    }

    protected String getSomeBoolType() {
        return super.getSomeBoolType().toUpperCase();
    }

    protected String getIsDeleted() {
        return super.getIsDeleted().toUpperCase();
    }
}

