/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.SchemaAndValueField;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class OracleNumberNegativeScaleIT
extends AbstractConnectorTest {
    private static final String PRECISION_PARAMETER_KEY = "connect.decimal.precision";
    private static final Schema NUMBER_SCHEMA = Decimal.builder((int)0).optional().parameter("connect.decimal.precision", "38").build();
    private static final String TEST_TABLE_DDL = "create table debezium.number_negative_scale (  id numeric(9,0) not null,   val_number_2_negative_scale number(1, -1),   val_number_4_negative_scale number(2, -2),   val_number_9_negative_scale number(8, -1),   val_number_18_negative_scale number(16, -2),   val_number_36_negative_scale number(36, -2),   primary key (id))";
    private static SchemaAndValueField[] expectedRecords = new SchemaAndValueField[]{new SchemaAndValueField("VAL_NUMBER_2_NEGATIVE_SCALE", Schema.OPTIONAL_INT8_SCHEMA, (Object)90), new SchemaAndValueField("VAL_NUMBER_4_NEGATIVE_SCALE", Schema.OPTIONAL_INT16_SCHEMA, (Object)9900), new SchemaAndValueField("VAL_NUMBER_9_NEGATIVE_SCALE", Schema.OPTIONAL_INT32_SCHEMA, (Object)999999990), new SchemaAndValueField("VAL_NUMBER_18_NEGATIVE_SCALE", Schema.OPTIONAL_INT64_SCHEMA, (Object)999999999999999900L), new SchemaAndValueField("VAL_NUMBER_36_NEGATIVE_SCALE", Decimal.builder((int)0).optional().parameter("connect.decimal.precision", "36").build(), (Object)new BigDecimal(new BigInteger("99999999999999999999999999999999999900"), 0))};
    private OracleConnection connection;

    @Before
    public void before() throws Exception {
        this.connection = TestHelper.testConnection();
        TestHelper.dropTable(this.connection, "debezium.number_negative_scale");
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
        this.connection.execute(new String[]{TEST_TABLE_DDL});
        TestHelper.streamTable(this.connection, "debezium.number_negative_scale");
    }

    @After
    public void after() throws Exception {
        if (this.connection != null && this.connection.isConnected()) {
            TestHelper.dropTable(this.connection, "debezium.number_negative_scale");
            this.connection.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-5880"})
    public void testNegativeScaleWithPrecisionHandling() throws Exception {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "debezium.number_negative_scale")).with(OracleConnectorConfig.CUSTOM_CONVERTERS, "zero_scale")).with("zero_scale.type", "io.debezium.connector.oracle.converters.NumberToZeroScaleConverter").build();
        this.insertAndStreamNegativeScaleNumbers(config);
    }

    @Test
    @FixFor(value={"DBZ-5880"})
    public void testNegativeScaleWithStringHandling() throws Exception {
        OracleNumberNegativeScaleIT.expectedRecords[4] = new SchemaAndValueField("VAL_NUMBER_36_NEGATIVE_SCALE", SchemaBuilder.string().optional().build(), (Object)"99999999999999999999999999999999999900");
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "debezium.number_negative_scale")).with(OracleConnectorConfig.CUSTOM_CONVERTERS, "zero_scale")).with("zero_scale.type", "io.debezium.connector.oracle.converters.NumberToZeroScaleConverter").with("zero_scale.decimal.mode", "string").build();
        this.insertAndStreamNegativeScaleNumbers(config);
    }

    @Test
    @FixFor(value={"DBZ-5880"})
    public void testNegativeScaleWithDoubleHandling() throws Exception {
        OracleNumberNegativeScaleIT.expectedRecords[4] = new SchemaAndValueField("VAL_NUMBER_36_NEGATIVE_SCALE", SchemaBuilder.float64().optional().build(), (Object)1.0E38);
        Configuration config = ((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "debezium.number_negative_scale")).with(OracleConnectorConfig.CUSTOM_CONVERTERS, "zero_scale")).with("zero_scale.type", "io.debezium.connector.oracle.converters.NumberToZeroScaleConverter").with("zero_scale.decimal.mode", "double").build();
        this.insertAndStreamNegativeScaleNumbers(config);
    }

    protected void insertAndStreamNegativeScaleNumbers(Configuration config) throws Exception {
        this.insertIntTypes();
        this.initializeConnectorTestFramework();
        this.start(OracleConnector.class, config);
        this.assertConnectorIsRunning();
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        List testTableRecords = records.recordsForTopic("server1.DEBEZIUM.NUMBER_NEGATIVE_SCALE");
        Assertions.assertThat((List)testTableRecords).hasSize(1);
        SourceRecord record = (SourceRecord)testTableRecords.get(0);
        VerifyRecord.isValid((SourceRecord)record);
        VerifyRecord.isValidRead((SourceRecord)record, (String)"ID", (int)1);
        Struct after = (Struct)((Struct)record.value()).get("after");
        Arrays.asList(expectedRecords).forEach(schemaAndValueField -> schemaAndValueField.assertFor(after));
        this.stopConnector();
    }

    protected void insertIntTypes() throws SQLException {
        this.connection.execute(new String[]{"INSERT INTO debezium.number_negative_scale VALUES (1, 94, 9949, 999999994, 999999999999999949, 99999999999999999999999999999999999949)"});
        this.connection.execute(new String[]{"COMMIT"});
    }
}

