/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.oracle.AbstractOracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogMinerStreamingChangeEventSourceMetricsMXBean;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.util.LRUCacheMap;
import io.debezium.util.Strings;
import java.math.BigInteger;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LogMinerStreamingChangeEventSourceMetrics
extends AbstractOracleStreamingChangeEventSourceMetrics
implements LogMinerStreamingChangeEventSourceMetricsMXBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerStreamingChangeEventSourceMetrics.class);
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final int TRANSACTION_ID_SET_SIZE = 10;
    private final OracleConnectorConfig connectorConfig;
    private final Instant startTime;
    private final Clock clock;
    private final AtomicReference<Scn> currentScn = new AtomicReference<Scn>(Scn.NULL);
    private final AtomicReference<Scn> offsetScn = new AtomicReference<Scn>(Scn.NULL);
    private final AtomicReference<Scn> commitScn = new AtomicReference<Scn>(Scn.NULL);
    private final AtomicReference<Scn> oldestScn = new AtomicReference<Scn>(Scn.NULL);
    private final AtomicReference<Instant> oldestScnTime = new AtomicReference();
    private final AtomicReference<String[]> currentLogFileNames = new AtomicReference<String[]>(new String[0]);
    private final AtomicReference<String[]> redoLogStatuses = new AtomicReference<String[]>(new String[0]);
    private final AtomicReference<ZoneOffset> databaseZoneOffset = new AtomicReference<ZoneOffset>(ZoneOffset.UTC);
    private final AtomicInteger batchSize = new AtomicInteger();
    private final AtomicInteger logSwitchCount = new AtomicInteger();
    private final AtomicInteger logMinerQueryCount = new AtomicInteger();
    private final AtomicLong sleepTime = new AtomicLong();
    private final AtomicLong minimumLogsMined = new AtomicLong();
    private final AtomicLong maximumLogsMined = new AtomicLong();
    private final AtomicLong maxBatchProcessingThroughput = new AtomicLong();
    private final AtomicLong timeDifference = new AtomicLong();
    private final AtomicLong processedRowsCount = new AtomicLong();
    private final AtomicLong activeTransactionCount = new AtomicLong();
    private final AtomicLong rolledBackTransactionCount = new AtomicLong();
    private final AtomicLong oversizedTransactionCount = new AtomicLong();
    private final AtomicLong changesCount = new AtomicLong();
    private final AtomicLong scnFreezeCount = new AtomicLong();
    private final DurationHistogramMetric batchProcessingDuration = new DurationHistogramMetric();
    private final DurationHistogramMetric fetchQueryDuration = new DurationHistogramMetric();
    private final DurationHistogramMetric commitDuration = new DurationHistogramMetric();
    private final DurationHistogramMetric lagFromSourceDuration = new DurationHistogramMetric();
    private final DurationHistogramMetric miningSessionStartupDuration = new DurationHistogramMetric();
    private final DurationHistogramMetric parseTimeDuration = new DurationHistogramMetric();
    private final DurationHistogramMetric resultSetNextDuration = new DurationHistogramMetric();
    private final MaxLongValueMetric userGlobalAreaMemory = new MaxLongValueMetric();
    private final MaxLongValueMetric processGlobalAreaMemory = new MaxLongValueMetric();
    private final LRUSet<String> abandonedTransactionIds = new LRUSet(10);
    private final LRUSet<String> rolledBackTransactionIds = new LRUSet(10);

    public LogMinerStreamingChangeEventSourceMetrics(CdcSourceTaskContext taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider, OracleConnectorConfig connectorConfig) {
        this(taskContext, changeEventQueueMetrics, metadataProvider, connectorConfig, Clock.systemUTC());
    }

    public LogMinerStreamingChangeEventSourceMetrics(CdcSourceTaskContext taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider, OracleConnectorConfig connectorConfig, Clock clock) {
        super(taskContext, changeEventQueueMetrics, metadataProvider);
        this.connectorConfig = connectorConfig;
        this.batchSize.set(connectorConfig.getLogMiningBatchSizeDefault());
        this.sleepTime.set(connectorConfig.getLogMiningSleepTimeDefault().toMillis());
        this.clock = clock;
        this.startTime = clock.instant();
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.changesCount.set(0L);
        this.processedRowsCount.set(0L);
        this.logMinerQueryCount.set(0);
        this.activeTransactionCount.set(0L);
        this.rolledBackTransactionCount.set(0L);
        this.oversizedTransactionCount.set(0L);
        this.scnFreezeCount.set(0L);
        this.fetchQueryDuration.reset();
        this.batchProcessingDuration.reset();
        this.parseTimeDuration.reset();
        this.miningSessionStartupDuration.reset();
        this.userGlobalAreaMemory.reset();
        this.processGlobalAreaMemory.reset();
        this.lagFromSourceDuration.reset();
        this.commitDuration.reset();
        this.abandonedTransactionIds.reset();
        this.rolledBackTransactionIds.reset();
        this.oldestScnTime.set(null);
    }

    @Override
    public long getMillisecondsToKeepTransactionsInBuffer() {
        return this.connectorConfig.getLogMiningTransactionRetention().toMillis();
    }

    @Override
    public long getSleepTimeInMilliseconds() {
        return this.sleepTime.get();
    }

    @Override
    public BigInteger getCurrentScn() {
        return this.currentScn.get().asBigInteger();
    }

    @Override
    public BigInteger getOffsetScn() {
        return this.offsetScn.get().asBigInteger();
    }

    @Override
    public BigInteger getCommittedScn() {
        return this.commitScn.get().asBigInteger();
    }

    @Override
    public BigInteger getOldestScn() {
        return this.oldestScn.get().asBigInteger();
    }

    @Override
    public long getOldestScnAgeInMilliseconds() {
        if (Objects.isNull(this.oldestScnTime.get())) {
            return 0L;
        }
        return Duration.between(Instant.now(), this.oldestScnTime.get()).toMillis();
    }

    @Override
    public String[] getCurrentLogFileNames() {
        return this.currentLogFileNames.get();
    }

    @Override
    public int getBatchSize() {
        return this.batchSize.get();
    }

    @Override
    public long getMinimumMinedLogCount() {
        return this.minimumLogsMined.get();
    }

    @Override
    public long getMaximumMinedLogCount() {
        return this.maximumLogsMined.get();
    }

    @Override
    public String[] getRedoLogStatuses() {
        return this.redoLogStatuses.get();
    }

    @Override
    public int getLogSwitchCount() {
        return this.logSwitchCount.get();
    }

    @Override
    public long getTotalProcessedRows() {
        return this.processedRowsCount.get();
    }

    @Override
    public long getNumberOfActiveTransactions() {
        return this.activeTransactionCount.get();
    }

    @Override
    public long getNumberOfRolledBackTransactions() {
        return this.rolledBackTransactionCount.get();
    }

    @Override
    public long getNumberOfOversizedTransactions() {
        return this.oversizedTransactionCount.get();
    }

    @Override
    public long getTotalChangesCount() {
        return this.changesCount.get();
    }

    @Override
    public long getFetchQueryCount() {
        return this.logMinerQueryCount.get();
    }

    @Override
    public long getScnFreezeCount() {
        return this.scnFreezeCount.get();
    }

    @Override
    public long getLastDurationOfFetchQueryInMilliseconds() {
        return this.fetchQueryDuration.getLast().toMillis();
    }

    @Override
    public long getMaxDurationOfFetchQueryInMilliseconds() {
        return this.fetchQueryDuration.getMaximum().toMillis();
    }

    @Override
    public long getLastBatchProcessingTimeInMilliseconds() {
        return this.batchProcessingDuration.getLast().toMillis();
    }

    @Override
    public long getMinBatchProcessingTimeInMilliseconds() {
        return this.batchProcessingDuration.getMinimum().toMillis();
    }

    @Override
    public long getMaxBatchProcessingTimeInMilliseconds() {
        return this.batchProcessingDuration.getMaximum().toMillis();
    }

    @Override
    public long getTotalBatchProcessingTimeInMilliseconds() {
        return this.batchProcessingDuration.getTotal().toMillis();
    }

    @Override
    public long getCommitThroughput() {
        long timeSpent = Duration.between(this.startTime, this.clock.instant()).toMillis();
        return this.getNumberOfCommittedTransactions() * 1000L / (timeSpent != 0L ? timeSpent : 1L);
    }

    @Override
    public long getLastBatchProcessingThroughput() {
        Duration lastBatchProcessingDuration = this.batchProcessingDuration.getLast();
        if (lastBatchProcessingDuration.isZero()) {
            return 0L;
        }
        return Math.round((float)this.getLastCapturedDmlCount() / (float)lastBatchProcessingDuration.toMillis() * 1000.0f);
    }

    @Override
    public long getMaxBatchProcessingThroughput() {
        return this.maxBatchProcessingThroughput.get();
    }

    @Override
    public long getAverageBatchProcessingThroughput() {
        Duration totalBatchProcessingDuration = this.batchProcessingDuration.getTotal();
        if (totalBatchProcessingDuration.isZero()) {
            return 0L;
        }
        return Math.round((float)this.getTotalCapturedDmlCount() / (float)totalBatchProcessingDuration.toMillis() * 1000.0f);
    }

    @Override
    public long getLastCommitDurationInMilliseconds() {
        return this.commitDuration.getLast().toMillis();
    }

    @Override
    public long getMaxCommitDurationInMilliseconds() {
        return this.commitDuration.getMaximum().toMillis();
    }

    @Override
    public long getLastMiningSessionStartTimeInMilliseconds() {
        return this.miningSessionStartupDuration.getLast().toMillis();
    }

    @Override
    public long getMaxMiningSessionStartTimeInMilliseconds() {
        return this.miningSessionStartupDuration.getMaximum().toMillis();
    }

    @Override
    public long getTotalMiningSessionStartTimeInMilliseconds() {
        return this.miningSessionStartupDuration.getTotal().toMillis();
    }

    @Override
    public long getTotalParseTimeInMilliseconds() {
        return this.parseTimeDuration.getTotal().toMillis();
    }

    @Override
    public long getTotalResultSetNextTimeInMilliseconds() {
        return this.resultSetNextDuration.getTotal().toMillis();
    }

    @Override
    public long getLagFromSourceInMilliseconds() {
        return this.lagFromSourceDuration.getLast().toMillis();
    }

    @Override
    public long getMinLagFromSourceInMilliseconds() {
        return this.lagFromSourceDuration.getMinimum().toMillis();
    }

    @Override
    public long getMaxLagFromSourceInMilliseconds() {
        return this.lagFromSourceDuration.getMaximum().toMillis();
    }

    @Override
    public long getMiningSessionUserGlobalAreaMemoryInBytes() {
        return this.userGlobalAreaMemory.getValue();
    }

    @Override
    public long getMiningSessionUserGlobalAreaMaxMemoryInBytes() {
        return this.userGlobalAreaMemory.getMax();
    }

    @Override
    public long getMiningSessionProcessGlobalAreaMemoryInBytes() {
        return this.processGlobalAreaMemory.getValue();
    }

    @Override
    public long getMiningSessionProcessGlobalAreaMaxMemoryInBytes() {
        return this.processGlobalAreaMemory.getMax();
    }

    @Override
    public Set<String> getAbandonedTransactionIds() {
        return this.abandonedTransactionIds.getAll();
    }

    @Override
    public Set<String> getRolledBackTransactionIds() {
        return this.rolledBackTransactionIds.getAll();
    }

    public ZoneOffset getDatabaseOffset() {
        return this.databaseZoneOffset.get();
    }

    public void setBatchSize(int batchSize) {
        this.batchSize.set(batchSize);
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime.set(sleepTime);
    }

    public void setCurrentScn(Scn currentScn) {
        this.currentScn.set(currentScn);
    }

    public void setOffsetScn(Scn offsetScn) {
        this.offsetScn.set(offsetScn);
    }

    public void setCommitScn(Scn commitScn) {
        this.commitScn.set(commitScn);
    }

    public void setOldestScnDetails(Scn oldestScn, Instant changeTime) {
        this.oldestScn.set(oldestScn);
        this.oldestScnTime.set(changeTime);
    }

    public void setCurrentLogFileNames(Set<String> logFileNames) {
        this.currentLogFileNames.set((String[])logFileNames.toArray(String[]::new));
        if ((long)logFileNames.size() < this.minimumLogsMined.get()) {
            this.minimumLogsMined.set(logFileNames.size());
        } else if (this.minimumLogsMined.get() == 0L) {
            this.minimumLogsMined.set(logFileNames.size());
        }
        if ((long)logFileNames.size() > this.maximumLogsMined.get()) {
            this.maximumLogsMined.set(logFileNames.size());
        }
    }

    public void setRedoLogStatuses(Map<String, String> statuses) {
        this.redoLogStatuses.set((String[])statuses.entrySet().stream().map(entry -> (String)entry.getKey() + " | " + (String)entry.getValue()).toArray(String[]::new));
    }

    public void setSwitchCount(int logSwitchCount) {
        this.logSwitchCount.set(logSwitchCount);
    }

    public void setLastProcessedRowsCount(long processedRowsCount) {
        this.processedRowsCount.getAndAdd(processedRowsCount);
    }

    public void setActiveTransactionCount(long activeTransactionCount) {
        this.activeTransactionCount.set(activeTransactionCount);
    }

    public void incrementRolledBackTransactionCount() {
        this.rolledBackTransactionCount.incrementAndGet();
    }

    public void incrementOversizedTransactionCount() {
        this.oversizedTransactionCount.incrementAndGet();
    }

    public void incrementTotalChangesCount() {
        this.changesCount.incrementAndGet();
    }

    public void incrementLogMinerQueryCount() {
        this.logMinerQueryCount.incrementAndGet();
    }

    public void incrementScnFreezeCount() {
        this.scnFreezeCount.incrementAndGet();
    }

    public void setScnFreezeCount(long scnFreezeCount) {
        this.scnFreezeCount.set(scnFreezeCount);
    }

    public void setLastDurationOfFetchQuery(Duration duration) {
        this.fetchQueryDuration.set(duration);
        this.logMinerQueryCount.incrementAndGet();
    }

    public void setLastBatchProcessingDuration(Duration duration) {
        this.batchProcessingDuration.set(duration);
        if (this.getLastBatchProcessingThroughput() > this.getMaxBatchProcessingThroughput()) {
            this.maxBatchProcessingThroughput.set(this.getLastBatchProcessingThroughput());
        }
    }

    public void setLastCommitDuration(Duration duration) {
        this.commitDuration.set(duration);
    }

    public void setLastMiningSessionStartDuration(Duration duration) {
        this.miningSessionStartupDuration.set(duration);
    }

    public void setLastParseTimeDuration(Duration duration) {
        this.parseTimeDuration.set(duration);
    }

    public void setLastResultSetNextDuration(Duration duration) {
        this.resultSetNextDuration.set(duration);
    }

    public void setUserGlobalAreaMemory(long memory, long maxMemory) {
        this.userGlobalAreaMemory.setValue(memory);
        this.userGlobalAreaMemory.setMax(maxMemory);
    }

    public void setProcessGlobalAreaMemory(long memory, long maxMemory) {
        this.processGlobalAreaMemory.setValue(memory);
        this.processGlobalAreaMemory.setMax(maxMemory);
    }

    public void addAbandonedTransactionId(String transactionId) {
        if (!Strings.isNullOrBlank((String)transactionId)) {
            this.abandonedTransactionIds.add(transactionId);
        }
    }

    public void addRolledBackTransactionId(String transactionId) {
        if (!Strings.isNullOrBlank((String)transactionId)) {
            this.rolledBackTransactionIds.add(transactionId);
        }
    }

    public void setDatabaseTimeDifference(OffsetDateTime databaseSystemTime) {
        this.databaseZoneOffset.set(databaseSystemTime.getOffset());
        LOGGER.trace("Timezone offset of database time is {} seconds.", (Object)this.databaseZoneOffset.get().getTotalSeconds());
        Instant now = this.clock.instant();
        long timeDifferenceInMilliseconds = Duration.between(databaseSystemTime.toInstant(), now).toMillis();
        this.timeDifference.set(timeDifferenceInMilliseconds);
        LOGGER.trace("Current time {} ms, database difference {} ms", (Object)now.toEpochMilli(), (Object)timeDifferenceInMilliseconds);
    }

    public void calculateLagFromSource(Instant changeTime) {
        if (changeTime != null) {
            Instant adjustedTime = changeTime.plusMillis(this.timeDifference.longValue()).minusSeconds(this.databaseZoneOffset.get().getTotalSeconds());
            this.lagFromSourceDuration.set(Duration.between(adjustedTime, this.clock.instant()).abs());
        }
    }

    public String toString() {
        return "LogMinerStreamingChangeEventSourceMetrics{connectorConfig=" + this.connectorConfig + ", startTime=" + this.startTime + ", clock=" + this.clock + ", currentScn=" + this.currentScn + ", offsetScn=" + this.offsetScn + ", commitScn=" + this.commitScn + ", oldestScn=" + this.oldestScn + ", oldestScnTime=" + this.oldestScnTime + ", currentLogFileNames=" + this.currentLogFileNames + ", redoLogStatuses=" + this.redoLogStatuses + ", databaseZoneOffset=" + this.databaseZoneOffset + ", batchSize=" + this.batchSize + ", logSwitchCount=" + this.logSwitchCount + ", logMinerQueryCount=" + this.logMinerQueryCount + ", sleepTime=" + this.sleepTime + ", minimumLogsMined=" + this.minimumLogsMined + ", maximumLogsMined=" + this.maximumLogsMined + ", maxBatchProcessingThroughput=" + this.maxBatchProcessingThroughput + ", timeDifference=" + this.timeDifference + ", processedRowsCount=" + this.processedRowsCount + ", activeTransactionCount=" + this.activeTransactionCount + ", rolledBackTransactionCount=" + this.rolledBackTransactionCount + ", oversizedTransactionCount=" + this.oversizedTransactionCount + ", changesCount=" + this.changesCount + ", scnFreezeCount=" + this.scnFreezeCount + ", batchProcessingDuration=" + this.batchProcessingDuration + ", fetchQueryDuration=" + this.fetchQueryDuration + ", commitDuration=" + this.commitDuration + ", lagFromSourceDuration=" + this.lagFromSourceDuration + ", miningSessionStartupDuration=" + this.miningSessionStartupDuration + ", parseTimeDuration=" + this.parseTimeDuration + ", resultSetNextDuration=" + this.resultSetNextDuration + ", userGlobalAreaMemory=" + this.userGlobalAreaMemory + ", processGlobalAreaMemory=" + this.processGlobalAreaMemory + ", abandonedTransactionIds=" + this.abandonedTransactionIds + ", rolledBackTransactionIds=" + this.rolledBackTransactionIds + "} " + super.toString();
    }

    @ThreadSafe
    static class DurationHistogramMetric {
        private final AtomicReference<Duration> min = new AtomicReference<Duration>(Duration.ZERO);
        private final AtomicReference<Duration> max = new AtomicReference<Duration>(Duration.ZERO);
        private final AtomicReference<Duration> last = new AtomicReference<Duration>(Duration.ZERO);
        private final AtomicReference<Duration> total = new AtomicReference<Duration>(Duration.ZERO);

        DurationHistogramMetric() {
        }

        void reset() {
            this.min.set(Duration.ZERO);
            this.max.set(Duration.ZERO);
            this.last.set(Duration.ZERO);
            this.total.set(Duration.ZERO);
        }

        void set(Duration lastDuration) {
            long minimumValue;
            this.last.set(lastDuration);
            this.total.accumulateAndGet(lastDuration, Duration::plus);
            if (this.max.get().toMillis() < lastDuration.toMillis()) {
                this.max.set(lastDuration);
            }
            if ((minimumValue = this.min.get().toMillis()) > lastDuration.toMillis()) {
                this.min.set(lastDuration);
            } else if (minimumValue == 0L) {
                this.min.set(lastDuration);
            }
        }

        Duration getMinimum() {
            return this.min.get();
        }

        Duration getMaximum() {
            return this.max.get();
        }

        Duration getLast() {
            return this.last.get();
        }

        Duration getTotal() {
            return this.total.get();
        }
    }

    @ThreadSafe
    static class MaxLongValueMetric {
        private final AtomicLong value = new AtomicLong();
        private final AtomicLong max = new AtomicLong();

        MaxLongValueMetric() {
        }

        public void reset() {
            this.value.set(0L);
            this.max.set(0L);
        }

        public void setValueAndCalculateMax(long value) {
            this.value.set(value);
            if (this.max.get() < value) {
                this.max.set(value);
            }
        }

        public void setValue(long value) {
            this.value.set(value);
        }

        public void setMax(long max) {
            if (this.max.get() < max) {
                this.max.set(max);
            }
        }

        public long getValue() {
            return this.value.get();
        }

        public long getMax() {
            return this.max.get();
        }
    }

    @ThreadSafe
    static class LRUSet<T> {
        private final AtomicReference<LRUCacheMap<T, T>> cache = new AtomicReference();
        private final int capacity;

        LRUSet(int capacity) {
            this.cache.set(new LRUCacheMap(capacity));
            this.capacity = capacity;
        }

        public void reset() {
            this.cache.set(new LRUCacheMap(this.capacity));
        }

        public void add(T value) {
            this.cache.get().put(value, value);
        }

        public Set<T> getAll() {
            return this.cache.get().keySet();
        }
    }
}

