/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.query;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.QueryOperation;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Closeables;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.remote.client.impl.BaseQueryResponse;

public final class RemoteQuery<T>
extends BaseQuery<T> {
    private static final Log log = LogFactory.getLog(RemoteQuery.class);
    private final InternalRemoteCache<?, ?> cache;
    private final SerializationContext serializationContext;

    RemoteQuery(QueryFactory queryFactory, InternalRemoteCache<?, ?> cache, SerializationContext serializationContext, String queryString) {
        super(queryFactory, queryString);
        this.cache = cache;
        this.serializationContext = serializationContext;
    }

    RemoteQuery(QueryFactory queryFactory, InternalRemoteCache<?, ?> cache, SerializationContext serializationContext, String queryString, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults, boolean local) {
        super(queryFactory, queryString, namedParameters, projection, startOffset, maxResults, local);
        this.cache = cache;
        this.serializationContext = serializationContext;
    }

    public void resetQuery() {
    }

    public List<T> list() {
        BaseQueryResponse<T> response = this.executeRemotely(false);
        try {
            return response.extractResults(this.serializationContext);
        }
        catch (IOException e) {
            throw new HotRodClientException(e);
        }
    }

    public QueryResult<T> execute() {
        final BaseQueryResponse<T> response = this.executeRemotely(true);
        return new QueryResult<T>(){

            public OptionalLong hitCount() {
                long totalResults = response.getTotalResults();
                return totalResults == -1L ? OptionalLong.empty() : OptionalLong.of(totalResults);
            }

            public List<T> list() {
                try {
                    return response.extractResults(RemoteQuery.this.serializationContext);
                }
                catch (IOException e) {
                    throw new HotRodClientException(e);
                }
            }
        };
    }

    public int executeStatement() {
        BaseQueryResponse<T> response = this.executeRemotely(false);
        return (int)response.getTotalResults();
    }

    public CloseableIterator<T> iterator() {
        if (this.maxResults == -1 && this.startOffset == 0) {
            log.warnPerfRemoteIterationWithoutPagination(this.queryString);
        }
        return Closeables.iterator(this.list().iterator());
    }

    public int getResultSize() {
        BaseQueryResponse<T> response = this.executeRemotely(true);
        return (int)response.getTotalResults();
    }

    private BaseQueryResponse<T> executeRemotely(boolean withHitCount) {
        this.validateNamedParameters();
        QueryOperation op = this.cache.getOperationsFactory().newQueryOperation(this, this.cache.getDataFormat(), withHitCount);
        return (BaseQueryResponse)(this.timeout != -1L ? Util.await(op.execute(), TimeUnit.NANOSECONDS.toMillis(this.timeout)) : Util.await(op.execute()));
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public RemoteCache<?, ?> getCache() {
        return this.cache;
    }

    public String toString() {
        return "RemoteQuery{queryString=" + this.queryString + ", namedParameters=" + String.valueOf(this.namedParameters) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", timeout=" + this.timeout + "}";
    }
}

