/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;

public final class MarshallerRegistry {
    public static final Log log = LogFactory.getLog(MarshallerRegistry.class, Log.class);
    private final Map<MediaType, Marshaller> marshallerByMediaType = new ConcurrentHashMap<MediaType, Marshaller>();

    public void registerMarshaller(Marshaller marshaller) {
        this.marshallerByMediaType.put(marshaller.mediaType().withoutParameters(), marshaller);
    }

    public Marshaller getMarshaller(MediaType mediaType) {
        return this.marshallerByMediaType.get(mediaType);
    }

    public Marshaller getMarshaller(Class<? extends Marshaller> marshallerClass) {
        return this.marshallerByMediaType.values().stream().filter(m -> m.getClass().equals(marshallerClass)).findFirst().orElse(null);
    }
}

