/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import java.sql.SQLException;
import java.util.List;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class TransactionCommitConsumerIT
extends AbstractConnectorTest {
    @Rule
    public final TestRule skipAdapterRule = new SkipTestDependingOnAdapterNameRule();
    private static OracleConnection connection;

    @BeforeClass
    public static void beforeClass() throws SQLException {
        connection = TestHelper.testConnection();
        TestHelper.dropAllTables();
    }

    @AfterClass
    public static void afterClass() throws SQLException {
        if (connection != null) {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"DBZ-6963"})
    public void testShouldNotConsolidateEventsWhenTableHasNoLobColumns() throws Exception {
        try {
            connection.execute(new String[]{"CREATE TABLE addresses (ID numeric(9,0) primary key, person_id numeric(9,0))"});
            connection.execute(new String[]{"CREATE TABLE email (ID numeric(9,0) primary key, person_id numeric(9,0))"});
            connection.execute(new String[]{"CREATE TABLE phone (ID numeric(9,0) primary key, person_id numeric(9,0))"});
            connection.execute(new String[]{"INSERT INTO addresses values (-1,-1)"});
            connection.execute(new String[]{"INSERT INTO email values (-1,-1)"});
            connection.execute(new String[]{"INSERT INTO phone values (-1,-1)"});
            TestHelper.streamTable(connection, "addresses");
            TestHelper.streamTable(connection, "email");
            TestHelper.streamTable(connection, "phone");
            Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.ADDRESSES,DEBEZIUM\\.EMAIL,DEBEZIUM\\.PHONE")).with(OracleConnectorConfig.LOB_ENABLED, "true")).with(OracleConnectorConfig.SNAPSHOT_MODE, "schema_only")).build();
            this.start(OracleConnector.class, config);
            this.assertConnectorIsRunning();
            TransactionCommitConsumerIT.waitForStreamingRunning((String)"oracle", (String)"server1");
            connection.setAutoCommit(false);
            int ITERATIONS = 25;
            for (int i = 0; i < 25; ++i) {
                connection.executeWithoutCommitting(new String[]{"INSERT INTO addresses (ID,PERSON_ID) values (" + i + ",-1)"});
                connection.executeWithoutCommitting(new String[]{"UPDATE email SET person_id = " + i + " WHERE id = -1"});
                connection.executeWithoutCommitting(new String[]{"INSERT INTO email (ID,PERSON_ID) values (" + i + ",-1)"});
                connection.executeWithoutCommitting(new String[]{"UPDATE email SET person_id = " + (i + 999) + " WHERE id = " + i});
                connection.executeWithoutCommitting(new String[]{"UPDATE email SET person_id = " + (i + 1000) + " WHERE id = -1"});
                connection.executeWithoutCommitting(new String[]{"UPDATE phone SET person_id = " + i + " WHERE id = -1"});
                connection.executeWithoutCommitting(new String[]{"INSERT INTO phone (ID,PERSON_ID) values (" + i + ",-1)"});
                connection.executeWithoutCommitting(new String[]{"UPDATE phone SET person_id = " + i + " WHERE id = " + i});
                connection.executeWithoutCommitting(new String[]{"UPDATE phone SET person_id = -1 WHERE id = -1"});
                connection.executeWithoutCommitting(new String[]{"UPDATE addresses SET person_id = " + i + " WHERE id = -1"});
            }
            connection.commit();
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(250);
            List addresses = records.recordsForTopic("server1.DEBEZIUM.ADDRESSES");
            Assertions.assertThat((List)addresses).hasSize(50);
            int i = 0;
            int k = 0;
            while (i < addresses.size()) {
                VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)addresses.get(i)), (String)"ID", (int)k);
                VerifyRecord.isValidUpdate((SourceRecord)((SourceRecord)addresses.get(i + 1)), (String)"ID", (int)-1);
                i += 2;
                ++k;
            }
            List phones = records.recordsForTopic("server1.DEBEZIUM.PHONE");
            Assertions.assertThat((List)phones).hasSize(100);
            int i2 = 0;
            int k2 = 0;
            while (i2 < phones.size()) {
                VerifyRecord.isValidUpdate((SourceRecord)((SourceRecord)phones.get(i2)), (String)"ID", (int)-1);
                VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)phones.get(i2 + 1)), (String)"ID", (int)k2);
                VerifyRecord.isValidUpdate((SourceRecord)((SourceRecord)phones.get(i2 + 2)), (String)"ID", (int)k2);
                VerifyRecord.isValidUpdate((SourceRecord)((SourceRecord)phones.get(i2 + 3)), (String)"ID", (int)-1);
                i2 += 4;
                ++k2;
            }
            List emails = records.recordsForTopic("server1.DEBEZIUM.EMAIL");
            Assertions.assertThat((List)emails).hasSize(100);
            int i3 = 0;
            int k3 = 0;
            while (i3 < emails.size()) {
                VerifyRecord.isValidUpdate((SourceRecord)((SourceRecord)emails.get(i3)), (String)"ID", (int)-1);
                VerifyRecord.isValidInsert((SourceRecord)((SourceRecord)emails.get(i3 + 1)), (String)"ID", (int)k3);
                VerifyRecord.isValidUpdate((SourceRecord)((SourceRecord)emails.get(i3 + 2)), (String)"ID", (int)k3);
                VerifyRecord.isValidUpdate((SourceRecord)((SourceRecord)emails.get(i3 + 3)), (String)"ID", (int)-1);
                i3 += 4;
                ++k3;
            }
            this.assertNoRecordsToConsume();
        }
        finally {
            TestHelper.dropTable(connection, "phone");
            TestHelper.dropTable(connection, "email");
            TestHelper.dropTable(connection, "addresses");
        }
    }
}

