/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.processors.reselect;

import io.debezium.bean.StandardBeanNames;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.common.annotation.Incubating;
import io.debezium.config.Configuration;
import io.debezium.data.Envelope;
import io.debezium.function.Predicates;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.processors.spi.PostProcessor;
import io.debezium.relational.Column;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.util.Strings;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Incubating
public class ReselectColumnsPostProcessor
implements PostProcessor,
BeanRegistryAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReselectColumnsPostProcessor.class);
    private static final String RESELECT_COLUMNS_INCLUDE_LIST = "reselect.columns.include.list";
    private static final String RESELECT_COLUMNS_EXCLUDE_LIST = "reselect.columns.exclude.list";
    private static final String RESELECT_UNAVAILABLE_VALUES = "reselect.unavailable.values";
    private static final String RESELECT_NULL_VALUES = "reselect.null.values";
    private static final String RESELECT_USE_EVENT_KEY = "reselect.use.event.key";
    private Predicate<String> selector;
    private boolean reselectUnavailableValues;
    private boolean reselectNullValues;
    private boolean reselectUseEventKeyFields;
    private JdbcConnection jdbcConnection;
    private ValueConverterProvider valueConverterProvider;
    private String unavailableValuePlaceholder;
    private byte[] unavailableValuePlaceholderBytes;
    private RelationalDatabaseSchema schema;

    @Override
    public void configure(Map<String, ?> properties) {
        Configuration config = Configuration.from(properties);
        this.reselectUnavailableValues = config.getBoolean(RESELECT_UNAVAILABLE_VALUES, true);
        this.reselectNullValues = config.getBoolean(RESELECT_NULL_VALUES, true);
        this.reselectUseEventKeyFields = config.getBoolean(RESELECT_USE_EVENT_KEY, false);
        this.selector = new ReselectColumnsPredicateBuilder().includeColumns(config.getString(RESELECT_COLUMNS_INCLUDE_LIST)).excludeColumns(config.getString(RESELECT_COLUMNS_EXCLUDE_LIST)).build();
        if (!this.reselectNullValues && !this.reselectUnavailableValues) {
            LOGGER.warn("Reselect post-processor disables both null and unavailable columns, no-reselection will occur.");
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void apply(Object messageKey, Struct value) {
        Map<String, Object> selections;
        if (value == null) {
            LOGGER.debug("Value is not a Struct, no re-selection possible.");
            return;
        }
        if (!(messageKey instanceof Struct)) {
            LOGGER.debug("Key is not a Struct, no re-selection possible.");
            return;
        }
        Struct key = (Struct)messageKey;
        Struct after = value.getStruct("after");
        if (after == null) {
            LOGGER.debug("Value has no after field, no re-selection possible.");
            return;
        }
        String operation = value.getString("op");
        if (Envelope.Operation.READ.code().equals(operation)) {
            return;
        }
        Struct source = value.getStruct("source");
        if (source == null) {
            LOGGER.debug("Value has no source field, no re-selection possible.");
            return;
        }
        TableId tableId = this.getTableIdFromSource(source);
        if (tableId == null) {
            return;
        }
        Table table = this.schema.tableFor(tableId);
        if (table == null) {
            LOGGER.debug("Unable to locate table {} in relational model.", (Object)tableId);
            return;
        }
        List<String> requiredColumnSelections = this.getRequiredColumnSelections(tableId, after);
        if (requiredColumnSelections.isEmpty()) {
            LOGGER.debug("No columns require re-selection.");
            return;
        }
        ArrayList<String> keyColumns = new ArrayList<String>();
        ArrayList<Object> keyValues = new ArrayList<Object>();
        if (this.reselectUseEventKeyFields) {
            for (Field field : key.schema().fields()) {
                keyColumns.add(field.name());
                keyValues.add(key.get(field));
            }
        } else {
            for (Column column : table.primaryKeyColumns()) {
                keyColumns.add(column.name());
                keyValues.add(after.get(after.schema().field(column.name())));
            }
        }
        try {
            selections = this.jdbcConnection.reselectColumns(tableId, requiredColumnSelections, keyColumns, keyValues, source);
            if (selections.isEmpty()) {
                LOGGER.warn("Failed to find row in table {} with key {}.", (Object)tableId, (Object)key);
                return;
            }
        }
        catch (SQLException e) {
            LOGGER.warn("Failed to re-select row for table {} and key {}", new Object[]{tableId, key, e});
            return;
        }
        for (Map.Entry<String, Object> selection : selections.entrySet()) {
            String columnName = selection.getKey();
            Column column = table.columnWithName(columnName);
            Field field = after.schema().field(columnName);
            Object convertedValue = this.getConvertedValue(column, field, selection.getValue());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Replaced field {} value {} with {}", new Object[]{field.name(), value.get(field), convertedValue});
            }
            after.put(field.name(), convertedValue);
        }
    }

    @Override
    public void injectBeanRegistry(BeanRegistry beanRegistry) {
        RelationalDatabaseConnectorConfig connectorConfig = beanRegistry.lookupByName("ConnectorConfig", RelationalDatabaseConnectorConfig.class);
        this.unavailableValuePlaceholder = new String(connectorConfig.getUnavailableValuePlaceholder());
        this.unavailableValuePlaceholderBytes = connectorConfig.getUnavailableValuePlaceholder();
        this.valueConverterProvider = beanRegistry.lookupByName(StandardBeanNames.VALUE_CONVERTER, ValueConverterProvider.class);
        this.jdbcConnection = beanRegistry.lookupByName(StandardBeanNames.JDBC_CONNECTION, JdbcConnection.class);
        this.schema = beanRegistry.lookupByName("Schema", RelationalDatabaseSchema.class);
    }

    private List<String> getRequiredColumnSelections(TableId tableId, Struct after) {
        ArrayList<String> columnSelections = new ArrayList<String>();
        for (Field field : after.schema().fields()) {
            String fullyQualifiedName;
            Object value = after.get(field);
            if (this.reselectUnavailableValues && this.isUnavailableValueHolder(field, value)) {
                fullyQualifiedName = this.jdbcConnection.getQualifiedTableName(tableId) + ":" + field.name();
                if (!this.selector.test(fullyQualifiedName)) continue;
                LOGGER.debug("Adding column {} for table {} to re-select list due to unavailable value placeholder.", (Object)field.name(), (Object)tableId);
                columnSelections.add(field.name());
                continue;
            }
            if (!this.reselectNullValues || value != null || !this.selector.test(fullyQualifiedName = this.jdbcConnection.getQualifiedTableName(tableId) + ":" + field.name())) continue;
            LOGGER.debug("Adding empty column {} for table {} to re-select list.", (Object)field.name(), (Object)tableId);
            columnSelections.add(field.name());
        }
        return columnSelections;
    }

    private boolean isUnavailableValueHolder(Field field, Object value) {
        if (field.schema().type() == Schema.Type.BYTES && this.unavailableValuePlaceholderBytes != null) {
            return ByteBuffer.wrap(this.unavailableValuePlaceholderBytes).equals(value);
        }
        return this.unavailableValuePlaceholder != null && this.unavailableValuePlaceholder.equals(value);
    }

    private Object getConvertedValue(Column column, Field field, Object value) {
        ValueConverter converter = this.valueConverterProvider.converter(column, field);
        if (converter != null) {
            return converter.convert(value);
        }
        return value;
    }

    private TableId getTableIdFromSource(Struct source) {
        String databaseName = source.getString("db");
        if (Strings.isNullOrEmpty(databaseName)) {
            LOGGER.debug("Database name is not available, no re-selection possible.");
            return null;
        }
        String tableName = source.getString("table");
        if (Strings.isNullOrEmpty(tableName)) {
            LOGGER.debug("Table name is not available, no re-selection possible.");
            return null;
        }
        String schemaName = null;
        if (source.schema().field("schema") != null) {
            schemaName = source.getString("schema");
        }
        return this.jdbcConnection.createTableId(databaseName, schemaName, tableName);
    }

    private static class ReselectColumnsPredicateBuilder {
        private Predicate<String> reselectColumnInclusions;
        private Predicate<String> reselectColumnExclusions;

        private ReselectColumnsPredicateBuilder() {
        }

        public ReselectColumnsPredicateBuilder includeColumns(String columnNames) {
            if (columnNames == null || columnNames.trim().isEmpty()) {
                this.reselectColumnInclusions = null;
            }
            this.reselectColumnInclusions = Predicates.includes(columnNames, 2);
            return this;
        }

        public ReselectColumnsPredicateBuilder excludeColumns(String columnNames) {
            if (columnNames == null || columnNames.trim().isEmpty()) {
                this.reselectColumnExclusions = null;
            }
            this.reselectColumnExclusions = Predicates.excludes(columnNames, 2);
            return this;
        }

        public Predicate<String> build() {
            Predicate<String> filter = this.reselectColumnInclusions != null ? this.reselectColumnInclusions : this.reselectColumnExclusions;
            return filter != null ? filter : x -> true;
        }
    }
}

