/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.processor.Transaction;
import java.time.Instant;
import java.util.Objects;

public abstract class AbstractTransaction
implements Transaction {
    private static final String UNKNOWN = "UNKNOWN";
    private final String transactionId;
    private final Scn startScn;
    private final Instant changeTime;
    private final String userName;
    private final Integer redoThreadId;

    public AbstractTransaction(String transactionId, Scn startScn, Instant changeTime, String userName, Integer redoThreadId) {
        this.transactionId = transactionId;
        this.startScn = startScn;
        this.changeTime = changeTime;
        this.userName = !UNKNOWN.equalsIgnoreCase(userName) ? userName : null;
        this.redoThreadId = redoThreadId;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public Scn getStartScn() {
        return this.startScn;
    }

    @Override
    public Instant getChangeTime() {
        return this.changeTime;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public int getRedoThreadId() {
        return this.redoThreadId == null ? -1 : this.redoThreadId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractTransaction that = (AbstractTransaction)o;
        return Objects.equals(this.transactionId, that.transactionId);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId);
    }

    public String toString() {
        return "AbstractTransaction{transactionId='" + this.transactionId + "', startScn=" + this.startScn + ", changeTime=" + this.changeTime + ", userName='" + this.userName + "'}";
    }
}

