/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogFile;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import java.math.BigInteger;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class LogMinerHelperTest
extends AbstractConnectorTest {
    @Test
    public void testStandaloneLogStateWithOneThreadArchiveLogGap() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100L, 4, 1));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80L, 90L, 2, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isFalse();
    }

    @Test
    public void testStandaloneLogStateWithNoGaps() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100L, 4, 1));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80L, 90L, 2, 1));
        files.add(LogMinerHelperTest.createArchiveLog("archive0.log", 90L, 100L, 3, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    @Test
    public void testStandaloneLogStateWithJustOnlineLogs() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100L, 4, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    @Test
    public void testStandaloneLogStateWithMixOfArchiveAndRedoNoGaps() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100L, 4, 1));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80L, 90L, 3, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    @Test
    public void testRacLogStateWithOneThreadArchiveLogGap() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100L, 4, 1));
        files.add(LogMinerHelperTest.createRedoLog("redo2.log", 80L, 1, 2));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80L, 90L, 2, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isFalse();
    }

    @Test
    public void testRacLogStateWithNoGaps() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100L, 4, 1));
        files.add(LogMinerHelperTest.createRedoLog("redo2.log", 80L, 1, 2));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80L, 90L, 2, 1));
        files.add(LogMinerHelperTest.createArchiveLog("archive0.log", 90L, 100L, 3, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    @Test
    public void testRacLogStateWithJustOnlineLogs() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100L, 4, 1));
        files.add(LogMinerHelperTest.createRedoLog("redo2.log", 90L, 3, 2));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    @Test
    public void testRacLogStateWithMixOfArchiveAndRedoNoGaps() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100L, 4, 1));
        files.add(LogMinerHelperTest.createRedoLog("redo2.log", 90L, 3, 2));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80L, 90L, 3, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    @Test
    public void testRacLogStateWithMixOfArchiveAndRedoForBothThreadsNoGap() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100L, 4, 1));
        files.add(LogMinerHelperTest.createRedoLog("redo2.log", 90L, 3, 2));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80L, 90L, 3, 1));
        files.add(LogMinerHelperTest.createArchiveLog("archive2.log", 70L, 80L, 2, 2));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    @Test
    @FixFor(value={"DBZ-7158"})
    public void testOracleRacWithRealDataRedoThreadsWithIndependentSequenceRanges() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createArchiveLog("thread_3_seq_56768.164992.1152789389", 10403071210665L, 10403071900071L, 56768, 3));
        files.add(LogMinerHelperTest.createArchiveLog("thread_3_seq_56769.148871.1152791329", 10403071900071L, 10403072997229L, 56769, 3));
        files.add(LogMinerHelperTest.createRedoLog("group_303.8411.1106167689", 10403072997229L, 56770, 3));
        files.add(LogMinerHelperTest.createArchiveLog("thread_4_seq_62925.29497.1152789389", 10403069930249L, 10403071899909L, 62925, 4));
        files.add(LogMinerHelperTest.createRedoLog("group_401.8418.1106167699", 10403071899909L, 62926, 4));
        files.add(LogMinerHelperTest.createRedoLog("group_201.8400.1106167673", 10326919867728L, 10326919867733L, 78034, 2, false));
        files.add(LogMinerHelperTest.createRedoLog("group_202.8401.1106167675", 10326919867733L, 10326919910394L, 78035, 2, false));
        files.add(LogMinerHelperTest.createRedoLog("group_203.8402.1106167677", 10326919910394L, 10326919923665L, 78036, 2, false));
        files.add(LogMinerHelperTest.createRedoLog("group_101.8391.1106167659", 10326919867747L, 10326919867788L, 83112, 1, false));
        files.add(LogMinerHelperTest.createRedoLog("group_102.8392.1106167661", 10326919867788L, 10326919910390L, 83113, 1, false));
        files.add(LogMinerHelperTest.createRedoLog("group_103.8393.1106167663", 10326919910390L, 10326919923663L, 83114, 1, false));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((String)"10403071210665"))).isTrue();
    }

    private static LogFile createRedoLog(String name, long startScn, int sequence, int threadId) {
        return LogMinerHelperTest.createRedoLog(name, startScn, Long.MAX_VALUE, sequence, threadId);
    }

    private static LogFile createRedoLog(String name, long startScn, long endScn, int sequence, int threadId) {
        return LogMinerHelperTest.createRedoLog(name, startScn, endScn, sequence, threadId, true);
    }

    private static LogFile createRedoLog(String name, long startScn, long endScn, int sequence, int threadId, boolean current) {
        return new LogFile(name, Scn.valueOf((long)startScn), Scn.valueOf((long)Long.MAX_VALUE), BigInteger.valueOf(sequence), LogFile.Type.REDO, current, threadId);
    }

    private static LogFile createArchiveLog(String name, long startScn, long endScn, int sequence, int threadId) {
        return new LogFile(name, Scn.valueOf((long)startScn), Scn.valueOf((long)endScn), BigInteger.valueOf(sequence), LogFile.Type.ARCHIVE, false, threadId);
    }
}

