/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.xstream;

import io.debezium.config.Configuration;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.oracle.AbstractStreamingAdapter;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleTaskContext;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.StreamingAdapter;
import io.debezium.connector.oracle.xstream.LcrPosition;
import io.debezium.connector.oracle.xstream.XStreamOracleOffsetContextLoader;
import io.debezium.connector.oracle.xstream.XStreamStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.xstream.XstreamStreamingChangeEventSource;
import io.debezium.document.Document;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.util.Clock;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XStreamAdapter
extends AbstractStreamingAdapter<XStreamStreamingChangeEventSourceMetrics> {
    private static final Logger LOGGER = LoggerFactory.getLogger(XStreamAdapter.class);
    public static final String TYPE = "xstream";

    public XStreamAdapter(OracleConnectorConfig connectorConfig) {
        super(connectorConfig);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public HistoryRecordComparator getHistoryRecordComparator() {
        return new HistoryRecordComparator(){

            public boolean isPositionAtOrBefore(Document recorded, Document desired) {
                Scn desiredScn;
                LcrPosition recordedPosition = LcrPosition.valueOf(recorded.getString((CharSequence)"lcr_position"));
                LcrPosition desiredPosition = LcrPosition.valueOf(desired.getString((CharSequence)"lcr_position"));
                Scn recordedScn = recordedPosition != null ? recordedPosition.getScn() : XStreamAdapter.this.resolveScn(recorded);
                Scn scn = desiredScn = desiredPosition != null ? desiredPosition.getScn() : XStreamAdapter.this.resolveScn(desired);
                if (recordedPosition != null && desiredPosition != null) {
                    return recordedPosition.compareTo(desiredPosition) < 1;
                }
                return recordedScn.compareTo(desiredScn) < 1;
            }
        };
    }

    @Override
    public OffsetContext.Loader<OracleOffsetContext> getOffsetContextLoader() {
        return new XStreamOracleOffsetContextLoader(this.connectorConfig);
    }

    @Override
    public StreamingChangeEventSource<OraclePartition, OracleOffsetContext> getSource(OracleConnection connection, EventDispatcher<OraclePartition, TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, OracleTaskContext taskContext, Configuration jdbcConfig, XStreamStreamingChangeEventSourceMetrics streamingMetrics) {
        return new XstreamStreamingChangeEventSource(this.connectorConfig, connection, dispatcher, errorHandler, clock, schema, streamingMetrics);
    }

    @Override
    public XStreamStreamingChangeEventSourceMetrics getStreamingMetrics(OracleTaskContext taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider, OracleConnectorConfig connectorConfig) {
        return new XStreamStreamingChangeEventSourceMetrics(taskContext, changeEventQueueMetrics, metadataProvider);
    }

    @Override
    public StreamingAdapter.TableNameCaseSensitivity getTableNameCaseSensitivity(OracleConnection connection) {
        if (connection.getOracleVersion().getMajor() == 11) {
            return StreamingAdapter.TableNameCaseSensitivity.SENSITIVE;
        }
        return super.getTableNameCaseSensitivity(connection);
    }

    @Override
    public OracleOffsetContext determineSnapshotOffset(RelationalSnapshotChangeEventSource.RelationalSnapshotContext<OraclePartition, OracleOffsetContext> ctx, OracleConnectorConfig connectorConfig, OracleConnection connection) throws SQLException {
        Optional<Scn> latestTableDdlScn = this.getLatestTableDdlScn(ctx, connection);
        Scn currentScn = null;
        do {
            currentScn = connection.getCurrentScn();
        } while (this.areSameTimestamp(latestTableDdlScn.orElse(null), currentScn, connection));
        LOGGER.info("\tCurrent SCN resolved as {}", (Object)currentScn);
        return OracleOffsetContext.create().logicalName(connectorConfig).scn(currentScn).snapshotScn(currentScn).snapshotPendingTransactions(Collections.emptyMap()).transactionContext(new TransactionContext()).incrementalSnapshotContext((IncrementalSnapshotContext<TableId>)new SignalBasedIncrementalSnapshotContext()).build();
    }
}

