/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.memory;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.processor.AbstractTransaction;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryTransaction
extends AbstractTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemoryTransaction.class);
    private int numberOfEvents;
    private List<LogMinerEvent> events = new ArrayList<LogMinerEvent>();

    public MemoryTransaction(String transactionId, Scn startScn, Instant changeTime, String userName, Integer redoThreadId) {
        super(transactionId, startScn, changeTime, userName, redoThreadId);
        this.start();
    }

    @Override
    public int getNumberOfEvents() {
        return this.numberOfEvents;
    }

    @Override
    public int getNextEventId() {
        return this.numberOfEvents++;
    }

    @Override
    public void start() {
        this.numberOfEvents = 0;
    }

    public List<LogMinerEvent> getEvents() {
        return this.events;
    }

    public boolean removeEventWithRowId(String rowId) {
        for (int i = this.events.size() - 1; i >= 0; --i) {
            LogMinerEvent event = this.events.get(i);
            if (!event.getRowId().equals(rowId)) continue;
            this.events.remove(i);
            LOGGER.trace("Undo applied for event {}.", (Object)event);
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "MemoryTransaction{numberOfEvents=" + this.numberOfEvents + "} " + super.toString();
    }
}

