/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.antlr.listener;

import io.debezium.ddl.parser.oracle.generated.PlSqlParser;
import io.debezium.ddl.parser.oracle.generated.PlSqlParserBaseListener;

class BaseParserListener
extends PlSqlParserBaseListener {
    BaseParserListener() {
    }

    String getTableName(PlSqlParser.Tableview_nameContext tableview_name) {
        String tableName = tableview_name.id_expression() != null ? tableview_name.id_expression().getText() : tableview_name.identifier().id_expression().getText();
        return BaseParserListener.getTableOrColumnName(tableName);
    }

    String getTableName(PlSqlParser.Column_nameContext ctx) {
        String tableName = ctx.id_expression() != null && ctx.id_expression().size() > 1 ? BaseParserListener.getTableOrColumnName(ctx.id_expression(0).getText()) : BaseParserListener.getTableOrColumnName(ctx.identifier().id_expression().getText());
        return tableName;
    }

    String getColumnName(PlSqlParser.Column_nameContext ctx) {
        String columnName = ctx.id_expression() != null && ctx.id_expression().size() > 0 ? BaseParserListener.getTableOrColumnName(ctx.id_expression(ctx.id_expression().size() - 1).getText()) : BaseParserListener.getTableOrColumnName(ctx.identifier().id_expression().getText());
        return columnName;
    }

    String getColumnName(PlSqlParser.Old_column_nameContext ctx) {
        return BaseParserListener.getTableOrColumnName(ctx.getText());
    }

    String getColumnName(PlSqlParser.New_column_nameContext ctx) {
        return BaseParserListener.getTableOrColumnName(ctx.getText());
    }

    private static String getTableOrColumnName(String name) {
        return BaseParserListener.removeQuotes(name, true);
    }

    private static String removeQuotes(String text, boolean upperCaseIfNotQuoted) {
        if (text != null && text.length() > 2 && text.startsWith("\"") && text.endsWith("\"")) {
            return text.substring(1, text.length() - 1);
        }
        return upperCaseIfNotQuoted ? text.toUpperCase() : text;
    }
}

