/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.rest;

import io.debezium.connector.oracle.Module;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.rest.DebeziumOracleConnectRestExtension;
import io.debezium.testing.testcontainers.testhelper.RestExtensionTestInfrastructure;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DebeziumOracleConnectorResourceNoDatabaseIT {
    @BeforeClass
    public static void checkCondition() {
        Assume.assumeThat((String)"Skipping DebeziumOracleConnectorResourceIT tests when assembly profile is not active!", (Object)System.getProperty("isAssemblyProfileActive", "false"), (Matcher)CoreMatchers.is((Object)"true"));
    }

    @Before
    public void start() {
        RestExtensionTestInfrastructure.setupDebeziumContainer((String)Module.version(), (String)DebeziumOracleConnectRestExtension.class.getName());
        RestExtensionTestInfrastructure.startContainers((RestExtensionTestInfrastructure.DATABASE)RestExtensionTestInfrastructure.DATABASE.NONE);
    }

    @After
    public void stop() {
        RestExtensionTestInfrastructure.stopContainers();
    }

    @Test
    public void testVersionEndpoint() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().get("/debezium/oracle/version", new Object[0])).then()).log().all()).statusCode(200)).body(CoreMatchers.is((Object)Module.version()), new Matcher[0]);
    }

    @Test
    public void testSchemaEndpoint() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().get("/debezium/oracle/schema", new Object[0])).then()).log().all()).statusCode(200)).body("components.schemas.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("components.schemas.values()[0]")).body("title", CoreMatchers.is((Object)"Debezium Oracle Connector"), new Object[0])).body("properties.size()", CoreMatchers.is((Object)88), new Object[0])).body("x-connector-id", CoreMatchers.is((Object)"oracle"), new Object[0])).body("x-version", CoreMatchers.is((Object)Module.version()), new Object[0])).body("x-className", CoreMatchers.is((Object)OracleConnector.class.getName()), new Object[0])).body("properties", Matchers.hasKey((Object)"topic.prefix"), new Object[0])).body("properties", Matchers.hasKey((Object)"database.pdb.name"), new Object[0])).body("properties", Matchers.hasKey((Object)"database.out.server.name"), new Object[0])).body("properties", Matchers.hasKey((Object)"rac.nodes"), new Object[0])).body("properties", Matchers.hasKey((Object)"database.connection.adapter"), new Object[0])).body("properties", Matchers.hasKey((Object)"log.mining.strategy"), new Object[0])).body("properties", Matchers.hasKey((Object)"lob.enabled"), new Object[0])).body("properties", Matchers.hasKey((Object)"snapshot.mode"), new Object[0]);
    }
}

