/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.rest;

import io.debezium.connector.oracle.Module;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.rest.DebeziumOracleConnectRestExtension;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.testing.testcontainers.ConnectorConfiguration;
import io.debezium.testing.testcontainers.testhelper.RestExtensionTestInfrastructure;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Locale;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class DebeziumOracleConnectorResourceIT {
    private static final boolean IS_ASSEMBLY_PROFILE_ACTIVE = System.getProperty("isAssemblyProfileActive", "false").equalsIgnoreCase("true");
    private static String ORACLE_USERNAME;
    private static boolean running;

    @BeforeClass
    public static void checkConditionAndStart() {
        Assume.assumeTrue((String)"Skipping DebeziumOracleConnectorResourceIT tests when assembly profile is not active!", (boolean)IS_ASSEMBLY_PROFILE_ACTIVE);
        RestExtensionTestInfrastructure.setupDebeziumContainer((String)Module.version(), (String)DebeziumOracleConnectRestExtension.class.getName());
        RestExtensionTestInfrastructure.startContainers((RestExtensionTestInfrastructure.DATABASE)RestExtensionTestInfrastructure.DATABASE.ORACLE);
        TestHelper.loadTestData(TestHelper.getOracleConnectorConfiguration(1, new String[0]), "rest/data.sql");
        ORACLE_USERNAME = RestExtensionTestInfrastructure.getOracleContainer().getUsername();
        running = true;
    }

    @AfterClass
    public static void stop() {
        if (IS_ASSEMBLY_PROFILE_ACTIVE && running) {
            RestExtensionTestInfrastructure.stopContainers();
        }
    }

    @Test
    public void testValidConnection() {
        ConnectorConfiguration config = TestHelper.getOracleConnectorConfiguration(1, new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/oracle/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0]);
    }

    @Test
    public void testInvalidHostnameConnection() {
        ConnectorConfiguration config = TestHelper.getOracleConnectorConfiguration(1, new String[0]).with(OracleConnectorConfig.HOSTNAME.name(), "zzzzzzzzzz");
        Locale.setDefault(new Locale("en", "US"));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/oracle/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.equalTo((Object)OracleConnectorConfig.HOSTNAME.name()), new Object[0])).body("message", CoreMatchers.startsWith((String)"Unable to connect: Failed to resolve Oracle database version"), new Object[0]);
    }

    @Test
    public void testInvalidConnection() {
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body("{\"connector.class\": \"" + OracleConnector.class.getName() + "\"}").put("/debezium/oracle/validate/connection", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)5), new Object[0])).body("validationResults", CoreMatchers.hasItems((Object[])new Map[]{Map.of("property", OracleConnectorConfig.DATABASE_NAME.name(), "message", "The 'database.dbname' value is invalid: A value is required"), Map.of("property", OracleConnectorConfig.USER.name(), "message", "The 'database.user' value is invalid: A value is required"), Map.of("property", OracleConnectorConfig.TOPIC_PREFIX.name(), "message", "The 'topic.prefix' value is invalid: A value is required"), Map.of("property", OracleConnectorConfig.URL.name(), "message", "The 'database.url' value is invalid: A value is required"), Map.of("property", OracleConnectorConfig.HOSTNAME.name(), "message", "The 'database.hostname' value is invalid: A value is required")}), new Object[0]);
    }

    @Test
    public void testFiltersWithEmptyFilters() {
        ConnectorConfiguration config = TestHelper.getOracleConnectorConfiguration(1, new String[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/oracle/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)10), new Object[0])).body("matchingCollections", CoreMatchers.hasItems((Object[])new Map[]{Map.of("namespace", ORACLE_USERNAME.toUpperCase(), "name", "ORDERS", "identifier", ORACLE_USERNAME.toUpperCase() + ".ORDERS"), Map.of("namespace", ORACLE_USERNAME.toUpperCase(), "name", "PEOPLE", "identifier", ORACLE_USERNAME.toUpperCase() + ".PEOPLE"), Map.of("namespace", ORACLE_USERNAME.toUpperCase(), "name", "TEST", "identifier", ORACLE_USERNAME.toUpperCase() + ".TEST"), Map.of("namespace", ORACLE_USERNAME.toUpperCase(), "name", "PRODUCTS", "identifier", ORACLE_USERNAME.toUpperCase() + ".PRODUCTS"), Map.of("namespace", ORACLE_USERNAME.toUpperCase(), "name", "CUSTOMERS", "identifier", ORACLE_USERNAME.toUpperCase() + ".CUSTOMERS"), Map.of("namespace", ORACLE_USERNAME.toUpperCase(), "name", "DEBEZIUM_TABLE3", "identifier", ORACLE_USERNAME.toUpperCase() + ".DEBEZIUM_TABLE3"), Map.of("namespace", ORACLE_USERNAME.toUpperCase(), "name", "DEBEZIUM_TABLE2", "identifier", ORACLE_USERNAME.toUpperCase() + ".DEBEZIUM_TABLE2"), Map.of("namespace", ORACLE_USERNAME.toUpperCase(), "name", "DEBEZIUM_TABLE1", "identifier", ORACLE_USERNAME.toUpperCase() + ".DEBEZIUM_TABLE1"), Map.of("namespace", ORACLE_USERNAME.toUpperCase(), "name", "PRODUCTS_ON_HAND", "identifier", ORACLE_USERNAME.toUpperCase() + ".PRODUCTS_ON_HAND"), Map.of("namespace", ORACLE_USERNAME.toUpperCase(), "name", "DEBEZIUM_TEST", "identifier", ORACLE_USERNAME.toUpperCase() + ".DEBEZIUM_TEST")}), new Object[0]);
    }

    @Test
    public void testFiltersWithValidTableIncludeList() {
        ConnectorConfiguration config = TestHelper.getOracleConnectorConfiguration(1, new String[0]).with("table.include.list", ORACLE_USERNAME.toUpperCase() + "\\.DEBEZIUM_TABLE.*");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/oracle/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"VALID"), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)0), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)3), new Object[0])).body("matchingCollections", CoreMatchers.hasItems((Object[])new Map[]{Map.of("namespace", ORACLE_USERNAME.toUpperCase(), "name", "DEBEZIUM_TABLE3", "identifier", ORACLE_USERNAME.toUpperCase() + ".DEBEZIUM_TABLE3"), Map.of("namespace", ORACLE_USERNAME.toUpperCase(), "name", "DEBEZIUM_TABLE1", "identifier", ORACLE_USERNAME.toUpperCase() + ".DEBEZIUM_TABLE1"), Map.of("namespace", ORACLE_USERNAME.toUpperCase(), "name", "DEBEZIUM_TABLE2", "identifier", ORACLE_USERNAME.toUpperCase() + ".DEBEZIUM_TABLE2")}), new Object[0]);
    }

    @Test
    public void testFiltersWithInvalidTableIncludeList() {
        ConnectorConfiguration config = TestHelper.getOracleConnectorConfiguration(1, new String[0]).with("table.include.list", "+");
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(RestExtensionTestInfrastructure.getDebeziumContainer().getFirstMappedPort().intValue()).when().contentType(ContentType.JSON).accept(ContentType.JSON).body(config.toJson()).put("/debezium/oracle/validate/filters", new Object[0])).then()).log().all()).statusCode(200)).assertThat()).body("status", CoreMatchers.equalTo((Object)"INVALID"), new Object[0])).body("matchingCollections.size()", CoreMatchers.is((Object)0), new Object[0])).body("validationResults.size()", CoreMatchers.is((Object)1), new Object[0])).rootPath("validationResults[0]")).body("property", CoreMatchers.equalTo((Object)"table.include.list"), new Object[0])).body("message", CoreMatchers.equalTo((Object)"The 'table.include.list' value is invalid: A comma-separated list of valid regular expressions is expected, but Dangling meta character '+' near index 0\n+\n^"), new Object[0]);
    }

    static {
        running = false;
    }
}

