/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.junit;

import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIs;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.junit.AnnotationBasedTestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipTestDependingOnAdapterNameRule
extends AnnotationBasedTestRule {
    private static final String adapterName = SkipTestDependingOnAdapterNameRule.determineAdapterName();

    public Statement apply(Statement base, Description description) {
        SkipWhenAdapterNameIs skipWhenAdpterName = (SkipWhenAdapterNameIs)this.hasAnnotation(description, SkipWhenAdapterNameIs.class);
        if (skipWhenAdpterName != null && skipWhenAdpterName.value().isEqualTo(adapterName)) {
            String reasonForSkipping = "Adapter name is " + skipWhenAdpterName.value() + System.lineSeparator() + skipWhenAdpterName.reason();
            return SkipTestDependingOnAdapterNameRule.emptyStatement((String)reasonForSkipping, (Description)description);
        }
        SkipWhenAdapterNameIsNot skipWhenAdapterNameNot = (SkipWhenAdapterNameIsNot)this.hasAnnotation(description, SkipWhenAdapterNameIsNot.class);
        if (skipWhenAdapterNameNot != null && skipWhenAdapterNameNot.value().isNotEqualTo(adapterName)) {
            String reasonForSkipping = "Adapter name is not " + skipWhenAdapterNameNot.value() + System.lineSeparator() + skipWhenAdapterNameNot.reason();
            return SkipTestDependingOnAdapterNameRule.emptyStatement((String)reasonForSkipping, (Description)description);
        }
        return base;
    }

    public static String determineAdapterName() {
        return TestHelper.adapter().getValue();
    }
}

