/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LogMinerQueryBuilder {
    private static final String EMPTY = "";
    private static final String LOGMNR_CONTENTS_VIEW = "V$LOGMNR_CONTENTS";
    private static final String UNKNOWN_USERNAME = "UNKNOWN";
    private static final String UNKNOWN_SCHEMA_NAME = "UNKNOWN";
    private static final String UNKNOWN_TABLE_NAME_PREFIX = "OBJ#";
    private static final List<Integer> OPERATION_CODES_LOB = Arrays.asList(1, 2, 3, 6, 7, 9, 10, 11, 29, 34, 36, 68, 70, 71, 255);
    private static final List<Integer> OPERATION_CODES_NO_LOB = Arrays.asList(1, 2, 3, 6, 7, 34, 36, 255);

    public static String build(OracleConnectorConfig connectorConfig) {
        String tablesPredicate;
        String schemasPredicate;
        StringBuilder query = new StringBuilder(1024);
        query.append("SELECT SCN, SQL_REDO, OPERATION_CODE, TIMESTAMP, XID, CSF, TABLE_NAME, SEG_OWNER, OPERATION, ");
        query.append("USERNAME, ROW_ID, ROLLBACK, RS_ID, STATUS, INFO, SSN, THREAD# ");
        query.append("FROM ").append(LOGMNR_CONTENTS_VIEW).append(" ");
        query.append("WHERE SCN > ? AND SCN <= ?");
        String multiTenantPredicate = LogMinerQueryBuilder.getMultiTenantPredicate(connectorConfig);
        if (!multiTenantPredicate.isEmpty()) {
            query.append(" AND ").append(multiTenantPredicate);
        }
        query.append(" AND ");
        if (!connectorConfig.storeOnlyCapturedTables()) {
            query.append("((");
        }
        query.append(LogMinerQueryBuilder.getOperationCodePredicate(connectorConfig));
        String userNamePredicate = LogMinerQueryBuilder.getUserNamePredicate(connectorConfig);
        if (!userNamePredicate.isEmpty()) {
            query.append(" AND ").append(userNamePredicate);
        }
        if (!(schemasPredicate = LogMinerQueryBuilder.getSchemaNamePredicate(connectorConfig)).isEmpty()) {
            query.append(" AND ").append(schemasPredicate);
        }
        if (!(tablesPredicate = LogMinerQueryBuilder.getTableNamePredicate(connectorConfig)).isEmpty()) {
            query.append(" AND ").append(tablesPredicate);
        }
        if (!connectorConfig.storeOnlyCapturedTables()) {
            query.append(")").append(LogMinerQueryBuilder.getDdlPredicate()).append(")");
        }
        return query.toString();
    }

    private static String getOperationCodePredicate(OracleConnectorConfig connectorConfig) {
        StringBuilder predicate = new StringBuilder();
        InClause operationInClause = InClause.builder().withField("OPERATION_CODE");
        if (connectorConfig.isLobEnabled()) {
            operationInClause.withValues(OPERATION_CODES_LOB);
        } else {
            operationInClause.withValues(OPERATION_CODES_NO_LOB);
        }
        predicate.append("(").append(operationInClause.build());
        if (connectorConfig.storeOnlyCapturedTables()) {
            predicate.append(LogMinerQueryBuilder.getDdlPredicate());
        }
        return predicate.append(")").toString();
    }

    private static String getDdlPredicate() {
        return " OR (OPERATION_CODE = 5 AND INFO NOT LIKE 'INTERNAL DDL%')";
    }

    private static String getMultiTenantPredicate(OracleConnectorConfig connectorConfig) {
        if (!Strings.isNullOrEmpty((String)connectorConfig.getPdbName())) {
            return "SRC_CON_NAME = '" + connectorConfig.getPdbName() + "'";
        }
        return EMPTY;
    }

    private static String getUserNamePredicate(OracleConnectorConfig connectorConfig) {
        if (!OracleConnectorConfig.LogMiningQueryFilterMode.NONE.equals((Object)connectorConfig.getLogMiningQueryFilterMode())) {
            return IncludeExcludeInClause.builder().withField("USERNAME").withFilterMode(OracleConnectorConfig.LogMiningQueryFilterMode.IN).withDefaultIncludeValues(Collections.singletonList("UNKNOWN")).withIncludeValues(connectorConfig.getLogMiningUsernameIncludes()).withExcludeValues(connectorConfig.getLogMiningUsernameExcludes()).caseInsensitive().build();
        }
        return EMPTY;
    }

    private static String getSchemaNamePredicate(OracleConnectorConfig connectorConfig) {
        String fieldName = "SEG_OWNER";
        String includeList = connectorConfig.schemaIncludeList();
        String excludeList = connectorConfig.schemaExcludeList();
        OracleConnectorConfig.LogMiningQueryFilterMode queryFilterMode = connectorConfig.getLogMiningQueryFilterMode();
        if (OracleConnectorConfig.LogMiningQueryFilterMode.NONE.equals((Object)queryFilterMode)) {
            return LogMinerQueryBuilder.resolveExcludedSchemaPredicate("SEG_OWNER");
        }
        if (Strings.isNullOrEmpty((String)includeList) && Strings.isNullOrEmpty((String)excludeList)) {
            return LogMinerQueryBuilder.resolveExcludedSchemaPredicate("SEG_OWNER");
        }
        if (OracleConnectorConfig.LogMiningQueryFilterMode.IN.equals((Object)queryFilterMode)) {
            Set includeSchemasList = Strings.setOf((String)includeList, String::new);
            Set excludeSchemasList = Strings.setOf((String)excludeList, String::new);
            StringBuilder predicate = new StringBuilder();
            predicate.append("(").append("SEG_OWNER").append(" IS NULL OR ");
            predicate.append(IncludeExcludeInClause.builder().withField("SEG_OWNER").withFilterMode(queryFilterMode).withIncludeValues(includeSchemasList).withDefaultIncludeValues(Collections.singletonList("UNKNOWN")).withExcludeValues(excludeSchemasList).withDefaultExcludeValues(LogMinerQueryBuilder.getBuiltInExcludedSchemas()).caseInsensitive().build());
            predicate.append(")");
            return predicate.toString();
        }
        if (OracleConnectorConfig.LogMiningQueryFilterMode.REGEX.equals((Object)queryFilterMode)) {
            List includeSchemaList = Strings.listOfRegex((String)includeList, (int)2);
            List excludeSchemaList = Strings.listOfRegex((String)excludeList, (int)2);
            StringBuilder predicate = new StringBuilder();
            predicate.append("(");
            predicate.append("SEG_OWNER").append(" IS NULL OR ");
            if (includeSchemaList.isEmpty() && !excludeSchemaList.isEmpty()) {
                predicate.append(InClause.builder().withField("SEG_OWNER").negate().withValues(LogMinerQueryBuilder.getBuiltInExcludedSchemas()).build());
            } else {
                predicate.append("SEG_OWNER").append(" = '").append("UNKNOWN").append("'");
            }
            predicate.append(" OR ");
            predicate.append(IncludeExcludeRegExpLike.builder().withField("SEG_OWNER").withFilterMode(queryFilterMode).withIncludeValues(includeSchemaList).withExcludeValues(excludeSchemaList).build());
            predicate.append(")");
            return predicate.toString();
        }
        throw new DebeziumException("An unsupported LogMiningQueryFilterMode detected: " + queryFilterMode);
    }

    private static String getTableNamePredicate(OracleConnectorConfig connectorConfig) {
        String fieldName = "SEG_OWNER || '.' || TABLE_NAME";
        String includeList = connectorConfig.tableIncludeList();
        String excludeList = connectorConfig.tableExcludeList();
        OracleConnectorConfig.LogMiningQueryFilterMode queryFilterMode = connectorConfig.getLogMiningQueryFilterMode();
        if (OracleConnectorConfig.LogMiningQueryFilterMode.NONE.equals((Object)queryFilterMode)) {
            return EMPTY;
        }
        if (Strings.isNullOrEmpty((String)includeList) && Strings.isNullOrEmpty((String)excludeList)) {
            return EMPTY;
        }
        if (OracleConnectorConfig.LogMiningQueryFilterMode.IN.equals((Object)queryFilterMode)) {
            List<String> includeTableList = LogMinerQueryBuilder.getTableIncludeExcludeListAsInValueList(includeList);
            List<String> excludeTableList = LogMinerQueryBuilder.getTableIncludeExcludeListAsInValueList(excludeList);
            StringBuilder predicate = new StringBuilder();
            predicate.append("(TABLE_NAME IS NULL OR ");
            predicate.append("TABLE_NAME LIKE '").append(UNKNOWN_TABLE_NAME_PREFIX).append("%' OR ");
            LogMinerQueryBuilder.getSignalDataCollectionId(connectorConfig).ifPresent(signalTableId -> {
                if (!LogMinerQueryBuilder.tableIncludeListContains(includeTableList, signalTableId)) {
                    predicate.append("UPPER(").append("SEG_OWNER || '.' || TABLE_NAME").append(") = '").append(signalTableId.schema().toUpperCase()).append('.').append(signalTableId.table().toUpperCase()).append("' OR ");
                }
            });
            predicate.append(IncludeExcludeInClause.builder().withField("SEG_OWNER || '.' || TABLE_NAME").withFilterMode(queryFilterMode).withIncludeValues(includeTableList).withExcludeValues(excludeTableList).caseInsensitive().build());
            predicate.append(")");
            return predicate.toString();
        }
        if (OracleConnectorConfig.LogMiningQueryFilterMode.REGEX.equals((Object)queryFilterMode)) {
            List includeTableList = Strings.listOfRegex((String)includeList, (int)2);
            List excludeTableList = Strings.listOfRegex((String)excludeList, (int)2);
            StringBuilder predicate = new StringBuilder();
            predicate.append("(TABLE_NAME IS NULL OR ");
            predicate.append("TABLE_NAME LIKE '").append(UNKNOWN_TABLE_NAME_PREFIX).append("%' OR ");
            LogMinerQueryBuilder.getSignalDataCollectionId(connectorConfig).ifPresent(signalTableId -> {
                if (!LogMinerQueryBuilder.matches(includeTableList, signalTableId.identifier())) {
                    predicate.append("UPPER(").append("SEG_OWNER || '.' || TABLE_NAME").append(") = '").append(signalTableId.schema().toUpperCase()).append('.').append(signalTableId.table().toUpperCase()).append("' OR ");
                }
            });
            predicate.append(IncludeExcludeRegExpLike.builder().withField("SEG_OWNER || '.' || TABLE_NAME").withFilterMode(queryFilterMode).withIncludeValues(includeTableList).withExcludeValues(excludeTableList).build());
            predicate.append(")");
            return predicate.toString();
        }
        throw new DebeziumException("An unsupported LogMiningQueryFilterMode detected: " + queryFilterMode);
    }

    private static Optional<TableId> getSignalDataCollectionId(OracleConnectorConfig connectorConfig) {
        if (!Strings.isNullOrEmpty((String)connectorConfig.getSignalingDataCollectionId())) {
            return Optional.of(TableId.parse((String)connectorConfig.getSignalingDataCollectionId()));
        }
        return Optional.empty();
    }

    private static boolean tableIncludeListContains(Collection<String> values, TableId searchValue) {
        for (String value : values) {
            TableId tableId = TableId.parse((String)value, (boolean)false);
            if (!tableId.schema().equalsIgnoreCase(searchValue.schema()) || !tableId.table().equalsIgnoreCase(searchValue.table())) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(Collection<Pattern> patterns, String searchValue) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(searchValue).matches()) continue;
            return true;
        }
        return false;
    }

    private static String resolveExcludedSchemaPredicate(String fieldName) {
        List<String> schemas = LogMinerQueryBuilder.getBuiltInExcludedSchemas();
        if (!schemas.isEmpty()) {
            StringBuilder query = new StringBuilder();
            query.append('(').append(fieldName).append(" IS NULL OR ");
            query.append(InClause.builder().withField(fieldName).negate().withValues(schemas).build());
            query.append(')');
            return query.toString();
        }
        return EMPTY;
    }

    private static List<String> getBuiltInExcludedSchemas() {
        return LogMinerQueryBuilder.toUpperCase(OracleConnectorConfig.EXCLUDED_SCHEMAS);
    }

    private static List<String> getTableIncludeExcludeListAsInValueList(String list) {
        return Strings.listOf((String)list, s -> s.split("[,]"), v -> v.replaceAll("\\\\", EMPTY));
    }

    private static List<String> toUpperCase(Collection<String> values) {
        return values.stream().map(String::toUpperCase).collect(Collectors.toList());
    }

    private static class InClause {
        private String fieldName;
        private boolean negated;
        private boolean caseInsensitive;
        private Collection<?> values;

        private InClause() {
        }

        public static InClause builder() {
            return new InClause();
        }

        public InClause withField(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public InClause negate() {
            this.negated = true;
            return this;
        }

        public InClause caseInsensitive() {
            this.caseInsensitive = true;
            return this;
        }

        public InClause withValues(Collection<?> values) {
            this.values = values;
            return this;
        }

        public String build() {
            Objects.requireNonNull(this.fieldName, "The field name must not be null");
            Objects.requireNonNull(this.values, "The values list must not be null");
            StringBuilder sql = new StringBuilder();
            if (this.caseInsensitive) {
                sql.append("UPPER(").append(this.fieldName).append(")");
            } else {
                sql.append(this.fieldName);
            }
            if (this.negated) {
                sql.append(" NOT");
            }
            sql.append(" IN (");
            sql.append(this.commaSeparatedList(this.values));
            sql.append(")");
            return sql.toString();
        }

        private String commaSeparatedList(Collection<?> values) {
            StringBuilder list = new StringBuilder();
            Iterator<?> iterator = values.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (value instanceof String) {
                    if (this.caseInsensitive) {
                        list.append("'").append(((String)value).toUpperCase()).append("'");
                    } else {
                        list.append("'").append(value).append("'");
                    }
                } else {
                    list.append(value);
                }
                if (!iterator.hasNext()) continue;
                list.append(",");
            }
            return list.toString();
        }
    }

    private static class IncludeExcludeInClause {
        private String fieldName;
        private boolean caseInsensitive;
        private OracleConnectorConfig.LogMiningQueryFilterMode mode;
        private List<Object> defaultIncludeValues;
        private List<Object> includeValues;
        private List<Object> defaultExcludeValues;
        private List<Object> excludeValues;

        private IncludeExcludeInClause() {
        }

        public static IncludeExcludeInClause builder() {
            return new IncludeExcludeInClause();
        }

        public IncludeExcludeInClause caseInsensitive() {
            this.caseInsensitive = true;
            return this;
        }

        public IncludeExcludeInClause withField(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public IncludeExcludeInClause withFilterMode(OracleConnectorConfig.LogMiningQueryFilterMode mode) {
            this.mode = mode;
            return this;
        }

        public IncludeExcludeInClause withDefaultIncludeValues(Collection<?> values) {
            this.defaultIncludeValues = new ArrayList(values);
            return this;
        }

        public IncludeExcludeInClause withIncludeValues(Collection<?> values) {
            this.includeValues = new ArrayList(values);
            return this;
        }

        public IncludeExcludeInClause withDefaultExcludeValues(Collection<?> values) {
            this.defaultExcludeValues = new ArrayList(values);
            return this;
        }

        public IncludeExcludeInClause withExcludeValues(Collection<?> values) {
            this.excludeValues = new ArrayList(values);
            return this;
        }

        public String build() {
            Objects.requireNonNull(this.includeValues, "The include values must not be null");
            Objects.requireNonNull(this.excludeValues, "The exclude values must not be null");
            Objects.requireNonNull(this.mode, "The LogMiningQueryFilterMode must not be null");
            if (OracleConnectorConfig.LogMiningQueryFilterMode.NONE.equals((Object)this.mode) || this.includeValues.isEmpty() && this.excludeValues.isEmpty()) {
                return LogMinerQueryBuilder.EMPTY;
            }
            if (!OracleConnectorConfig.LogMiningQueryFilterMode.IN.equals((Object)this.mode)) {
                throw new IllegalStateException("Expected LogMiningQueryFilterMode to be IN");
            }
            InClause inClause = InClause.builder().withField(this.fieldName);
            if (this.caseInsensitive) {
                inClause.caseInsensitive();
            }
            if (!this.excludeValues.isEmpty()) {
                if (this.defaultExcludeValues != null && !this.defaultExcludeValues.isEmpty()) {
                    this.defaultExcludeValues.addAll(this.excludeValues);
                    inClause.negate().withValues(this.defaultExcludeValues);
                } else {
                    inClause.negate().withValues(this.excludeValues);
                }
            } else if (this.defaultIncludeValues != null && !this.defaultIncludeValues.isEmpty()) {
                this.defaultIncludeValues.addAll(this.includeValues);
                inClause.withValues(this.defaultIncludeValues);
            } else {
                inClause.withValues(this.includeValues);
            }
            return inClause.build();
        }
    }

    private static class IncludeExcludeRegExpLike {
        private String fieldName;
        private OracleConnectorConfig.LogMiningQueryFilterMode mode;
        private List<Pattern> includeValues;
        private List<Pattern> excludeValues;

        private IncludeExcludeRegExpLike() {
        }

        public static IncludeExcludeRegExpLike builder() {
            return new IncludeExcludeRegExpLike();
        }

        public IncludeExcludeRegExpLike withField(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public IncludeExcludeRegExpLike withFilterMode(OracleConnectorConfig.LogMiningQueryFilterMode mode) {
            this.mode = mode;
            return this;
        }

        public IncludeExcludeRegExpLike withIncludeValues(Collection<Pattern> values) {
            this.includeValues = new ArrayList<Pattern>(values);
            return this;
        }

        public IncludeExcludeRegExpLike withExcludeValues(Collection<Pattern> values) {
            this.excludeValues = new ArrayList<Pattern>(values);
            return this;
        }

        public String build() {
            Objects.requireNonNull(this.includeValues, "The include values must not be null");
            Objects.requireNonNull(this.excludeValues, "The exclude values must not be null");
            Objects.requireNonNull(this.mode, "The LogMiningQueryFilterMode must not be null");
            if (OracleConnectorConfig.LogMiningQueryFilterMode.NONE.equals((Object)this.mode) || this.includeValues.isEmpty() && this.excludeValues.isEmpty()) {
                return LogMinerQueryBuilder.EMPTY;
            }
            if (!OracleConnectorConfig.LogMiningQueryFilterMode.REGEX.equals((Object)this.mode)) {
                throw new IllegalStateException("Expected LogMiningQueryFilterMode to be REGEX");
            }
            List<Pattern> values = !this.excludeValues.isEmpty() ? this.excludeValues : this.includeValues;
            String prepend = !this.excludeValues.isEmpty() ? "NOT " : LogMinerQueryBuilder.EMPTY;
            String junction = !this.excludeValues.isEmpty() ? " AND " : " OR ";
            StringBuilder sql = new StringBuilder();
            sql.append("(");
            Iterator<Pattern> iterator = values.iterator();
            while (iterator.hasNext()) {
                sql.append(prepend);
                sql.append(this.regularExpressionLike(iterator.next()));
                if (!iterator.hasNext()) continue;
                sql.append(junction);
            }
            sql.append(")");
            return sql.toString();
        }

        private String regularExpressionLike(Pattern pattern) {
            return "REGEXP_LIKE(" + this.fieldName + ",'" + this.preparePattern(pattern) + "','i')";
        }

        private String preparePattern(Pattern pattern) {
            Object patternText = pattern.pattern();
            if (!((String)patternText).startsWith("^")) {
                patternText = "^" + (String)patternText;
            }
            if (!((String)patternText).endsWith("$")) {
                patternText = (String)patternText + "$";
            }
            return patternText;
        }
    }
}

