/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogFile;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.embedded.AbstractConnectorTest;
import java.math.BigInteger;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class LogMinerHelperTest
extends AbstractConnectorTest {
    @Test
    public void testStandaloneLogStateWithOneThreadArchiveLogGap() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100, 4, 1));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80, 90, 2, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isFalse();
    }

    @Test
    public void testStandaloneLogStateWithNoGaps() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100, 4, 1));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80, 90, 2, 1));
        files.add(LogMinerHelperTest.createArchiveLog("archive0.log", 90, 100, 3, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    @Test
    public void testStandaloneLogStateWithJustOnlineLogs() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100, 4, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    @Test
    public void testStandaloneLogStateWithMixOfArchiveAndRedoNoGaps() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100, 4, 1));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80, 90, 3, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    @Test
    public void testRacLogStateWithOneThreadArchiveLogGap() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100, 4, 1));
        files.add(LogMinerHelperTest.createRedoLog("redo2.log", 80, 1, 2));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80, 90, 2, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isFalse();
    }

    @Test
    public void testRacLogStateWithNoGaps() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100, 4, 1));
        files.add(LogMinerHelperTest.createRedoLog("redo2.log", 80, 1, 2));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80, 90, 2, 1));
        files.add(LogMinerHelperTest.createArchiveLog("archive0.log", 90, 100, 3, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    @Test
    public void testRacLogStateWithJustOnlineLogs() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100, 4, 1));
        files.add(LogMinerHelperTest.createRedoLog("redo2.log", 90, 3, 2));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    @Test
    public void testRacLogStateWithMixOfArchiveAndRedoNoGaps() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100, 4, 1));
        files.add(LogMinerHelperTest.createRedoLog("redo2.log", 90, 3, 2));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80, 90, 2, 1));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    @Test
    public void testRacLogStateWithMixOfArchiveAndRedoForBothThreadsNoGap() throws Exception {
        ArrayList<LogFile> files = new ArrayList<LogFile>();
        files.add(LogMinerHelperTest.createRedoLog("redo1.log", 100, 4, 1));
        files.add(LogMinerHelperTest.createRedoLog("redo2.log", 90, 3, 2));
        files.add(LogMinerHelperTest.createArchiveLog("archive1.log", 80, 90, 2, 1));
        files.add(LogMinerHelperTest.createArchiveLog("archive2.log", 70, 80, 1, 2));
        Assertions.assertThat((boolean)LogMinerHelper.hasLogFilesStartingBeforeOrAtScn(files, (Scn)Scn.valueOf((int)101))).isTrue();
    }

    private static LogFile createRedoLog(String name, int startScn, int sequence, int threadId) {
        return new LogFile(name, Scn.valueOf((int)startScn), Scn.valueOf((long)Long.MAX_VALUE), BigInteger.valueOf(sequence), LogFile.Type.REDO, true, threadId);
    }

    private static LogFile createArchiveLog(String name, int startScn, int endScn, int sequence, int threadId) {
        return new LogFile(name, Scn.valueOf((int)startScn), Scn.valueOf((int)endScn), BigInteger.valueOf(sequence), LogFile.Type.ARCHIVE, false, threadId);
    }
}

