/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleSchemaChangeEventEmitter;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogMinerChangeRecordEmitter;
import io.debezium.connector.oracle.logminer.LogMinerQueryBuilder;
import io.debezium.connector.oracle.logminer.LogMinerStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.logminer.events.DmlEvent;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.connector.oracle.logminer.events.LobEraseEvent;
import io.debezium.connector.oracle.logminer.events.LobWriteEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEvent;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import io.debezium.connector.oracle.logminer.events.SelectLobLocatorEvent;
import io.debezium.connector.oracle.logminer.events.TruncateEvent;
import io.debezium.connector.oracle.logminer.events.XmlBeginEvent;
import io.debezium.connector.oracle.logminer.events.XmlEndEvent;
import io.debezium.connector.oracle.logminer.events.XmlWriteEvent;
import io.debezium.connector.oracle.logminer.logwriter.LogWriterFlushStrategy;
import io.debezium.connector.oracle.logminer.parser.DmlParserException;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntryImpl;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlParser;
import io.debezium.connector.oracle.logminer.parser.SelectLobParser;
import io.debezium.connector.oracle.logminer.parser.XmlBeginParser;
import io.debezium.connector.oracle.logminer.processor.AbstractTransaction;
import io.debezium.connector.oracle.logminer.processor.LogMinerEventProcessor;
import io.debezium.connector.oracle.logminer.processor.TransactionCommitConsumer;
import io.debezium.data.Envelope;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SchemaChangeEventEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.text.ParsingException;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.sql.RAW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogMinerEventProcessor<T extends AbstractTransaction>
implements LogMinerEventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLogMinerEventProcessor.class);
    private static final String NO_SEQUENCE_TRX_ID_SUFFIX = "ffffffff";
    private static final String XML_WRITE_PREAMBLE = "XML_REDO := ";
    private final ChangeEventSource.ChangeEventSourceContext context;
    private final OracleConnectorConfig connectorConfig;
    private final OracleDatabaseSchema schema;
    private final OraclePartition partition;
    private final OracleOffsetContext offsetContext;
    private final EventDispatcher<OraclePartition, TableId> dispatcher;
    private final LogMinerStreamingChangeEventSourceMetrics metrics;
    private final LogMinerDmlParser dmlParser;
    private final SelectLobParser selectLobParser;
    private final XmlBeginParser xmlBeginParser;
    private final Tables.TableFilter tableFilter;
    protected final Counters counters;
    protected final String sqlQuery;
    private Scn currentOffsetScn = Scn.NULL;
    private Map<Integer, Scn> currentOffsetCommitScns = new HashMap<Integer, Scn>();
    private Instant lastProcessedScnChangeTime = null;
    private Scn lastProcessedScn = Scn.NULL;
    private boolean sequenceUnavailable = false;
    private static Pattern LOB_WRITE_SQL_PATTERN = Pattern.compile("(?s).* := ((?:HEXTORAW\\()?'.*'(?:\\))?);\\s*dbms_lob.write\\([^,]+,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,[^,]+\\);.*");

    public AbstractLogMinerEventProcessor(ChangeEventSource.ChangeEventSourceContext context, OracleConnectorConfig connectorConfig, OracleDatabaseSchema schema, OraclePartition partition, OracleOffsetContext offsetContext, EventDispatcher<OraclePartition, TableId> dispatcher, LogMinerStreamingChangeEventSourceMetrics metrics) {
        this.context = context;
        this.connectorConfig = connectorConfig;
        this.schema = schema;
        this.partition = partition;
        this.offsetContext = offsetContext;
        this.dispatcher = dispatcher;
        this.metrics = metrics;
        this.tableFilter = connectorConfig.getTableFilters().dataCollectionFilter();
        this.counters = new Counters();
        this.dmlParser = new LogMinerDmlParser();
        this.selectLobParser = new SelectLobParser();
        this.xmlBeginParser = new XmlBeginParser();
        this.sqlQuery = LogMinerQueryBuilder.build(connectorConfig);
    }

    protected OracleConnectorConfig getConfig() {
        return this.connectorConfig;
    }

    protected OracleDatabaseSchema getSchema() {
        return this.schema;
    }

    protected boolean isRecentlyProcessed(String transactionId) {
        return false;
    }

    protected boolean hasSchemaChangeBeenSeen(LogMinerEventRow row) {
        return false;
    }

    protected Scn getLastProcessedScn() {
        return this.lastProcessedScn;
    }

    protected Instant getLastProcessedScnChangeTime() {
        return this.lastProcessedScnChangeTime;
    }

    protected abstract Map<String, T> getTransactionCache();

    protected abstract T createTransaction(LogMinerEventRow var1);

    protected abstract void removeEventWithRowId(LogMinerEventRow var1);

    protected abstract int getTransactionEventCount(T var1);

    protected boolean isTrxIdRawValue() {
        return true;
    }

    @Override
    public Scn process(Scn startScn, Scn endScn) throws SQLException, InterruptedException {
        this.counters.reset();
        try (PreparedStatement statement = this.createQueryStatement();){
            Scn scn;
            block22: {
                LOGGER.debug("Fetching results for SCN [{}, {}]", (Object)startScn, (Object)endScn);
                statement.setFetchSize(this.getConfig().getQueryFetchSize());
                statement.setFetchDirection(1000);
                statement.setString(1, startScn.toString());
                statement.setString(2, endScn.toString());
                Instant queryStart = Instant.now();
                ResultSet resultSet = statement.executeQuery();
                try {
                    this.metrics.setLastDurationOfFetchQuery(Duration.between(queryStart, Instant.now()));
                    Instant startProcessTime = Instant.now();
                    this.processResults(this.partition, resultSet);
                    Duration totalTime = Duration.between(startProcessTime, Instant.now());
                    this.metrics.setLastCapturedDmlCount(this.counters.dmlCount);
                    if (this.counters.dmlCount > 0 || this.counters.commitCount > 0 || this.counters.rollbackCount > 0) {
                        this.warnPotentiallyStuckScn(this.currentOffsetScn, this.currentOffsetCommitScns);
                        this.currentOffsetScn = this.offsetContext.getScn();
                        if (this.offsetContext.getCommitScn() != null) {
                            this.currentOffsetCommitScns = this.offsetContext.getCommitScn().getCommitScnForAllRedoThreads();
                        }
                    }
                    LOGGER.debug("{}.", (Object)this.counters);
                    LOGGER.debug("Processed in {} ms. Lag: {}. Offset SCN: {}, Offset Commit SCN: {}, Active Transactions: {}, Sleep: {}", new Object[]{totalTime.toMillis(), this.metrics.getLagFromSourceInMilliseconds(), this.offsetContext.getScn(), this.offsetContext.getCommitScn(), this.metrics.getNumberOfActiveTransactions(), this.metrics.getSleepTimeInMilliseconds()});
                    if (this.metrics.getNumberOfActiveTransactions() > 0L && LOGGER.isDebugEnabled()) {
                        try (Stream<AbstractTransaction> stream = this.getTransactionCache().values().stream();){
                            LOGGER.debug("All active transactions: {}", (Object)stream.map(t -> t.getTransactionId() + " (" + t.getStartScn() + ")").collect(Collectors.joining(",")));
                        }
                    }
                    this.metrics.setLastProcessedRowsCount(this.counters.rows);
                    scn = this.calculateNewStartScn(endScn, this.offsetContext.getCommitScn().getMaxCommittedScn());
                    if (resultSet == null) break block22;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return scn;
        }
    }

    protected String getQueryString() {
        return this.sqlQuery;
    }

    protected abstract PreparedStatement createQueryStatement() throws SQLException;

    protected abstract Scn calculateNewStartScn(Scn var1, Scn var2) throws InterruptedException;

    protected void processResults(OraclePartition partition, ResultSet resultSet) throws SQLException, InterruptedException {
        while (this.context.isRunning() && this.hasNextWithMetricsUpdate(resultSet)) {
            ++this.counters.rows;
            this.processRow(partition, LogMinerEventRow.fromResultSet(resultSet, this.getConfig().getCatalogName(), this.isTrxIdRawValue()));
        }
    }

    protected void processRow(OraclePartition partition, LogMinerEventRow row) throws SQLException, InterruptedException {
        Map<String, Scn> snapshotPendingTransactions;
        if (!row.getEventType().equals((Object)EventType.MISSING_SCN)) {
            this.lastProcessedScn = row.getScn();
            this.lastProcessedScnChangeTime = row.getChangeTime();
        }
        if (!(row.getScn().compareTo(this.offsetContext.getSnapshotScn()) >= 0 || (snapshotPendingTransactions = this.offsetContext.getSnapshotPendingTransactions()) != null && snapshotPendingTransactions.containsKey(row.getTransactionId()))) {
            LOGGER.debug("Skipping event {} (SCN {}) because it is already encompassed by the initial snapshot", (Object)row.getEventType(), (Object)row.getScn());
            return;
        }
        if (row.getTableId() != null) {
            if (LogWriterFlushStrategy.isFlushTable(row.getTableId(), this.connectorConfig.getJdbcConfig().getUser(), this.connectorConfig.getLogMiningFlushTableName())) {
                LOGGER.trace("Skipped change associated with flush table '{}'", (Object)row.getTableId());
                return;
            }
            if (!EventType.DDL.equals((Object)row.getEventType()) && !this.tableFilter.isIncluded(row.getTableId())) {
                LOGGER.trace("Skipping change associated with table '{}' which does not match filters.", (Object)row.getTableId());
                return;
            }
        }
        switch (row.getEventType()) {
            case MISSING_SCN: {
                this.handleMissingScn(row);
            }
            case START: {
                this.handleStart(row);
                break;
            }
            case COMMIT: {
                this.handleCommit(partition, row);
                break;
            }
            case ROLLBACK: {
                this.handleRollback(row);
                break;
            }
            case DDL: {
                this.handleSchemaChange(row);
                break;
            }
            case SELECT_LOB_LOCATOR: {
                this.handleSelectLobLocator(row);
                break;
            }
            case LOB_WRITE: {
                this.handleLobWrite(row);
                break;
            }
            case LOB_ERASE: {
                this.handleLobErase(row);
                break;
            }
            case XML_BEGIN: {
                this.handleXmlBegin(row);
                break;
            }
            case XML_WRITE: {
                this.handleXmlWrite(row);
                break;
            }
            case XML_END: {
                this.handleXmlEnd(row);
                break;
            }
            case INSERT: 
            case UPDATE: 
            case DELETE: {
                this.handleDataEvent(row);
                break;
            }
            case UNSUPPORTED: {
                this.handleUnsupportedEvent(row);
            }
        }
    }

    protected void handleMissingScn(LogMinerEventRow row) {
        LOGGER.warn("Missing SCN detected. {}", (Object)row);
    }

    protected void handleStart(LogMinerEventRow row) {
        String transactionId = row.getTransactionId();
        AbstractTransaction transaction = (AbstractTransaction)this.getTransactionCache().get(transactionId);
        if (transaction == null && !this.isRecentlyProcessed(transactionId)) {
            this.getTransactionCache().put(transactionId, this.createTransaction(row));
            this.metrics.setActiveTransactionCount(this.getTransactionCache().size());
        } else if (transaction != null && !this.isRecentlyProcessed(transactionId)) {
            LOGGER.trace("Transaction {} is not yet committed and START event detected.", (Object)transactionId);
            this.resetTransactionToStart(transaction);
        }
    }

    protected void resetTransactionToStart(T transaction) {
        transaction.start();
    }

    protected void handleCommit(final OraclePartition partition, final LogMinerEventRow row) throws InterruptedException {
        Scn smallestScn;
        final String transactionId = row.getTransactionId();
        if (this.isRecentlyProcessed(transactionId)) {
            LOGGER.debug("\tTransaction is already committed, skipped.");
            return;
        }
        final T transaction = this.getAndRemoveTransactionFromCache(transactionId);
        if (transaction == null) {
            this.handleCommitNotFoundInBuffer(row);
            LOGGER.debug("Transaction {} not found, commit skipped.", (Object)transactionId);
            return;
        }
        Optional<T> oldestTransaction = this.getOldestTransactionInCache();
        if (oldestTransaction.isPresent()) {
            smallestScn = ((AbstractTransaction)oldestTransaction.get()).getStartScn();
            this.metrics.setOldestScnDetails(smallestScn, ((AbstractTransaction)oldestTransaction.get()).getChangeTime());
        } else {
            smallestScn = Scn.NULL;
            this.metrics.setOldestScnDetails(Scn.valueOf(-1), null);
        }
        final Scn commitScn = row.getScn();
        if (this.offsetContext.getCommitScn().hasCommitAlreadyBeenHandled(row)) {
            if (transaction.getNumberOfEvents() > 0) {
                Scn lastCommittedScn = this.offsetContext.getCommitScn().getCommitScnForRedoThread(row.getThread());
                LOGGER.debug("Transaction {} has already been processed. Offset Commit SCN {}, Transaction Commit SCN {}, Last Seen Commit SCN {}.", new Object[]{transactionId, this.offsetContext.getCommitScn(), commitScn, lastCommittedScn});
            }
            this.removeTransactionAndEventsFromCache(transaction);
            this.metrics.setActiveTransactionCount(this.getTransactionCache().size());
            return;
        }
        ++this.counters.commitCount;
        int numEvents = this.getTransactionEventCount(transaction);
        LOGGER.debug("Committing transaction {} with {} events (scn: {}, oldest buffer scn: {}): {}", new Object[]{transactionId, numEvents, row.getScn(), smallestScn, row});
        final ZoneOffset databaseOffset = this.metrics.getDatabaseOffset();
        final boolean skipExcludedUserName = this.isTransactionUserExcluded(transaction);
        TransactionCommitConsumer.Handler<LogMinerEvent> delegate = new TransactionCommitConsumer.Handler<LogMinerEvent>(){
            private int numEvents;
            {
                this.numEvents = AbstractLogMinerEventProcessor.this.getTransactionEventCount(transaction);
            }

            @Override
            public void accept(LogMinerEvent event, long eventsProcessed) throws InterruptedException {
                if (smallestScn.isNull() || commitScn.compareTo(smallestScn) < 0) {
                    AbstractLogMinerEventProcessor.this.offsetContext.setScn(event.getScn());
                    AbstractLogMinerEventProcessor.this.metrics.setOldestScnDetails(event.getScn(), event.getChangeTime());
                }
                AbstractLogMinerEventProcessor.this.offsetContext.setEventScn(event.getScn());
                AbstractLogMinerEventProcessor.this.offsetContext.setTransactionId(transactionId);
                AbstractLogMinerEventProcessor.this.offsetContext.setUserName(transaction.getUserName());
                AbstractLogMinerEventProcessor.this.offsetContext.setSourceTime(event.getChangeTime().minusSeconds(databaseOffset.getTotalSeconds()));
                AbstractLogMinerEventProcessor.this.offsetContext.setTableId(event.getTableId());
                AbstractLogMinerEventProcessor.this.offsetContext.setRedoThread(row.getThread());
                AbstractLogMinerEventProcessor.this.offsetContext.setRsId(event.getRsId());
                if (eventsProcessed == (long)this.numEvents) {
                    AbstractLogMinerEventProcessor.this.offsetContext.getCommitScn().recordCommit(row);
                }
                DmlEvent dmlEvent = (DmlEvent)event;
                if (!skipExcludedUserName) {
                    LogMinerChangeRecordEmitter logMinerChangeRecordEmitter = dmlEvent instanceof TruncateEvent ? new LogMinerChangeRecordEmitter(AbstractLogMinerEventProcessor.this.connectorConfig, (Partition)partition, (OffsetContext)AbstractLogMinerEventProcessor.this.offsetContext, Envelope.Operation.TRUNCATE, dmlEvent.getDmlEntry().getOldValues(), dmlEvent.getDmlEntry().getNewValues(), AbstractLogMinerEventProcessor.this.getSchema().tableFor(event.getTableId()), AbstractLogMinerEventProcessor.this.getSchema(), Clock.system()) : new LogMinerChangeRecordEmitter(AbstractLogMinerEventProcessor.this.connectorConfig, (Partition)partition, (OffsetContext)AbstractLogMinerEventProcessor.this.offsetContext, dmlEvent.getEventType(), dmlEvent.getDmlEntry().getOldValues(), dmlEvent.getDmlEntry().getNewValues(), AbstractLogMinerEventProcessor.this.getSchema().tableFor(event.getTableId()), AbstractLogMinerEventProcessor.this.getSchema(), Clock.system());
                    AbstractLogMinerEventProcessor.this.dispatcher.dispatchDataChangeEvent((Partition)partition, (DataCollectionId)event.getTableId(), (ChangeRecordEmitter)logMinerChangeRecordEmitter);
                }
            }
        };
        Instant start = Instant.now();
        int dispatchedEventCount = 0;
        if (numEvents > 0) {
            try (TransactionCommitConsumer commitConsumer = new TransactionCommitConsumer(delegate, this.connectorConfig, this.schema);){
                Iterator<LogMinerEvent> iterator = this.getTransactionEventIterator(transaction);
                while (iterator.hasNext()) {
                    if (!this.context.isRunning()) {
                        return;
                    }
                    LogMinerEvent event = iterator.next();
                    LOGGER.trace("Dispatching event {} {}", (Object)(++dispatchedEventCount), (Object)event.getEventType());
                    commitConsumer.accept(event);
                }
            }
        } else {
            this.offsetContext.getCommitScn().recordCommit(row);
        }
        this.offsetContext.setEventScn(commitScn);
        this.offsetContext.setRsId(row.getRsId());
        if (this.getTransactionEventCount(transaction) > 0 && !skipExcludedUserName) {
            this.dispatcher.dispatchTransactionCommittedEvent((Partition)partition, (OffsetContext)this.offsetContext, ((AbstractTransaction)transaction).getChangeTime());
        } else {
            this.dispatcher.dispatchHeartbeatEvent((Partition)partition, (OffsetContext)this.offsetContext);
        }
        this.metrics.calculateLagFromSource(row.getChangeTime());
        this.finalizeTransactionCommit(transactionId, commitScn);
        this.removeTransactionAndEventsFromCache(transaction);
        this.metrics.incrementCommittedTransactionCount();
        this.metrics.setActiveTransactionCount(this.getTransactionCache().size());
        this.metrics.setCommitScn(commitScn);
        this.metrics.setOffsetScn(this.offsetContext.getScn());
        this.metrics.setLastCommitDuration(Duration.between(start, Instant.now()));
    }

    protected void handleCommitNotFoundInBuffer(LogMinerEventRow row) {
    }

    protected void handleRollbackNotFoundInBuffer(LogMinerEventRow row) {
    }

    protected abstract T getAndRemoveTransactionFromCache(String var1);

    protected abstract void removeTransactionAndEventsFromCache(T var1);

    protected abstract Iterator<LogMinerEvent> getTransactionEventIterator(T var1);

    protected abstract void finalizeTransactionCommit(String var1, Scn var2);

    protected abstract String getFirstActiveTransactionKey();

    protected boolean isTransactionUserExcluded(T transaction) {
        if (transaction != null) {
            if (((AbstractTransaction)transaction).getUserName() == null && this.getTransactionEventCount(transaction) > 0) {
                LOGGER.debug("Detected transaction with null username {}", transaction);
                return false;
            }
            if (this.connectorConfig.getLogMiningUsernameExcludes().contains(((AbstractTransaction)transaction).getUserName())) {
                LOGGER.debug("Skipped transaction with excluded username {}", transaction);
                return true;
            }
        }
        return false;
    }

    protected void handleRollback(LogMinerEventRow row) {
        if (this.getTransactionCache().containsKey(row.getTransactionId())) {
            LOGGER.debug("Transaction {} was rolled back.", (Object)row.getTransactionId());
            this.finalizeTransactionRollback(row.getTransactionId(), row.getScn());
            this.metrics.setActiveTransactionCount(this.getTransactionCache().size());
            this.metrics.incrementRolledBackTransactionCount();
            this.metrics.addRolledBackTransactionId(row.getTransactionId());
            ++this.counters.rollbackCount;
        } else {
            LOGGER.debug("Could not rollback transaction {}, was not found in cache.", (Object)row.getTransactionId());
            this.handleRollbackNotFoundInBuffer(row);
        }
    }

    protected abstract void finalizeTransactionRollback(String var1, Scn var2);

    protected void handleSchemaChange(LogMinerEventRow row) throws InterruptedException {
        if (row.getTableId() != null) {
            boolean isExcluded = this.connectorConfig.getLogMiningSchemaChangesUsernameExcludes().stream().anyMatch(userName -> userName.equalsIgnoreCase(row.getUserName()));
            if (isExcluded) {
                LOGGER.trace("User '{}' is in schema change exclusions, DDL '{}' skipped.", (Object)row.getUserName(), (Object)row.getRedoSql());
                return;
            }
            if (row.getInfo() != null && row.getInfo().startsWith("INTERNAL DDL")) {
                LOGGER.trace("Internal DDL '{}' skipped", (Object)row.getRedoSql());
                return;
            }
            if (this.schema.storeOnlyCapturedTables() && !this.tableFilter.isIncluded(row.getTableId())) {
                LOGGER.trace("Skipping DDL associated with table '{}', schema history only stores included tables only.", (Object)row.getTableId());
                return;
            }
        }
        if (this.hasSchemaChangeBeenSeen(row)) {
            LOGGER.trace("DDL: Scn {}, SQL '{}' has already been processed, skipped.", (Object)row.getScn(), (Object)row.getRedoSql());
            return;
        }
        if (this.offsetContext.getCommitScn().hasCommitAlreadyBeenHandled(row)) {
            Scn commitScn = this.offsetContext.getCommitScn().getCommitScnForRedoThread(row.getThread());
            LOGGER.trace("DDL: SQL '{}' skipped with {} (SCN) <= {} (commit SCN for redo thread {})", new Object[]{row.getRedoSql(), row.getScn(), commitScn, row.getThread()});
            return;
        }
        LOGGER.trace("DDL: '{}' {}", (Object)row.getRedoSql(), (Object)row);
        if (row.getTableName() != null) {
            String transactionId;
            ++this.counters.ddlCount;
            TableId tableId = row.getTableId();
            int activeTransactions = this.getTransactionCache().size();
            boolean advanceLowerScnBoundary = false;
            if (activeTransactions == 0) {
                advanceLowerScnBoundary = true;
            } else if (activeTransactions == 1 && (transactionId = this.getFirstActiveTransactionKey()).equals(row.getTransactionId())) {
                advanceLowerScnBoundary = true;
            }
            if (advanceLowerScnBoundary) {
                LOGGER.debug("Schema change advanced offset SCN to {}", (Object)row.getScn());
                this.offsetContext.setScn(row.getScn());
            }
            LOGGER.debug("Schema change advanced offset commit SCN to {} for thread {}", (Object)row.getScn(), (Object)row.getThread());
            this.offsetContext.getCommitScn().recordCommit(row);
            this.offsetContext.setEventScn(row.getScn());
            this.offsetContext.setRedoThread(row.getThread());
            this.offsetContext.setRsId(row.getRsId());
            this.dispatcher.dispatchSchemaChangeEvent((Partition)this.partition, (OffsetContext)this.offsetContext, (DataCollectionId)tableId, (SchemaChangeEventEmitter)new OracleSchemaChangeEventEmitter(this.getConfig(), this.partition, this.offsetContext, tableId, tableId.catalog(), tableId.schema(), row.getRedoSql(), this.getSchema(), row.getChangeTime(), this.metrics, () -> this.processTruncateEvent(row)));
        }
    }

    private void processTruncateEvent(LogMinerEventRow row) {
        LOGGER.debug("Handling truncate event");
        try {
            Table table = this.getTableForDataEvent(row);
            if (table == null) {
                return;
            }
        }
        catch (InterruptedException | SQLException e) {
            LOGGER.warn("Failed to process truncate event.", (Throwable)e);
            return;
        }
        this.addToTransaction(row.getTransactionId(), row, () -> {
            LogMinerDmlEntry dmlEntry = LogMinerDmlEntryImpl.forValuelessDdl();
            dmlEntry.setObjectName(row.getTableName());
            dmlEntry.setObjectOwner(row.getTablespaceName());
            return new TruncateEvent(row, dmlEntry);
        });
    }

    protected void handleSelectLobLocator(LogMinerEventRow row) {
        if (!this.getConfig().isLobEnabled()) {
            LOGGER.trace("LOB support is disabled, SEL_LOB_LOCATOR '{}' skipped.", (Object)row.getRedoSql());
            return;
        }
        LOGGER.debug("SEL_LOB_LOCATOR: {}", (Object)row);
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            LOGGER.warn("SEL_LOB_LOCATOR for table '{}' is not known, skipped.", (Object)tableId);
            return;
        }
        this.addToTransaction(row.getTransactionId(), row, () -> {
            LogMinerDmlEntry dmlEntry = this.selectLobParser.parse(row.getRedoSql(), table);
            dmlEntry.setObjectName(row.getTableName());
            dmlEntry.setObjectOwner(row.getTablespaceName());
            return new SelectLobLocatorEvent(row, dmlEntry, this.selectLobParser.getColumnName(), this.selectLobParser.isBinary());
        });
        this.metrics.incrementTotalChangesCount();
    }

    protected void handleLobWrite(LogMinerEventRow row) {
        if (!this.getConfig().isLobEnabled()) {
            LOGGER.trace("LOB support is disabled, LOB_WRITE scn={}, tableId={} skipped", (Object)row.getScn(), (Object)row.getTableId());
            return;
        }
        LOGGER.debug("LOB_WRITE: scn={}, tableId={}, changeTime={}, transactionId={}", new Object[]{row.getScn(), row.getTableId(), row.getChangeTime(), row.getTransactionId()});
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            LOGGER.warn("LOB_WRITE for table '{}' is not known, skipped", (Object)tableId);
            return;
        }
        if (row.getRedoSql() != null) {
            this.addToTransaction(row.getTransactionId(), row, () -> {
                ParsedLobWriteSql parsed = this.parseLobWriteSql(row.getRedoSql());
                return new LobWriteEvent(row, parsed.data, parsed.offset, parsed.length);
            });
        }
    }

    private void handleLobErase(LogMinerEventRow row) {
        if (!this.getConfig().isLobEnabled()) {
            LOGGER.trace("LOB support is disabled, LOB_ERASE '{}' skipped", (Object)row);
            return;
        }
        LOGGER.debug("LOB_ERASE: {}", (Object)row);
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            LOGGER.warn("LOB_ERASE for table '{}' is not known, skipped", (Object)tableId);
            return;
        }
        this.addToTransaction(row.getTransactionId(), row, () -> new LobEraseEvent(row));
    }

    private void handleXmlBegin(LogMinerEventRow row) {
        if (!this.getConfig().isLobEnabled()) {
            LOGGER.trace("LOB support is disabled, XML_BEGIN '{}' skipped.", (Object)row.getRedoSql());
            return;
        }
        LOGGER.trace("XML_BEGIN: {}", (Object)row);
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            LOGGER.warn("XML_BEGIN for table '{}' is not known, skipped.", (Object)tableId);
            return;
        }
        this.addToTransaction(row.getTransactionId(), row, () -> {
            LogMinerDmlEntry dmlEntry = this.xmlBeginParser.parse(row.getRedoSql(), table);
            dmlEntry.setObjectName(row.getTableName());
            dmlEntry.setObjectOwner(row.getTablespaceName());
            return new XmlBeginEvent(row, dmlEntry, this.xmlBeginParser.getColumnName());
        });
    }

    private void handleXmlWrite(LogMinerEventRow row) {
        if (!this.getConfig().isLobEnabled()) {
            LOGGER.trace("LOB support is disabled, XML_WRITE '{}' skipped.", (Object)row.getRedoSql());
            return;
        }
        LOGGER.trace("XML_WRITE: {}", (Object)row);
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            LOGGER.warn("XML_WRITE for table '{}' is not known, skipped.", (Object)tableId);
            return;
        }
        this.addToTransaction(row.getTransactionId(), row, () -> this.getXmlWriteEventFromRow(row));
    }

    private XmlWriteEvent getXmlWriteEventFromRow(LogMinerEventRow row) {
        String sql = row.getRedoSql();
        if (!sql.startsWith(XML_WRITE_PREAMBLE)) {
            throw new ParsingException(null, "XML write operation does not start with XML_REDO preamble");
        }
        try {
            String xml;
            if (sql.charAt(XML_WRITE_PREAMBLE.length()) == '\'') {
                int lastQuoteIndex = sql.lastIndexOf(39);
                if (lastQuoteIndex == -1) {
                    throw new IllegalStateException("Failed to find end of XML document");
                }
                xml = sql.substring(XML_WRITE_PREAMBLE.length() + 1, lastQuoteIndex);
            } else {
                int lastParenIndex = sql.lastIndexOf(41);
                if (lastParenIndex == -1) {
                    throw new IllegalStateException("Failed to find end of XML document");
                }
                String xmlHex = sql.substring(XML_WRITE_PREAMBLE.length(), lastParenIndex + 1);
                if (!xmlHex.startsWith("HEXTORAW('") || !xmlHex.endsWith(")")) {
                    throw new IllegalStateException("Invalid HEXTORAW XML decoded data");
                }
                xmlHex = xmlHex.endsWith("')") ? xmlHex.substring(10, xmlHex.length() - 2) : xmlHex.substring(10, xmlHex.length() - 1);
                xml = new String(RAW.hexString2Bytes((String)xmlHex), StandardCharsets.UTF_8);
            }
            int lastColonIndex = sql.lastIndexOf(58);
            if (lastColonIndex == -1) {
                throw new IllegalStateException("Failed to find XML document length");
            }
            Integer length = Integer.parseInt(sql.substring(lastColonIndex + 1).trim());
            return new XmlWriteEvent(row, xml, length);
        }
        catch (Exception e) {
            throw new ParsingException(null, "Failed to parse XML write data", (Throwable)e);
        }
    }

    private void handleXmlEnd(LogMinerEventRow row) {
        if (!this.getConfig().isLobEnabled()) {
            LOGGER.trace("LOB support is disabled, XML_END skipped.");
            return;
        }
        LOGGER.trace("XML_END: {}", (Object)row);
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            LOGGER.warn("XM_END for table ' {}' is not known, skipped.", (Object)tableId);
            return;
        }
        this.addToTransaction(row.getTransactionId(), row, () -> new XmlEndEvent(row));
    }

    protected void handleDataEvent(LogMinerEventRow row) throws SQLException, InterruptedException {
        if (row.getRedoSql() == null) {
            return;
        }
        LOGGER.debug("DML: {}", (Object)row);
        LOGGER.trace("\t{}", (Object)row.getRedoSql());
        if (row.getStatus() == 2 && !Strings.isNullOrBlank((String)row.getInfo())) {
            switch (this.connectorConfig.getEventProcessingFailureHandlingMode()) {
                case FAIL: {
                    LOGGER.error("Oracle LogMiner is unable to re-construct the SQL for '{}'", (Object)row);
                    throw new DebeziumException("Oracle failed to re-construct redo SQL '" + row.getRedoSql() + "'");
                }
                case WARN: {
                    LOGGER.warn("Oracle LogMiner event '{}' cannot be parsed. This event will be ignored and skipped.", (Object)row);
                    return;
                }
            }
            LOGGER.debug("Oracle LogMiner event '{}' cannot be parsed. This event will be ignored and skipped.", (Object)row);
            return;
        }
        ++this.counters.dmlCount;
        switch (row.getEventType()) {
            case INSERT: {
                ++this.counters.insertCount;
                break;
            }
            case UPDATE: {
                ++this.counters.updateCount;
                break;
            }
            case DELETE: {
                ++this.counters.deleteCount;
            }
        }
        Table table = this.getTableForDataEvent(row);
        if (table == null) {
            return;
        }
        if (row.isRollbackFlag()) {
            this.removeEventWithRowId(row);
            return;
        }
        this.addToTransaction(row.getTransactionId(), row, () -> {
            LogMinerDmlEntry dmlEntry = this.parseDmlStatement(row.getRedoSql(), table);
            dmlEntry.setObjectName(row.getTableName());
            dmlEntry.setObjectOwner(row.getTablespaceName());
            return new DmlEvent(row, dmlEntry);
        });
        this.metrics.incrementTotalChangesCount();
    }

    protected void handleUnsupportedEvent(LogMinerEventRow row) {
        if (!Strings.isNullOrEmpty((String)row.getTableName())) {
            LOGGER.warn("An unsupported operation detected for table '{}' in transaction {} with SCN {} on redo thread {}.", new Object[]{row.getTableId(), row.getTransactionId(), row.getScn(), row.getThread()});
            LOGGER.debug("\t{}", (Object)row);
        }
    }

    protected void warnPotentiallyStuckScn(Scn previousOffsetScn, Map<Integer, Scn> previousOffsetCommitScns) {
        if (this.offsetContext != null && this.offsetContext.getCommitScn() != null) {
            Scn scn = this.offsetContext.getScn();
            Map<Integer, Scn> commitScns = this.offsetContext.getCommitScn().getCommitScnForAllRedoThreads();
            if (previousOffsetScn.equals(scn) && !previousOffsetCommitScns.equals(commitScns)) {
                ++this.counters.stuckCount;
                if (this.counters.stuckCount == 25) {
                    LOGGER.warn("Offset SCN {} has not changed in 25 mining session iterations. This indicates long running transaction(s) are active.  Commit SCNs {}.", (Object)previousOffsetScn, previousOffsetCommitScns);
                    this.metrics.incrementScnFreezeCount();
                }
            } else {
                this.counters.stuckCount = 0;
            }
        }
    }

    private Table getTableForDataEvent(LogMinerEventRow row) throws SQLException, InterruptedException {
        TableId tableId = row.getTableId();
        Table table = this.getSchema().tableFor(tableId);
        if (table == null) {
            if (!this.getConfig().getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
                return null;
            }
            table = this.dispatchSchemaChangeEventAndGetTableForNewCapturedTable(tableId, this.offsetContext, this.dispatcher);
        }
        return table;
    }

    private boolean hasNextWithMetricsUpdate(ResultSet resultSet) throws SQLException {
        Instant start = Instant.now();
        boolean result = false;
        try {
            if (resultSet.next()) {
                this.metrics.setLastResultSetNextDuration(Duration.between(start, Instant.now()));
                result = true;
            }
            if (this.sequenceUnavailable) {
                LOGGER.debug("The previous batch's unavailable log problem has been cleared.");
                this.sequenceUnavailable = false;
            }
        }
        catch (SQLException e) {
            if (!e.getMessage().startsWith("ORA-00310")) {
                throw e;
            }
            if (this.sequenceUnavailable) {
                LOGGER.error("The log availability error '{}' wasn't cleared, stop requested.", (Object)e.getMessage());
                throw e;
            }
            LOGGER.debug("A mined log is no longer available: {}", (Object)e.getMessage());
            LOGGER.warn("Restarting mining session after a log became unavailable.");
            this.sequenceUnavailable = true;
        }
        return result;
    }

    protected abstract void addToTransaction(String var1, LogMinerEventRow var2, Supplier<LogMinerEvent> var3);

    private Table dispatchSchemaChangeEventAndGetTableForNewCapturedTable(TableId tableId, OracleOffsetContext offsetContext, EventDispatcher<OraclePartition, TableId> dispatcher) throws SQLException, InterruptedException {
        String tableDdl;
        LOGGER.warn("Obtaining schema for table {}, which should be already loaded, this may signal potential bug in fetching table schemas.", (Object)tableId);
        try {
            tableDdl = this.getTableMetadataDdl(tableId);
        }
        catch (OracleConnection.NonRelationalTableException e) {
            LOGGER.warn("Table {} is not a relational table and will be skipped.", (Object)tableId);
            this.metrics.incrementWarningCount();
            return null;
        }
        LOGGER.info("Table '{}' is new and will now be captured.", (Object)tableId);
        offsetContext.event((DataCollectionId)tableId, Instant.now());
        dispatcher.dispatchSchemaChangeEvent((Partition)this.partition, (OffsetContext)offsetContext, (DataCollectionId)tableId, (SchemaChangeEventEmitter)new OracleSchemaChangeEventEmitter(this.connectorConfig, this.partition, offsetContext, tableId, tableId.catalog(), tableId.schema(), tableDdl, this.getSchema(), Instant.now(), this.metrics, null));
        return this.getSchema().tableFor(tableId);
    }

    private String getTableMetadataDdl(TableId tableId) throws SQLException, OracleConnection.NonRelationalTableException {
        ++this.counters.tableMetadataCount;
        LOGGER.info("Getting database metadata for table '{}'", (Object)tableId);
        try (OracleConnection connection = new OracleConnection(this.connectorConfig.getJdbcConfig(), false);){
            connection.setAutoCommit(false);
            String pdbName = this.getConfig().getPdbName();
            if (pdbName != null) {
                connection.setSessionToPdb(pdbName);
            }
            String string = connection.getTableMetadataDdl(tableId);
            return string;
        }
    }

    private LogMinerDmlEntry parseDmlStatement(String redoSql, Table table) {
        LogMinerDmlEntry dmlEntry;
        try {
            Instant parseStart = Instant.now();
            dmlEntry = this.dmlParser.parse(redoSql, table);
            this.metrics.setLastParseTimeDuration(Duration.between(parseStart, Instant.now()));
        }
        catch (DmlParserException e) {
            String message = "DML statement couldn't be parsed. Please open a Jira issue with the statement '" + redoSql + "'.";
            throw new DmlParserException(message, (Throwable)((Object)e));
        }
        if (dmlEntry.getOldValues().length == 0 && (EventType.UPDATE == dmlEntry.getEventType() || EventType.DELETE == dmlEntry.getEventType())) {
            LOGGER.warn("The DML event '{}' contained no before state.", (Object)redoSql);
            this.metrics.incrementWarningCount();
        }
        return dmlEntry;
    }

    private ParsedLobWriteSql parseLobWriteSql(String sql) {
        if (sql == null) {
            return null;
        }
        Matcher m = LOB_WRITE_SQL_PATTERN.matcher(sql.trim());
        if (!m.matches()) {
            throw new DebeziumException("Unable to parse unsupported LOB_WRITE SQL: " + sql);
        }
        String data = m.group(1);
        if (data.startsWith("'")) {
            data = data.substring(1, data.length() - 1);
        }
        int length = Integer.parseInt(m.group(2));
        int offset = Integer.parseInt(m.group(3)) - 1;
        if (data.contains("''")) {
            data = data.replaceAll("''", "'");
        }
        return new ParsedLobWriteSql(offset, length, data);
    }

    protected abstract Scn getTransactionCacheMinimumScn();

    protected abstract Optional<T> getOldestTransactionInCache();

    protected boolean isTransactionIdWithNoSequence(String transactionId) {
        return transactionId.endsWith(NO_SEQUENCE_TRX_ID_SUFFIX);
    }

    protected String getTransactionIdPrefix(String transactionId) {
        return transactionId.substring(0, 8);
    }

    protected boolean isTransactionOverEventThreshold(T transaction) {
        if (this.getConfig().getLogMiningBufferTransactionEventsThreshold() == 0L) {
            return false;
        }
        return (long)this.getTransactionEventCount(transaction) >= this.getConfig().getLogMiningBufferTransactionEventsThreshold();
    }

    protected void abandonTransactionOverEventThreshold(T transaction) {
        LOGGER.warn("Transaction {} exceeds maximum allowed number of events, transaction will be abandoned.", (Object)((AbstractTransaction)transaction).getTransactionId());
        this.metrics.incrementWarningCount();
        this.getAndRemoveTransactionFromCache(((AbstractTransaction)transaction).getTransactionId());
        this.metrics.incrementOversizedTransactionCount();
    }

    protected class Counters {
        public int stuckCount;
        public int dmlCount;
        public int ddlCount;
        public int insertCount;
        public int updateCount;
        public int deleteCount;
        public int commitCount;
        public int rollbackCount;
        public int tableMetadataCount;
        public long rows;

        protected Counters() {
        }

        public void reset() {
            this.stuckCount = 0;
            this.dmlCount = 0;
            this.ddlCount = 0;
            this.insertCount = 0;
            this.updateCount = 0;
            this.deleteCount = 0;
            this.commitCount = 0;
            this.rollbackCount = 0;
            this.tableMetadataCount = 0;
            this.rows = 0L;
        }

        public String toString() {
            return "Counters{rows=" + this.rows + ", stuckCount=" + this.stuckCount + ", dmlCount=" + this.dmlCount + ", ddlCount=" + this.ddlCount + ", insertCount=" + this.insertCount + ", updateCount=" + this.updateCount + ", deleteCount=" + this.deleteCount + ", commitCount=" + this.commitCount + ", rollbackCount=" + this.rollbackCount + ", tableMetadataCount=" + this.tableMetadataCount + "}";
        }
    }

    private class ParsedLobWriteSql {
        final int offset;
        final int length;
        final String data;

        ParsedLobWriteSql(int _offset, int _length, String _data) {
            this.offset = _offset;
            this.length = _length;
            this.data = _data;
        }
    }
}

