/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.util.ArrayList;
import java.util.List;
import org.jboss.byteman.agent.Transform;
import org.jboss.byteman.agent.Transformer;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;

public class TransformSet {
    private ClassLoader loader;
    private String triggerClass;
    private List<Transform> transforms;
    private Rule rule;

    public TransformSet(ClassLoader loader, String triggerClass) {
        this.loader = loader;
        this.triggerClass = triggerClass;
        this.transforms = new ArrayList<Transform>();
        this.rule = null;
    }

    public boolean isFor(ClassLoader loader, String triggerClass) {
        return this.loader == loader && this.triggerClass.equals(triggerClass);
    }

    public void add(Transform transform) {
        if (transform.getThrowable() == null) {
            String key = transform.getRule().getKey();
            for (Transform current : this.transforms) {
                if (current.getRule() == null || !key.equals(current.getRule().getKey())) continue;
                if (transform.getThrowable() != null && Transformer.isVerbose()) {
                    Helper.verbose("TransformSet.add : mismatch between successful and failed transforms with key " + key);
                    Helper.verboseTraceException(transform.getThrowable());
                }
                return;
            }
        }
        this.transforms.add(transform);
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public String getTriggerClass() {
        return this.triggerClass;
    }

    public boolean isInstalled() {
        return this.getRule() != null;
    }

    public void setInstalled(Rule key) {
        this.rule = key;
    }

    public Rule getRule() {
        return this.rule;
    }

    public List<Transform> getTransforms() {
        return this.transforms;
    }

    public boolean isEmpty() {
        return this.transforms.isEmpty();
    }

    public void clearTransforms() {
        this.transforms.clear();
    }
}

