/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.MalformedProtobufException;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.infinispan.protostream.TagReader;
import org.infinispan.protostream.descriptors.WireType;
import org.infinispan.protostream.impl.Log;
import org.infinispan.protostream.impl.ProtoStreamReaderImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;

public final class TagReaderImpl
implements TagReader,
ProtobufTagMarshaller.ReadContext {
    private static final Log log = Log.LogFactory.getLog(TagReaderImpl.class);
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final byte[] EMPTY = new byte[0];
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(EMPTY);
    private final SerializationContextImpl serCtx;
    private final Decoder decoder;
    private final TagReaderImpl parent;
    private Map<Object, Object> params = null;
    @Deprecated
    private ProtoStreamReaderImpl reader = null;

    private TagReaderImpl(TagReaderImpl parent, Decoder decoder) {
        this.parent = parent;
        this.serCtx = parent.serCtx;
        this.decoder = decoder;
    }

    private TagReaderImpl(SerializationContextImpl serCtx, Decoder decoder) {
        this.parent = null;
        this.serCtx = serCtx;
        this.decoder = decoder;
    }

    public static TagReaderImpl newNestedInstance(ProtobufTagMarshaller.ReadContext parent, InputStream input) {
        return new TagReaderImpl((TagReaderImpl)parent, (Decoder)new InputStreamDecoder(input, 4096));
    }

    public static TagReaderImpl newNestedInstance(ProtobufTagMarshaller.ReadContext parent, byte[] buf) {
        return new TagReaderImpl((TagReaderImpl)parent, (Decoder)new ByteArrayDecoder(buf, 0, buf.length));
    }

    public static TagReaderImpl newInstance(ImmutableSerializationContext serCtx, InputStream input) {
        return new TagReaderImpl((SerializationContextImpl)serCtx, (Decoder)new InputStreamDecoder(input, 4096));
    }

    public static TagReaderImpl newInstance(ImmutableSerializationContext serCtx, ByteBuffer buf) {
        Decoder decoder = buf.hasArray() ? new ByteArrayDecoder(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining()) : new ByteBufferDecoder(buf);
        return new TagReaderImpl((SerializationContextImpl)serCtx, decoder);
    }

    public static TagReaderImpl newInstance(ImmutableSerializationContext serCtx, byte[] buf) {
        return new TagReaderImpl((SerializationContextImpl)serCtx, (Decoder)new ByteArrayDecoder(buf, 0, buf.length));
    }

    public static TagReaderImpl newInstance(ImmutableSerializationContext serCtx, byte[] buf, int offset, int length) {
        return new TagReaderImpl((SerializationContextImpl)serCtx, (Decoder)new ByteArrayDecoder(buf, offset, length));
    }

    @Override
    public boolean isAtEnd() throws IOException {
        return this.decoder.isAtEnd();
    }

    @Override
    public int readTag() throws IOException {
        return this.decoder.readTag();
    }

    @Override
    public void checkLastTagWas(int tag) throws IOException {
        this.decoder.checkLastTagWas(tag);
    }

    @Override
    public boolean skipField(int tag) throws IOException {
        return this.decoder.skipField(tag);
    }

    @Override
    public long readUInt64() throws IOException {
        return this.decoder.readVarint64();
    }

    @Override
    public long readInt64() throws IOException {
        return this.decoder.readVarint64();
    }

    @Override
    public int readInt32() throws IOException {
        return this.decoder.readVarint32();
    }

    @Override
    public long readFixed64() throws IOException {
        return this.decoder.readFixed64();
    }

    @Override
    public int readFixed32() throws IOException {
        return this.decoder.readFixed32();
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.decoder.readFixed64());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.decoder.readFixed32());
    }

    @Override
    public boolean readBool() throws IOException {
        return this.decoder.readVarint64() != 0L;
    }

    @Override
    public String readString() throws IOException {
        return this.decoder.readString();
    }

    @Override
    public byte[] readByteArray() throws IOException {
        int length = this.decoder.readVarint32();
        return this.decoder.readRawByteArray(length);
    }

    @Override
    public ByteBuffer readByteBuffer() throws IOException {
        int length = this.decoder.readVarint32();
        return this.decoder.readRawByteBuffer(length);
    }

    @Override
    public int readUInt32() throws IOException {
        return this.decoder.readVarint32();
    }

    @Override
    public int readEnum() throws IOException {
        return this.decoder.readVarint32();
    }

    @Override
    public int readSFixed32() throws IOException {
        return this.decoder.readFixed32();
    }

    @Override
    public long readSFixed64() throws IOException {
        return this.decoder.readFixed64();
    }

    @Override
    public int readSInt32() throws IOException {
        int value = this.decoder.readVarint32();
        return value >>> 1 ^ -(value & 1);
    }

    @Override
    public long readSInt64() throws IOException {
        long value = this.decoder.readVarint64();
        return value >>> 1 ^ -(value & 1L);
    }

    @Override
    public int pushLimit(int limit) throws IOException {
        return this.decoder.pushLimit(limit);
    }

    @Override
    public void popLimit(int oldLimit) {
        this.decoder.popLimit(oldLimit);
    }

    @Override
    public SerializationContextImpl getSerializationContext() {
        return this.serCtx;
    }

    @Override
    public Object getParam(Object key) {
        if (this.parent != null) {
            return this.parent.getParam(key);
        }
        if (this.params == null) {
            return null;
        }
        return this.params.get(key);
    }

    @Override
    public void setParam(Object key, Object value) {
        if (this.parent != null) {
            this.parent.setParam(key, value);
        } else {
            if (this.params == null) {
                this.params = new HashMap<Object, Object>();
            }
            this.params.put(key, value);
        }
    }

    @Override
    public TagReader getReader() {
        return this;
    }

    @Override
    public byte[] fullBufferArray() throws IOException {
        this.checkBufferUnused("fullBufferArray");
        return this.decoder.getBufferArray();
    }

    @Override
    public InputStream fullBufferInputStream() throws IOException {
        this.checkBufferUnused("fullBufferInputStream");
        if (this.isInputStream()) {
            return ((InputStreamDecoder)this.decoder).getInputStream();
        }
        return new ByteArrayInputStream(this.decoder.getBufferArray());
    }

    private void checkBufferUnused(String methodName) {
        if (this.decoder.getPos() > 0) {
            throw new IllegalStateException(methodName + " in marshaller can only be used on an unprocessed buffer");
        }
    }

    @Override
    public boolean isInputStream() {
        return this.decoder instanceof InputStreamDecoder;
    }

    @Deprecated
    public ProtoStreamReaderImpl getProtoStreamReader() {
        if (this.parent != null) {
            return this.parent.getProtoStreamReader();
        }
        if (this.reader == null) {
            this.reader = new ProtoStreamReaderImpl(this, this.serCtx);
        }
        return this.reader;
    }

    private static final class InputStreamDecoder
    extends Decoder {
        private final InputStream in;
        private final byte[] buf;
        private int end;
        private int pos;
        private int bytesBeforeStart = 0;
        private int bytesAfterLimit = 0;
        private int limit = Integer.MAX_VALUE;

        private InputStreamDecoder(InputStream in, int bufferSize) {
            if (in == null) {
                throw new IllegalArgumentException("input stream cannot be null");
            }
            this.in = in;
            bufferSize = Math.max(bufferSize, 20);
            this.buf = new byte[bufferSize];
            this.end = 0;
            this.pos = 0;
        }

        @Override
        String readString() throws IOException {
            int length = this.readVarint32();
            if (length > 0 && length <= this.end - this.pos) {
                String value = new String(this.buf, this.pos, length, UTF8);
                this.pos += length;
                return value;
            }
            if (length == 0) {
                return "";
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            if (length <= this.buf.length) {
                this.fillBuffer(length);
                String value = new String(this.buf, this.pos, length, UTF8);
                this.pos += length;
                return value;
            }
            return new String(this.readRawBytesLarge(length), UTF8);
        }

        @Override
        ByteBuffer readRawByteBuffer(int length) throws IOException {
            if (length <= this.end - this.pos && length > 0) {
                int from = this.pos;
                this.pos += length;
                return ByteBuffer.wrap(Arrays.copyOfRange(this.buf, from, this.pos));
            }
            if (length == 0) {
                return EMPTY_BUFFER;
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            if (length <= this.buf.length) {
                this.fillBuffer(length);
                int from = this.pos;
                this.pos += length;
                return ByteBuffer.wrap(Arrays.copyOfRange(this.buf, from, this.pos));
            }
            return ByteBuffer.wrap(this.readRawBytesLarge(length));
        }

        @Override
        protected void skipVarint() throws IOException {
            if (this.end - this.pos >= 10) {
                for (int i = 0; i < 10; ++i) {
                    if (this.buf[this.pos++] < 0) continue;
                    return;
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    if (this.readRawByte() < 0) continue;
                    return;
                }
            }
            throw log.malformedVarint();
        }

        @Override
        long readVarint64() throws IOException {
            long value = 0L;
            if (this.end - this.pos >= 10) {
                for (int i = 0; i < 64; i += 7) {
                    byte b = this.buf[this.pos++];
                    value |= (long)(b & 0x7F) << i;
                    if (b < 0) continue;
                    return value;
                }
            } else {
                for (int i = 0; i < 64; i += 7) {
                    byte b = this.readRawByte();
                    value |= (long)(b & 0x7F) << i;
                    if (b < 0) continue;
                    return value;
                }
            }
            throw log.malformedVarint();
        }

        @Override
        int readFixed32() throws IOException {
            if (this.end - this.pos < 4) {
                this.fillBuffer(4);
            }
            int value = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8 | (this.buf[this.pos + 2] & 0xFF) << 16 | (this.buf[this.pos + 3] & 0xFF) << 24;
            this.pos += 4;
            return value;
        }

        @Override
        long readFixed64() throws IOException {
            if (this.end - this.pos < 8) {
                this.fillBuffer(8);
            }
            long value = (long)this.buf[this.pos] & 0xFFL | ((long)this.buf[this.pos + 1] & 0xFFL) << 8 | ((long)this.buf[this.pos + 2] & 0xFFL) << 16 | ((long)this.buf[this.pos + 3] & 0xFFL) << 24 | ((long)this.buf[this.pos + 4] & 0xFFL) << 32 | ((long)this.buf[this.pos + 5] & 0xFFL) << 40 | ((long)this.buf[this.pos + 6] & 0xFFL) << 48 | ((long)this.buf[this.pos + 7] & 0xFFL) << 56;
            this.pos += 8;
            return value;
        }

        @Override
        int setGlobalLimit(int globalLimit) {
            if (globalLimit < 0) {
                throw new IllegalArgumentException("Global limit cannot be negative: " + globalLimit);
            }
            int oldGlobalLimit = this.globalLimit;
            this.globalLimit = globalLimit;
            return oldGlobalLimit;
        }

        @Override
        int pushLimit(int limit) throws IOException {
            if (limit < 0) {
                throw log.negativeLength();
            }
            int oldLimit = this.limit;
            if ((limit = this.bytesBeforeStart + this.pos + limit) > oldLimit) {
                throw log.messageTruncated();
            }
            this.limit = limit;
            this.adjustEnd();
            return oldLimit;
        }

        @Override
        void popLimit(int oldLimit) {
            this.limit = oldLimit;
            this.adjustEnd();
        }

        private void adjustEnd() {
            this.end += this.bytesAfterLimit;
            int absEnd = this.bytesBeforeStart + this.end;
            if (absEnd > this.limit) {
                this.bytesAfterLimit = absEnd - this.limit;
                this.end -= this.bytesAfterLimit;
            } else {
                this.bytesAfterLimit = 0;
            }
        }

        @Override
        int getEnd() {
            return this.end;
        }

        @Override
        int getPos() {
            return this.pos;
        }

        @Override
        byte[] getBufferArray() throws IOException {
            this.fillBuffer(this.buf.length);
            return this.buf;
        }

        InputStream getInputStream() {
            return this.in;
        }

        @Override
        boolean isAtEnd() throws IOException {
            return this.pos == this.end && !this.tryFillBuffer(1);
        }

        private void fillBuffer(int requestedBytes) throws IOException {
            if (!this.tryFillBuffer(requestedBytes)) {
                throw log.messageTruncated();
            }
        }

        private boolean tryFillBuffer(int requestedBytes) throws IOException {
            int read;
            if (requestedBytes + this.pos <= this.end) {
                return true;
            }
            if (requestedBytes + this.bytesBeforeStart + this.pos > this.limit) {
                return false;
            }
            if (this.pos > 0) {
                if (this.end > this.pos) {
                    System.arraycopy(this.buf, this.pos, this.buf, 0, this.end - this.pos);
                }
                this.bytesBeforeStart += this.pos;
                this.end -= this.pos;
                this.pos = 0;
            }
            if ((read = this.in.read(this.buf, this.end, this.buf.length - this.end)) <= 0) {
                return false;
            }
            this.end += read;
            if (requestedBytes + this.bytesBeforeStart - this.globalLimit > 0) {
                throw log.globalLimitExceeded();
            }
            this.adjustEnd();
            return this.end >= requestedBytes || this.end == this.buf.length || this.tryFillBuffer(requestedBytes);
        }

        @Override
        byte readRawByte() throws IOException {
            if (this.pos == this.end) {
                this.fillBuffer(1);
            }
            return this.buf[this.pos++];
        }

        @Override
        byte[] readRawByteArray(int length) throws IOException {
            if (length > 0 && length <= this.end - this.pos) {
                int from = this.pos;
                this.pos += length;
                return Arrays.copyOfRange(this.buf, from, this.pos);
            }
            if (length == 0) {
                return EMPTY;
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            if (length <= this.buf.length) {
                this.fillBuffer(length);
                int from = this.pos;
                this.pos += length;
                return Arrays.copyOfRange(this.buf, from, this.pos);
            }
            return this.readRawBytesLarge(length);
        }

        private byte[] readRawBytesLarge(int length) throws IOException {
            int segPos;
            if (length < 0) {
                throw new IllegalArgumentException("Length must not be negative");
            }
            int total = this.bytesBeforeStart + this.pos + length;
            if (total - this.globalLimit > 0) {
                throw log.globalLimitExceeded();
            }
            if (total > this.limit) {
                this.skipRawBytes(this.limit - this.bytesBeforeStart - this.pos);
                throw log.messageTruncated();
            }
            int buffered = this.end - this.pos;
            int needed = length - buffered;
            if (needed <= 0) {
                throw new IllegalStateException("The needed data already exists in buffer!");
            }
            int oldPos = this.pos;
            this.bytesBeforeStart += this.end;
            this.pos = 0;
            this.end = 0;
            if (needed < 4096 || needed <= this.in.available()) {
                byte[] bytes = new byte[length];
                System.arraycopy(this.buf, oldPos, bytes, 0, buffered);
                while (buffered < bytes.length) {
                    int read = this.in.read(bytes, buffered, length - buffered);
                    if (read <= 0) {
                        throw log.messageTruncated();
                    }
                    this.bytesBeforeStart += read;
                    buffered += read;
                }
                return bytes;
            }
            ArrayList<byte[]> segments = new ArrayList<byte[]>();
            while (needed > 0) {
                byte[] segment = new byte[Math.min(needed, 4096)];
                segPos = 0;
                while (segPos < segment.length) {
                    int read = this.in.read(segment, segPos, segment.length - segPos);
                    if (read <= 0) {
                        throw log.messageTruncated();
                    }
                    segPos += read;
                    this.bytesBeforeStart += read;
                }
                segments.add(segment);
                needed -= segment.length;
            }
            byte[] bytes = new byte[length];
            System.arraycopy(this.buf, oldPos, bytes, 0, buffered);
            segPos = buffered;
            for (int i = 0; i < segments.size(); ++i) {
                byte[] segment = (byte[])segments.get(i);
                System.arraycopy(segment, 0, bytes, segPos, segment.length);
                segPos += segment.length;
                segments.set(i, null);
            }
            return bytes;
        }

        @Override
        protected void skipRawBytes(int length) throws IOException {
            if (length <= this.end - this.pos && length >= 0) {
                this.pos += length;
            } else {
                if (length < 0) {
                    throw log.negativeLength();
                }
                if (this.bytesBeforeStart + this.pos + length > this.limit) {
                    this.skipRawBytes(this.limit - this.bytesBeforeStart - this.pos);
                    throw log.messageTruncated();
                }
                length -= this.end - this.pos;
                while (true) {
                    this.pos = this.end;
                    this.fillBuffer(1);
                    if (length <= this.end) {
                        this.pos = length;
                        break;
                    }
                    length -= this.end;
                }
            }
        }
    }

    private static final class ByteBufferDecoder
    extends Decoder {
        private final ByteBuffer buf;
        private final int start;
        private final int stop;
        private int end;
        private int limit;

        private ByteBufferDecoder(ByteBuffer buf) {
            this.buf = buf;
            this.start = buf.position();
            this.limit = buf.remaining();
            this.stop = this.end = this.start + this.limit;
        }

        @Override
        int pushLimit(int limit) throws IOException {
            int oldLimit;
            if (limit < 0) {
                throw log.negativeLength();
            }
            if ((limit += this.buf.position() - this.start) > (oldLimit = this.limit)) {
                throw log.messageTruncated();
            }
            this.limit = limit;
            this.adjustEnd();
            return oldLimit;
        }

        @Override
        void popLimit(int oldLimit) {
            this.limit = oldLimit;
            this.adjustEnd();
        }

        private void adjustEnd() {
            this.end = this.stop - this.start > this.limit ? this.start + this.limit : this.stop;
        }

        @Override
        int getEnd() {
            return this.end;
        }

        @Override
        int getPos() {
            return this.buf.position() - this.start;
        }

        @Override
        byte[] getBufferArray() throws IOException {
            return this.buf.array();
        }

        @Override
        boolean isAtEnd() {
            return this.buf.position() == this.end;
        }

        @Override
        String readString() throws IOException {
            int length = this.readVarint32();
            if (length > 0 && length <= this.end - this.buf.position()) {
                byte[] bytes = new byte[length];
                this.buf.get(bytes);
                return new String(bytes, 0, length, UTF8);
            }
            if (length == 0) {
                return "";
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        ByteBuffer readRawByteBuffer(int length) throws IOException {
            if (length > 0 && length <= this.end - this.buf.position()) {
                ByteBuffer byteBuffer = this.buf.slice().limit(length);
                this.buf.position(this.buf.position() + length);
                return byteBuffer;
            }
            if (length == 0) {
                return EMPTY_BUFFER;
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        protected void skipVarint() throws IOException {
            if (this.end - this.buf.position() >= 10) {
                for (int i = 0; i < 10; ++i) {
                    if (this.buf.get() < 0) continue;
                    return;
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    if (this.readRawByte() < 0) continue;
                    return;
                }
            }
            throw log.malformedVarint();
        }

        @Override
        long readVarint64() throws IOException {
            long value = 0L;
            if (this.end - this.buf.position() >= 10) {
                for (int i = 0; i < 64; i += 7) {
                    byte b = this.buf.get();
                    value |= (long)(b & 0x7F) << i;
                    if (b < 0) continue;
                    return value;
                }
            } else {
                for (int i = 0; i < 64; i += 7) {
                    byte b = this.readRawByte();
                    value |= (long)(b & 0x7F) << i;
                    if (b < 0) continue;
                    return value;
                }
            }
            throw log.malformedVarint();
        }

        @Override
        int readFixed32() throws IOException {
            try {
                return this.buf.getInt();
            }
            catch (BufferUnderflowException e) {
                throw log.messageTruncated(e);
            }
        }

        @Override
        long readFixed64() throws IOException {
            try {
                return this.buf.getLong();
            }
            catch (BufferUnderflowException e) {
                throw log.messageTruncated(e);
            }
        }

        @Override
        byte readRawByte() throws IOException {
            try {
                return this.buf.get();
            }
            catch (BufferUnderflowException e) {
                throw log.messageTruncated(e);
            }
        }

        @Override
        byte[] readRawByteArray(int length) throws IOException {
            if (length > 0 && length <= this.end - this.buf.position()) {
                byte[] bytes = new byte[length];
                this.buf.get(bytes);
                return bytes;
            }
            if (length == 0) {
                return EMPTY;
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        protected void skipRawBytes(int length) throws IOException {
            if (length < 0) {
                throw log.negativeLength();
            }
            if (length <= this.end - this.buf.position()) {
                this.buf.position(this.buf.position() + length);
                return;
            }
            throw log.messageTruncated();
        }

        @Override
        int setGlobalLimit(int globalLimit) {
            return Integer.MAX_VALUE;
        }
    }

    private static final class ByteArrayDecoder
    extends Decoder {
        private final byte[] array;
        private final int start;
        private final int stop;
        private int pos;
        private int end;
        private int limit;

        private ByteArrayDecoder(byte[] array, int offset, int length) {
            if (array == null) {
                throw new IllegalArgumentException("array cannot be null");
            }
            if (offset < 0) {
                throw new IllegalArgumentException("offset cannot be negative");
            }
            if (length < 0) {
                throw new IllegalArgumentException("length cannot be negative");
            }
            if (offset > array.length) {
                throw new IllegalArgumentException("start position is outside array bounds");
            }
            if (offset + length > array.length) {
                throw new IllegalArgumentException("end position is outside array bounds");
            }
            this.array = array;
            this.start = this.pos = offset;
            this.limit = length;
            this.stop = this.end = offset + length;
            this.adjustEnd();
        }

        @Override
        int pushLimit(int limit) throws IOException {
            if (limit < 0) {
                throw log.negativeLength();
            }
            int oldLimit = this.limit;
            if ((limit += this.pos - this.start) > oldLimit) {
                throw log.messageTruncated();
            }
            this.limit = limit;
            this.adjustEnd();
            return oldLimit;
        }

        @Override
        void popLimit(int oldLimit) {
            this.limit = oldLimit;
            this.adjustEnd();
        }

        private void adjustEnd() {
            this.end = this.stop - this.start > this.limit ? this.start + this.limit : this.stop;
        }

        @Override
        int getEnd() {
            return this.end;
        }

        @Override
        int getPos() {
            return this.pos;
        }

        @Override
        byte[] getBufferArray() throws IOException {
            return this.array;
        }

        @Override
        boolean isAtEnd() {
            return this.pos == this.end;
        }

        @Override
        String readString() throws IOException {
            int length = this.readVarint32();
            if (length > 0 && length <= this.end - this.pos) {
                String value = new String(this.array, this.pos, length, UTF8);
                this.pos += length;
                return value;
            }
            if (length == 0) {
                return "";
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        ByteBuffer readRawByteBuffer(int length) throws IOException {
            if (length > 0 && length <= this.end - this.pos) {
                int from = this.pos;
                this.pos += length;
                return ByteBuffer.wrap(this.array, from, length).slice();
            }
            if (length == 0) {
                return EMPTY_BUFFER;
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        protected void skipVarint() throws IOException {
            if (this.end - this.pos >= 10) {
                for (int i = 0; i < 10; ++i) {
                    if (this.array[this.pos++] < 0) continue;
                    return;
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    if (this.readRawByte() < 0) continue;
                    return;
                }
            }
            throw log.malformedVarint();
        }

        @Override
        long readVarint64() throws IOException {
            long value = 0L;
            if (this.end - this.pos >= 10) {
                for (int i = 0; i < 64; i += 7) {
                    byte b = this.array[this.pos++];
                    value |= (long)(b & 0x7F) << i;
                    if (b < 0) continue;
                    return value;
                }
            } else {
                for (int i = 0; i < 64; i += 7) {
                    byte b = this.readRawByte();
                    value |= (long)(b & 0x7F) << i;
                    if (b < 0) continue;
                    return value;
                }
            }
            throw log.malformedVarint();
        }

        @Override
        int readFixed32() throws IOException {
            try {
                int value = this.array[this.pos] & 0xFF | (this.array[this.pos + 1] & 0xFF) << 8 | (this.array[this.pos + 2] & 0xFF) << 16 | (this.array[this.pos + 3] & 0xFF) << 24;
                this.pos += 4;
                return value;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw log.messageTruncated(e);
            }
        }

        @Override
        long readFixed64() throws IOException {
            try {
                long value = (long)this.array[this.pos] & 0xFFL | ((long)this.array[this.pos + 1] & 0xFFL) << 8 | ((long)this.array[this.pos + 2] & 0xFFL) << 16 | ((long)this.array[this.pos + 3] & 0xFFL) << 24 | ((long)this.array[this.pos + 4] & 0xFFL) << 32 | ((long)this.array[this.pos + 5] & 0xFFL) << 40 | ((long)this.array[this.pos + 6] & 0xFFL) << 48 | ((long)this.array[this.pos + 7] & 0xFFL) << 56;
                this.pos += 8;
                return value;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw log.messageTruncated(e);
            }
        }

        @Override
        byte readRawByte() throws IOException {
            try {
                return this.array[this.pos++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw log.messageTruncated(e);
            }
        }

        @Override
        byte[] readRawByteArray(int length) throws IOException {
            if (length > 0 && length <= this.end - this.pos) {
                int from = this.pos;
                this.pos += length;
                return Arrays.copyOfRange(this.array, from, this.pos);
            }
            if (length == 0) {
                return EMPTY;
            }
            if (length < 0) {
                throw log.negativeLength();
            }
            throw log.messageTruncated();
        }

        @Override
        protected void skipRawBytes(int length) throws IOException {
            if (length < 0) {
                throw log.negativeLength();
            }
            if (length <= this.end - this.pos) {
                this.pos += length;
                return;
            }
            throw log.messageTruncated();
        }

        @Override
        int setGlobalLimit(int globalLimit) {
            return Integer.MAX_VALUE;
        }
    }

    private static abstract class Decoder {
        protected int globalLimit = Integer.MAX_VALUE;
        protected int lastTag;

        private Decoder() {
        }

        abstract int getEnd();

        abstract int getPos();

        abstract byte[] getBufferArray() throws IOException;

        abstract boolean isAtEnd() throws IOException;

        final int readTag() throws IOException {
            if (this.isAtEnd()) {
                this.lastTag = 0;
                return 0;
            }
            long tag = this.readVarint64();
            this.lastTag = (int)tag;
            if ((long)this.lastTag != tag) {
                throw new MalformedProtobufException("Found a protobuf tag (" + tag + ") greater than the largest allowed value");
            }
            WireType.fromTag(this.lastTag);
            if (WireType.getTagFieldNumber(this.lastTag) >= 1) {
                return this.lastTag;
            }
            throw new MalformedProtobufException("Found an invalid protobuf tag (" + this.lastTag + ") having a field number smaller than 1");
        }

        final void checkLastTagWas(int expectedTag) throws IOException {
            if (this.lastTag == expectedTag || expectedTag == 0 && this.isAtEnd()) {
                return;
            }
            if (expectedTag == 0) {
                throw new MalformedProtobufException("Expected ond of message but found tag " + this.lastTag);
            }
            throw new MalformedProtobufException("Protobuf message end group tag expected but found " + this.lastTag);
        }

        final boolean skipField(int tag) throws IOException {
            switch (WireType.getTagWireType(tag)) {
                case 0: {
                    this.skipVarint();
                    return true;
                }
                case 5: {
                    this.skipRawBytes(4);
                    return true;
                }
                case 1: {
                    this.skipRawBytes(8);
                    return true;
                }
                case 2: {
                    this.skipRawBytes(this.readVarint32());
                    return true;
                }
                case 3: {
                    int t;
                    while ((t = this.readTag()) != 0 && this.skipField(t)) {
                    }
                    this.checkLastTagWas(WireType.makeTag(WireType.getTagFieldNumber(tag), 4));
                    return true;
                }
                case 4: {
                    return false;
                }
            }
            throw new MalformedProtobufException("Found a protobuf tag with invalid wire type : " + tag);
        }

        abstract void skipVarint() throws IOException;

        abstract void skipRawBytes(int var1) throws IOException;

        abstract String readString() throws IOException;

        abstract byte readRawByte() throws IOException;

        abstract byte[] readRawByteArray(int var1) throws IOException;

        abstract ByteBuffer readRawByteBuffer(int var1) throws IOException;

        final int readVarint32() throws IOException {
            return (int)this.readVarint64();
        }

        abstract long readVarint64() throws IOException;

        abstract int readFixed32() throws IOException;

        abstract long readFixed64() throws IOException;

        abstract int pushLimit(int var1) throws IOException;

        abstract void popLimit(int var1);

        abstract int setGlobalLimit(int var1);
    }
}

