/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.junit.SkipTestDependingOnAdapterNameRule;
import io.debezium.connector.oracle.junit.SkipWhenAdapterNameIsNot;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import io.debezium.doc.FixFor;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@SkipWhenAdapterNameIsNot(value=SkipWhenAdapterNameIsNot.AdapterName.LOGMINER)
public class LogMinerEventRowTest {
    @Rule
    public TestRule skipRule = new SkipTestDependingOnAdapterNameRule();
    private static final String CATALOG_NAME = "DEBEZIUM";
    private ResultSet resultSet;

    @Before
    public void before() {
        this.resultSet = (ResultSet)Mockito.mock(ResultSet.class);
    }

    @Test
    public void testChangeTime() throws Exception {
        Mockito.when((Object)this.resultSet.getTimestamp(ArgumentMatchers.eq((int)4), (Calendar)ArgumentMatchers.any(Calendar.class))).thenReturn((Object)new Timestamp(1000L));
        LogMinerEventRow row = LogMinerEventRow.fromResultSet((ResultSet)this.resultSet, (String)CATALOG_NAME, (boolean)true);
        Assertions.assertThat((Instant)row.getChangeTime()).isEqualTo((Object)Instant.ofEpochMilli(1000L));
        Mockito.when((Object)this.resultSet.getTimestamp(ArgumentMatchers.eq((int)4), (Calendar)ArgumentMatchers.any(Calendar.class))).thenThrow(SQLException.class);
        LogMinerEventRowTest.assertThrows(this.resultSet, SQLException.class);
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)2))).getTimestamp(ArgumentMatchers.eq((int)4), (Calendar)ArgumentMatchers.any(Calendar.class));
    }

    @Test
    public void testEventType() throws Exception {
        Mockito.when((Object)this.resultSet.getInt(3)).thenReturn((Object)EventType.UPDATE.getValue());
        LogMinerEventRow row = LogMinerEventRow.fromResultSet((ResultSet)this.resultSet, (String)CATALOG_NAME, (boolean)true);
        Assertions.assertThat((Comparable)row.getEventType()).isEqualTo((Object)EventType.UPDATE);
        ((ResultSet)Mockito.verify((Object)this.resultSet)).getInt(3);
        Mockito.when((Object)this.resultSet.getInt(3)).thenThrow(SQLException.class);
        LogMinerEventRowTest.assertThrows(this.resultSet, SQLException.class);
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)2))).getInt(3);
    }

    @Test
    public void testTableName() throws Exception {
        Mockito.when((Object)this.resultSet.getString(7)).thenReturn((Object)"TABLENAME");
        LogMinerEventRow row = LogMinerEventRow.fromResultSet((ResultSet)this.resultSet, (String)CATALOG_NAME, (boolean)true);
        Assertions.assertThat((String)row.getTableName()).isEqualTo((Object)"TABLENAME");
        ((ResultSet)Mockito.verify((Object)this.resultSet)).getString(7);
        Mockito.when((Object)this.resultSet.getString(7)).thenThrow(SQLException.class);
        LogMinerEventRowTest.assertThrows(this.resultSet, SQLException.class);
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)2))).getString(7);
    }

    @Test
    public void testTablespaceName() throws Exception {
        Mockito.when((Object)this.resultSet.getString(8)).thenReturn((Object)CATALOG_NAME);
        LogMinerEventRow row = LogMinerEventRow.fromResultSet((ResultSet)this.resultSet, (String)CATALOG_NAME, (boolean)true);
        Assertions.assertThat((String)row.getTablespaceName()).isEqualTo((Object)CATALOG_NAME);
        ((ResultSet)Mockito.verify((Object)this.resultSet)).getString(8);
        Mockito.when((Object)this.resultSet.getString(8)).thenThrow(SQLException.class);
        LogMinerEventRowTest.assertThrows(this.resultSet, SQLException.class);
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)2))).getString(8);
    }

    @Test
    public void testScn() throws Exception {
        Mockito.when((Object)this.resultSet.getString(1)).thenReturn((Object)"12345");
        LogMinerEventRow row = LogMinerEventRow.fromResultSet((ResultSet)this.resultSet, (String)CATALOG_NAME, (boolean)true);
        Assertions.assertThat((Comparable)row.getScn()).isEqualTo((Object)Scn.valueOf((long)12345L));
        ((ResultSet)Mockito.verify((Object)this.resultSet)).getString(1);
        Mockito.when((Object)this.resultSet.getString(1)).thenThrow(SQLException.class);
        LogMinerEventRowTest.assertThrows(this.resultSet, SQLException.class);
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)2))).getString(1);
    }

    @Test
    public void testTransactionId() throws Exception {
        Mockito.when((Object)this.resultSet.getBytes(5)).thenReturn((Object)"tr_id".getBytes(StandardCharsets.UTF_8));
        LogMinerEventRow row = LogMinerEventRow.fromResultSet((ResultSet)this.resultSet, (String)CATALOG_NAME, (boolean)true);
        Assertions.assertThat((String)row.getTransactionId()).isEqualToIgnoringCase((CharSequence)"74725F6964");
        ((ResultSet)Mockito.verify((Object)this.resultSet)).getBytes(5);
        Mockito.when((Object)this.resultSet.getBytes(5)).thenThrow(SQLException.class);
        LogMinerEventRowTest.assertThrows(this.resultSet, SQLException.class);
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)2))).getBytes(5);
    }

    @Test
    public void testTableId() throws Exception {
        Mockito.when((Object)this.resultSet.getString(8)).thenReturn((Object)"SCHEMA");
        Mockito.when((Object)this.resultSet.getString(7)).thenReturn((Object)"TABLE");
        LogMinerEventRow row = LogMinerEventRow.fromResultSet((ResultSet)this.resultSet, (String)CATALOG_NAME, (boolean)true);
        Assertions.assertThat((String)row.getTableId().toString()).isEqualTo((Object)"DEBEZIUM.SCHEMA.TABLE");
        ((ResultSet)Mockito.verify((Object)this.resultSet)).getString(8);
        Mockito.when((Object)this.resultSet.getString(8)).thenThrow(SQLException.class);
        LogMinerEventRowTest.assertThrows(this.resultSet, SQLException.class);
    }

    @Test
    @FixFor(value={"DBZ-2555"})
    public void tesetTableIdWithVariedCase() throws Exception {
        Mockito.when((Object)this.resultSet.getString(8)).thenReturn((Object)"Schema");
        Mockito.when((Object)this.resultSet.getString(7)).thenReturn((Object)"table");
        LogMinerEventRow row = LogMinerEventRow.fromResultSet((ResultSet)this.resultSet, (String)CATALOG_NAME, (boolean)true);
        Assertions.assertThat((String)row.getTableId().toString()).isEqualTo((Object)"DEBEZIUM.Schema.table");
        ((ResultSet)Mockito.verify((Object)this.resultSet)).getString(8);
        Mockito.when((Object)this.resultSet.getString(8)).thenThrow(SQLException.class);
        LogMinerEventRowTest.assertThrows(this.resultSet, SQLException.class);
    }

    @Test
    public void testSqlRedo() throws Exception {
        Mockito.when((Object)this.resultSet.getInt(6)).thenReturn((Object)0);
        Mockito.when((Object)this.resultSet.getString(2)).thenReturn((Object)"short_sql");
        LogMinerEventRow row = LogMinerEventRow.fromResultSet((ResultSet)this.resultSet, (String)CATALOG_NAME, (boolean)true);
        Assertions.assertThat((String)row.getRedoSql()).isEqualTo((Object)"short_sql");
        ((ResultSet)Mockito.verify((Object)this.resultSet)).getInt(6);
        ((ResultSet)Mockito.verify((Object)this.resultSet)).getString(2);
        Mockito.when((Object)this.resultSet.getInt(6)).thenReturn((Object)1).thenReturn((Object)0);
        Mockito.when((Object)this.resultSet.getString(2)).thenReturn((Object)"long").thenReturn((Object)"_sql");
        row = LogMinerEventRow.fromResultSet((ResultSet)this.resultSet, (String)CATALOG_NAME, (boolean)true);
        Assertions.assertThat((String)row.getRedoSql()).isEqualTo((Object)"long_sql");
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)3))).getInt(6);
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)3))).getString(2);
        char[] chars = new char[4000];
        Arrays.fill(chars, 'a');
        Mockito.when((Object)this.resultSet.getString(2)).thenReturn((Object)new String(chars));
        Mockito.when((Object)this.resultSet.getInt(6)).thenReturn((Object)1, (Object[])new Integer[]{1, 1, 1, 1, 1, 1, 1, 1, 0});
        row = LogMinerEventRow.fromResultSet((ResultSet)this.resultSet, (String)CATALOG_NAME, (boolean)true);
        Assertions.assertThat((int)row.getRedoSql().length()).isEqualTo(40000);
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)13))).getInt(6);
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)13))).getString(2);
        Mockito.when((Object)this.resultSet.getInt(6)).thenReturn((Object)0);
        Mockito.when((Object)this.resultSet.getString(2)).thenReturn(null);
        row = LogMinerEventRow.fromResultSet((ResultSet)this.resultSet, (String)CATALOG_NAME, (boolean)true);
        Assertions.assertThat((String)row.getRedoSql()).isNull();
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)13))).getInt(6);
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)14))).getString(2);
        Mockito.when((Object)this.resultSet.getInt(6)).thenReturn((Object)0);
        Mockito.when((Object)this.resultSet.getString(2)).thenThrow(SQLException.class);
        LogMinerEventRowTest.assertThrows(this.resultSet, SQLException.class);
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)13))).getInt(6);
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)15))).getString(2);
    }

    private static <T extends Throwable, R> void assertThrows(ResultSet rs, Class<T> throwAs) {
        try {
            LogMinerEventRow.fromResultSet((ResultSet)rs, (String)CATALOG_NAME, (boolean)true);
            Assertions.fail((String)("Should have thrown a " + throwAs.getSimpleName()));
        }
        catch (Throwable t) {
            Assertions.assertThat((Throwable)t).isInstanceOf(throwAs);
        }
    }
}

