/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnector;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.util.TestHelper;
import io.debezium.data.VerifyRecord;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.junit.SkipTestRule;
import io.debezium.pipeline.source.snapshot.incremental.AbstractIncrementalSnapshotTest;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class IncrementalSnapshotCaseSensitiveIT
extends AbstractIncrementalSnapshotTest<OracleConnector> {
    private OracleConnection connection;
    @Rule
    public SkipTestRule skipRule = new SkipTestRule();

    @Before
    public void before() throws Exception {
        this.connection = TestHelper.testConnection();
        TestHelper.dropTable(this.connection, "a");
        TestHelper.dropTable(this.connection, "b");
        this.connection.execute(new String[]{"CREATE TABLE a (\"Pk\" numeric(9,0) primary key, aa numeric(9,0))"});
        this.connection.execute(new String[]{"CREATE TABLE b (\"Pk\" numeric(9,0) primary key, aa numeric(9,0))"});
        TestHelper.dropTable(this.connection, "debezium_signal");
        this.connection.execute(new String[]{"CREATE TABLE debezium_signal (id varchar2(64), type varchar2(32), data varchar2(2048))"});
        this.connection.execute(new String[]{"GRANT INSERT on debezium_signal to " + TestHelper.getConnectorUserName()});
        TestHelper.streamTable(this.connection, "debezium_signal");
        this.setConsumeTimeout(TestHelper.defaultMessageConsumerPollTimeout(), TimeUnit.SECONDS);
        this.initializeConnectorTestFramework();
        Testing.Files.delete((Path)TestHelper.SCHEMA_HISTORY_PATH);
    }

    @After
    public void after() throws Exception {
        this.stopConnector();
        if (this.connection != null) {
            TestHelper.dropTable(this.connection, "a");
            TestHelper.dropTable(this.connection, "b");
            TestHelper.dropTable(this.connection, "debezium_signal");
            this.connection.close();
        }
    }

    protected void waitForConnectorToStart() {
        super.waitForConnectorToStart();
        try {
            IncrementalSnapshotCaseSensitiveIT.waitForStreamingRunning((String)"oracle", (String)"server1");
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void populateTable() throws SQLException {
        super.populateTable();
        TestHelper.streamTable(this.connection, "a");
    }

    protected void populateTables() throws SQLException {
        super.populateTables();
        TestHelper.streamTable(this.connection, "a");
        TestHelper.streamTable(this.connection, "b");
    }

    protected Class<OracleConnector> connectorClass() {
        return OracleConnector.class;
    }

    protected JdbcConnection databaseConnection() {
        return this.connection;
    }

    protected String topicName() {
        return "server1.DEBEZIUM.A";
    }

    protected List<String> topicNames() {
        return List.of("server1.DEBEZIUM.A", "server1.DEBEZIUM.B");
    }

    protected String tableName() {
        return "DEBEZIUM.A";
    }

    protected List<String> tableNames() {
        return List.of("DEBEZIUM.A", "DEBEZIUM.B");
    }

    protected String tableDataCollectionId() {
        return TestHelper.getDatabaseName() + ".DEBEZIUM.A";
    }

    protected List<String> tableDataCollectionIds() {
        return List.of(TestHelper.getDatabaseName() + ".DEBEZIUM.A", TestHelper.getDatabaseName() + ".DEBEZIUM.B");
    }

    protected String signalTableName() {
        return "DEBEZIUM.DEBEZIUM_SIGNAL";
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.SCHEMA_ONLY)).with(OracleConnectorConfig.SIGNAL_DATA_COLLECTION, TestHelper.getDatabaseName() + ".DEBEZIUM.DEBEZIUM_SIGNAL")).with(OracleConnectorConfig.TABLE_INCLUDE_LIST, "DEBEZIUM\\.A,DEBEZIUM\\.B")).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, true);
    }

    protected Configuration.Builder mutableConfig(boolean signalTableOnly, boolean storeOnlyCapturedDdl) {
        String tableIncludeList = signalTableOnly ? "DEBEZIUM\\.B" : "DEBEZIUM\\.A,DEBEZIUM\\.B";
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.defaultConfig().with(OracleConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)OracleConnectorConfig.SnapshotMode.INITIAL)).with(OracleConnectorConfig.SIGNAL_DATA_COLLECTION, TestHelper.getDatabaseName() + ".DEBEZIUM.DEBEZIUM_SIGNAL")).with(OracleConnectorConfig.TABLE_INCLUDE_LIST, tableIncludeList)).with(SchemaHistory.STORE_ONLY_CAPTURED_TABLES_DDL, storeOnlyCapturedDdl);
    }

    protected String valueFieldName() {
        return "AA";
    }

    protected String pkFieldName() {
        return "Pk";
    }

    protected String getSignalTypeFieldName() {
        return "TYPE";
    }

    protected String alterTableAddColumnStatement(String tableName) {
        return "ALTER TABLE " + tableName + " ADD col3 INTEGER DEFAULT 0";
    }

    protected int defaultIncrementalSnapshotChunkSize() {
        return 250;
    }

    protected String connector() {
        return "oracle";
    }

    protected String server() {
        return "server1";
    }

    @Test
    public void snapshotPreceededBySchemaChange() throws Exception {
        if (VerifyRecord.isApucurioAvailable()) {
            this.skipAvroValidation();
        }
        super.snapshotPreceededBySchemaChange();
    }
}

