/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.OracleOffsetContext;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleStreamingChangeEventSourceMetrics;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.LogFile;
import io.debezium.connector.oracle.logminer.LogMinerDatabaseStateWriter;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.SqlUtils;
import io.debezium.connector.oracle.logminer.logwriter.CommitLogWriterFlushStrategy;
import io.debezium.connector.oracle.logminer.logwriter.LogWriterFlushStrategy;
import io.debezium.connector.oracle.logminer.logwriter.RacCommitLogWriterFlushStrategy;
import io.debezium.connector.oracle.logminer.logwriter.ReadOnlyLogWriterFlushStrategy;
import io.debezium.connector.oracle.logminer.processor.LogMinerEventProcessor;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import io.debezium.util.Stopwatch;
import java.math.BigInteger;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerStreamingChangeEventSource
implements StreamingChangeEventSource<OraclePartition, OracleOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerStreamingChangeEventSource.class);
    private static final int MAXIMUM_NAME_LENGTH = 30;
    private static final String ALL_COLUMN_LOGGING = "ALL COLUMN LOGGING";
    private static final int MINING_START_RETRIES = 5;
    private static final Long SMALL_REDO_LOG_WARNING = 524288000L;
    private final OracleConnection jdbcConnection;
    private final EventDispatcher<OraclePartition, TableId> dispatcher;
    private final Clock clock;
    private final OracleDatabaseSchema schema;
    private final JdbcConfiguration jdbcConfiguration;
    private final OracleConnectorConfig.LogMiningStrategy strategy;
    private final ErrorHandler errorHandler;
    private final boolean isContinuousMining;
    private final OracleStreamingChangeEventSourceMetrics streamingMetrics;
    private final OracleConnectorConfig connectorConfig;
    private final Duration archiveLogRetention;
    private final boolean archiveLogOnlyMode;
    private final String archiveDestinationName;
    private final int logFileQueryMaxRetries;
    private final Duration initialDelay;
    private final Duration maxDelay;
    private Scn startScn;
    private Scn endScn;
    private Scn snapshotScn;
    private List<LogFile> currentLogFiles;
    private List<BigInteger> currentRedoLogSequences;
    private OracleOffsetContext effectiveOffset;

    public LogMinerStreamingChangeEventSource(OracleConnectorConfig connectorConfig, OracleConnection jdbcConnection, EventDispatcher<OraclePartition, TableId> dispatcher, ErrorHandler errorHandler, Clock clock, OracleDatabaseSchema schema, Configuration jdbcConfig, OracleStreamingChangeEventSourceMetrics streamingMetrics) {
        this.jdbcConnection = jdbcConnection;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.schema = schema;
        this.connectorConfig = connectorConfig;
        this.strategy = connectorConfig.getLogMiningStrategy();
        this.isContinuousMining = connectorConfig.isContinuousMining();
        this.errorHandler = errorHandler;
        this.streamingMetrics = streamingMetrics;
        this.jdbcConfiguration = JdbcConfiguration.adapt((Configuration)jdbcConfig);
        this.archiveLogRetention = connectorConfig.getLogMiningArchiveLogRetention();
        this.archiveLogOnlyMode = connectorConfig.isArchiveLogOnlyMode();
        this.archiveDestinationName = connectorConfig.getLogMiningArchiveDestinationName();
        this.logFileQueryMaxRetries = connectorConfig.getMaximumNumberOfLogQueryRetries();
        this.initialDelay = connectorConfig.getLogMiningInitialDelay();
        this.maxDelay = connectorConfig.getLogMiningMaxDelay();
    }

    public void init(OracleOffsetContext offsetContext) throws InterruptedException {
        this.effectiveOffset = offsetContext == null ? this.emptyContext() : offsetContext;
    }

    private OracleOffsetContext emptyContext() {
        return OracleOffsetContext.create().logicalName(this.connectorConfig).snapshotPendingTransactions(Collections.emptyMap()).transactionContext(new TransactionContext()).incrementalSnapshotContext((IncrementalSnapshotContext<TableId>)new SignalBasedIncrementalSnapshotContext()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ChangeEventSource.ChangeEventSourceContext context, OraclePartition partition, OracleOffsetContext offsetContext) {
        if (!this.connectorConfig.getSnapshotMode().shouldStream()) {
            LOGGER.info("Streaming is not enabled in current configuration");
            return;
        }
        try {
            this.prepareConnection(false);
            this.effectiveOffset = offsetContext;
            this.startScn = offsetContext.getScn();
            this.snapshotScn = offsetContext.getSnapshotScn();
            Scn firstScn = this.getFirstScnInLogs(this.jdbcConnection);
            if (this.startScn.compareTo(this.snapshotScn) == 0) {
                this.computeStartScnForFirstMiningSession(offsetContext, firstScn);
            }
            try (LogWriterFlushStrategy flushStrategy = this.resolveFlushStrategy();){
                if (!this.isContinuousMining && this.startScn.compareTo(firstScn.subtract(Scn.ONE)) < 0) {
                    throw new DebeziumException("Online REDO LOG files or archive log files do not contain the offset scn " + this.startScn + ".  Please perform a new snapshot.");
                }
                this.checkDatabaseAndTableState(this.jdbcConnection, this.connectorConfig.getPdbName(), this.schema);
                this.logOnlineRedoLogSizes(this.connectorConfig);
                try (LogMinerEventProcessor processor = this.createProcessor(context, partition, offsetContext);){
                    if (this.archiveLogOnlyMode && !this.waitForStartScnInArchiveLogs(context, this.startScn)) {
                        return;
                    }
                    this.initializeRedoLogsForMining(this.jdbcConnection, false, this.startScn);
                    int retryAttempts = 1;
                    Stopwatch sw = Stopwatch.accumulating().start();
                    while (context.isRunning()) {
                        this.streamingMetrics.calculateTimeDifference(this.getDatabaseSystemTime(this.jdbcConnection));
                        if (this.archiveLogOnlyMode && !this.waitForStartScnInArchiveLogs(context, this.startScn)) {
                            break;
                        }
                        Instant start = Instant.now();
                        this.endScn = this.calculateEndScn(this.jdbcConnection, this.startScn, this.endScn);
                        if (this.archiveLogOnlyMode && this.startScn.equals(this.endScn)) {
                            this.pauseBetweenMiningSessions();
                            continue;
                        }
                        Duration deviation = this.connectorConfig.getLogMiningMaxScnDeviation();
                        if (!deviation.isZero()) {
                            Optional<Scn> deviatedScn = this.calculateDeviatedEndScn(this.startScn, this.endScn, deviation);
                            if (deviatedScn.isEmpty()) {
                                this.pauseBetweenMiningSessions();
                                continue;
                            }
                            this.endScn = deviatedScn.get();
                        }
                        flushStrategy.flush(this.jdbcConnection.getCurrentScn());
                        boolean restartRequired = false;
                        if (this.connectorConfig.getLogMiningMaximumSession().isPresent()) {
                            Duration totalDuration = sw.stop().durations().statistics().getTotal();
                            if (totalDuration.toMillis() >= this.connectorConfig.getLogMiningMaximumSession().get().toMillis()) {
                                LOGGER.info("LogMiner session has exceeded maximum session time of '{}', forcing restart.", this.connectorConfig.getLogMiningMaximumSession());
                                restartRequired = true;
                            } else {
                                sw.start();
                            }
                        }
                        if (restartRequired || this.hasLogSwitchOccurred()) {
                            this.endMiningSession(this.jdbcConnection, offsetContext);
                            if (this.connectorConfig.isLogMiningRestartConnection()) {
                                this.prepareConnection(true);
                            }
                            this.initializeRedoLogsForMining(this.jdbcConnection, true, this.startScn);
                            sw = Stopwatch.accumulating().start();
                        }
                        if (context.isRunning()) {
                            if (!this.startMiningSession(this.jdbcConnection, this.startScn, this.endScn, retryAttempts)) {
                                ++retryAttempts;
                            } else {
                                retryAttempts = 1;
                                this.startScn = processor.process(this.startScn, this.endScn);
                                this.streamingMetrics.setCurrentBatchProcessingTime(Duration.between(start, Instant.now()));
                                this.captureSessionMemoryStatistics(this.jdbcConnection);
                            }
                            this.pauseBetweenMiningSessions();
                        }
                        if (!context.isPaused()) continue;
                        LOGGER.info("Streaming will now pause");
                        context.streamingPaused();
                        context.waitSnapshotCompletion();
                        LOGGER.info("Streaming resumed");
                    }
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("Mining session stopped due to error.", t);
            this.streamingMetrics.incrementErrorCount();
            this.errorHandler.setProducerThrowable(t);
        }
        finally {
            LOGGER.info("startScn={}, endScn={}", (Object)this.startScn, (Object)this.endScn);
            LOGGER.info("Streaming metrics dump: {}", (Object)this.streamingMetrics.toString());
            LOGGER.info("Offsets: {}", (Object)offsetContext);
        }
    }

    private void prepareConnection(boolean closeAndReconnect) throws SQLException {
        if (closeAndReconnect) {
            LOGGER.debug("Log switch or maximum session threshold detected, restarting Oracle JDBC connection.");
            this.jdbcConnection.close();
        }
        this.jdbcConnection.setAutoCommit(false);
        this.setNlsSessionParameters(this.jdbcConnection);
    }

    private void logOnlineRedoLogSizes(OracleConnectorConfig config) throws SQLException {
        this.jdbcConnection.query("SELECT GROUP#, BYTES FROM V$LOG ORDER BY 1", rs -> {
            LOGGER.info("Redo Log Group Sizes:");
            boolean potentiallySmallLogs = false;
            while (rs.next()) {
                long logSize = rs.getLong(2);
                if (logSize < SMALL_REDO_LOG_WARNING) {
                    potentiallySmallLogs = true;
                }
                LOGGER.info("\tGroup #{}: {} bytes", (Object)rs.getInt(1), (Object)logSize);
            }
            if (config.getAdapter().getType().equals("logminer") && config.getLogMiningStrategy() == OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO && potentiallySmallLogs) {
                LOGGER.warn("Redo logs may be sized too small using the default mining strategy, consider increasing redo log sizes to a minimum of 500MB.");
            }
        });
    }

    private void computeStartScnForFirstMiningSession(OracleOffsetContext offsetContext, Scn firstScn) {
        Map<String, Scn> snapshotPendingTransactions = offsetContext.getSnapshotPendingTransactions();
        if (snapshotPendingTransactions == null || snapshotPendingTransactions.isEmpty()) {
            this.startScn = this.snapshotScn;
        } else {
            Scn minScn = this.snapshotScn;
            for (Map.Entry<String, Scn> entry : snapshotPendingTransactions.entrySet()) {
                String transactionId = entry.getKey();
                Scn scn = entry.getValue();
                LOGGER.info("Transaction {} was pending across snapshot boundary. Start SCN = {}, snapshot SCN = {}", new Object[]{transactionId, scn, this.startScn});
                if (scn.compareTo(firstScn) < 0) {
                    LOGGER.warn("Transaction {} was still ongoing while snapshot was taken, but is no longer completely recorded in the archive logs. Events will be lost. Oldest SCN in logs = {}, TX start SCN = {}", new Object[]{transactionId, firstScn, scn});
                    minScn = firstScn;
                    continue;
                }
                if (scn.compareTo(minScn) >= 0) continue;
                minScn = scn;
            }
            if (offsetContext.getCommitScn().compareTo(this.snapshotScn) < 0) {
                LOGGER.info("Setting commit SCN to {} (snapshot SCN - 1) to ensure we don't double-emit events from pre-snapshot transactions.", (Object)this.snapshotScn.subtract(Scn.ONE));
                offsetContext.getCommitScn().setCommitScnOnAllThreads(this.snapshotScn.subtract(Scn.ONE));
            }
            if (minScn.compareTo(this.startScn) < 0) {
                LOGGER.info("Resetting start SCN from {} (snapshot SCN) to {} (start of oldest complete pending transaction)", (Object)this.startScn, (Object)minScn);
                this.startScn = minScn.subtract(Scn.ONE);
            }
        }
        offsetContext.setScn(this.startScn);
    }

    private void captureSessionMemoryStatistics(OracleConnection connection) throws SQLException {
        long sessionUserGlobalAreaMemory = connection.getSessionStatisticByName("session uga memory");
        long sessionUserGlobalAreaMaxMemory = connection.getSessionStatisticByName("session uga memory max");
        this.streamingMetrics.setUserGlobalAreaMemory(sessionUserGlobalAreaMemory, sessionUserGlobalAreaMaxMemory);
        long sessionProcessGlobalAreaMemory = connection.getSessionStatisticByName("session pga memory");
        long sessionProcessGlobalAreaMaxMemory = connection.getSessionStatisticByName("session pga memory max");
        this.streamingMetrics.setProcessGlobalAreaMemory(sessionProcessGlobalAreaMemory, sessionProcessGlobalAreaMaxMemory);
        DecimalFormat format = new DecimalFormat("#.##");
        LOGGER.debug("Oracle Session UGA {}MB (max = {}MB), PGA {}MB (max = {}MB)", new Object[]{format.format((float)sessionUserGlobalAreaMemory / 1024.0f / 1024.0f), format.format((float)sessionUserGlobalAreaMaxMemory / 1024.0f / 1024.0f), format.format((float)sessionProcessGlobalAreaMemory / 1024.0f / 1024.0f), format.format((float)sessionProcessGlobalAreaMaxMemory / 1024.0f / 1024.0f)});
    }

    private LogMinerEventProcessor createProcessor(ChangeEventSource.ChangeEventSourceContext context, OraclePartition partition, OracleOffsetContext offsetContext) {
        OracleConnectorConfig.LogMiningBufferType bufferType = this.connectorConfig.getLogMiningBufferType();
        return bufferType.createProcessor(context, this.connectorConfig, this.jdbcConnection, this.dispatcher, partition, offsetContext, this.schema, this.streamingMetrics);
    }

    private Scn getFirstScnInLogs(OracleConnection connection) throws SQLException {
        String oldestScn = (String)connection.singleOptionalValue(SqlUtils.oldestFirstChangeQuery(this.archiveLogRetention, this.archiveDestinationName), rs -> rs.getString(1));
        if (oldestScn == null) {
            throw new DebeziumException("Failed to calculate oldest SCN available in logs");
        }
        LOGGER.trace("Oldest SCN in logs is '{}'", (Object)oldestScn);
        return Scn.valueOf(oldestScn);
    }

    private void initializeRedoLogsForMining(OracleConnection connection, boolean postEndMiningSession, Scn startScn) throws SQLException {
        if (!postEndMiningSession) {
            if (OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO.equals((Object)this.strategy)) {
                this.buildDataDictionary(connection);
            }
            if (!this.isContinuousMining) {
                this.currentLogFiles = LogMinerHelper.setLogFilesForMining(connection, startScn, this.archiveLogRetention, this.archiveLogOnlyMode, this.archiveDestinationName, this.logFileQueryMaxRetries, this.initialDelay, this.maxDelay);
                this.currentRedoLogSequences = this.getCurrentLogFileSequences(this.currentLogFiles);
            }
        } else if (!this.isContinuousMining) {
            if (OracleConnectorConfig.LogMiningStrategy.CATALOG_IN_REDO.equals((Object)this.strategy)) {
                this.buildDataDictionary(connection);
            }
            this.currentLogFiles = LogMinerHelper.setLogFilesForMining(connection, startScn, this.archiveLogRetention, this.archiveLogOnlyMode, this.archiveDestinationName, this.logFileQueryMaxRetries, this.initialDelay, this.maxDelay);
            this.currentRedoLogSequences = this.getCurrentLogFileSequences(this.currentLogFiles);
        }
        this.updateRedoLogMetrics();
    }

    private List<BigInteger> getCurrentLogFileSequences(List<LogFile> logFiles) {
        if (logFiles == null || logFiles.isEmpty()) {
            return Collections.emptyList();
        }
        return logFiles.stream().filter(LogFile::isCurrent).map(LogFile::getSequence).collect(Collectors.toList());
    }

    private Scn getMaxArchiveLogScn(List<LogFile> logFiles) {
        if (logFiles == null || logFiles.isEmpty()) {
            throw new DebeziumException("Cannot get maximum archive log SCN as no logs were available.");
        }
        List archiveLogs = logFiles.stream().filter(log -> log.getType().equals((Object)LogFile.Type.ARCHIVE)).collect(Collectors.toList());
        if (archiveLogs.isEmpty()) {
            throw new DebeziumException("Cannot get maximum archive log SCN as no archive logs are present.");
        }
        Scn maxScn = ((LogFile)archiveLogs.get(0)).getNextScn();
        for (int i = 1; i < archiveLogs.size(); ++i) {
            Scn nextScn = ((LogFile)archiveLogs.get(i)).getNextScn();
            if (nextScn.compareTo(maxScn) <= 0) continue;
            maxScn = nextScn;
        }
        LOGGER.debug("Maximum archive log SCN resolved as {}", (Object)maxScn);
        return maxScn;
    }

    private void buildDataDictionary(OracleConnection connection) throws SQLException {
        LOGGER.trace("Building data dictionary");
        connection.executeWithoutCommitting(new String[]{"BEGIN DBMS_LOGMNR_D.BUILD (options => DBMS_LOGMNR_D.STORE_IN_REDO_LOGS); END;"});
    }

    private boolean hasLogSwitchOccurred() throws SQLException {
        List<BigInteger> newSequences = this.getCurrentRedoLogSequences();
        if (!newSequences.equals(this.currentRedoLogSequences)) {
            LOGGER.debug("Current log sequence(s) is now {}, was {}", newSequences, this.currentRedoLogSequences);
            this.currentRedoLogSequences = newSequences;
            int logSwitchCount = (Integer)this.jdbcConnection.queryAndMap(SqlUtils.switchHistoryQuery(this.archiveDestinationName), rs -> {
                if (rs.next()) {
                    return rs.getInt(2);
                }
                return 0;
            });
            this.streamingMetrics.setSwitchCount(logSwitchCount);
            return true;
        }
        return false;
    }

    private void updateRedoLogMetrics() throws SQLException {
        Map logStatuses = (Map)this.jdbcConnection.queryAndMap(SqlUtils.redoLogStatusQuery(), rs -> {
            LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
            while (rs.next()) {
                results.put(rs.getString(1), rs.getString(2));
            }
            return results;
        });
        Set<String> fileNames = this.getCurrentRedoLogFiles(this.jdbcConnection);
        this.streamingMetrics.setCurrentLogFileName(fileNames);
        this.streamingMetrics.setRedoLogStatus(logStatuses);
    }

    private Set<String> getCurrentRedoLogFiles(OracleConnection connection) throws SQLException {
        HashSet<String> fileNames = new HashSet<String>();
        connection.query(SqlUtils.currentRedoNameQuery(), rs -> {
            while (rs.next()) {
                fileNames.add(rs.getString(1));
            }
        });
        LOGGER.trace("Current redo log filenames: {}", fileNames);
        return fileNames;
    }

    private List<BigInteger> getCurrentRedoLogSequences() throws SQLException {
        return (List)this.jdbcConnection.queryAndMap(SqlUtils.currentRedoLogSequenceQuery(), rs -> {
            ArrayList<BigInteger> sequences = new ArrayList<BigInteger>();
            while (rs.next()) {
                sequences.add(new BigInteger(rs.getString(1)));
            }
            return sequences;
        });
    }

    private void pauseBetweenMiningSessions() throws InterruptedException {
        Duration period = Duration.ofMillis(this.streamingMetrics.getMillisecondToSleepBetweenMiningQuery());
        Metronome.sleeper((Duration)period, (Clock)this.clock).pause();
    }

    private void setNlsSessionParameters(OracleConnection connection) throws SQLException {
        String NLS_SESSION_PARAMETERS = "ALTER SESSION SET   NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'  NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF'  NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM'  NLS_NUMERIC_CHARACTERS = '.,'";
        connection.executeWithoutCommitting(new String[]{"ALTER SESSION SET   NLS_DATE_FORMAT = 'YYYY-MM-DD HH24:MI:SS'  NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF'  NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM'  NLS_NUMERIC_CHARACTERS = '.,'"});
        connection.executeWithoutCommitting(new String[]{"ALTER SESSION SET TIME_ZONE = '00:00'"});
    }

    private OffsetDateTime getDatabaseSystemTime(OracleConnection connection) throws SQLException {
        return (OffsetDateTime)connection.singleOptionalValue("SELECT SYSTIMESTAMP FROM DUAL", rs -> rs.getObject(1, OffsetDateTime.class));
    }

    public boolean startMiningSession(OracleConnection connection, Scn startScn, Scn endScn, int attempts) throws SQLException {
        LOGGER.debug("Starting mining session startScn={}, endScn={}, strategy={}, continuous={}", new Object[]{startScn, endScn, this.strategy, this.isContinuousMining});
        try {
            Instant start = Instant.now();
            connection.executeWithoutCommitting(new String[]{SqlUtils.startLogMinerStatement(startScn.add(Scn.ONE), endScn, this.strategy, this.isContinuousMining)});
            this.streamingMetrics.addCurrentMiningSessionStart(Duration.between(start, Instant.now()));
            return true;
        }
        catch (SQLException e) {
            LogMinerDatabaseStateWriter.writeLogMinerStartParameters(connection);
            if (e.getErrorCode() == 1291 || e.getMessage().startsWith("ORA-01291")) {
                if (attempts <= 5) {
                    LOGGER.warn("Failed to start Oracle LogMiner session, retrying...");
                    return false;
                }
                LOGGER.error("Failed to start Oracle LogMiner after '{}' attempts.", (Object)5, (Object)e);
                LogMinerDatabaseStateWriter.writeLogMinerLogFailures(connection);
            }
            LOGGER.error("Got exception when starting mining session.", (Throwable)e);
            LogMinerDatabaseStateWriter.write(connection);
            throw e;
        }
    }

    public void endMiningSession(OracleConnection connection, OracleOffsetContext offsetContext) throws SQLException {
        try {
            LOGGER.trace("Ending log mining startScn={}, endScn={}, offsetContext.getScn={}, strategy={}, continuous={}", new Object[]{this.startScn, this.endScn, offsetContext.getScn(), this.strategy, this.isContinuousMining});
            connection.executeWithoutCommitting(new String[]{"BEGIN SYS.DBMS_LOGMNR.END_LOGMNR(); END;"});
        }
        catch (SQLException e) {
            if (e.getMessage().toUpperCase().contains("ORA-01307")) {
                LOGGER.info("LogMiner mining session is already closed.");
                return;
            }
            throw e;
        }
    }

    private Scn calculateEndScn(OracleConnection connection, Scn startScn, Scn prevEndScn) throws SQLException {
        long timeDeltaMs;
        Optional<Instant> currentScnTimestamp;
        Optional<Instant> prevEndScnTimestamp;
        Scn deltaScn;
        Scn currentScn = this.archiveLogOnlyMode ? this.getMaxArchiveLogScn(this.currentLogFiles) : connection.getCurrentScn();
        this.streamingMetrics.setCurrentScn(currentScn);
        Scn currentBatchSizeScn = Scn.valueOf(this.streamingMetrics.getBatchSize());
        Scn topScnToMine = startScn.add(currentBatchSizeScn);
        boolean topMiningScnInFarFuture = false;
        Scn defaultBatchScn = Scn.valueOf(this.connectorConfig.getLogMiningBatchSizeDefault());
        if (topScnToMine.subtract(currentScn).compareTo(defaultBatchScn) > 0) {
            this.streamingMetrics.changeBatchSize(false, this.connectorConfig.isLobEnabled());
            topMiningScnInFarFuture = true;
        }
        if (currentScn.subtract(topScnToMine).compareTo(defaultBatchScn) > 0) {
            this.streamingMetrics.changeBatchSize(true, this.connectorConfig.isLobEnabled());
        }
        if (currentScn.compareTo(topScnToMine) < 0) {
            if (!topMiningScnInFarFuture) {
                this.streamingMetrics.changeSleepingTime(true);
            }
            LOGGER.debug("Using current SCN {} as end SCN.", (Object)currentScn);
            return currentScn;
        }
        if (prevEndScn != null && topScnToMine.compareTo(prevEndScn) <= 0) {
            LOGGER.debug("Max batch size too small, using current SCN {} as end SCN.", (Object)currentScn);
            return currentScn;
        }
        this.streamingMetrics.changeSleepingTime(false);
        if (topScnToMine.compareTo(startScn) < 0) {
            LOGGER.debug("Top SCN calculation resulted in end before start SCN, using current SCN {} as end SCN.", (Object)currentScn);
            return currentScn;
        }
        if (prevEndScn != null && (deltaScn = currentScn.subtract(prevEndScn)).compareTo(Scn.valueOf(this.connectorConfig.getLogMiningScnGapDetectionGapSizeMin())) > 0 && (prevEndScnTimestamp = connection.getScnToTimestamp(prevEndScn)).isPresent() && (currentScnTimestamp = connection.getScnToTimestamp(currentScn)).isPresent() && (timeDeltaMs = ChronoUnit.MILLIS.between(prevEndScnTimestamp.get(), currentScnTimestamp.get())) < (long)this.connectorConfig.getLogMiningScnGapDetectionTimeIntervalMaxMs()) {
            LOGGER.warn("Detected possible SCN gap, using current SCN, startSCN {}, prevEndScn {} timestamp {}, current SCN {} timestamp {}.", new Object[]{startScn, prevEndScn, prevEndScnTimestamp.get(), currentScn, currentScnTimestamp.get()});
            return currentScn;
        }
        LOGGER.debug("Using Top SCN calculation {} as end SCN. currentScn {}, startScn {}", new Object[]{topScnToMine, currentScn, startScn});
        return topScnToMine;
    }

    private Optional<Scn> calculateDeviatedEndScn(Scn lowerboundsScn, Scn upperboundsScn, Duration deviation) {
        if (this.archiveLogOnlyMode) {
            return Optional.of(upperboundsScn);
        }
        Optional<Scn> calculatedDeviatedEndScn = this.getDeviatedMaxScn(upperboundsScn, deviation);
        if (calculatedDeviatedEndScn.isEmpty() || calculatedDeviatedEndScn.get().isNull()) {
            LOGGER.warn("Mining session end SCN deviation calculation is outside undo space, using upperbounds {}. If this continues, consider lowering the value of the '{}' configuration property.", (Object)upperboundsScn, (Object)OracleConnectorConfig.LOG_MINING_MAX_SCN_DEVIATION_MS.name());
            return Optional.of(upperboundsScn);
        }
        if (calculatedDeviatedEndScn.get().compareTo(lowerboundsScn) <= 0) {
            LOGGER.debug("Mining session end SCN deviation as {}, outside of mining range, recalculating.", (Object)calculatedDeviatedEndScn.get());
            return Optional.empty();
        }
        return calculatedDeviatedEndScn;
    }

    private Optional<Scn> getDeviatedMaxScn(Scn upperboundsScn, Duration deviation) {
        try {
            Scn currentScn = this.jdbcConnection.getCurrentScn();
            Optional<Instant> currentInstant = this.jdbcConnection.getScnToTimestamp(currentScn);
            Optional<Instant> upperInstant = this.jdbcConnection.getScnToTimestamp(upperboundsScn);
            if (currentInstant.isPresent() && upperInstant.isPresent() && Duration.between(upperInstant.get(), currentInstant.get()).compareTo(deviation) >= 0) {
                LOGGER.trace("Upper bounds {} is within deviation period, using it.", (Object)upperboundsScn);
                return Optional.of(upperboundsScn);
            }
            return Optional.of(this.jdbcConnection.getScnAdjustedByTime(upperboundsScn, deviation));
        }
        catch (SQLException e) {
            LOGGER.warn("Failed to calculate deviated max SCN value from {}.", (Object)upperboundsScn);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDatabaseAndTableState(OracleConnection connection, String pdbName, OracleDatabaseSchema schema) throws SQLException {
        Instant start = Instant.now();
        LOGGER.trace("Checking database and table state, this may take time depending on the size of your schema.");
        try {
            if (pdbName != null) {
                connection.setSessionToPdb(pdbName);
            }
            if (!this.isDatabaseAllSupplementalLoggingEnabled(connection)) {
                if (!this.isDatabaseMinSupplementalLoggingEnabled(connection)) {
                    throw new DebeziumException("Supplemental logging not properly configured. Use: ALTER DATABASE ADD SUPPLEMENTAL LOG DATA");
                }
                for (TableId tableId : schema.tableIds()) {
                    if (!connection.isTableExists(tableId)) {
                        LOGGER.warn("Database table '{}' no longer exists, supplemental log check skipped", (Object)tableId);
                    } else if (!this.isTableAllColumnsSupplementalLoggingEnabled(connection, tableId)) {
                        LOGGER.warn("Database table '{}' not configured with supplemental logging \"(ALL) COLUMNS\"; only explicitly changed columns will be captured. Use: ALTER TABLE {}.{} ADD SUPPLEMENTAL LOG DATA (ALL) COLUMNS", new Object[]{tableId, tableId.schema(), tableId.table()});
                    }
                    Table table = schema.tableFor(tableId);
                    if (table == null) {
                        throw new DebeziumException("Unable to find table in relational model: " + tableId);
                    }
                    this.checkTableColumnNameLengths(table);
                }
            } else {
                for (TableId tableId : schema.tableIds()) {
                    Table table = schema.tableFor(tableId);
                    if (table == null) {
                        throw new DebeziumException("Unable to find table in relational model: " + tableId);
                    }
                    this.checkTableColumnNameLengths(table);
                }
            }
        }
        finally {
            if (pdbName != null) {
                connection.resetSessionToCdb();
            }
        }
        LOGGER.trace("Database and table state check finished after {} ms", (Object)Duration.between(start, Instant.now()).toMillis());
    }

    private void checkTableColumnNameLengths(Table table) {
        if (table.id().table().length() > 30) {
            LOGGER.warn("Table '{}' won't be captured by Oracle LogMiner because its name exceeds {} characters.", (Object)table.id().table(), (Object)30);
        }
        for (Column column : table.columns()) {
            if (column.name().length() <= 30) continue;
            LOGGER.warn("Table '{}' won't be captured by Oracle LogMiner because column '{}' exceeds {} characters.", new Object[]{table.id().table(), column.name(), 30});
        }
    }

    private boolean isDatabaseAllSupplementalLoggingEnabled(OracleConnection connection) throws SQLException {
        return (Boolean)connection.queryAndMap(SqlUtils.databaseSupplementalLoggingAllCheckQuery(), rs -> {
            while (rs.next()) {
                if (!"YES".equalsIgnoreCase(rs.getString(2))) continue;
                return true;
            }
            return false;
        });
    }

    private boolean isDatabaseMinSupplementalLoggingEnabled(OracleConnection connection) throws SQLException {
        return (Boolean)connection.queryAndMap(SqlUtils.databaseSupplementalLoggingMinCheckQuery(), rs -> {
            while (rs.next()) {
                if (!"YES".equalsIgnoreCase(rs.getString(2))) continue;
                return true;
            }
            return false;
        });
    }

    private boolean isTableAllColumnsSupplementalLoggingEnabled(OracleConnection connection, TableId tableId) throws SQLException {
        return (Boolean)connection.queryAndMap(SqlUtils.tableSupplementalLoggingCheckQuery(tableId), rs -> {
            while (rs.next()) {
                if (!ALL_COLUMN_LOGGING.equals(rs.getString(2))) continue;
                return true;
            }
            return false;
        });
    }

    private LogWriterFlushStrategy resolveFlushStrategy() {
        if (this.connectorConfig.isLogMiningReadOnly()) {
            return new ReadOnlyLogWriterFlushStrategy();
        }
        if (this.connectorConfig.isRacSystem().booleanValue()) {
            return new RacCommitLogWriterFlushStrategy(this.connectorConfig, this.jdbcConfiguration, this.streamingMetrics);
        }
        return new CommitLogWriterFlushStrategy(this.connectorConfig, this.jdbcConnection);
    }

    private boolean waitForStartScnInArchiveLogs(ChangeEventSource.ChangeEventSourceContext context, Scn startScn) throws SQLException, InterruptedException {
        boolean showStartScnNotInArchiveLogs = true;
        while (context.isRunning() && !this.isStartScnInArchiveLogs(startScn)) {
            if (!showStartScnNotInArchiveLogs) continue;
            LOGGER.warn("Starting SCN {} is not yet in archive logs, waiting for archive log switch.", (Object)startScn);
            showStartScnNotInArchiveLogs = false;
            Metronome.sleeper((Duration)this.connectorConfig.getArchiveLogOnlyScnPollTime(), (Clock)this.clock).pause();
        }
        if (!context.isRunning()) {
            return false;
        }
        if (!showStartScnNotInArchiveLogs) {
            LOGGER.info("Starting SCN {} is now available in archive logs, log mining unpaused.", (Object)startScn);
        }
        return true;
    }

    private boolean isStartScnInArchiveLogs(Scn startScn) throws SQLException {
        List<LogFile> logs = LogMinerHelper.getLogFilesForOffsetScn(this.jdbcConnection, startScn, this.archiveLogRetention, this.archiveLogOnlyMode, this.archiveDestinationName);
        return logs.stream().anyMatch(l -> l.getFirstScn().compareTo(startScn) <= 0 && l.getNextScn().compareTo(startScn) > 0 && l.getType().equals((Object)LogFile.Type.ARCHIVE));
    }

    public void commitOffset(Map<String, ?> partition, Map<String, ?> offset) {
    }

    public OracleOffsetContext getOffsetContext() {
        return this.effectiveOffset;
    }
}

