/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum LocationType {
    ENTRY,
    LINE,
    READ,
    READ_COMPLETED,
    WRITE,
    WRITE_COMPLETED,
    INVOKE,
    INVOKE_COMPLETED,
    SYNCHRONIZE,
    SYNCHRONIZE_COMPLETED,
    THROW,
    EXIT,
    EXCEPTION_EXIT,
    NEW,
    NEW_COMPLETED;

    private static String[] specifiers;
    private static Pattern[] specifierPatterns;
    private static LocationType[] types;

    public String specifierText() {
        for (int i = 0; i < specifiers.length; ++i) {
            if (types[i] != this) continue;
            return specifiers[i];
        }
        return specifiers[0];
    }

    public static LocationType type(String locationSpec) {
        locationSpec = locationSpec.trim();
        for (int i = 0; i < specifiers.length; ++i) {
            Pattern p = specifierPatterns[i];
            Matcher m = p.matcher(locationSpec);
            if (!m.lookingAt()) continue;
            return types[i];
        }
        return null;
    }

    public static String parameterText(String locationSpec) {
        locationSpec = locationSpec.trim();
        for (int i = 0; i < specifiers.length; ++i) {
            Pattern p = specifierPatterns[i];
            Matcher m = p.matcher(locationSpec);
            if (!m.lookingAt()) continue;
            return locationSpec.substring(m.end());
        }
        return "";
    }

    private static Pattern[] createPatterns() {
        int length = specifiers.length;
        Pattern[] patterns = new Pattern[length];
        for (int i = 0; i < length; ++i) {
            patterns[i] = Pattern.compile(specifiers[i]);
        }
        return patterns;
    }

    static {
        specifiers = new String[]{"AT[ \t]*ENTRY", "AT[ \t]*LINE", "AT[ \t]*READ", "AFTER[ \t]*READ", "AT[ \t]*WRITE", "AFTER[ \t]*WRITE", "AT[ \t]*INVOKE", "AFTER[ \t]*INVOKE", "AT[ \t]*SYNCHRONIZE", "AFTER[ \t]*SYNCHRONIZE", "AT[ \t]*THROW", "AT[ \t]*EXIT", "AT[ \t]*EXCEPTION[ \t]*EXIT", "AT[ \t]*NEW", "AFTER[ \t]*NEW", "LINE", "AT[ \t]*CALL", "AFTER[ \t]*CALL", "AT[ \t]*RETURN"};
        specifierPatterns = LocationType.createPatterns();
        types = new LocationType[]{ENTRY, LINE, READ, READ_COMPLETED, WRITE, WRITE_COMPLETED, INVOKE, INVOKE_COMPLETED, SYNCHRONIZE, SYNCHRONIZE_COMPLETED, THROW, EXIT, EXCEPTION_EXIT, NEW, NEW_COMPLETED, LINE, INVOKE, INVOKE_COMPLETED, EXIT};
    }
}

